

% the first case

clear
close all
clc
rng('default')
%% load codes

train_codes = readNPY('train_codes.npy');
test_codes = readNPY('test_codes.npy');


%% 

[Mdl,tf,train_scores] = iforest(train_codes); 
figure("name","IF_train")
h = histogram(train_scores,NumBins=50);

save("nuclear_IF_train.mat","train_scores")

[~, test_scores] = isanomaly(Mdl,test_codes);

figure("name","IF_test")
h_normal = histogram(test_scores(1:51),NumBins=50);
hold on
h_anormaly = histogram(test_scores(52:end),NumBins=50);
hold off

save("nuclear_IF_test.mat","test_scores")


%%
close all

%% EVALUATE 
codes = test_scores;

normal = codes(1:51)';
anomaly = codes(52:end)';

for i = 1:floor(499/20)
    test_codes_(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end

labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_if(i) = 0;
    [~, ~, ~, auc_if(i)] = perfcurve(labels, test_codes_(i,:), 1);

end
auc_if_mean = mean(auc_if)

sorted_codes = sort(test_codes_,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR(i) = 0;
    FNR(i) = 0;
    TPR(i) = 0;
    FPR(i) = 0;
    for j = 52:71
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR(i) = a(i)/20;
        FPR(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR(i) = n(i)/51;
        FNR(i) = n_f(i)/51;
    end
end
tolal_TNR = mean(TNR)
tolal_FNR = mean(FNR)
tolal_TPR = mean(TPR)
tolal_FPR = mean(FPR)

acc = (a+n)/71;
acc_IF = mean(acc)


% a = 0;
% a_f = 0;
% n = 0;
% n_f = 0;
% 
% for i = 52:length(test_scores)
%     if test_scores(i) > max(train_scores)
%         a = a + 1;
%     else
%         a_f = a_f + 1;
%     end
% end
% 
% TNR = a/499
% FNR = a_f/499
% 
% for i = 1:51
%     if test_scores(i) <= max(train_scores)
%         n = n + 1;
%     else
%         n_f = n_f + 1;
%     end
% end
% 
% TPR = n/51
% FPR = n_f/51
% 
% acc_max = (TNR+TPR)/2
% 
% 
% 
