
% the third case

clear
close all
clc
rng("default")
%% load 
GMM_test = load("nuclear_GMM_test_sap.mat").test_scores_max;
GMM_train = load("nuclear_GMM_train_sap.mat").train_scores_max;
LOF_test = load("nuclear_LOF_test_sap.mat").test_scores_max;
LOF_train = load("nuclear_LOF_train_sap.mat").train_scores_max;
IF_test = load("nuclear_IF_test_sap.mat").test_scores_max;
IF_train = load("nuclear_IF_train_sap.mat").train_scores_max;
x_loss_ecdf = load("loss_ecdf_max.mat").ecdf_max;


%% ecdf train
subplot(1,3,1)
[GMM_ecdf,GMM_scores] = ecdf(GMM_train);
ecdf(GMM_train)
title('GMM')

subplot(1,3,2)
[LOF_ecdf,LOF_scores] = ecdf(LOF_train);
ecdf(LOF_train)
title('LOF')

subplot(1,3,3)
[IF_ecdf,IF_scores] = ecdf(IF_train);
ecdf(IF_train)
title('IF')
close all
%% ecdf

x_ecdf_LOF = fun(LOF_scores(1:395), LOF_ecdf, LOF_test);
x_ecdf_GMM = fun(GMM_scores(1:395), GMM_ecdf, GMM_test);
x_ecdf_IF = fun(IF_scores(1:265), IF_ecdf, IF_test);

%% EVALUATE  MAX

ecdf = [x_loss_ecdf;x_ecdf_LOF;x_ecdf_GMM;x_ecdf_IF];
ecdf_max = max(ecdf);
codes = ecdf_max;

normal = codes(1:51);
anomaly = codes(52:end);

for i = 1:floor(499/20)
    test_codes(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end
% test_codes(i+1,:) = [normal, anomaly(491:end), anomaly(489:end)];

labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_max(i) = 0;
    [~, ~, ~, auc_max(i)] = perfcurve(labels, test_codes(i,:), 1);
end
auc_max_mean = mean(auc_max)

sorted_codes = sort(test_codes,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_MAX(i) = 0;
    FNR_MAX(i) = 0;
    TPR_MAX(i) = 0;
    FPR_MAX(i) = 0;
    for j = 52:71
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_MAX(i) = a(i)/20;
        FPR_MAX(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_MAX(i) = n(i)/51;
        FNR_MAX(i) = n_f(i)/51;
    end
end
tolal_TNR_MAX = mean(TNR_MAX)
tolal_FNR_MAX = mean(FNR_MAX)
tolal_TPR_MAX = mean(TPR_MAX)
tolal_FPR_MAX = mean(FPR_MAX)

acc = (a+n)/71;
acc_MAX = mean(acc)



%% EVALUATE average 
ecdf_average = (x_loss_ecdf+x_ecdf_LOF+x_ecdf_GMM+x_ecdf_IF)/4;

codes = ecdf_average;

normal = codes(1:51);
anomaly = codes(52:end);

for i = 1:floor(499/20)
    test_codes(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end
labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_ave(i) = 0;
    [~, ~, ~, auc_ave(i)] = perfcurve(labels, test_codes(i,:), 1);
end
auc_ave_mean = mean(auc_ave)
sorted_codes = sort(test_codes,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_AVE(i) = 0;
    FNR_AVE(i) = 0;
    TPR_AVE(i) = 0;
    FPR_AVE(i) = 0;
    for j = 52:71
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_AVE(i) = a(i)/20;
        FPR_AVE(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_AVE(i) = n(i)/51;
        FNR_AVE(i) = n_f(i)/51;
    end
end
tolal_TNR_AVE = mean(TNR_AVE);
tolal_FNR_AVE = mean(FNR_AVE);
tolal_TPR_AVE = mean(TPR_AVE);
tolal_FPR_AVE = mean(FPR_AVE);

acc = (a+n)/71;
acc_AVE = mean(acc)


%% KPV

ecdf = [x_loss_ecdf;x_ecdf_LOF;x_ecdf_IF;x_ecdf_GMM];
ecdf_min = min(ecdf);
ecdf_ = ecdf - [ecdf_min; ecdf_min; ecdf_min; ecdf_min];

ecdf_KPV = sum(ecdf_)/3+ecdf_min;



codes = ecdf_KPV;
normal = ecdf_KPV(1:51);
anomaly = ecdf_KPV(52:end);


for i = 1:floor(499/20)
    test_codes_(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end

labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_kpv(i) = 0;
    [~, ~, ~, auc_kpv(i)] = perfcurve(labels, test_codes_(i,:), 1);

end
auc_kpv_mean = mean(auc_kpv)

sorted_codes = sort(test_codes_,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_KPV(i) = 0;
    FNR_KPV(i) = 0;
    TPR_KPV(i) = 0;
    FPR_KPV(i) = 0;
    for j = 52:71
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_KPV(i) = a(i)/20;
        FPR_KPV(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_KPV(i) = n(i)/51;
        FNR_KPV(i) = n_f(i)/51;
    end
end
tolal_TNR_KPV = mean(TNR_KPV)
tolal_FNR_KPV = mean(FNR_KPV)
tolal_TPR_KPV = mean(TPR_KPV)
tolal_FPR_KPV = mean(FPR_KPV)

acc = (a+n)/71;
acc_KPV = mean(acc)
 
 
%% AKPV

ecdf_AKPV = (x_loss_ecdf+x_ecdf_LOF+x_ecdf_GMM)/3;

codes = ecdf_AKPV;
normal = ecdf_AKPV(1:51);
anomaly = ecdf_AKPV(52:end);


for i = 1:floor(499/20)
    test_codes_(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end

labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_akpv(i) = 0;
    [~, ~, ~, auc_akpv(i)] = perfcurve(labels, test_codes_(i,:), 1);

end
auc_akpv_mean = mean(auc_akpv)

sorted_codes = sort(test_codes_,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_AKPV(i) = 0;
    FNR_AKPV(i) = 0;
    TPR_AKPV(i) = 0;
    FPR_AKPV(i) = 0;
    for j = 52:71
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_AKPV(i) = a(i)/20;
        FPR_AKPV(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_AKPV(i) = n(i)/51;
        FNR_AKPV(i) = n_f(i)/51;
    end
end
tolal_TNR_AKPV = mean(TNR_AKPV)
tolal_FNR_AKPV = mean(FNR_AKPV)
tolal_TPR_AKPV = mean(TPR_AKPV)
tolal_FPR_AKPV = mean(FPR_AKPV)

acc = (a+n)/71;
acc_AKPV = mean(acc)


%% da
damped_average_ecdf = (sqrt(x_loss_ecdf)+sqrt(x_ecdf_IF)+sqrt(x_ecdf_LOF)+sqrt(x_ecdf_GMM))/4;


codes = damped_average_ecdf;
normal = damped_average_ecdf(1:51);
anomaly = damped_average_ecdf(52:end);


for i = 1:floor(499/20)
    test_codes_(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end

labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_da(i) = 0;
    [~, ~, ~, auc_da(i)] = perfcurve(labels, test_codes_(i,:), 1);

end
auc_da_mean = mean(auc_da)

sorted_codes = sort(test_codes_,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_da(i) = 0;
    FNR_da(i) = 0;
    TPR_da(i) = 0;
    FPR_da(i) = 0;
    for j = 52:71
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_da(i) = a(i)/20;
        FPR_da(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_da(i) = n(i)/51;
        FNR_da(i) = n_f(i)/51;
    end
end
tolal_TNR_da = mean(TNR_da)
tolal_FNR_da = mean(FNR_da)
tolal_TPR_da = mean(TPR_da)
tolal_FPR_da = mean(FPR_da)

acc = (a+n)/71;
acc_da = mean(acc)

