


clear
close all
clc

rng('default')
%% load codes

train_codes_0 = readNPY('train_codes_0.npy');
test_codes_0 = readNPY('test_codes_0.npy');

train_codes_1 = readNPY('train_codes_1.npy');
test_codes_1 = readNPY('test_codes_1.npy');

train_codes_2 = readNPY('train_codes_2.npy');
test_codes_2 = readNPY('test_codes_2.npy');

train_codes_3 = readNPY('train_codes_3.npy');
test_codes_3 = readNPY('test_codes_3.npy');


%% ocsvm 
train_codes = [train_codes_0, train_codes_1, train_codes_2, train_codes_3];
test_codes = [test_codes_0, test_codes_1, test_codes_2, test_codes_3];

[Mdl,tf,train_scores] = ocsvm(train_codes); 
figure("name","ocsvm_train")
h = histogram(train_scores,NumBins=50);

[~, test_scores] = isanomaly(Mdl,test_codes);

figure("name","ocsvm_test")
h_normal = histogram(test_scores(1:51),NumBins=50);
hold on
h_anormaly = histogram(test_scores(52:end),NumBins=50);
hold off

train_scores_max = max(train_scores);

close all
%% EVALUATE 
codes = test_scores;

normal = codes(1:51)';
anomaly = codes(52:end)';

for i = 1:floor(499/20)
    test_codes_(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end

sorted_codes = sort(test_codes_,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_SVM(i) = 0;
    FNR_SVM(i) = 0;
    TPR_SVM(i) = 0;
    FPR_SVM(i) = 0;
    for j = 52:71
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_SVM(i) = a(i)/20;
        FPR_SVM(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_SVM(i) = n(i)/51;
        FNR_SVM(i) = n_f(i)/51;
    end
end
tolal_TNR_SVM = mean(TNR_SVM)
tolal_FNR_SVM = mean(FNR_SVM)
tolal_TPR_SVM = mean(TPR_SVM)
tolal_FPR_SVM = mean(FPR_SVM)

acc = (a+n)/71;
acc_SVM = mean(acc)

return
%%
% a = 0;
% a_f = 0;
% n = 0;
% n_f = 0;
% 
% for i = 52:length(test_scores)
%     if test_scores(i) > train_scores_max
%         a = a + 1;
%     else
%         a_f = a_f + 1;
%     end
% end
% 
% TNR = a/499
% FNR = a_f/499
% 
% for i = 1:51
%     if test_scores(i) <= train_scores_max
%         n = n + 1;
%     else
%         n_f = n_f + 1;
%     end
% end
% 
% TPR = n/51
% FPR = n_f/51
% 
% acc_max = (TNR+TPR)/2
% 
