


clear
close all
clc
rng("default")
%% load codes

train_codes_0 = readNPY('train_codes_0.npy');
test_codes_0 = readNPY('test_codes_0.npy');

train_codes_1 = readNPY('train_codes_1.npy');
test_codes_1 = readNPY('test_codes_1.npy');

train_codes_2 = readNPY('train_codes_2.npy');
test_codes_2 = readNPY('test_codes_2.npy');

train_codes_3 = readNPY('train_codes_3.npy');
test_codes_3 = readNPY('test_codes_3.npy');


%% LOF
[Mdl,tf,train_scores_0] = lof(train_codes_0); 
[~, test_scores_0] = isanomaly(Mdl,test_codes_0);


[Mdl,tf,train_scores_1] = lof(train_codes_1); 
[~, test_scores_1] = isanomaly(Mdl,test_codes_1);


[Mdl,tf,train_scores_2] = lof(train_codes_2); 
[~, test_scores_2] = isanomaly(Mdl,test_codes_2);


[Mdl,tf,train_scores_3] = lof(train_codes_3); 
[~, test_scores_3] = isanomaly(Mdl,test_codes_3);


%% 
close all

train_scores = [train_scores_0, train_scores_1, train_scores_2, train_scores_3];
train_scores_max = max(train_scores,[],2);

save("nuclear_LOF_train_sap.mat","train_scores_max")

test_scores = [test_scores_0, test_scores_1, test_scores_2, test_scores_3];
test_scores_max = max(test_scores,[],2);

save("nuclear_LOF_test_sap.mat","test_scores_max")

%% EVALUATE 
codes = test_scores_max;

normal = codes(1:51)';
anomaly = codes(52:end)';

for i = 1:floor(499/20)
    test_codes(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end
% test_codes(i+1,:) = [normal, anomaly(491:end), anomaly(489:end)];


labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_lof(i) = 0;
    [~, ~, ~, auc_lof(i)] = perfcurve(labels, test_codes(i,:), 1);
end
auc_lof_mean = mean(auc_lof)

sorted_codes = sort(test_codes,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_LOF(i) = 0;
    FNR_LOF(i) = 0;
    TPR_LOF(i) = 0;
    FPR_LOF(i) = 0;
    for j = 52:71
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_LOF(i) = a(i)/20;
        FPR_LOF(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_LOF(i) = n(i)/51;
        FNR_LOF(i) = n_f(i)/51;
    end
end
tolal_TNR_LOF = mean(TNR_LOF)
tolal_FNR_LOF = mean(FNR_LOF)
tolal_TPR_LOF = mean(TPR_LOF)
tolal_FPR_LOF = mean(FPR_LOF)

acc = (a+n)/71;
acc_LOF = mean(acc)


return

%% eva
a = 0;
a_f = 0;
n = 0;
n_f = 0;

for i = 52:length(test_scores_max)
    if test_scores_max(i) > max(train_scores_max)
        a = a + 1;
    else
        a_f = a_f + 1;
    end
end

TNR = a/499
FNR = a_f/499

for i = 1:51
    if test_scores_max(i) <= max(train_scores_max)
        n = n + 1;
    else
        n_f = n_f + 1;
    end
end

TPR = n/51
FPR = n_f/51

acc_max = (TNR+TPR)/2



