
% the second case

clear
close all
clc
%% load codes

train_codes_0 = readNPY('train_codes_0.npy');
test_codes_0 = readNPY('test_codes_0.npy');

train_codes_1 = readNPY('train_codes_1.npy');
test_codes_1 = readNPY('test_codes_1.npy');

train_codes_2 = readNPY('train_codes_2.npy');
test_codes_2 = readNPY('test_codes_2.npy');

train_codes_3 = readNPY('train_codes_3.npy');
test_codes_3 = readNPY('test_codes_3.npy');


%% feature difussion con
train_codes = [train_codes_0, train_codes_1, train_codes_2, train_codes_3];
test_codes = [test_codes_0, test_codes_1, test_codes_2, test_codes_3];

[Mdl,tf,train_scores] = lof(train_codes); 
figure("name","LOF_train")
h = histogram(train_scores,NumBins=50);

save("nuclear_LOF_train.mat","train_scores")

[~, test_scores] = isanomaly(Mdl,test_codes);

save("nuclear_LOF_test.mat","test_scores")

figure("name","LOF_test")
h_normal = histogram(test_scores(1:51),NumBins=50);
hold on
h_anormaly = histogram(test_scores(52:end),NumBins=50);
hold off

close all
%% EVALUATE 
codes = test_scores;

normal = codes(1:51)';
anomaly = codes(52:end)';

for i = 1:floor(499/20)
    test_codes_(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end

labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_lof(i) = 0;
    [~, ~, ~, auc_lof(i)] = perfcurve(labels, test_codes_(i,:), 1);
end
auc_lof_mean = mean(auc_lof)

sorted_codes = sort(test_codes_,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_LOF(i) = 0;
    FNR_LOF(i) = 0;
    TPR_LOF(i) = 0;
    FPR_LOF(i) = 0;
    for j = 52:71
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_LOF(i) = a(i)/20;
        FPR_LOF(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes_(i,:) == sorted_codes(i,j));
        test_codes_(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_LOF(i) = n(i)/51;
        FNR_LOF(i) = n_f(i)/51;
    end
end
tolal_TNR_LOF = mean(TNR_LOF)
tolal_FNR_LOF = mean(FNR_LOF)
tolal_TPR_LOF = mean(TPR_LOF)
tolal_FPR_LOF = mean(FPR_LOF)

acc = (a+n)/71;
acc_LOF = mean(acc)
return

%%
% a = 0;
% a_f = 0;
% n = 0;
% n_f = 0;
% 
% for i = 52:length(test_scores)
%     if test_scores(i) > max(train_scores)
%         a = a + 1;
%     else
%         a_f = a_f + 1;
%     end
% end
% 
% TNR = a/499
% FNR = a_f/499
% 
% for i = 1:51
%     if test_scores(i) <= max(train_scores)
%         n = n + 1;
%     else
%         n_f = n_f + 1;
%     end
% end
% 
% TPR = n/51
% FPR = n_f/51
% 
% acc_max = (TNR+TPR)/2
% 
