


clear
close all
clc

rng('default')
%% load codes

train_codes_0 = readNPY('train_codes_0.npy');
test_codes_0 = readNPY('test_codes_0.npy');

train_codes_1 = readNPY('train_codes_1.npy');
test_codes_1 = readNPY('test_codes_1.npy');

train_codes_2 = readNPY('train_codes_2.npy');
test_codes_2 = readNPY('test_codes_2.npy');

train_codes_3 = readNPY('train_codes_3.npy');
test_codes_3 = readNPY('test_codes_3.npy');


%% LOF
[Mdl,tf,train_scores_0] = iforest(train_codes_0); 
[~, test_scores_0] = isanomaly(Mdl,test_codes_0);


[Mdl,tf,train_scores_1] = iforest(train_codes_1); 
[~, test_scores_1] = isanomaly(Mdl,test_codes_1);


[Mdl,tf,train_scores_2] = iforest(train_codes_2); 
[~, test_scores_2] = isanomaly(Mdl,test_codes_2);


[Mdl,tf,train_scores_3] = iforest(train_codes_3); 
[~, test_scores_3] = isanomaly(Mdl,test_codes_3);


%% 
close all

train_scores = [train_scores_0, train_scores_1, train_scores_2, train_scores_3];
train_scores_max = max(train_scores,[],2);

save("nuclear_IF_train_sap.mat","train_scores_max")

test_scores = [test_scores_0, test_scores_1, test_scores_2, test_scores_3];
test_scores_max = max(test_scores,[],2);

save("nuclear_IF_test_sap.mat","test_scores_max")

%% EVALUATE 
codes = test_scores_max;

normal = codes(1:51)';
anomaly = codes(52:end)';

for i = 1:floor(499/20)
    test_codes(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end

labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_if(i) = 0;
    [~, ~, ~, auc_if(i)] = perfcurve(labels, test_codes(i,:), 1);
end
auc_if_mean = mean(auc_if)

sorted_codes = sort(test_codes,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_IF(i) = 0;
    FNR_IF(i) = 0;
    TPR_IF(i) = 0;
    FPR_IF(i) = 0;
    for j = 52:71
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_IF(i) = a(i)/20;
        FPR_SAE(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_SAE(i) = n(i)/51;
        FNR_IF(i) = n_f(i)/51;
    end
end
tolal_TNR_IF = mean(TNR_IF)
tolal_FNR_IF = mean(FNR_IF)
tolal_TPR_IF = mean(TPR_SAE)
tolal_FPR_IF = mean(FPR_SAE)

acc = (a+n)/71;
acc_IF = mean(acc)

return

%%
a = 0;
a_f = 0;
n = 0;
n_f = 0;

for i = 52:length(test_scores_max)
    if test_scores_max(i) > max(train_scores_max)
        a = a + 1;
    else
        a_f = a_f + 1;
    end
end

TNR = a/499
FNR = a_f/499

for i = 1:51
    if test_scores_max(i) <= max(train_scores_max)
        n = n + 1;
    else
        n_f = n_f + 1;
    end
end

TPR = n/51
FPR = n_f/51

acc_max = (TNR+TPR)/2




