
% the third case

clear
close all
clc
rng('default')
%% load codes

train_codes_0 = readNPY('train_codes_0.npy');
test_codes_0 = readNPY('test_codes_0.npy');

train_codes_1 = readNPY('train_codes_1.npy');
test_codes_1 = readNPY('test_codes_1.npy');

train_codes_2 = readNPY('train_codes_2.npy');
test_codes_2 = readNPY('test_codes_2.npy');

train_codes_3 = readNPY('train_codes_3.npy');
test_codes_3 = readNPY('test_codes_3.npy');


%% GMM 0
gmm = fitgmdist(train_codes_0, 2);
probs = pdf(gmm, train_codes_0);
train_scores_0 = -log(probs);

probs = pdf(gmm, test_codes_0);
test_scores_0 = -log(probs);

for i = 1:length(test_scores_0)
    if test_scores_0(i) == inf
        test_scores_0(i) = 'a';
    end
end

b = max(test_scores_0);
for i = 1:length(test_scores_0)
    if test_scores_0(i) == 'a'
        test_scores_0(i) = b;
    end
end


%% GMM 1
gmm = fitgmdist(train_codes_1, 2);
probs = pdf(gmm, train_codes_1);
train_scores_1 = -log(probs);

probs = pdf(gmm, test_codes_1);
test_scores_1 = -log(probs);

for i = 1:length(test_scores_1)
    if test_scores_1(i) == inf
        test_scores_1(i) = 'a';
    end
end

b = max(test_scores_1);
for i = 1:length(test_scores_1)
    if test_scores_1(i) == 'a'
        test_scores_1(i) = b;
    end
end

%% GMM 2
gmm = fitgmdist(train_codes_2, 2)
% gmm = load("gmm.mat");
probs = pdf(gmm, train_codes_2);
train_scores_2 = -log(probs);

probs = pdf(gmm, test_codes_2);
test_scores_2 = -log(probs);

for i = 1:length(test_scores_2)
    if test_scores_2(i) == inf
        test_scores_2(i) = 'a';
    end
end

b = max(test_scores_2);
for i = 1:length(test_scores_2)
    if test_scores_2(i) == 'a'
        test_scores_2(i) = b;
    end
end

%% GMM 3
gmm = fitgmdist(train_codes_3, 2);
probs = pdf(gmm, train_codes_3);
train_scores_3 = -log(probs);

probs = pdf(gmm, test_codes_3);
test_scores_3 = -log(probs);

for i = 1:length(test_scores_3)
    if test_scores_3(i) == inf
        test_scores_3(i) = 'a';
    end
end

b = max(test_scores_3);
for i = 1:length(test_scores_3)
    if test_scores_3(i) == 'a'
        test_scores_3(i) = b;
    end
end

%% 

train_scores = [train_scores_0, train_scores_1, train_scores_2, train_scores_3];
train_scores_max = max(train_scores,[],2);

save("nuclear_GMM_train_sap.mat","train_scores_max")

test_scores = [test_scores_0, test_scores_1, test_scores_2, test_scores_3];
test_scores_max = max(test_scores,[],2);

save("nuclear_GMM_test_sap.mat","test_scores_max")

%% EVALUATE 
codes = test_scores_max;

normal = codes(1:51)';
anomaly = codes(52:end)';

for i = 1:floor(499/20)
    test_codes(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end
% test_codes(i+1,:) = [normal, anomaly(491:end), anomaly(489:end)];
labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_gmm(i) = 0;
    [~, ~, ~, auc_gmm(i)] = perfcurve(labels, test_codes(i,:), 1);
end
auc_gmm_mean = mean(auc_gmm)

sorted_codes = sort(test_codes,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_GMM(i) = 0;
    FNR_GMM(i) = 0;
    TPR_GMM(i) = 0;
    FPR_GMM(i) = 0;
    for j = 52:71
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_GMM(i) = a(i)/20;
        FPR_GMM(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_GMM(i) = n(i)/51;
        FNR_GMM(i) = n_f(i)/51;
    end
end
tolal_TNR_GMM = mean(TNR_GMM)
tolal_FNR_GMM = mean(FNR_GMM)
tolal_TPR_GMM = mean(TPR_GMM)
tolal_FPR_GMM = mean(FPR_GMM)


acc = (a+n)/71;
acc_GMM = mean(acc)

return

%% EVALUATE 

a = 0;
a_f = 0;
n = 0;
n_f = 0;

for i = 52:length(test_scores_max)
    if test_scores_max(i) > max(train_scores_max)
        a = a + 1;
    else
        a_f = a_f + 1;
    end
end

TNR = a/499;
FNR = a_f/499;

for i = 1:51
    if test_scores_max(i) <= max(train_scores_max)
        n = n + 1;
    else
        n_f = n_f + 1;
    end
end

TPR = n/51;
FPR = n_f/51;

acc_max = (TNR+TPR)/2;





