

clear
close all
clc
rng("default")

%%
AE_loss_train = readNPY("train_losses_FC.npy");
AE_loss_test = readNPY("test_losses_FC.npy");

SAE_loss_train = readNPY("train_losses_SSA.npy");
SAE_loss_test = readNPY("test_losses_SSA.npy");

%% histgrom

figure('Name','test')
subplot(2,1,1), hold on
title('SAE loss')
histogram(SAE_loss_test(1:526),'NumBins',100)
histogram(SAE_loss_test(527:end),'NumBins',100)
hold off

subplot(2,1,2), hold on
title('AE loss')
histogram(AE_loss_test(1:526),'NumBins',100)
histogram(AE_loss_test(527:end),'NumBins',100)
hold off

%%

SAE_GMM_train = load("SAE_GMM_train.mat");
SAE_GMM_test = load("SAE_GMM_test.mat");
SAE_LOF_train = load("SAE_LOF_train.mat");
SAE_LOF_test = load("SAE_LOF_test.mat");
SAE_IF_train = load("SAE_IF_train.mat");
SAE_IF_test = load("SAE_IF_test.mat");

SAE_LOF_train = SAE_LOF_train.train_scores;
SAE_LOF_test = SAE_LOF_test.test_scores;
SAE_GMM_train = SAE_GMM_train.train_scores;
SAE_GMM_test = SAE_GMM_test.test_scores;
SAE_IF_train = SAE_IF_train.train_scores;
SAE_IF_test = SAE_IF_test.test_scores;


%% ecdf train
figure('Name','ecdf')
subplot(2,2,1)
[SAE_loss_ecdf,SAE_loss] = ecdf(SAE_loss_train);
ecdf(SAE_loss_train)
title('SAE loss')

subplot(2,2,2)
[AE_loss_ecdf,AE_loss] = ecdf(AE_loss_train);
ecdf(AE_loss_train)
title('AE loss')

subplot(2,2,3)
[GMM_ecdf,GMM_scores] = ecdf(SAE_GMM_train);
ecdf(SAE_GMM_train)
title('GMM')

subplot(2,2,4)
[LOF_ecdf,LOF_scores] = ecdf(SAE_LOF_train);
ecdf(SAE_LOF_train)
title('LOF')

average_sum_ecdf_train = (SAE_loss_ecdf+AE_loss_ecdf(2:end) ...
    +GMM_ecdf(2:end)+LOF_ecdf(2:end))/4;


%% ecdf
x_ecdf_SAE = fun(SAE_loss(1:2030), SAE_loss_ecdf, SAE_loss_test);
x_ecdf_AE = fun(AE_loss(1:2030), AE_loss_ecdf, AE_loss_test);
x_ecdf_LOF = fun(LOF_scores(1:2030), LOF_ecdf, SAE_LOF_test);
x_ecdf_GMM = fun(GMM_scores(1:2030), GMM_ecdf, SAE_GMM_test);
%% average sum

average_sum_ecdf = (x_ecdf_SAE+x_ecdf_AE+x_ecdf_LOF+x_ecdf_GMM)/4;

figure('Name','test_ecdf'),hold on
histogram(average_sum_ecdf(1:526),'NumBins',100)
histogram(average_sum_ecdf(527:end),'NumBins',100)
hold off

figure('Name','train_ecdf'),hold on
histogram(average_sum_ecdf_train,'NumBins',100)
hold off


%% max

ecdf = [x_ecdf_SAE;x_ecdf_AE;x_ecdf_LOF;x_ecdf_GMM];
ecdf_max = max(ecdf);

figure('Name','test_ecdf_max'),hold on
histogram(ecdf_max(1:526),'NumBins',100)
histogram(ecdf_max(527:end),'NumBins',100)

%% damped average

damped_average_ecdf = (sqrt(x_ecdf_SAE)+sqrt(x_ecdf_AE)+sqrt(x_ecdf_LOF)+sqrt(x_ecdf_GMM))/4;

figure('Name','damped_average_ecdf'),hold on
histogram(damped_average_ecdf(1:526),'NumBins',100)
histogram(damped_average_ecdf(527:end),'NumBins',100)
% %% KPV
% 
% ecdf = [x_ecdf_SAE;x_ecdf_AE;x_ecdf_LOF;x_ecdf_GMM];
% ecdf_min = min(ecdf);
% ecdf_ = ecdf - [ecdf_min; ecdf_min; ecdf_min; ecdf_min];
% 
% ecdf_KPV = sum(ecdf_)/3+ecdf_min;
% 
% figure('Name','ecdf_AKPV'),hold on
% histogram(ecdf_KPV(1:526),'NumBins',100)
% histogram(ecdf_KPV(527:end),'NumBins',100)

%% AKPV

ecdf_AKPV = (x_ecdf_SAE+x_ecdf_LOF+x_ecdf_GMM)/3;

figure('Name','test_ecdf'),hold on
histogram(ecdf_AKPV(1:526),'NumBins',100)
histogram(ecdf_AKPV(527:end),'NumBins',100)
hold off


%% ranking SAE
close all

normal_SAE = SAE_loss_test(1:526)';
anomaly_SAE = SAE_loss_test(527:end)';

for i = 1:floor(2081/20)
    codes(i,:) = [normal_SAE, anomaly_SAE((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_sae(i) = 0;
    [~, ~, ~, auc_sae(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_sae_mean = mean(auc_sae);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_SAE(i) = 0;
    FNR_SAE(i) = 0;
    TPR_SAE(i) = 0;
    FPR_SAE(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_SAE(i) = a(i)/20;
        FPR_SAE(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_SAE(i) = n(i)/526;
        FNR_SAE(i) = n_f(i)/526;
    end
end
tolal_TNR_SAE = mean(TNR_SAE);
tolal_FNR_SAE = mean(FNR_SAE);
tolal_TPR_SAE = mean(TPR_SAE);
tolal_FPR_SAE = mean(FPR_SAE);

acc = (a+n)/546;
acc_SAE = mean(acc);

%% ranking AE
close all

normal_AE = AE_loss_test(1:526)';
anomaly_AE = AE_loss_test(527:end)';

for i = 1:floor(2081/20)
    codes(i,:) = [normal_AE, anomaly_AE((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_ae(i) = 0;
    [~, ~, ~, auc_ae(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_ae_mean = mean(auc_ae);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_AE(i) = 0;
    FNR_AE(i) = 0;
    TPR_AE(i) = 0;
    FPR_AE(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_AE(i) = a(i)/20;
        FPR_AE(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_AE(i) = n(i)/526;
        FNR_AE(i) = n_f(i)/526;
    end
end
tolal_TNR_AE = mean(TNR_AE);
tolal_FNR_AE = mean(FNR_AE);
tolal_TPR_AE = mean(TPR_AE);
tolal_FPR_AE = mean(FPR_AE);

acc = (a+n)/546;
acc_AE = mean(acc);
%% ranking GMM
close all

normal_GMM = SAE_GMM_test(1:526)';
anomaly_GMM = SAE_GMM_test(527:end)';

for i = 1:floor(2081/20)
    codes(i,:) = [normal_GMM, anomaly_GMM((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_gmm(i) = 0;
    [~, ~, ~, auc_gmm(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_gmm_mean = mean(auc_gmm);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_GMM(i) = 0;
    FNR_GMM(i) = 0;
    TPR_GMM(i) = 0;
    FPR_GMM(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_GMM(i) = a(i)/20;
        FNR_GMM(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_GMM(i) = n(i)/526;
        FPR_GMM(i) = n_f(i)/526;
    end
end

tolal_TNR_GMM = mean(TNR_GMM);
tolal_FNR_GMM = mean(FNR_GMM);
tolal_TPR_GMM = mean(TPR_GMM);
tolal_FPR_GMM = mean(FPR_GMM);

acc = (a+n)/546;
acc_GMM = mean(acc);
%% ranking LOF
close all

normal_LOF = SAE_LOF_test(1:526)';
anomaly_LOF = SAE_LOF_test(527:end)';

for i = 1:floor(2081/20)
    codes(i,:) = [normal_LOF, anomaly_LOF((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_lof(i) = 0;
    [~, ~, ~, auc_lof(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_lof_mean = mean(auc_lof);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_LOF(i) = 0;
    FNR_LOF(i) = 0;
    TPR_LOF(i) = 0;
    FPR_LOF(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_LOF(i) = a(i)/20;
        FPR_LOF(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_LOF(i) = n(i)/526;
        FNR_LOF(i) = n_f(i)/526;
    end
end

tolal_TNR_LOF = mean(TNR_LOF);
tolal_FNR_LOF = mean(FNR_LOF);
tolal_TPR_LOF = mean(TPR_LOF);
tolal_FPR_LOF = mean(FPR_LOF);

acc = (a+n)/546;
acc_LOF = mean(acc);
%% ranking aom
close all

normal_aom = average_sum_ecdf(1:526);
anomaly_aom = average_sum_ecdf(527:end);

for i = 1:floor(2081/20)
    codes(i,:) = [normal_aom, anomaly_aom((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_aom(i) = 0;
    [~, ~, ~, auc_aom(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_aom_mean = mean(auc_aom);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_aom(i) = 0;
    FNR_aom(i) = 0;
    TPR_aom(i) = 0;
    FPR_aom(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_aom(i) = a(i)/20;
        FPR_aom(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_aom(i) = n(i)/526;
        FNR_aom(i) = n_f(i)/526;
    end
end

tolal_TNR_aom = mean(TNR_aom);
tolal_FNR_aom = mean(FNR_aom);
tolal_TPR_aom = mean(TPR_aom);
tolal_FPR_aom = mean(FPR_aom);

acc = (a+n)/546;
acc_aom = mean(acc);
%% ranking max
close all

normal_max = ecdf_max(1:526);
anomaly_max = ecdf_max(527:end);

for i = 1:floor(2081/20)
    codes(i,:) = [normal_max, anomaly_max((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_max(i) = 0;
    [~, ~, ~, auc_max(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_max_mean = mean(auc_max);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_max(i) = 0;
    FNR_max(i) = 0;
    TPR_max(i) = 0;
    FPR_max(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_max(i) = a(i)/20;
        FPR_max(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_max(i) = n(i)/526;
        FNR_max(i) = n_f(i)/526;
    end
end

tolal_TNR_max = mean(TNR_max);
tolal_FNR_max = mean(FNR_max);
tolal_TPR_max = mean(TPR_max);
tolal_FPR_max = mean(FPR_max);

acc = (a+n)/546;
acc_max = mean(acc);

%% ranking damped average
close all

normal_da = damped_average_ecdf(1:526);
anomaly_da = damped_average_ecdf(527:end);

for i = 1:floor(2081/20)
    codes(i,:) = [normal_da, anomaly_da((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_da(i) = 0;
    [~, ~, ~, auc_da(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_da_mean = mean(auc_da);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_da(i) = 0;
    FNR_da(i) = 0;
    TPR_da(i) = 0;
    FPR_da(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_da(i) = a(i)/20;
        FPR_da(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_da(i) = n(i)/526;
        FNR_da(i) = n_f(i)/526;
    end
end

tolal_TNR_da = mean(TNR_da);
tolal_FNR_da = mean(FNR_da);
tolal_TPR_da = mean(TPR_da);
tolal_FPR_da = mean(FPR_da);

acc = (a+n)/546;
acc_da = mean(acc);

%% ranking KPV
% close all
% 
% normal_KPV = ecdf_KPV(1:526);
% anomaly_KPV = ecdf_KPV(527:end);
% 
% for i = 1:floor(2081/20)
%     codes(i,:) = [normal_KPV, anomaly_KPV((i-1)*20+1:i*20)];
% end
% 
% labels = [zeros(1,526), ones(1,20)];
% for i=1:104
%     auc_kpv(i) = 0;
%     [~, ~, ~, auc_kpv(i)] = perfcurve(labels, codes(i,:), 1);
% end
% auc_kpv_mean = mean(auc_kpv);
% 
% sorted_codes = sort(codes,2);
% 
% for i=1:104
%     a(i) = 0;
%     a_f(i) = 0;
%     n(i) = 0;
%     n_f(i) = 0;
%     TNR_KPV(i) = 0;
%     FNR_KPV(i) = 0;
%     TPR_KPV(i) = 0;
%     FPR_KPV(i) = 0;
%     for j = 527:546
%         index = find(codes(i,:) == sorted_codes(i,j));
%         codes(i,index(end)) = nan;
%         if index(end) > 526
%             a(i) = a(i) + 1;
%         else
%             a_f(i) = a_f(i) + 1;
%         end
%         TNR_KPV(i) = a(i)/20;
%         FPR_KPV(i) = a_f(i)/20;
%     end
%     for j = 1:526
%         index = find(codes(i,:) == sorted_codes(i,j));
%         codes(i,index(end)) = nan;
%         if index(end) < 527
%             n(i) = n(i) + 1;
%         else
%             n_f(i) = n_f(i) + 1;
%         end
%         TPR_KPV(i) = n(i)/526;
%         FNR_KPV(i) = n_f(i)/526;
%     end
% end
% 
% 
% tolal_TNR_KPV = mean(TNR_KPV);
% tolal_FNR_KPV = mean(FNR_KPV);
% tolal_TPR_KPV = mean(TPR_KPV);
% tolal_FPR_KPV = mean(FPR_KPV);
% acc = (a+n)/546;
% acc_KPV = mean(acc);


%% ranking AKPV
close all

normal_AKPV = ecdf_AKPV(1:526);
anomaly_AKPV = ecdf_AKPV(527:end);

for i = 1:floor(2081/20)
    codes(i,:) = [normal_AKPV, anomaly_AKPV((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_akpv(i) = 0;
    [~, ~, ~, auc_akpv(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_akpv_mean = mean(auc_akpv)

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_AKPV(i) = 0;
    FNR_AKPV(i) = 0;
    TPR_AKPV(i) = 0;
    FPR_AKPV(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_AKPV(i) = a(i)/20;
        FPR_AKPV(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_AKPV(i) = n(i)/526;
        FNR_AKPV(i) = n_f(i)/526;
    end
end


tolal_TNR_AKPV = mean(TNR_AKPV)
tolal_FNR_AKPV = mean(FNR_AKPV)
tolal_TPR_AKPV = mean(TPR_AKPV)
tolal_FPR_AKPV = mean(FPR_AKPV)
acc = (a+n)/546;
acc_AKPV = mean(acc)