

clear
close all
clc

%% load data
AE_loss_train = readNPY("train_losses_FC.npy");
AE_loss_test = readNPY("test_losses_FC.npy");

SAE_loss_train = readNPY("train_losses_SSA.npy");
SAE_loss_test = readNPY("test_losses_SSA.npy");

%% ecdf train
figure('Name','ecdf')
subplot(2,2,1)
[SAE_loss_ecdf,SAE_loss] = ecdf(SAE_loss_train);
ecdf(SAE_loss_train)
title('SAE loss')

subplot(2,2,2)
[AE_loss_ecdf,AE_loss] = ecdf(AE_loss_train);
ecdf(AE_loss_train)
title('AE loss')


%% ecdf
x_ecdf_SAE = fun(SAE_loss(1:2030), SAE_loss_ecdf, SAE_loss_test);
x_ecdf_AE = fun(AE_loss(1:2030), AE_loss_ecdf, AE_loss_test);

%% ecdf processing
average_sum_ecdf = (x_ecdf_SAE+x_ecdf_AE);
ecdf = [x_ecdf_SAE;x_ecdf_AE];
ecdf_max = max(ecdf);
damped_average_ecdf = (sqrt(x_ecdf_SAE)+sqrt(x_ecdf_AE))/2;

ecdf_min = min(ecdf);
ecdf_ = ecdf - [ecdf_min; ecdf_min];

ecdf_AKPV = sum(ecdf_)+ecdf_min;


%% ranking aom
close all

normal_aom = average_sum_ecdf(1:526);
anomaly_aom = average_sum_ecdf(527:end);

for i = 1:floor(2081/20)
    codes(i,:) = [normal_aom, anomaly_aom((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_aom(i) = 0;
    [~, ~, ~, auc_aom(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_aom_mean = mean(auc_aom);


sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_aom(i) = 0;
    FNR_aom(i) = 0;
    TPR_aom(i) = 0;
    FPR_aom(i) = 0;

    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_aom(i) = a(i)/20;
        FPR_aom(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_aom(i) = n(i)/526;
        FNR_aom(i) = n_f(i)/526;
    end
end

tolal_TNR_aom = mean(TNR_aom);
tolal_FNR_aom = mean(FNR_aom);
tolal_TPR_aom = mean(TPR_aom);
tolal_FPR_aom = mean(FPR_aom);

acc = (a+n)/546;
acc_aom = mean(acc);

%% ranking max
close all

normal_max = ecdf_max(1:526);
anomaly_max = ecdf_max(527:end);

for i = 1:floor(2081/20)
    codes(i,:) = [normal_max, anomaly_max((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_max(i) = 0;
    [~, ~, ~, auc_max(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_max_mean = mean(auc_max);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_max(i) = 0;
    FNR_max(i) = 0;
    TPR_max(i) = 0;
    FPR_max(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_max(i) = a(i)/20;
        FPR_max(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_max(i) = n(i)/526;
        FNR_max(i) = n_f(i)/526;
    end
end

tolal_TNR_max = mean(TNR_max);
tolal_FNR_max = mean(FNR_max);
tolal_TPR_max = mean(TPR_max);
tolal_FPR_max = mean(FPR_max);

acc = (a+n)/546;
acc_max = mean(acc);

%% ranking damped average
close all

normal_da = damped_average_ecdf(1:526);
anomaly_da = damped_average_ecdf(527:end);

for i = 1:floor(2081/20)
    codes(i,:) = [normal_da, anomaly_da((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_da(i) = 0;
    [~, ~, ~, auc_da(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_da_mean = mean(auc_da);

sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_da(i) = 0;
    FNR_da(i) = 0;
    TPR_da(i) = 0;
    FPR_da(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_da(i) = a(i)/20;
        FPR_da(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_da(i) = n(i)/526;
        FNR_da(i) = n_f(i)/526;
    end
end

tolal_TNR_da = mean(TNR_da);
tolal_FNR_da = mean(FNR_da);
tolal_TPR_da = mean(TPR_da);
tolal_FPR_da = mean(FPR_da);

acc = (a+n)/546;
acc_da = mean(acc);

%% ranking KPV
close all

normal_AKPV = ecdf_AKPV(1:526);
anomaly_AKPV = ecdf_AKPV(527:end);

for i = 1:floor(2081/20)
    codes(i,:) = [normal_AKPV, anomaly_AKPV((i-1)*20+1:i*20)];
end

labels = [zeros(1,526), ones(1,20)];
for i=1:104
    auc_akpv(i) = 0;
    [~, ~, ~, auc_akpv(i)] = perfcurve(labels, codes(i,:), 1);
end
auc_akpv_mean = mean(auc_akpv)


sorted_codes = sort(codes,2);

for i=1:104
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR_AKPV(i) = 0;
    FNR_AKPV(i) = 0;
    TPR_AKPV(i) = 0;
    FPR_AKPV(i) = 0;
    for j = 527:546
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) > 526
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR_AKPV(i) = a(i)/20;
        FPR_AKPV(i) = a_f(i)/20;
    end
    for j = 1:526
        index = find(codes(i,:) == sorted_codes(i,j));
        codes(i,index(end)) = nan;
        if index(end) < 527
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR_AKPV(i) = n(i)/526;
        FNR_AKPV(i) = n_f(i)/526;
    end
end


tolal_TNR_AKPV = mean(TNR_AKPV)
tolal_FNR_AKPV = mean(FNR_AKPV)
tolal_TPR_AKPV = mean(TPR_AKPV)
tolal_FPR_AKPV = mean(FPR_AKPV)
acc = (a+n)/546;
acc_AKPV = mean(acc)