

clear
close all
clc
rng('default')

%% 
train_codes = readNPY('train_codes_SSA.npy'); 
val_codes = readNPY('valid_codes_SSA.npy');
test_codes = readNPY('test_codes_SSA.npy');


normal_test = test_codes(1:526,:);
anomaly_test = test_codes(527:end,:);

codes = [normal_test; anomaly_test(1:20,:)];

%% LOF
% codes
[Mdl,tf,train_scores] = lof(train_codes); 
figure("name","LOF")
h = histogram(train_scores,NumBins=50);

save("SAE_LOF_train.mat","train_scores")

[~, test_scores] = isanomaly(Mdl,test_codes);

figure("name","LOF_")
h_normal = histogram(test_scores(1:526),NumBins=50);
hold on
h_anormaly = histogram(test_scores(527:end),NumBins=50);
hold off

save("SAE_LOF_test.mat","test_scores")

