window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"fedbox": {"fullname": "fedbox", "modulename": "fedbox", "kind": "module", "doc": "<p>This package allows running customizable federated simulations on two different dataset families.</p>\n\n<ol>\n  <li>FEMNIST (written digits subsets) (see <a href=\"https://arxiv.org/pdf/1812.01097\">paper</a>)</li>\n  <li>CIFAR10 and CIFAR100 (see <a href=\"https://www.cs.toronto.edu/~kriz/learning-features-2009-TR.pdf\">paper</a>)</li>\n</ol>\n\n<p>Three possible algorithms can be chosen.</p>\n\n<ol>\n  <li>FedAvg (see <a href=\"https://arxiv.org/pdf/1602.05629\">paper</a>)</li>\n  <li>FedProx (see <a href=\"https://arxiv.org/pdf/1812.06127\">paper</a>)</li>\n  <li>Our novel framework proposed in the paper alongside this supplemental code\n</ol>\n\n<h6 id=\"examples\">Examples</h6>\n\n<p>This example lets you run a simulation on imbalanced FEMNIST dataset using our proposed algorithm\nwith beta equal to 0.70 (perturbation parameter) and a logistic regression model. Moreover, the simulation \nin scheduled with 200 global rounds and 10 local optimization epochs per each. The number of training\nand testing clients is 100 (per each group). The simulation saves the data in the './simulations'\ndirectory as a JSON file.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">n_rounds</span> <span class=\"o\">=</span> <span class=\"mi\">200</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">n_epochs</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">class_imbalance</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">data_imbalance</span> <span class=\"o\">=</span> <span class=\"mi\">1</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">n_clients</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">datasets</span> <span class=\"o\">=</span> <span class=\"n\">femnist</span><span class=\"p\">(</span>\n<span class=\"go\">        &#39;./data&#39;, </span>\n<span class=\"go\">        n_subsets = n_clients,</span>\n<span class=\"go\">        transform = transforms.Compose([</span>\n<span class=\"go\">            transforms.Normalize((0.5,), (0.5,))</span>\n<span class=\"go\">        ]),</span>\n<span class=\"go\">        heterogeneity_degree = class_imbalance,</span>\n<span class=\"go\">        samples_variance = data_imbalance,</span>\n<span class=\"go\">        strict = False,</span>\n<span class=\"go\">        seed = 0</span>\n<span class=\"go\">    )</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">model</span> <span class=\"o\">=</span> <span class=\"n\">MultinomialLogisticRegression</span><span class=\"p\">(</span><span class=\"n\">n_inputs</span> <span class=\"o\">=</span> <span class=\"mi\">784</span><span class=\"p\">,</span> <span class=\"n\">n_classes</span> <span class=\"o\">=</span> <span class=\"mi\">10</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">scheme</span> <span class=\"o\">=</span> <span class=\"n\">AdjancencyWeightingScheme</span><span class=\"p\">(</span><span class=\"n\">datasets</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">logger</span> <span class=\"o\">=</span> <span class=\"n\">Logger</span><span class=\"p\">(</span>\n<span class=\"go\">        directory = &#39;./simulations&#39;, </span>\n<span class=\"go\">        simulation = { &#39;dataset&#39;: &#39;femnist&#39;, &#39;class_imbalance&#39;: class_imbalance, &#39;data_imbalance&#39;: data_imbalance }, </span>\n<span class=\"go\">        convergence = lambda values: values[&#39;step&#39;] if values[&#39;accuracy.testing&#39;] &gt;= 0.75 else None, </span>\n<span class=\"go\">        enable = True</span>\n<span class=\"go\">    )</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">coordinator</span> <span class=\"o\">=</span> <span class=\"n\">ours</span><span class=\"o\">.</span><span class=\"n\">Coordinator</span><span class=\"p\">(</span><span class=\"n\">beta</span> <span class=\"o\">=</span> <span class=\"mf\">0.70</span><span class=\"p\">,</span> <span class=\"n\">model</span><span class=\"p\">,</span> <span class=\"n\">datasets</span><span class=\"p\">,</span> <span class=\"n\">scheme</span><span class=\"p\">,</span> <span class=\"n\">logger</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">coordinator</span><span class=\"o\">.</span><span class=\"n\">run</span><span class=\"p\">(</span><span class=\"n\">n_iterations</span> <span class=\"o\">=</span> <span class=\"n\">n_rounds</span><span class=\"p\">,</span> <span class=\"n\">n_epochs</span> <span class=\"o\">=</span> <span class=\"n\">n_epochs</span><span class=\"p\">,</span> <span class=\"n\">batch_size</span> <span class=\"o\">=</span> <span class=\"mi\">256</span><span class=\"p\">,</span> <span class=\"n\">step_size</span> <span class=\"o\">=</span> <span class=\"mf\">1e-3</span><span class=\"p\">,</span> <span class=\"n\">l2_penalty</span> <span class=\"o\">=</span> <span class=\"mf\">1e-4</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">flush</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n"}, "fedbox.datasets": {"fullname": "fedbox.datasets", "modulename": "fedbox.datasets", "kind": "module", "doc": "<p>This submodule defines the federated version of the following datasets.</p>\n\n<ol>\n  <li>FEMNIST (written digits subsets) (see <a href=\"https://arxiv.org/pdf/1812.01097\">paper</a>) that can be loaded with <b>femnist(...)</b>.</li>\n  <li>CIFAR10 and CIFAR100 (see <a href=\"https://www.cs.toronto.edu/~kriz/learning-features-2009-TR.pdf\">paper</a>) that can be loaded with <b>cifar10(...)</b> and <b>cifar100(...)</b>, respectively.</li>\n</ol>\n\n<p>In addition, here we define the routine <strong>partition(...)</strong> that partitions a centralized dataset in multiple subsets where each corresponds to a client. This function\nis responsible injecting the specified level of heterogeneity in the generation of the federated subsets.</p>\n"}, "fedbox.datasets.cifar10": {"fullname": "fedbox.datasets.cifar10", "modulename": "fedbox.datasets.cifar10", "kind": "module", "doc": "<p></p>\n"}, "fedbox.datasets.cifar10.cifar10": {"fullname": "fedbox.datasets.cifar10.cifar10", "modulename": "fedbox.datasets.cifar10", "qualname": "cifar10", "kind": "function", "doc": "<p>Loads the <code>CIFAR10</code> dataset and partitions it into <code>n_subsets</code> training subsets and \n<code>n_subsets</code> testing subsets according to heterogeneity parameters <code>heterogeneity_degree</code> \nand <code>samples_variance</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>directory</strong> (str):\nRoot directory to load the dataset</li>\n<li><strong>n_subsets</strong> (int):\nNumber of datasets for splitting</li>\n<li><strong>heterogeneity_degree</strong> (float):\nClass heterogeneity degree, by default is homogeneous</li>\n<li><strong>samples_variance</strong> (float):\nStandard deviation (%) in the number of samples for each client, <code>0</code> by default</li>\n<li><strong>transform</strong> (Any):\nTransformation to apply on data samples, <code>None</code> by default</li>\n<li><strong>target_transform</strong> (Any):\nTransformation to apply on data labels, <code>None</code> by default</li>\n<li><strong>seed</strong> (int):\nRandom seed initializer</li>\n<li><strong>strict</strong> (bool):\nIn strict mode <code>heterogeneity_degree</code> and <code>samples_variance</code> are highly respected,\notherwise flexibility is allowed</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, list[utils.FederatedSubset]]</strong>: Returns the lists of subsets of training clients and testing clients</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">directory</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">n_subsets</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">heterogeneity_degree</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">samples_variance</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">transform</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">target_transform</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">seed</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "fedbox.datasets.cifar100": {"fullname": "fedbox.datasets.cifar100", "modulename": "fedbox.datasets.cifar100", "kind": "module", "doc": "<p></p>\n"}, "fedbox.datasets.cifar100.cifar100": {"fullname": "fedbox.datasets.cifar100.cifar100", "modulename": "fedbox.datasets.cifar100", "qualname": "cifar100", "kind": "function", "doc": "<p>Loads the <code>CIFAR100</code> dataset and partitions it into <code>n_subsets</code> training subsets and \n<code>n_subsets</code> testing subsets according to heterogeneity parameters <code>heterogeneity_degree</code> \nand <code>samples_variance</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>directory</strong> (str):\nRoot directory to load the dataset</li>\n<li><strong>n_subsets</strong> (int):\nNumber of datasets for splitting</li>\n<li><strong>heterogeneity_degree</strong> (float):\nClass heterogeneity degree, by default is homogeneous</li>\n<li><strong>samples_variance</strong> (float):\nStandard deviation (%) in the number of samples for each client, <code>0</code> by default</li>\n<li><strong>transform</strong> (Any):\nTransformation to apply on data samples, <code>None</code> by default</li>\n<li><strong>target_transform</strong> (Any):\nTransformation to apply on data labels, <code>None</code> by default</li>\n<li><strong>seed</strong> (int):\nRandom seed initializer</li>\n<li><strong>strict</strong> (bool):\nIn strict mode <code>heterogeneity_degree</code> and <code>samples_variance</code> are highly respected,\notherwise flexibility is allowed</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, list[utils.FederatedSubset]]</strong>: Returns the lists of subsets of training clients and testing clients</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">directory</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">n_subsets</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">heterogeneity_degree</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">samples_variance</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">transform</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">target_transform</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">seed</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "fedbox.datasets.femnist": {"fullname": "fedbox.datasets.femnist", "modulename": "fedbox.datasets.femnist", "kind": "module", "doc": "<p></p>\n"}, "fedbox.datasets.femnist.FEMNIST": {"fullname": "fedbox.datasets.femnist.FEMNIST", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST", "kind": "class", "doc": "<p>This class loads the FEMNIST dataset, specifically only its 10 classes subset with written digit in [0, 9].</p>\n\n<h6 id=\"note\">Note</h6>\n\n<p>The dataset must be downloaded beforehand using the instructions in the file README.md.</p>\n", "bases": "typing.Generic[+T_co]"}, "fedbox.datasets.femnist.FEMNIST.__init__": {"fullname": "fedbox.datasets.femnist.FEMNIST.__init__", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">root</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">train</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">transform</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">target_transform</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">download</span><span class=\"o\">=</span><span class=\"kc\">True</span></span>)</span>"}, "fedbox.datasets.femnist.FEMNIST.root": {"fullname": "fedbox.datasets.femnist.FEMNIST.root", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST.root", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.datasets.femnist.FEMNIST.train": {"fullname": "fedbox.datasets.femnist.FEMNIST.train", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST.train", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.datasets.femnist.FEMNIST.transform": {"fullname": "fedbox.datasets.femnist.FEMNIST.transform", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST.transform", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"fullname": "fedbox.datasets.femnist.FEMNIST.target_transform", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST.target_transform", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.datasets.femnist.FEMNIST.download": {"fullname": "fedbox.datasets.femnist.FEMNIST.download", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST.download", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.datasets.femnist.FEMNIST.data": {"fullname": "fedbox.datasets.femnist.FEMNIST.data", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST.data", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.datasets.femnist.FEMNIST.targets": {"fullname": "fedbox.datasets.femnist.FEMNIST.targets", "modulename": "fedbox.datasets.femnist", "qualname": "FEMNIST.targets", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.datasets.femnist.femnist": {"fullname": "fedbox.datasets.femnist.femnist", "modulename": "fedbox.datasets.femnist", "qualname": "femnist", "kind": "function", "doc": "<p>Loads the <code>FEMNIST</code> dataset and partitions it into <code>n_subsets</code> training subsets and \n<code>n_subsets</code> testing subsets according to heterogeneity parameters <code>heterogeneity_degree</code> \nand <code>samples_variance</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>directory</strong> (str):\nRoot directory to load the dataset</li>\n<li><strong>n_subsets</strong> (int):\nNumber of datasets for splitting</li>\n<li><strong>heterogeneity_degree</strong> (float):\nClass heterogeneity degree, by default is homogeneous</li>\n<li><strong>samples_variance</strong> (float):\nStandard deviation (%) in the number of samples for each client, <code>0</code> by default</li>\n<li><strong>transform</strong> (Any):\nTransformation to apply on data samples, <code>None</code> by default</li>\n<li><strong>target_transform</strong> (Any):\nTransformation to apply on data labels, <code>None</code> by default</li>\n<li><strong>seed</strong> (int):\nRandom seed initializer</li>\n<li><strong>strict</strong> (bool):\nIn strict mode <code>heterogeneity_degree</code> and <code>samples_variance</code> are highly respected,\notherwise flexibility is allowed</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, list[utils.FederatedSubset]]</strong>: Returns the lists of subsets of training clients and testing clients</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">directory</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">n_subsets</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1000</span>,</span><span class=\"param\">\t<span class=\"n\">heterogeneity_degree</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">samples_variance</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">transform</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">target_transform</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">seed</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "fedbox.datasets.utils": {"fullname": "fedbox.datasets.utils", "modulename": "fedbox.datasets.utils", "kind": "module", "doc": "<p></p>\n"}, "fedbox.datasets.utils.FederatedSubset": {"fullname": "fedbox.datasets.utils.FederatedSubset", "modulename": "fedbox.datasets.utils", "qualname": "FederatedSubset", "kind": "class", "doc": "<p>This class represents the local subset held by each client in a federated simulation.</p>\n", "bases": "torch.utils.data.dataset.Dataset[+T_co]"}, "fedbox.datasets.utils.FederatedSubset.__init__": {"fullname": "fedbox.datasets.utils.FederatedSubset.__init__", "modulename": "fedbox.datasets.utils", "qualname": "FederatedSubset.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dataset</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">data</span><span class=\"o\">.</span><span class=\"n\">dataset</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>, </span><span class=\"param\"><span class=\"n\">indices</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span></span>)</span>"}, "fedbox.datasets.utils.FederatedSubset.normalization": {"fullname": "fedbox.datasets.utils.FederatedSubset.normalization", "modulename": "fedbox.datasets.utils", "qualname": "FederatedSubset.normalization", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.datasets.utils.FederatedSubset.data": {"fullname": "fedbox.datasets.utils.FederatedSubset.data", "modulename": "fedbox.datasets.utils", "qualname": "FederatedSubset.data", "kind": "variable", "doc": "<p></p>\n", "annotation": ": torch.Tensor"}, "fedbox.datasets.utils.FederatedSubset.targets": {"fullname": "fedbox.datasets.utils.FederatedSubset.targets", "modulename": "fedbox.datasets.utils", "qualname": "FederatedSubset.targets", "kind": "variable", "doc": "<p></p>\n", "annotation": ": torch.Tensor"}, "fedbox.datasets.utils.set_seed": {"fullname": "fedbox.datasets.utils.set_seed", "modulename": "fedbox.datasets.utils", "qualname": "set_seed", "kind": "function", "doc": "<p>Sets the same random initialization seed across multiple libraries, and\nenables the usage of deterministic algorithms in PyTorch.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>s</strong> (int):\nSeed initialization value</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">s</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.datasets.utils.partition": {"fullname": "fedbox.datasets.utils.partition", "modulename": "fedbox.datasets.utils", "qualname": "partition", "kind": "function", "doc": "<p>Partitions a dataset in <code>n_subsets</code> heterogenously or homogenously according to\n<code>heterogeneity_degree</code> and <code>samples_variance</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>dataset</strong> (Dataset):\nDataset (pytorch)</li>\n<li><strong>n_subsets</strong> (int):\nNumber of datasets for splitting</li>\n<li><strong>n_classes</strong> (int):\nNumber of classes in the dataset, inferred if <code>None</code></li>\n<li><strong>heterogeneity_degree</strong> (float):\nClass heterogeneity degree, by default is homogeneous</li>\n<li><strong>samples_variance</strong> (float):\nStandard deviation (%) in the number of samples for each client, <code>0</code> by default</li>\n<li><strong>return_indices</strong> (bool):\nTo return indices instead of federated subsets</li>\n<li><strong>seed</strong> (int):\nRandom seed initializer</li>\n<li><strong>strict</strong> (bool):\nIn strict mode <code>heterogeneity_degree</code> and <code>samples_variance</code> are highly respected,\notherwise flexibility is allowed</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>Union[list[list[int]], list[FederatedSubset]]</strong>: If <code>return_indices</code> is <code>False</code> then returns federated subsets, otherwise indices</li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<p>Heterogeneity degree is the inverse of the concentration parameter of a Dirichelet distribution\nused to sample class ratios across each subset, whilst sample variance refers to the variance in\nthe number of samples assigned to each subset, which is extracted from a log-normal distribution.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">dataset</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">data</span><span class=\"o\">.</span><span class=\"n\">dataset</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>,</span><span class=\"param\">\t<span class=\"n\">n_subsets</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_classes</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">heterogeneity_degree</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">samples_variance</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">return_indices</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">seed</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]],</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "fedbox.models": {"fullname": "fedbox.models", "modulename": "fedbox.models", "kind": "module", "doc": "<p>This submodule defines the two main statistical models to be used in the simulations.</p>\n\n<ol>\n  <li><b>MultinomialLogisticRegression</b> is a multinomial logistic regression model that allows testing in a \n  smooth and strongly convex setting.</li>\n  <li><b>NeuralNetwork</b> is a simple ReLU-activated neural network with one hidden layer. This allows testing in\n  a nonconvex scenario.</li>\n</ol>\n"}, "fedbox.models.mlr": {"fullname": "fedbox.models.mlr", "modulename": "fedbox.models.mlr", "kind": "module", "doc": "<p></p>\n"}, "fedbox.models.mlr.MultinomialLogisticRegression": {"fullname": "fedbox.models.mlr.MultinomialLogisticRegression", "modulename": "fedbox.models.mlr", "qualname": "MultinomialLogisticRegression", "kind": "class", "doc": "<p>This class implements the multinomial logistic regression\nfor multiclass classification. The combination of this model\nand loss criterion yields a strongly convex loss objective.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<p>A cross-entropy loss is utilized during optimization, in Pytorch\nit is equivalent to log-softmax and negative log likelihood. Thus,\nwe do not need to apply softmax on the output layer, see <a href=\"https://pytorch.org/docs/stable/generated/torch.nn.CrossEntropyLoss.html#torch.nn.CrossEntropyLoss\">link</a>.</p>\n", "bases": "torch.nn.modules.module.Module"}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"fullname": "fedbox.models.mlr.MultinomialLogisticRegression.__init__", "modulename": "fedbox.models.mlr", "qualname": "MultinomialLogisticRegression.__init__", "kind": "function", "doc": "<p>Initialize internal Module state, shared by both nn.Module and ScriptModule.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">n_inputs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">n_classes</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span>)</span>"}, "fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"fullname": "fedbox.models.mlr.MultinomialLogisticRegression.flatten", "modulename": "fedbox.models.mlr", "qualname": "MultinomialLogisticRegression.flatten", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.models.mlr.MultinomialLogisticRegression.linear": {"fullname": "fedbox.models.mlr.MultinomialLogisticRegression.linear", "modulename": "fedbox.models.mlr", "qualname": "MultinomialLogisticRegression.linear", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"fullname": "fedbox.models.mlr.MultinomialLogisticRegression.forward", "modulename": "fedbox.models.mlr", "qualname": "MultinomialLogisticRegression.forward", "kind": "function", "doc": "<p>Define the computation performed at every call.</p>\n\n<p>Should be overridden by all subclasses.</p>\n\n<div class=\"pdoc-alert pdoc-alert-note\">\n\n<p>Although the recipe for forward pass needs to be defined within\nthis function, one should call the <code>Module</code> instance afterwards\ninstead of this since the former takes care of running the\nregistered hooks while the latter silently ignores them.</p>\n\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>:</span></span>", "funcdef": "def"}, "fedbox.models.nn": {"fullname": "fedbox.models.nn", "modulename": "fedbox.models.nn", "kind": "module", "doc": "<p></p>\n"}, "fedbox.models.nn.NeuralNetwork": {"fullname": "fedbox.models.nn.NeuralNetwork", "modulename": "fedbox.models.nn", "qualname": "NeuralNetwork", "kind": "class", "doc": "<p>Basic neural network with one hidden layer and ReLU activation. The\ncombination of this model and the loss criterion constitutes a nonconvex\nloss objective.</p>\n", "bases": "torch.nn.modules.module.Module"}, "fedbox.models.nn.NeuralNetwork.__init__": {"fullname": "fedbox.models.nn.NeuralNetwork.__init__", "modulename": "fedbox.models.nn", "qualname": "NeuralNetwork.__init__", "kind": "function", "doc": "<p>Initialize internal Module state, shared by both nn.Module and ScriptModule.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">n_inputs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">n_classes</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">n_hidden</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">128</span></span>)</span>"}, "fedbox.models.nn.NeuralNetwork.flatten": {"fullname": "fedbox.models.nn.NeuralNetwork.flatten", "modulename": "fedbox.models.nn", "qualname": "NeuralNetwork.flatten", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.models.nn.NeuralNetwork.linear1": {"fullname": "fedbox.models.nn.NeuralNetwork.linear1", "modulename": "fedbox.models.nn", "qualname": "NeuralNetwork.linear1", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.models.nn.NeuralNetwork.linear2": {"fullname": "fedbox.models.nn.NeuralNetwork.linear2", "modulename": "fedbox.models.nn", "qualname": "NeuralNetwork.linear2", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.models.nn.NeuralNetwork.forward": {"fullname": "fedbox.models.nn.NeuralNetwork.forward", "modulename": "fedbox.models.nn", "qualname": "NeuralNetwork.forward", "kind": "function", "doc": "<p>Define the computation performed at every call.</p>\n\n<p>Should be overridden by all subclasses.</p>\n\n<div class=\"pdoc-alert pdoc-alert-note\">\n\n<p>Although the recipe for forward pass needs to be defined within\nthis function, one should call the <code>Module</code> instance afterwards\ninstead of this since the former takes care of running the\nregistered hooks while the latter silently ignores them.</p>\n\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization": {"fullname": "fedbox.optimization", "modulename": "fedbox.optimization", "kind": "module", "doc": "<p>This submodule defines the three optimization algorithms that can\nbe used in the simulations. The structure of the code is the same\nfor each algorithm, and we always have two main components.</p>\n\n<ol>\n  <li>A <b>Coordinator</b> instance which represents the central server \n  broadcasting the model at the beginning of every round and performing the aggregation of\n  the received updates before the beginning of the next.</li>\n  <li>A <b>Agent</b> instance which performs local optimization and evaluation on its data samples \n  with a specific federated framework.</li>\n</ol>\n\n<p>For each algorithmic framework, we extend from the base classes <b>Coordinator</b> and <b>Agent</b> and\nwe specialize them accordingly to the specific procedure.</p>\n"}, "fedbox.optimization.fedavg": {"fullname": "fedbox.optimization.fedavg", "modulename": "fedbox.optimization.fedavg", "kind": "module", "doc": "<p></p>\n"}, "fedbox.optimization.fedavg.Agent": {"fullname": "fedbox.optimization.fedavg.Agent", "modulename": "fedbox.optimization.fedavg", "qualname": "Agent", "kind": "class", "doc": "<p>An agent (client) uses the FedAvg scheme to optimize a shared model on its local subset.</p>\n"}, "fedbox.optimization.fedavg.Agent.__init__": {"fullname": "fedbox.optimization.fedavg.Agent.__init__", "modulename": "fedbox.optimization.fedavg", "qualname": "Agent.__init__", "kind": "function", "doc": "<p>Initializes the agent with a local <code>subset</code> of data samples and labels.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>subset</strong> (utils.FederatedSubset):\nSubset of data samples and labels</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span></span>)</span>"}, "fedbox.optimization.fedavg.Agent.subset": {"fullname": "fedbox.optimization.fedavg.Agent.subset", "modulename": "fedbox.optimization.fedavg", "qualname": "Agent.subset", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedavg.Agent.step": {"fullname": "fedbox.optimization.fedavg.Agent.step", "modulename": "fedbox.optimization.fedavg", "qualname": "Agent.step", "kind": "function", "doc": "<p>Performs an optimization step on <code>model</code> using minibatch (<code>x</code>, <code>y</code>).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is optimized locally</li>\n<li><strong>x</strong> (torch.Tensor):\nData samples in the minibatch</li>\n<li><strong>y</strong> (torch.Tensor):\nData labels in the minibatch</li>\n<li><strong>optimizer</strong> (optim.Optimizer):\nGradient-based optimizer</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>,</span><span class=\"param\">\t<span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>,</span><span class=\"param\">\t<span class=\"n\">optimizer</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">optim</span><span class=\"o\">.</span><span class=\"n\">optimizer</span><span class=\"o\">.</span><span class=\"n\">Optimizer</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedavg.Agent.optimize": {"fullname": "fedbox.optimization.fedavg.Agent.optimize", "modulename": "fedbox.optimization.fedavg", "qualname": "Agent.optimize", "kind": "function", "doc": "<p>Runs <code>n_steps</code> stochastic gradient descent steps on the local dataset (one step for each minibatch).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps, i.e. number of minibatches</li>\n<li><strong>step_size</strong> (float):\nStep size or learning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of L2 (Tikhonov) regularization term</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedavg.Agent.multioptimize": {"fullname": "fedbox.optimization.fedavg.Agent.multioptimize", "modulename": "fedbox.optimization.fedavg", "qualname": "Agent.multioptimize", "kind": "function", "doc": "<p>Runs <code>n_epochs</code> stochastic gradient descent epochs on the local dataset.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs to pass over the entire local dataset</li>\n<li><strong>step_size</strong> (float):\nStep size or learning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of L2 (Tikhonov) regularization term</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<p>Differently from <code>optimize(...)</code>, each epoch corresponds to passing over the entire dataset using SGD.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedavg.Agent.evaluate": {"fullname": "fedbox.optimization.fedavg.Agent.evaluate", "modulename": "fedbox.optimization.fedavg", "qualname": "Agent.evaluate", "kind": "function", "doc": "<p>Evaluate the <code>model</code> by computing the average sample loss and accuracy. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>tuple[float, float]</strong>: Tuple of average sample loss and accuracy on the local dataset</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.fedavg.Coordinator": {"fullname": "fedbox.optimization.fedavg.Coordinator", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator", "kind": "class", "doc": "<p>This class represents a centralized server coordinating the training of a shared model across multiple agents (i.e. clients).</p>\n\n<h6 id=\"note\">Note</h6>\n\n<p>The agents locally update their models using the FedAvg optimization scheme.</p>\n"}, "fedbox.optimization.fedavg.Coordinator.__init__": {"fullname": "fedbox.optimization.fedavg.Coordinator.__init__", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.__init__", "kind": "function", "doc": "<p>Constructs the centralized coordinator, i.e. server, in the federated learning simulation.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>model</strong> (torch.nn.Module):\nInitial shared model</li>\n<li><strong>datasets</strong> (dict[str, list[utils.FederatedSubset]]):\nTraining clients' subsets ('training') and testing clients' subsets ('testing')</li>\n<li><strong>scheme</strong> (WeightingScheme):\nAggregation scheme to weight local updates from clients</li>\n<li><strong>logger</strong> (Logger):\nLogger instance to save progress during the simulation</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">datasets</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">scheme</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">WeightingScheme</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logger</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span></span>)</span>"}, "fedbox.optimization.fedavg.Coordinator.datasets": {"fullname": "fedbox.optimization.fedavg.Coordinator.datasets", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.datasets", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedavg.Coordinator.model": {"fullname": "fedbox.optimization.fedavg.Coordinator.model", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.model", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedavg.Coordinator.agents": {"fullname": "fedbox.optimization.fedavg.Coordinator.agents", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.agents", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedavg.Coordinator.weights": {"fullname": "fedbox.optimization.fedavg.Coordinator.weights", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.weights", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedavg.Coordinator.logger": {"fullname": "fedbox.optimization.fedavg.Coordinator.logger", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.logger", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedavg.Coordinator.run": {"fullname": "fedbox.optimization.fedavg.Coordinator.run", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.run", "kind": "function", "doc": "<p>Runs <code>n_iterations</code> optimization (with algorithm FedAvg) and evaluation rounds on training clients.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>n_iterations</strong> (int):\nNumber of global rounds</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps used for optimization on clients</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs used for optimization on clients (mutually excludes n_steps)</li>\n<li><strong>batch_size</strong> (int):\nNumber of samples in one SGD minibatch</li>\n<li><strong>step_size</strong> (float):\nLearning rate</li>\n<li><strong>step_size_diminishing</strong> (bool):\nThis enables diminishing the step size linearly in time</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of the L2 (Tikhonov) regularization used to penalize local models</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient during local optimization</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n<li><strong>evaluate</strong> (bool):\nFlag that enables evaluation of the update global model on training and testing clients</li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<p>Runs <code>n_iterations</code> times function <code>iterate(...)</code>.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">n_iterations</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.001</span>,</span><span class=\"param\">\t<span class=\"n\">step_size_diminishing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0001</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span> <span class=\"o\">=</span> <span class=\"n\">device</span><span class=\"p\">(</span><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span><span class=\"p\">)</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedavg.Coordinator.iterate": {"fullname": "fedbox.optimization.fedavg.Coordinator.iterate", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.iterate", "kind": "function", "doc": "<p>Runs a single optimization round with FedAvg algorithm on all training clients.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>iteration</strong> (int):\nCurrent global round</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps used for optimization on clients</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs used for optimization on clients (mutually excludes n_steps)</li>\n<li><strong>batch_size</strong> (int):\nNumber of samples in one SGD minibatch</li>\n<li><strong>step_size</strong> (float):\nLearning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of the L2 (Tikhonov) regularization used to penalize local models</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient during local optimization</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n<li><strong>evaluate</strong> (bool):\nFlag that enables evaluation of the update global model on training and testing clients</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, float]</strong>: Dictionary of current round's metrics</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">iteration</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span>,</span><span class=\"param\">\t<span class=\"n\">evaluate</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"fullname": "fedbox.optimization.fedavg.Coordinator.evaluate", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.evaluate", "kind": "function", "doc": "<p>Computes average sample accuracy and loss of the global model on training and testing clients during current <code>iteration</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>iteration</strong> (int):\nCurrent global round of the simulation</li>\n<li><strong>device</strong> (torch.device):\nAccelerator</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">iteration</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedavg.Coordinator.average": {"fullname": "fedbox.optimization.fedavg.Coordinator.average", "modulename": "fedbox.optimization.fedavg", "qualname": "Coordinator.average", "kind": "function", "doc": "<p>Averages clients' <code>updates</code> weighted by aggreation <code>weights</code> into the shared model.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>updates</strong> (list[torch.nn.Module]):\nLocally updated clients' models</li>\n<li><strong>weights</strong> (list[float]):\nAggregation weights (one for each client)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">updates</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">weights</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedprox": {"fullname": "fedbox.optimization.fedprox", "modulename": "fedbox.optimization.fedprox", "kind": "module", "doc": "<p></p>\n"}, "fedbox.optimization.fedprox.Agent": {"fullname": "fedbox.optimization.fedprox.Agent", "modulename": "fedbox.optimization.fedprox", "qualname": "Agent", "kind": "class", "doc": "<p>An agent (client) uses the FedProx scheme to optimize a shared model on its local subset.</p>\n", "bases": "fedbox.optimization.fedavg.Agent"}, "fedbox.optimization.fedprox.Agent.__init__": {"fullname": "fedbox.optimization.fedprox.Agent.__init__", "modulename": "fedbox.optimization.fedprox", "qualname": "Agent.__init__", "kind": "function", "doc": "<p>Initializes the agent with a local <code>subset</code> of data samples and labels.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>subset</strong> (utils.FederatedSubset):\nSubset of data samples and labels</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span></span>)</span>"}, "fedbox.optimization.fedprox.Agent.subset": {"fullname": "fedbox.optimization.fedprox.Agent.subset", "modulename": "fedbox.optimization.fedprox", "qualname": "Agent.subset", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedprox.Agent.step": {"fullname": "fedbox.optimization.fedprox.Agent.step", "modulename": "fedbox.optimization.fedprox", "qualname": "Agent.step", "kind": "function", "doc": "<p>Performs an optimization step on <code>model</code> using minibatch (<code>x</code>, <code>y</code>) accounting for the proximal term weighted by <code>alpha</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>alpha</strong> (float):\nWeight of the proximal regularization term in FedProx</li>\n<li><strong>initial</strong> (torch.nn.Module):\nModel received at the beginning of the round from the server</li>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is optimized locally</li>\n<li><strong>x</strong> (torch.Tensor):\nData samples in the minibatch</li>\n<li><strong>y</strong> (torch.Tensor):\nData labels in the minibatch</li>\n<li><strong>optimizer</strong> (optim.Optimizer):\nGradient-based optimizer</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">initial</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>,</span><span class=\"param\">\t<span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>,</span><span class=\"param\">\t<span class=\"n\">optimizer</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">optim</span><span class=\"o\">.</span><span class=\"n\">optimizer</span><span class=\"o\">.</span><span class=\"n\">Optimizer</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedprox.Agent.optimize": {"fullname": "fedbox.optimization.fedprox.Agent.optimize", "modulename": "fedbox.optimization.fedprox", "qualname": "Agent.optimize", "kind": "function", "doc": "<p>Runs <code>n_steps</code> stochastic gradient descent steps including the <code>alpha</code>-weighted proximal term on the local dataset (one step for each minibatch).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>alpha</strong> (float):\nWeight of the proximal regularization term in FedProx</li>\n<li><strong>initial</strong> (torch.nn.Module):\nModel received at the beginning of the round from the server</li>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps, i.e. number of minibatches</li>\n<li><strong>step_size</strong> (float):\nStep size or learning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of L2 (Tikhonov) regularization term</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">initial</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedprox.Agent.multioptimize": {"fullname": "fedbox.optimization.fedprox.Agent.multioptimize", "modulename": "fedbox.optimization.fedprox", "qualname": "Agent.multioptimize", "kind": "function", "doc": "<p>Runs <code>n_epochs</code> stochastic gradient descent epochs including the <code>alpha</code>-weighted proximal term on the local dataset.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>alpha</strong> (float):\nWeight of the proximal regularization term in FedProx</li>\n<li><strong>initial</strong> (torch.nn.Module):\nModel received at the beginning of the round from the server</li>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs to pass over the entire local dataset</li>\n<li><strong>step_size</strong> (float):\nStep size or learning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of L2 (Tikhonov) regularization term</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<p>Differently from <code>optimize(...)</code>, each epoch corresponds to passing over the entire dataset using SGD.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">initial</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedprox.Agent.evaluate": {"fullname": "fedbox.optimization.fedprox.Agent.evaluate", "modulename": "fedbox.optimization.fedprox", "qualname": "Agent.evaluate", "kind": "function", "doc": "<p>Evaluate the <code>model</code> by computing the average sample loss and accuracy.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>tuple[float, float]</strong>: Tuple of average sample loss and accuracy on the local dataset</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.fedprox.Agent.proxterm": {"fullname": "fedbox.optimization.fedprox.Agent.proxterm", "modulename": "fedbox.optimization.fedprox", "qualname": "Agent.proxterm", "kind": "function", "doc": "<p>Computes the <code>alpha</code>-weighted proximal term as squared difference between <code>initial</code> model and locally optimized <code>model</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>initial</strong> (torch.nn.Module):\nModel received at the beginning of the round from the server</li>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>torch.Tensor</strong>: Squared difference between <code>initial</code> model and locally optimized <code>model</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">initial</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.fedprox.Coordinator": {"fullname": "fedbox.optimization.fedprox.Coordinator", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator", "kind": "class", "doc": "<p>This class represents a centralized server coordinating the training of a shared model across multiple agents (i.e. clients).</p>\n\n<h6 id=\"note\">Note</h6>\n\n<p>The agents locally update their models using the FedProx optimization scheme.</p>\n", "bases": "fedbox.optimization.fedavg.Coordinator"}, "fedbox.optimization.fedprox.Coordinator.__init__": {"fullname": "fedbox.optimization.fedprox.Coordinator.__init__", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.__init__", "kind": "function", "doc": "<p>Constructs the centralized coordinator, i.e. server, in the federated learning simulation.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>alpha</strong> (float):\nWeight of the proximal term used by training agents while running the optimization algorithm FedProx</li>\n<li><strong>model</strong> (torch.nn.Module):\nInitial shared model</li>\n<li><strong>datasets</strong> (dict[str, list[utils.FederatedSubset]]):\nTraining clients' subsets ('training') and testing clients' subsets ('testing')</li>\n<li><strong>scheme</strong> (WeightingScheme):\nAggregation scheme to weight local updates from clients</li>\n<li><strong>logger</strong> (Logger):\nLogger instance to save progress during the simulation</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">datasets</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">scheme</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">WeightingScheme</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logger</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span></span>)</span>"}, "fedbox.optimization.fedprox.Coordinator.alpha": {"fullname": "fedbox.optimization.fedprox.Coordinator.alpha", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.alpha", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedprox.Coordinator.datasets": {"fullname": "fedbox.optimization.fedprox.Coordinator.datasets", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.datasets", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedprox.Coordinator.model": {"fullname": "fedbox.optimization.fedprox.Coordinator.model", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.model", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedprox.Coordinator.agents": {"fullname": "fedbox.optimization.fedprox.Coordinator.agents", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.agents", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedprox.Coordinator.weights": {"fullname": "fedbox.optimization.fedprox.Coordinator.weights", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.weights", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedprox.Coordinator.logger": {"fullname": "fedbox.optimization.fedprox.Coordinator.logger", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.logger", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.fedprox.Coordinator.run": {"fullname": "fedbox.optimization.fedprox.Coordinator.run", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.run", "kind": "function", "doc": "<p>Runs <code>n_iterations</code> optimization (with algorithm FedProx) and evaluation rounds on training clients.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>n_iterations</strong> (int):\nNumber of global rounds</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps used for optimization on clients</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs used for optimization on clients (mutually excludes n_steps)</li>\n<li><strong>batch_size</strong> (int):\nNumber of samples in one SGD minibatch</li>\n<li><strong>step_size</strong> (float):\nLearning rate</li>\n<li><strong>step_size_diminishing</strong> (bool):\nThis enables diminishing the step size linearly in time</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of the L2 (Tikhonov) regularization used to penalize local models</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient during local optimization</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n<li><strong>evaluate</strong> (bool):\nFlag that enables evaluation of the update global model on training and testing clients</li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<p>Runs <code>n_iterations</code> times function <code>iterate(...)</code>.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">n_iterations</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.001</span>,</span><span class=\"param\">\t<span class=\"n\">step_size_diminishing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0001</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span> <span class=\"o\">=</span> <span class=\"n\">device</span><span class=\"p\">(</span><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span><span class=\"p\">)</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.fedprox.Coordinator.iterate": {"fullname": "fedbox.optimization.fedprox.Coordinator.iterate", "modulename": "fedbox.optimization.fedprox", "qualname": "Coordinator.iterate", "kind": "function", "doc": "<p>Runs a single optimization round with FedProx algorithm on all training clients.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>iteration</strong> (int):\nCurrent global round</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps used for optimization on clients</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs used for optimization on clients (mutually excludes n_steps)</li>\n<li><strong>batch_size</strong> (int):\nNumber of samples in one SGD minibatch</li>\n<li><strong>step_size</strong> (float):\nLearning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of the L2 (Tikhonov) regularization used to penalize local models</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient during local optimization</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n<li><strong>evaluate</strong> (bool):\nFlag that enables evaluation of the update global model on training and testing clients</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, float]</strong>: Dictionary of current round's metrics</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">iteration</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span>,</span><span class=\"param\">\t<span class=\"n\">evaluate</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.ours": {"fullname": "fedbox.optimization.ours", "modulename": "fedbox.optimization.ours", "kind": "module", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Agent": {"fullname": "fedbox.optimization.ours.Agent", "modulename": "fedbox.optimization.ours", "qualname": "Agent", "kind": "class", "doc": "<p>An agent (client) uses our novel scheme to optimize a shared model on its local subset.</p>\n", "bases": "fedbox.optimization.fedavg.Agent"}, "fedbox.optimization.ours.Agent.__init__": {"fullname": "fedbox.optimization.ours.Agent.__init__", "modulename": "fedbox.optimization.ours", "qualname": "Agent.__init__", "kind": "function", "doc": "<p>Initializes the agent with a local <code>subset</code> of data samples and labels.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>subset</strong> (utils.FederatedSubset):\nSubset of data samples and labels</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span></span>)</span>"}, "fedbox.optimization.ours.Agent.subset": {"fullname": "fedbox.optimization.ours.Agent.subset", "modulename": "fedbox.optimization.ours", "qualname": "Agent.subset", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Agent.step": {"fullname": "fedbox.optimization.ours.Agent.step", "modulename": "fedbox.optimization.ours", "qualname": "Agent.step", "kind": "function", "doc": "<p>Performs an optimization step on <code>model</code> using minibatch (<code>x</code>, <code>y</code>) by introducing our <code>beta</code>-specific perturbation.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>beta</strong> (float):\nParameter of our algorithm that controls the perturbation (the lower beta, the higher the perturbation)</li>\n<li><strong>u</strong> (torch.nn.Module):\nAveraged model with the latest updates (previous round) weighted by mutual statistical similarities with other agents</li>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is optimized locally</li>\n<li><strong>x</strong> (torch.Tensor):\nData samples in the minibatch</li>\n<li><strong>y</strong> (torch.Tensor):\nData labels in the minibatch</li>\n<li><strong>optimizer</strong> (optim.Optimizer):\nGradient-based optimizer</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">beta</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">u</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>,</span><span class=\"param\">\t<span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>,</span><span class=\"param\">\t<span class=\"n\">optimizer</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">optim</span><span class=\"o\">.</span><span class=\"n\">optimizer</span><span class=\"o\">.</span><span class=\"n\">Optimizer</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.ours.Agent.optimize": {"fullname": "fedbox.optimization.ours.Agent.optimize", "modulename": "fedbox.optimization.ours", "qualname": "Agent.optimize", "kind": "function", "doc": "<p>Runs <code>n_steps</code> stochastic gradient descent steps while injecting <code>beta</code>-specific perturbation on the local dataset (one step for each minibatch).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>beta</strong> (float):\nParameter of our algorithm that controls the perturbation (the lower beta, the higher the perturbation)</li>\n<li><strong>u</strong> (torch.nn.Module):\nAveraged model with the latest updates (previous round) weighted by mutual statistical similarities with other agents</li>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps, i.e. number of minibatches</li>\n<li><strong>step_size</strong> (float):\nStep size or learning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of L2 (Tikhonov) regularization term</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">beta</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">u</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.ours.Agent.multioptimize": {"fullname": "fedbox.optimization.ours.Agent.multioptimize", "modulename": "fedbox.optimization.ours", "qualname": "Agent.multioptimize", "kind": "function", "doc": "<p>Runs <code>n_epochs</code> stochastic gradient descent epochs while injecting <code>beta</code>-specific perturbation on the local dataset.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>beta</strong> (float):\nParameter of our algorithm that controls the perturbation (the lower beta, the higher the perturbation)</li>\n<li><strong>u</strong> (torch.nn.Module):\nAveraged model with the latest updates (previous round) weighted by mutual statistical similarities with other agents</li>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs to pass over the entire local dataset</li>\n<li><strong>step_size</strong> (float):\nStep size or learning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of L2 (Tikhonov) regularization term</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<p>Differently from <code>optimize(...)</code>, each epoch corresponds to passing over the entire dataset using SGD.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">beta</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">u</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.ours.Agent.evaluate": {"fullname": "fedbox.optimization.ours.Agent.evaluate", "modulename": "fedbox.optimization.ours", "qualname": "Agent.evaluate", "kind": "function", "doc": "<p>Evaluate the <code>model</code> by computing the average sample loss and accuracy.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>tuple[float, float]</strong>: Tuple of average sample loss and accuracy on the local dataset</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.ours.Agent.perturb": {"fullname": "fedbox.optimization.ours.Agent.perturb", "modulename": "fedbox.optimization.ours", "qualname": "Agent.perturb", "kind": "function", "doc": "<p>Computes the perturbed model as <code>beta</code>-weighted average between <code>model</code> and <code>u</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>beta</strong> (float):\nParameter of our algorithm that controls the perturbation (the lower beta, the higher the perturbation)</li>\n<li><strong>u</strong> (torch.nn.Module):\nAveraged model with the latest updates (previous round) weighted by mutual statistical similarities with other agents</li>\n<li><strong>model</strong> (torch.nn.Module):\nModel that is locally optimized</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>torch.nn.Module</strong>: Perturbed model as <code>beta</code>-weighted average between <code>model</code> and <code>u</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">beta</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">u</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.ours.Coordinator": {"fullname": "fedbox.optimization.ours.Coordinator", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator", "kind": "class", "doc": "<p>This class represents a centralized server coordinating the training of a shared model across multiple agents (i.e. clients).</p>\n\n<h6 id=\"note\">Note</h6>\n\n<p>The agents locally update their models using our novel algorithmic framework.</p>\n", "bases": "fedbox.optimization.fedavg.Coordinator"}, "fedbox.optimization.ours.Coordinator.__init__": {"fullname": "fedbox.optimization.ours.Coordinator.__init__", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.__init__", "kind": "function", "doc": "<p>Constructs the centralized coordinator, i.e. server, in the federated learning simulation.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>beta</strong> (float):\nParameter controlling the perturbation (the lower beta, the higher the perturbation) while running our novel algorithm on clients</li>\n<li><strong>model</strong> (torch.nn.Module):\nInitial shared model</li>\n<li><strong>datasets</strong> (dict[str, list[utils.FederatedSubset]]):\nTraining clients' subsets ('training') and testing clients' subsets ('testing')</li>\n<li><strong>scheme</strong> (WeightingScheme):\nAggregation scheme to weight local updates from clients</li>\n<li><strong>logger</strong> (Logger):\nLogger instance to save progress during the simulation</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">beta</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">model</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">modules</span><span class=\"o\">.</span><span class=\"n\">module</span><span class=\"o\">.</span><span class=\"n\">Module</span>,</span><span class=\"param\">\t<span class=\"n\">datasets</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">scheme</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">WeightingScheme</span>,</span><span class=\"param\">\t<span class=\"n\">logger</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">optimization</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span></span>)</span>"}, "fedbox.optimization.ours.Coordinator.beta": {"fullname": "fedbox.optimization.ours.Coordinator.beta", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.beta", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Coordinator.datasets": {"fullname": "fedbox.optimization.ours.Coordinator.datasets", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.datasets", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Coordinator.model": {"fullname": "fedbox.optimization.ours.Coordinator.model", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.model", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Coordinator.agents": {"fullname": "fedbox.optimization.ours.Coordinator.agents", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.agents", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Coordinator.weights": {"fullname": "fedbox.optimization.ours.Coordinator.weights", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.weights", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Coordinator.adjacency_matrices": {"fullname": "fedbox.optimization.ours.Coordinator.adjacency_matrices", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.adjacency_matrices", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Coordinator.logger": {"fullname": "fedbox.optimization.ours.Coordinator.logger", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.logger", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.ours.Coordinator.run": {"fullname": "fedbox.optimization.ours.Coordinator.run", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.run", "kind": "function", "doc": "<p>Runs <code>n_iterations</code> optimization (with our novel algorithm) and evaluation rounds on training clients.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>n_iterations</strong> (int):\nNumber of global rounds</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps used for optimization on clients</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs used for optimization on clients (mutually excludes n_steps)</li>\n<li><strong>batch_size</strong> (int):\nNumber of samples in one SGD minibatch</li>\n<li><strong>step_size</strong> (float):\nLearning rate</li>\n<li><strong>step_size_diminishing</strong> (bool):\nThis enables diminishing the step size linearly in time</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of the L2 (Tikhonov) regularization used to penalize local models</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient during local optimization</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n<li><strong>evaluate</strong> (bool):\nFlag that enables evaluation of the update global model on training and testing clients</li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<p>Runs <code>n_iterations</code> times function <code>iterate(...)</code>.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">n_iterations</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.001</span>,</span><span class=\"param\">\t<span class=\"n\">step_size_diminishing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0001</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span> <span class=\"o\">=</span> <span class=\"n\">device</span><span class=\"p\">(</span><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span><span class=\"p\">)</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.ours.Coordinator.iterate": {"fullname": "fedbox.optimization.ours.Coordinator.iterate", "modulename": "fedbox.optimization.ours", "qualname": "Coordinator.iterate", "kind": "function", "doc": "<p>Runs a single optimization round with our novel algorithm on all training clients.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>iteration</strong> (int):\nCurrent global round</li>\n<li><strong>n_steps</strong> (int):\nNumber of local SGD steps used for optimization on clients</li>\n<li><strong>n_epochs</strong> (int):\nNumber of local epochs used for optimization on clients (mutually excludes n_steps)</li>\n<li><strong>batch_size</strong> (int):\nNumber of samples in one SGD minibatch</li>\n<li><strong>step_size</strong> (float):\nLearning rate</li>\n<li><strong>l2_penalty</strong> (float):\nWeight of the L2 (Tikhonov) regularization used to penalize local models</li>\n<li><strong>max_gradient_norm</strong> (float):\nValue used to clip the norm of the stochastic gradient during local optimization</li>\n<li><strong>device</strong> (torch.device):\nAccelerator to run the code</li>\n<li><strong>evaluate</strong> (bool):\nFlag that enables evaluation of the update global model on training and testing clients</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, float]</strong>: Dictionary of current round's metrics</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">iteration</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_steps</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_epochs</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">batch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">step_size</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">l2_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">max_gradient_norm</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span>,</span><span class=\"param\">\t<span class=\"n\">evaluate</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.utils": {"fullname": "fedbox.optimization.utils", "modulename": "fedbox.optimization.utils", "kind": "module", "doc": "<p></p>\n"}, "fedbox.optimization.utils.WeightingScheme": {"fullname": "fedbox.optimization.utils.WeightingScheme", "modulename": "fedbox.optimization.utils", "qualname": "WeightingScheme", "kind": "class", "doc": "<p>This abstract class defines a weighting scheme to aggregate updates from agents.</p>\n", "bases": "abc.ABC"}, "fedbox.optimization.utils.WeightingScheme.__init__": {"fullname": "fedbox.optimization.utils.WeightingScheme.__init__", "modulename": "fedbox.optimization.utils", "qualname": "WeightingScheme.__init__", "kind": "function", "doc": "<p>Constructs an aggregation scheme using the list of clients' <code>datasets</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>datasets</strong> (dict[str, list[utils.FederatedSubset]]):\nList of local subsets where each one corresponds to a client</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">datasets</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span></span>)</span>"}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"fullname": "fedbox.optimization.utils.WeightingScheme.datasets_", "modulename": "fedbox.optimization.utils", "qualname": "WeightingScheme.datasets_", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.utils.WeightingScheme.weights_": {"fullname": "fedbox.optimization.utils.WeightingScheme.weights_", "modulename": "fedbox.optimization.utils", "qualname": "WeightingScheme.weights_", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.utils.WeightingScheme.weights": {"fullname": "fedbox.optimization.utils.WeightingScheme.weights", "modulename": "fedbox.optimization.utils", "qualname": "WeightingScheme.weights", "kind": "function", "doc": "<p>Computes aggregation weights.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, list[float]]</strong>: Aggregation weights</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.utils.UniformWeightingScheme": {"fullname": "fedbox.optimization.utils.UniformWeightingScheme", "modulename": "fedbox.optimization.utils", "qualname": "UniformWeightingScheme", "kind": "class", "doc": "<p>This class defines a uniform weighting scheme to aggregate updates from agents.</p>\n", "bases": "WeightingScheme"}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"fullname": "fedbox.optimization.utils.UniformWeightingScheme.__init__", "modulename": "fedbox.optimization.utils", "qualname": "UniformWeightingScheme.__init__", "kind": "function", "doc": "<p>Constructs an aggregation scheme using the list of clients' <code>datasets</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>datasets</strong> (dict[str, list[utils.FederatedSubset]]):\nList of local subsets where each one corresponds to a client</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">datasets</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span></span>)</span>"}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"fullname": "fedbox.optimization.utils.UniformWeightingScheme.weights", "modulename": "fedbox.optimization.utils", "qualname": "UniformWeightingScheme.weights", "kind": "function", "doc": "<p>Computes uniform aggregation weights.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, list[float]]</strong>: Uniform aggregation weights</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"fullname": "fedbox.optimization.utils.AdjancencyWeightingScheme", "modulename": "fedbox.optimization.utils", "qualname": "AdjancencyWeightingScheme", "kind": "class", "doc": "<p>This class defines a custom weighting scheme to aggregate updates from agents based on\nmutual statistical similarities computed as the negative logarithm of client misalignments.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<p>Each weight corresponds to the degree of each agent as a node in the graph representation of\nthe federated network.</p>\n", "bases": "WeightingScheme"}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"fullname": "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__", "modulename": "fedbox.optimization.utils", "qualname": "AdjancencyWeightingScheme.__init__", "kind": "function", "doc": "<p>Constructs an aggregation scheme using the list of clients' <code>datasets</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>datasets</strong> (dict[str, list[utils.FederatedSubset]]):\nList of local subsets where each one corresponds to a client</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">datasets</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]]</span></span>)</span>"}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"fullname": "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_", "modulename": "fedbox.optimization.utils", "qualname": "AdjancencyWeightingScheme.adjacency_matrices_", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"fullname": "fedbox.optimization.utils.AdjancencyWeightingScheme.weights", "modulename": "fedbox.optimization.utils", "qualname": "AdjancencyWeightingScheme.weights", "kind": "function", "doc": "<p>Computes aggregation weights as clients' degrees in the graph representation of the network.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, list[float]]</strong>: Aggregation weights as clients' degrees (adjacency matrix)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"fullname": "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies", "modulename": "fedbox.optimization.utils", "qualname": "AdjancencyWeightingScheme.adjacencies", "kind": "function", "doc": "<p>Computes the adjacency matrices for the training network (training clients) and testing network (testing clients).</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dict[str, torch.Tensor]</strong>: Adjacency matrices for training clients ('training') and testing clients ('testing')</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"fullname": "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_", "modulename": "fedbox.optimization.utils", "qualname": "AdjancencyWeightingScheme.adjacency_matrix_", "kind": "function", "doc": "<p>Computes the adjacency matrix and related aggregation weights on a network of clients where each client corresponds to one subset in <code>subsets</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>subsets</strong> (list[utils.FederatedSubset]):\nList of clients' subsets</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>tuple[torch.Tensor, list[float]]</strong>: Tuple containing the adjacency matrix built on statistical similarities (0) and clients' aggregation weights as degrees in the related graph (1)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">subsets</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"fullname": "fedbox.optimization.utils.AdjancencyWeightingScheme.message_", "modulename": "fedbox.optimization.utils", "qualname": "AdjancencyWeightingScheme.message_", "kind": "function", "doc": "<p>Computes the statistically-significant message on a client's local subset.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>subset</strong> (utils.FederatedSubset):\nSubset of samples of a specific client</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>torch.Tensor</strong>: Unitary vector message, i.e. normalized first principal component</li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<p>The message is computed as the first principal component on the client's dataset.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">fedbox</span><span class=\"o\">.</span><span class=\"n\">datasets</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">FederatedSubset</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>:</span></span>", "funcdef": "def"}, "fedbox.optimization.utils.Logger": {"fullname": "fedbox.optimization.utils.Logger", "modulename": "fedbox.optimization.utils", "qualname": "Logger", "kind": "class", "doc": "<p>This class allows to log simulation metrics on a JSON file.</p>\n"}, "fedbox.optimization.utils.Logger.__init__": {"fullname": "fedbox.optimization.utils.Logger.__init__", "modulename": "fedbox.optimization.utils", "qualname": "Logger.__init__", "kind": "function", "doc": "<p>Constructs a logger instance.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>directory</strong> (str):\nDirectory where to save the produced JSON file</li>\n<li><strong>simulation</strong> (dict):\nSimulation metadata</li>\n<li><strong>convergence</strong> (Callable):\nBoolean predicate that is run at each <code>log(...)</code> call to detect if the model converged</li>\n<li><strong>enable</strong> (bool):\nFlag to enable logging, <code>True</code> by default</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">directory</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">simulation</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">convergence</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>,</span><span class=\"param\">\t<span class=\"n\">enable</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "fedbox.optimization.utils.Logger.directory": {"fullname": "fedbox.optimization.utils.Logger.directory", "modulename": "fedbox.optimization.utils", "qualname": "Logger.directory", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "fedbox.optimization.utils.Logger.simulation": {"fullname": "fedbox.optimization.utils.Logger.simulation", "modulename": "fedbox.optimization.utils", "qualname": "Logger.simulation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict"}, "fedbox.optimization.utils.Logger.metrics": {"fullname": "fedbox.optimization.utils.Logger.metrics", "modulename": "fedbox.optimization.utils", "qualname": "Logger.metrics", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[dict]"}, "fedbox.optimization.utils.Logger.convergence_time": {"fullname": "fedbox.optimization.utils.Logger.convergence_time", "modulename": "fedbox.optimization.utils", "qualname": "Logger.convergence_time", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "fedbox.optimization.utils.Logger.execution_time": {"fullname": "fedbox.optimization.utils.Logger.execution_time", "modulename": "fedbox.optimization.utils", "qualname": "Logger.execution_time", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.utils.Logger.convergence": {"fullname": "fedbox.optimization.utils.Logger.convergence", "modulename": "fedbox.optimization.utils", "qualname": "Logger.convergence", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.utils.Logger.enable": {"fullname": "fedbox.optimization.utils.Logger.enable", "modulename": "fedbox.optimization.utils", "qualname": "Logger.enable", "kind": "variable", "doc": "<p></p>\n"}, "fedbox.optimization.utils.Logger.log": {"fullname": "fedbox.optimization.utils.Logger.log", "modulename": "fedbox.optimization.utils", "qualname": "Logger.log", "kind": "function", "doc": "<p>Adds new logged data to the buffer and checks whether convergence has been reached.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>values</strong> (dict):\nDictionary of logged values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">values</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.utils.Logger.flush": {"fullname": "fedbox.optimization.utils.Logger.flush", "modulename": "fedbox.optimization.utils", "qualname": "Logger.flush", "kind": "function", "doc": "<p>Flushes the buffer's content to the output JSON file.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fedbox.optimization.utils.Logger.default": {"fullname": "fedbox.optimization.utils.Logger.default", "modulename": "fedbox.optimization.utils", "qualname": "Logger.default", "kind": "function", "doc": "<p>Constructs a default fake logger.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>Logger</strong>: Fake logger</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}}, "docInfo": {"fedbox": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 665}, "fedbox.datasets": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 107}, "fedbox.datasets.cifar10": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.cifar10.cifar10": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 182, "bases": 0, "doc": 209}, "fedbox.datasets.cifar100": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.cifar100.cifar100": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 182, "bases": 0, "doc": 209}, "fedbox.datasets.femnist": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.FEMNIST": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 3, "doc": 41}, "fedbox.datasets.femnist.FEMNIST.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 81, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.FEMNIST.root": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.FEMNIST.train": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.FEMNIST.transform": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.FEMNIST.download": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.FEMNIST.data": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.FEMNIST.targets": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.femnist.femnist": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 182, "bases": 0, "doc": 209}, "fedbox.datasets.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.utils.FederatedSubset": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 17}, "fedbox.datasets.utils.FederatedSubset.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 3}, "fedbox.datasets.utils.FederatedSubset.normalization": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.utils.FederatedSubset.data": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.utils.FederatedSubset.targets": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.datasets.utils.set_seed": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 38}, "fedbox.datasets.utils.partition": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 205, "bases": 0, "doc": 243}, "fedbox.models": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 67}, "fedbox.models.mlr": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.models.mlr.MultinomialLogisticRegression": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 69}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 14}, "fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.models.mlr.MultinomialLogisticRegression.linear": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 67}, "fedbox.models.nn": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.models.nn.NeuralNetwork": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "fedbox.models.nn.NeuralNetwork.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 14}, "fedbox.models.nn.NeuralNetwork.flatten": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.models.nn.NeuralNetwork.linear1": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.models.nn.NeuralNetwork.linear2": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.models.nn.NeuralNetwork.forward": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 67}, "fedbox.optimization": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 127}, "fedbox.optimization.fedavg": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedavg.Agent": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "fedbox.optimization.fedavg.Agent.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 38}, "fedbox.optimization.fedavg.Agent.subset": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedavg.Agent.step": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 114, "bases": 0, "doc": 96}, "fedbox.optimization.fedavg.Agent.optimize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 119}, "fedbox.optimization.fedavg.Agent.multioptimize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 120, "bases": 0, "doc": 138}, "fedbox.optimization.fedavg.Agent.evaluate": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 74}, "fedbox.optimization.fedavg.Coordinator": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 39}, "fedbox.optimization.fedavg.Coordinator.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 169, "bases": 0, "doc": 83}, "fedbox.optimization.fedavg.Coordinator.datasets": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedavg.Coordinator.model": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedavg.Coordinator.agents": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedavg.Coordinator.weights": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedavg.Coordinator.logger": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedavg.Coordinator.run": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 195, "bases": 0, "doc": 212}, "fedbox.optimization.fedavg.Coordinator.iterate": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 145, "bases": 0, "doc": 191}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 52}, "fedbox.optimization.fedavg.Coordinator.average": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 52}, "fedbox.optimization.fedprox": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedprox.Agent": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 19}, "fedbox.optimization.fedprox.Agent.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 38}, "fedbox.optimization.fedprox.Agent.subset": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedprox.Agent.step": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 156, "bases": 0, "doc": 141}, "fedbox.optimization.fedprox.Agent.optimize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 150, "bases": 0, "doc": 162}, "fedbox.optimization.fedprox.Agent.multioptimize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 162, "bases": 0, "doc": 181}, "fedbox.optimization.fedprox.Agent.evaluate": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 74}, "fedbox.optimization.fedprox.Agent.proxterm": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 82, "bases": 0, "doc": 92}, "fedbox.optimization.fedprox.Coordinator": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 39}, "fedbox.optimization.fedprox.Coordinator.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 180, "bases": 0, "doc": 105}, "fedbox.optimization.fedprox.Coordinator.alpha": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedprox.Coordinator.datasets": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedprox.Coordinator.model": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedprox.Coordinator.agents": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedprox.Coordinator.weights": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedprox.Coordinator.logger": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.fedprox.Coordinator.run": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 195, "bases": 0, "doc": 212}, "fedbox.optimization.fedprox.Coordinator.iterate": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 145, "bases": 0, "doc": 191}, "fedbox.optimization.ours": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Agent": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 19}, "fedbox.optimization.ours.Agent.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 38}, "fedbox.optimization.ours.Agent.subset": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Agent.step": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 156, "bases": 0, "doc": 152}, "fedbox.optimization.ours.Agent.optimize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 150, "bases": 0, "doc": 174}, "fedbox.optimization.ours.Agent.multioptimize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 162, "bases": 0, "doc": 193}, "fedbox.optimization.ours.Agent.evaluate": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 74}, "fedbox.optimization.ours.Agent.perturb": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 120}, "fedbox.optimization.ours.Coordinator": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 39}, "fedbox.optimization.ours.Coordinator.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 173, "bases": 0, "doc": 108}, "fedbox.optimization.ours.Coordinator.beta": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Coordinator.datasets": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Coordinator.model": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Coordinator.agents": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Coordinator.weights": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Coordinator.adjacency_matrices": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Coordinator.logger": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.ours.Coordinator.run": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 195, "bases": 0, "doc": 213}, "fedbox.optimization.ours.Coordinator.iterate": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 145, "bases": 0, "doc": 192}, "fedbox.optimization.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.WeightingScheme": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 15}, "fedbox.optimization.utils.WeightingScheme.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 42}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.WeightingScheme.weights_": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.WeightingScheme.weights": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 21}, "fedbox.optimization.utils.UniformWeightingScheme": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 15}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 42}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 23}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 54}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 42}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 37}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 43}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 82}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 78}, "fedbox.optimization.utils.Logger": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "fedbox.optimization.utils.Logger.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 79}, "fedbox.optimization.utils.Logger.directory": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.Logger.simulation": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.Logger.metrics": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.Logger.convergence_time": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.Logger.execution_time": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.Logger.convergence": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.Logger.enable": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fedbox.optimization.utils.Logger.log": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 35}, "fedbox.optimization.utils.Logger.flush": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 13}, "fedbox.optimization.utils.Logger.default": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 22}}, "length": 126, "save": true}, "index": {"qualname": {"root": {"docs": {"fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 19, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"1": {"0": {"0": {"docs": {"fedbox.datasets.cifar100.cifar100": {"tf": 1}}, "df": 1}, "docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.alpha": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.beta": {"tf": 1}, "fedbox.optimization.ours.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.ours.Coordinator.model": {"tf": 1}, "fedbox.optimization.ours.Coordinator.agents": {"tf": 1}, "fedbox.optimization.ours.Coordinator.weights": {"tf": 1}, "fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.ours.Coordinator.logger": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 32}}}}}}}}}, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence": {"tf": 1}}, "df": 2}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.root": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.train": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.transform": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.download": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.data": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.targets": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 10}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.normalization": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.flatten": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 14}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 3}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST.root": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.femnist.FEMNIST.train": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.datasets.femnist.FEMNIST.transform": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1}}, "df": 1, "s": {"docs": {"fedbox.datasets.femnist.FEMNIST.targets": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.execution_time": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.femnist.FEMNIST.download": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.datasets.femnist.FEMNIST.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.ours.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}}, "df": 4}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.utils.Logger.directory": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.FederatedSubset.normalization": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.flatten": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear1": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear2": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 6}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent.subset": {"tf": 1}, "fedbox.optimization.fedprox.Agent.subset": {"tf": 1}, "fedbox.optimization.ours.Agent.subset": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.utils.Logger.simulation": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {"fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.linear": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 3}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization.fedavg.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.model": {"tf": 1}, "fedbox.optimization.ours.Coordinator.model": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}}, "df": 2}}}, "x": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.Logger.metrics": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"1": {"docs": {"fedbox.models.nn.NeuralNetwork.linear1": {"tf": 1}}, "df": 1}, "2": {"docs": {"fedbox.models.nn.NeuralNetwork.linear2": {"tf": 1}}, "df": 1}, "docs": {"fedbox.models.mlr.MultinomialLogisticRegression.linear": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.logger": {"tf": 1}, "fedbox.optimization.ours.Coordinator.logger": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.directory": {"tf": 1}, "fedbox.optimization.utils.Logger.simulation": {"tf": 1}, "fedbox.optimization.utils.Logger.metrics": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.execution_time": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence": {"tf": 1}, "fedbox.optimization.utils.Logger.enable": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 15}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.subset": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.subset": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.subset": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 23, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.agents": {"tf": 1}, "fedbox.optimization.ours.Coordinator.agents": {"tf": 1}}, "df": 3}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.optimization.fedprox.Coordinator.alpha": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 7}}}}}}}}}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}}, "df": 3}}}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}}, "df": 4}}}}}}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.utils.Logger.execution_time": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.enable": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.weights": {"tf": 1}, "fedbox.optimization.ours.Coordinator.weights": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}}, "df": 7}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.optimization.ours.Coordinator.beta": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}}}}}}, "fullname": {"root": {"docs": {"fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 19, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.root": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.train": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.transform": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.download": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.data": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.targets": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.normalization": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.models.mlr": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.linear": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.flatten": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear1": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear2": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.subset": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.subset": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.alpha": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.subset": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.beta": {"tf": 1}, "fedbox.optimization.ours.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.ours.Coordinator.model": {"tf": 1}, "fedbox.optimization.ours.Coordinator.agents": {"tf": 1}, "fedbox.optimization.ours.Coordinator.weights": {"tf": 1}, "fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.ours.Coordinator.logger": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.directory": {"tf": 1}, "fedbox.optimization.utils.Logger.simulation": {"tf": 1}, "fedbox.optimization.utils.Logger.metrics": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.execution_time": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence": {"tf": 1}, "fedbox.optimization.utils.Logger.enable": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 126}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.normalization": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedavg": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.subset": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 19}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"fedbox.optimization.fedprox": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.subset": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.alpha": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}}, "df": 19}}}}}, "m": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.root": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.train": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.transform": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.download": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.data": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.targets": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}}, "df": 11}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.flatten": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.datasets.femnist.FEMNIST.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.root": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.train": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.transform": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.download": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.data": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.targets": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.normalization": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.ours.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}}, "df": 28}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.femnist.FEMNIST.download": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.utils.Logger.directory": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"1": {"0": {"0": {"docs": {"fedbox.datasets.cifar100": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {"fedbox.datasets.cifar10": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.alpha": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.beta": {"tf": 1}, "fedbox.optimization.ours.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.ours.Coordinator.model": {"tf": 1}, "fedbox.optimization.ours.Coordinator.agents": {"tf": 1}, "fedbox.optimization.ours.Coordinator.weights": {"tf": 1}, "fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.ours.Coordinator.logger": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 32}}}}}}}}}, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence": {"tf": 1}}, "df": 2}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 14}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 3}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST.root": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.femnist.FEMNIST.train": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.datasets.femnist.FEMNIST.transform": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1}}, "df": 1, "s": {"docs": {"fedbox.datasets.femnist.FEMNIST.targets": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.execution_time": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.normalization": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.utils": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.directory": {"tf": 1}, "fedbox.optimization.utils.Logger.simulation": {"tf": 1}, "fedbox.optimization.utils.Logger.metrics": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.execution_time": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence": {"tf": 1}, "fedbox.optimization.utils.Logger.enable": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 36}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.FederatedSubset.normalization": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "n": {"docs": {"fedbox.models.nn": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.flatten": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear1": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear2": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 7}, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.flatten": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear1": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear2": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 6}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent.subset": {"tf": 1}, "fedbox.optimization.fedprox.Agent.subset": {"tf": 1}, "fedbox.optimization.ours.Agent.subset": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.utils.Logger.simulation": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {"fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization.fedavg.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.model": {"tf": 1}, "fedbox.optimization.ours.Coordinator.model": {"tf": 1}}, "df": 3, "s": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.mlr": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.linear": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.flatten": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear1": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.linear2": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 14}}}}}, "l": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.models.mlr": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.linear": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}}, "df": 6}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.linear": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 3}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}}, "df": 2}}}, "x": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.Logger.metrics": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"1": {"docs": {"fedbox.models.nn.NeuralNetwork.linear1": {"tf": 1}}, "df": 1}, "2": {"docs": {"fedbox.models.nn.NeuralNetwork.linear2": {"tf": 1}}, "df": 1}, "docs": {"fedbox.models.mlr.MultinomialLogisticRegression.linear": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.logger": {"tf": 1}, "fedbox.optimization.ours.Coordinator.logger": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.directory": {"tf": 1}, "fedbox.optimization.utils.Logger.simulation": {"tf": 1}, "fedbox.optimization.utils.Logger.metrics": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.execution_time": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence": {"tf": 1}, "fedbox.optimization.utils.Logger.enable": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 15}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.subset": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.subset": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.alpha": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.model": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.logger": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.subset": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.beta": {"tf": 1}, "fedbox.optimization.ours.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.ours.Coordinator.model": {"tf": 1}, "fedbox.optimization.ours.Coordinator.agents": {"tf": 1}, "fedbox.optimization.ours.Coordinator.weights": {"tf": 1}, "fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.ours.Coordinator.logger": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.directory": {"tf": 1}, "fedbox.optimization.utils.Logger.simulation": {"tf": 1}, "fedbox.optimization.utils.Logger.metrics": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}, "fedbox.optimization.utils.Logger.execution_time": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence": {"tf": 1}, "fedbox.optimization.utils.Logger.enable": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 87}}}}}, "e": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}}, "df": 3}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.ours": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.subset": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.beta": {"tf": 1}, "fedbox.optimization.ours.Coordinator.datasets": {"tf": 1}, "fedbox.optimization.ours.Coordinator.model": {"tf": 1}, "fedbox.optimization.ours.Coordinator.agents": {"tf": 1}, "fedbox.optimization.ours.Coordinator.weights": {"tf": 1}, "fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.ours.Coordinator.logger": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 20}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.subset": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.subset": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.subset": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 23, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.agents": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.agents": {"tf": 1}, "fedbox.optimization.ours.Coordinator.agents": {"tf": 1}}, "df": 3}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.optimization.fedprox.Coordinator.alpha": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 7}}}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}}, "df": 4}}}}}}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.utils.Logger.execution_time": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.enable": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.weights": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.weights": {"tf": 1}, "fedbox.optimization.ours.Coordinator.weights": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}}, "df": 7}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.optimization.ours.Coordinator.beta": {"tf": 1}}, "df": 1}}}}}}, "annotation": {"root": {"docs": {"fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}, "fedbox.optimization.utils.Logger.directory": {"tf": 1}, "fedbox.optimization.utils.Logger.simulation": {"tf": 1}, "fedbox.optimization.utils.Logger.metrics": {"tf": 1}, "fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}}, "df": 6, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.datasets.utils.FederatedSubset.data": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.utils.Logger.directory": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.Logger.simulation": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.Logger.metrics": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.Logger.convergence_time": {"tf": 1}}, "df": 1}}}}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"0": {"0": {"0": {"1": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "1": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}}, "df": 7}, "1": {"0": {"0": {"0": {"docs": {"fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 1}, "docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "2": {"8": {"docs": {"fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}, "3": {"2": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}, "9": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}}, "df": 3}, "docs": {}, "df": 0}, "docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 12.12435565298214}, "fedbox.datasets.cifar100.cifar100": {"tf": 12.12435565298214}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 8.18535277187245}, "fedbox.datasets.femnist.femnist": {"tf": 12.12435565298214}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 6.4031242374328485}, "fedbox.datasets.utils.set_seed": {"tf": 3.7416573867739413}, "fedbox.datasets.utils.partition": {"tf": 12.767145334803704}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 4.47213595499958}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 5.291502622129181}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 5.830951894845301}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 5.291502622129181}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 4.898979485566356}, "fedbox.optimization.fedavg.Agent.step": {"tf": 9.591663046625438}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 9.219544457292887}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 9.695359714832659}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 7.810249675906654}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 11.704699910719626}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 12.288205727444508}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 10.677078252031311}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 5.477225575051661}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 7.416198487095663}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 4.898979485566356}, "fedbox.optimization.fedprox.Agent.step": {"tf": 11.224972160321824}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 10.908712114635714}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 11.313708498984761}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 7.810249675906654}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 8.18535277187245}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 12.083045973594572}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 12.288205727444508}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 10.677078252031311}, "fedbox.optimization.ours.Agent.__init__": {"tf": 4.898979485566356}, "fedbox.optimization.ours.Agent.step": {"tf": 11.224972160321824}, "fedbox.optimization.ours.Agent.optimize": {"tf": 10.908712114635714}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 11.313708498984761}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 7.810249675906654}, "fedbox.optimization.ours.Agent.perturb": {"tf": 9.38083151964686}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 11.832159566199232}, "fedbox.optimization.ours.Coordinator.run": {"tf": 12.288205727444508}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 10.677078252031311}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 6.082762530298219}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 5}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 6.082762530298219}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 5}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 6.082762530298219}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 5}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 5.0990195135927845}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 7.483314773547883}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 6}, "fedbox.optimization.utils.Logger.__init__": {"tf": 6.782329983125268}, "fedbox.optimization.utils.Logger.log": {"tf": 4.242640687119285}, "fedbox.optimization.utils.Logger.flush": {"tf": 3.1622776601683795}, "fedbox.optimization.utils.Logger.default": {"tf": 2.6457513110645907}}, "df": 52, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 4}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 18}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}}}}}}}}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 16}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.partition": {"tf": 1.7320508075688772}}, "df": 2, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 15}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 18, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 12, "s": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 9}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 4, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 5}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 32}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 12}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 3}}}}}}, "n": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 18, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 2}, "fedbox.datasets.cifar100.cifar100": {"tf": 2}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 2}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}}, "df": 10}}, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 15}}}, "n": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 18}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 2}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}}, "df": 21}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 2}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}}, "df": 4}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 4, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 2}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 2}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 30}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 2}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 2}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 2}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 15}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 15}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 7}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 6}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 2}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 2.23606797749979}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 2.23606797749979}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 32}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 9}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 4}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}}, "df": 4}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}}, "df": 4}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 12}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 9}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 5}}}}, "l": {"2": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 12}, "docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}}, "df": 15}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.7320508075688772}}, "df": 3}}}}}, "t": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 3}}, "u": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 2}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 2}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 2}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 16}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 3}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "x": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 5}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 17}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 2}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 2}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 2}, "fedbox.optimization.ours.Agent.optimize": {"tf": 2}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.perturb": {"tf": 2.449489742783178}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}}, "df": 18, "s": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 18}}}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 15}}}, "y": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 3}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.step": {"tf": 1.7320508075688772}}, "df": 3}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.7320508075688772}}, "df": 3}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 3}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 15}}}}}}}, "t": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 3}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 12}}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 9}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 3}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 3}}}}}}}}}, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 1}}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 3}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "+": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 2}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}}, "df": 1, "[": {"docs": {}, "df": 0, "+": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}}, "df": 1}}}}}}}}}}, "n": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 4}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}}, "df": 2}}}}, "b": {"docs": {}, "df": 0, "c": {"docs": {"fedbox.optimization.utils.WeightingScheme": {"tf": 1.4142135623730951}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "doc": {"root": {"0": {"docs": {"fedbox": {"tf": 2.449489742783178}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 7}, "1": {"0": {"0": {"docs": {"fedbox": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {"fedbox": {"tf": 2}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 2}, "docs": {"fedbox": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 2, "e": {"docs": {"fedbox": {"tf": 1.4142135623730951}}, "df": 1}}, "2": {"0": {"0": {"docs": {"fedbox": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "5": {"6": {"docs": {"fedbox": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "3": {"9": {"docs": {"fedbox": {"tf": 4}}, "df": 1}, "docs": {"fedbox": {"tf": 1}}, "df": 1}, "4": {"docs": {"fedbox": {"tf": 1}}, "df": 1}, "5": {"docs": {"fedbox": {"tf": 1.4142135623730951}}, "df": 1}, "7": {"0": {"docs": {"fedbox": {"tf": 1.4142135623730951}}, "df": 1}, "5": {"docs": {"fedbox": {"tf": 1}}, "df": 1}, "8": {"4": {"docs": {"fedbox": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "9": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}, "docs": {"fedbox": {"tf": 19.467922333931785}, "fedbox.datasets": {"tf": 5.656854249492381}, "fedbox.datasets.cifar10": {"tf": 1.7320508075688772}, "fedbox.datasets.cifar10.cifar10": {"tf": 8.94427190999916}, "fedbox.datasets.cifar100": {"tf": 1.7320508075688772}, "fedbox.datasets.cifar100.cifar100": {"tf": 8.94427190999916}, "fedbox.datasets.femnist": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.FEMNIST": {"tf": 2.8284271247461903}, "fedbox.datasets.femnist.FEMNIST.__init__": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.FEMNIST.root": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.FEMNIST.train": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.FEMNIST.transform": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.FEMNIST.target_transform": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.FEMNIST.download": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.FEMNIST.data": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.FEMNIST.targets": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.femnist": {"tf": 8.94427190999916}, "fedbox.datasets.utils": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.FederatedSubset.__init__": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.FederatedSubset.normalization": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.FederatedSubset.data": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.FederatedSubset.targets": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.set_seed": {"tf": 3.7416573867739413}, "fedbox.datasets.utils.partition": {"tf": 9.16515138991168}, "fedbox.models": {"tf": 4.123105625617661}, "fedbox.models.mlr": {"tf": 1.7320508075688772}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 3.1622776601683795}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1.7320508075688772}, "fedbox.models.mlr.MultinomialLogisticRegression.flatten": {"tf": 1.7320508075688772}, "fedbox.models.mlr.MultinomialLogisticRegression.linear": {"tf": 1.7320508075688772}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 3.872983346207417}, "fedbox.models.nn": {"tf": 1.7320508075688772}, "fedbox.models.nn.NeuralNetwork": {"tf": 1.7320508075688772}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1.7320508075688772}, "fedbox.models.nn.NeuralNetwork.flatten": {"tf": 1.7320508075688772}, "fedbox.models.nn.NeuralNetwork.linear1": {"tf": 1.7320508075688772}, "fedbox.models.nn.NeuralNetwork.linear2": {"tf": 1.7320508075688772}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 3.872983346207417}, "fedbox.optimization": {"tf": 4.898979485566356}, "fedbox.optimization.fedavg": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 4}, "fedbox.optimization.fedavg.Agent.subset": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.step": {"tf": 6.324555320336759}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 6.4031242374328485}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 7}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 5.5677643628300215}, "fedbox.optimization.fedavg.Coordinator": {"tf": 2.8284271247461903}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 5.477225575051661}, "fedbox.optimization.fedavg.Coordinator.datasets": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.model": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.agents": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.weights": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.logger": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 8.48528137423857}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 8.06225774829855}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 4.58257569495584}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 4.898979485566356}, "fedbox.optimization.fedprox": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 4}, "fedbox.optimization.fedprox.Agent.subset": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.step": {"tf": 7.211102550927978}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 7.280109889280518}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 7.810249675906654}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 5.5677643628300215}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 6.244997998398398}, "fedbox.optimization.fedprox.Coordinator": {"tf": 2.8284271247461903}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 5.916079783099616}, "fedbox.optimization.fedprox.Coordinator.alpha": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.datasets": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.model": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.agents": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.weights": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.logger": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 8.48528137423857}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 8.06225774829855}, "fedbox.optimization.ours": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.__init__": {"tf": 4}, "fedbox.optimization.ours.Agent.subset": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.step": {"tf": 7.280109889280518}, "fedbox.optimization.ours.Agent.optimize": {"tf": 7.3484692283495345}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 7.874007874011811}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 5.5677643628300215}, "fedbox.optimization.ours.Agent.perturb": {"tf": 6.855654600401044}, "fedbox.optimization.ours.Coordinator": {"tf": 2.8284271247461903}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 5.916079783099616}, "fedbox.optimization.ours.Coordinator.beta": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.datasets": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.model": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.agents": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.weights": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.adjacency_matrices": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.logger": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.run": {"tf": 8.48528137423857}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 8.06225774829855}, "fedbox.optimization.utils": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 4}, "fedbox.optimization.utils.WeightingScheme.datasets_": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.WeightingScheme.weights_": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 3.605551275463989}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 4}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 3.605551275463989}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 2.8284271247461903}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 4}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrices_": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 3.7416573867739413}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 3.7416573867739413}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 5.196152422706632}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 5.385164807134504}, "fedbox.optimization.utils.Logger": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.__init__": {"tf": 5.830951894845301}, "fedbox.optimization.utils.Logger.directory": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.simulation": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.metrics": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.convergence_time": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.execution_time": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.convergence": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.enable": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.log": {"tf": 3.7416573867739413}, "fedbox.optimization.utils.Logger.flush": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.default": {"tf": 3.605551275463989}}, "df": 126, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.models": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1.4142135623730951}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}}, "df": 20}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 2}}}, "e": {"docs": {"fedbox": {"tf": 2.449489742783178}, "fedbox.datasets": {"tf": 2.449489742783178}, "fedbox.datasets.cifar10.cifar10": {"tf": 2}, "fedbox.datasets.cifar100.cifar100": {"tf": 2}, "fedbox.datasets.femnist.FEMNIST": {"tf": 2}, "fedbox.datasets.femnist.femnist": {"tf": 2}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 2.449489742783178}, "fedbox.models": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.7320508075688772}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 2.449489742783178}, "fedbox.models.nn.NeuralNetwork": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 2.449489742783178}, "fedbox.optimization": {"tf": 3.7416573867739413}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 2}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 2}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 2.449489742783178}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2.449489742783178}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2.23606797749979}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 3}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 3}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 3.3166247903554}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 2}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 2.23606797749979}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2.449489742783178}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2.23606797749979}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 3}, "fedbox.optimization.ours.Agent.optimize": {"tf": 3}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 3.3166247903554}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 2}, "fedbox.optimization.ours.Agent.perturb": {"tf": 2.449489742783178}, "fedbox.optimization.ours.Coordinator": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 2.6457513110645907}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2.449489742783178}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2.23606797749979}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 2}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 2}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1.4142135623730951}}, "df": 59, "n": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}, "m": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets": {"tf": 1.7320508075688772}, "fedbox.models": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 24}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"fedbox": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 3}}, "o": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 2}, "fedbox.datasets.cifar100.cifar100": {"tf": 2}, "fedbox.datasets.femnist.femnist": {"tf": 2}, "fedbox.datasets.utils.partition": {"tf": 2.23606797749979}, "fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 46, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 2}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 2}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 26}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 2}}, "df": 18}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"fedbox": {"tf": 1.4142135623730951}}, "df": 1}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.models": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 2}}, "df": 16}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 7}}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 9}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 3}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 12}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 4, "[": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 1}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox": {"tf": 2.23606797749979}, "fedbox.datasets": {"tf": 1.4142135623730951}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 7, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 40}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1, "s": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 5}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 3}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 3}}}}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}}, "df": 5}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 4}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox": {"tf": 1.4142135623730951}}, "df": 1, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}}, "df": 6}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization.ours.Agent.perturb": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 4}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 13}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 6}}}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 3}}}}}}}, "a": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.7320508075688772}, "fedbox.models": {"tf": 2}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.optimization": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 31, "l": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 5, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {"fedbox": {"tf": 1}, "fedbox.models": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 14, "s": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "c": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 2}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}}, "df": 5}}}}, "n": {"docs": {"fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}}, "df": 9, "d": {"docs": {"fedbox": {"tf": 2}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar10.cifar10": {"tf": 2.23606797749979}, "fedbox.datasets.cifar100.cifar100": {"tf": 2.23606797749979}, "fedbox.datasets.femnist.femnist": {"tf": 2.23606797749979}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.optimization": {"tf": 2.23606797749979}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 34}, "y": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}}, "df": 3}}, "s": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 7, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}}, "df": 5}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedprox.Agent.step": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 16}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 5}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}, "t": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 8}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}}}}, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}}, "df": 12}}}, "e": {"docs": {"fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 8, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 11}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 1}, "d": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 4}}}}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.WeightingScheme": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 17, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 5}}}}, "s": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 12}}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 3}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 13}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 19}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 5}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}}, "df": 5}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.7320508075688772}}, "df": 13, "s": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 5}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 12}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"1": {"0": {"0": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}}, "df": 3}, "docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.optimization": {"tf": 1}}, "df": 3}, "l": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 17}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 9}, "d": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2}}}}}}}}}, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 3}}}, "d": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 8}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 4}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 5}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 3}}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 9}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.7320508075688772}}, "df": 16, "s": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 2}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 2}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.7320508075688772}}, "df": 24}}}}, "p": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 15}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"fedbox": {"tf": 2}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}}, "df": 15, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 7}}}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2}}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 9, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 14}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}}, "df": 5}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}}, "df": 9}}}}}, "m": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox": {"tf": 2}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 2}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.Logger.default": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 3}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 14}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 5}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.4142135623730951}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"fedbox": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 2}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 2}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}}, "df": 25}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 7}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1.4142135623730951}}, "df": 20, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 6}}}}}}}}, "s": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 6, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 2}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1.4142135623730951}}, "df": 8, "s": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.models": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 3}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 6}}}}}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 13}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.7320508075688772}}, "df": 11, "s": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.datasets": {"tf": 1.7320508075688772}, "fedbox.datasets.cifar10.cifar10": {"tf": 2.449489742783178}, "fedbox.datasets.cifar100.cifar100": {"tf": 2.449489742783178}, "fedbox.datasets.femnist.femnist": {"tf": 2.449489742783178}, "fedbox.datasets.utils.partition": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.7320508075688772}}, "df": 13}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 3}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 2}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 3, "d": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.set_seed": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}}, "df": 6}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.models": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 11}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}}, "df": 15}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"fedbox.models": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 4, "s": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 2.23606797749979}, "fedbox.datasets.cifar100.cifar100": {"tf": 2.23606797749979}, "fedbox.datasets.femnist.femnist": {"tf": 2.23606797749979}, "fedbox.datasets.utils.partition": {"tf": 2.23606797749979}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 19}}}}, "e": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 16, "s": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.optimize": {"tf": 2}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.7320508075688772}}, "df": 9}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 7, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 15}}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}, "c": {"docs": {"fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.models": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 12}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "g": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 12}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger": {"tf": 1}}, "df": 33, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}, "e": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 18}}, "u": {"docs": {}, "df": 0, "r": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 10, "s": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 2}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}}, "df": 15}}}}}, "e": {"docs": {"fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 6, "d": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 14}, "r": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.step": {"tf": 1.7320508075688772}}, "df": 3}}}}}}}}, "f": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1.7320508075688772}, "fedbox.datasets.cifar10.cifar10": {"tf": 2}, "fedbox.datasets.cifar100.cifar100": {"tf": 2}, "fedbox.datasets.femnist.femnist": {"tf": 2}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 2.6457513110645907}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1.4142135623730951}, "fedbox.optimization": {"tf": 2}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 2}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2.6457513110645907}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2.6457513110645907}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 2.449489742783178}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 2.23606797749979}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2.6457513110645907}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2.6457513110645907}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 2.23606797749979}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2.6457513110645907}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2.6457513110645907}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 48}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 4, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}, "r": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 7}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}}, "df": 3, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 3}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1, "s": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1.4142135623730951}}, "df": 5}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1}}, "df": 16}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 4}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox": {"tf": 2.449489742783178}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 12, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 2.23606797749979}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 17, "s": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1.4142135623730951}}, "df": 12}}}}}}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 2}, "fedbox.datasets.cifar100.cifar100": {"tf": 2}, "fedbox.datasets.femnist.femnist": {"tf": 2}, "fedbox.datasets.utils.partition": {"tf": 2.23606797749979}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 6, "s": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 3, "s": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 6}, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 2}, "fedbox.datasets.cifar100.cifar100": {"tf": 2}, "fedbox.datasets.femnist.femnist": {"tf": 2}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1}}, "df": 6}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 16}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 6}}}}}}, "o": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 11}}}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 19, "i": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization": {"tf": 1.7320508075688772}}, "df": 3, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 17, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 3}}}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.7320508075688772}}, "df": 9}}, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}}, "df": 5}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 6}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 6}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.optimization": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1.4142135623730951}, "fedbox.optimization": {"tf": 1}}, "df": 7, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.perturb": {"tf": 2}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}}, "df": 6}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}}, "df": 5}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 7}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 1}}, "e": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1, "d": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 4}}}}, "y": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 2}, "fedbox.datasets.cifar100.cifar100": {"tf": 2}, "fedbox.datasets.femnist.femnist": {"tf": 2}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 20}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 11, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 2}}}}}}, "n": {"docs": {"fedbox": {"tf": 3.3166247903554}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.7320508075688772}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.femnist": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.partition": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2.449489742783178}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2.449489742783178}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2.449489742783178}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.7320508075688772}}, "df": 17, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 6}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 15, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1, "d": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 5}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1, "e": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 14}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 2}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.7320508075688772}}, "df": 17}}}}}, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"fedbox.models": {"tf": 1}}, "df": 1}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 6}}}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}, "w": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1}}, "n": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 20}}, "i": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 10, "n": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.datasets": {"tf": 1.7320508075688772}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 2.23606797749979}, "fedbox.models": {"tf": 1.7320508075688772}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}}, "df": 29, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 3}}}}}}}, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}}, "df": 18, "o": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 4}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 7, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1}}, "df": 2, "r": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}, "s": {"docs": {"fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}}, "df": 3}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 7}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.partition": {"tf": 2}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}}, "df": 2}}}}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 2.8284271247461903}}, "df": 1, "d": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.4142135623730951}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.4142135623730951}, "fedbox.datasets.femnist.femnist": {"tf": 1.4142135623730951}, "fedbox.datasets.utils.partition": {"tf": 2.23606797749979}, "fedbox.models": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.4142135623730951}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 25}, "f": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 3}, "t": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 4, "s": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.7320508075688772}}, "df": 4}}}}, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}}}}, "s": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}}, "df": 5}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 10, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1, "s": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 6}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}}, "df": 3, "s": {"docs": {"fedbox": {"tf": 2}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 2}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 10}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox": {"tf": 1.4142135623730951}, "fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1.7320508075688772}, "fedbox.optimization": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 21}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 7}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 7}}}, "e": {"docs": {"fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 9}}}}}}}}, "l": {"2": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 13}, "docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 15}}}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"fedbox": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 3}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.default": {"tf": 1.7320508075688772}}, "df": 6}, "d": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.utils.FederatedSubset": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 31, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 18}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets": {"tf": 1.4142135623730951}}, "df": 1}}, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 4}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1.7320508075688772}, "fedbox.models.nn.NeuralNetwork": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.4142135623730951}}, "df": 6}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 5}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.optimization.fedavg.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1}}, "df": 9}}}}, "y": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}}, "df": 4}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 4, "[": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 10}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 5}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}}, "df": 3}}}, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "k": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}}, "df": 3}}}}}}}}, "y": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}}, "df": 3, "o": {"docs": {}, "df": 0, "u": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.7320508075688772}}, "df": 4, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.femnist.FEMNIST": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.__init__": {"tf": 1}}, "df": 14}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}, "fedbox.models": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 2}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 2}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 2}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 2}}, "df": 19}, "s": {"docs": {"fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}}, "df": 3}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme.weights": {"tf": 1.4142135623730951}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"fedbox.optimization.fedavg.Agent.__init__": {"tf": 1}, "fedbox.optimization.fedprox.Agent.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.__init__": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 4}}}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 9, "s": {"docs": {"fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.utils.WeightingScheme": {"tf": 1}, "fedbox.optimization.utils.UniformWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 12}, "d": {"docs": {"fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4, "l": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}, "fedbox.optimization": {"tf": 1}, "fedbox.optimization.fedavg.Agent": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 2}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 2.6457513110645907}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 2}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.perturb": {"tf": 2.6457513110645907}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 37, "s": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 11}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.__init__": {"tf": 1.4142135623730951}, "fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.__init__": {"tf": 1.4142135623730951}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.average": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.evaluate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.proxterm": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.__init__": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.evaluate": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 22}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1}, "fedbox.models": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets": {"tf": 1}, "fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator": {"tf": 1}, "fedbox.optimization.ours.Coordinator": {"tf": 1}}, "df": 5}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 5, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 6}}}}}}}, "d": {"docs": {"fedbox.datasets.femnist.FEMNIST": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.optimization": {"tf": 1}}, "df": 2}}, "x": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 15}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1.4142135623730951}}, "df": 2}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.adjacencies": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 12, "e": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}}, "df": 3}}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fedbox.optimization.utils.Logger.__init__": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.evaluate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 8}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"fedbox": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1.7320508075688772}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1.4142135623730951}}, "df": 15}}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.weights": {"tf": 1}, "fedbox.optimization.utils.AdjancencyWeightingScheme.adjacency_matrix_": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {"fedbox": {"tf": 6.082762530298219}}, "df": 1}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}}}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox": {"tf": 1}, "fedbox.optimization.utils.Logger": {"tf": 1}, "fedbox.optimization.utils.Logger.__init__": {"tf": 1}, "fedbox.optimization.utils.Logger.flush": {"tf": 1}}, "df": 4}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 2.23606797749979}, "fedbox.datasets.cifar100.cifar100": {"tf": 2.23606797749979}, "fedbox.datasets.femnist.femnist": {"tf": 2.23606797749979}, "fedbox.datasets.utils.partition": {"tf": 2.23606797749979}}, "df": 6}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "d": {"docs": {"fedbox.datasets.utils.FederatedSubset": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.utils.partition": {"tf": 1}}, "df": 1}}}}}}}}}}, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"fedbox.models.mlr.MultinomialLogisticRegression.forward": {"tf": 1}, "fedbox.models.nn.NeuralNetwork.forward": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fedbox.datasets.cifar10.cifar10": {"tf": 1}, "fedbox.datasets.cifar100.cifar100": {"tf": 1}, "fedbox.datasets.femnist.femnist": {"tf": 1}, "fedbox.datasets.utils.partition": {"tf": 1}}, "df": 4}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Agent.perturb": {"tf": 1}, "fedbox.optimization.ours.Coordinator.__init__": {"tf": 1}}, "df": 5}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.models": {"tf": 1}, "fedbox.models.nn.NeuralNetwork": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.optimization": {"tf": 1}}, "df": 1}}, "s": {"docs": {"fedbox.optimization.utils.Logger.log": {"tf": 1}}, "df": 1}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fedbox": {"tf": 1}, "fedbox.datasets.cifar10.cifar10": {"tf": 1.7320508075688772}, "fedbox.datasets.cifar100.cifar100": {"tf": 1.7320508075688772}, "fedbox.datasets.femnist.femnist": {"tf": 1.7320508075688772}, "fedbox.datasets.utils.partition": {"tf": 2.23606797749979}}, "df": 5}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"fedbox.datasets.utils.set_seed": {"tf": 1}, "fedbox.optimization.fedavg.Agent.step": {"tf": 1}, "fedbox.optimization.fedavg.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedavg.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedavg.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1}, "fedbox.optimization.fedprox.Agent.optimize": {"tf": 1}, "fedbox.optimization.fedprox.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.run": {"tf": 1}, "fedbox.optimization.fedprox.Coordinator.iterate": {"tf": 1}, "fedbox.optimization.ours.Agent.step": {"tf": 1}, "fedbox.optimization.ours.Agent.optimize": {"tf": 1}, "fedbox.optimization.ours.Agent.multioptimize": {"tf": 1}, "fedbox.optimization.ours.Coordinator.run": {"tf": 1}, "fedbox.optimization.ours.Coordinator.iterate": {"tf": 1}}, "df": 16, "s": {"docs": {"fedbox": {"tf": 1.7320508075688772}, "fedbox.optimization.utils.Logger.log": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fedbox.datasets": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fedbox.optimization.utils.AdjancencyWeightingScheme.message_": {"tf": 1}}, "df": 1}}}}}}, "x": {"docs": {"fedbox.optimization.fedavg.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.fedprox.Agent.step": {"tf": 1.4142135623730951}, "fedbox.optimization.ours.Agent.step": {"tf": 1.4142135623730951}}, "df": 3}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();