import DataManipulation as DM

def PlantsDatasetCreation(
        Data_directory  : str,
        features        : list,
        labels          : list,
        target_ids      : list,
        ref_ids         : list,
        start_date      : str,
        end_date        : str,
        **kwargs                ):

    dataset = DM.read_csv_files(Data_directory)
    dataset = DM.select_data(
                    dataset,
                    features    =features,
                    labels      =labels,
                    start_date  =start_date,
                    end_date    =end_date
                    )
    if kwargs.get("features_to_clip"):
        dataset = DM.clip_data(dataset, kwargs["features_to_clip"]) 
    if kwargs.get("features_functions"):
        dataset = DM.apply_math_functions(dataset,kwargs["features_functions"],features)
    if kwargs.get("features_to_shift"):
        dataset = DM.add_delayed_columns(dataset,kwargs["features_to_shift"],features)

    dataset, dataset_min, dataset_max = DM.normalize_data(data=dataset, normalization_ids=target_ids,columns_to_normalize=features ,reference_ids=ref_ids,forced_norm_values=kwargs.get("forced_norm_values"))
    return dataset, dataset_min, dataset_max

