/**
  ******************************************************************************
  * @file    plantnetwork_data_params.c
  * @author  AST Embedded Analytics Research Platform
  * @date    Wed Nov  8 17:53:57 2023
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#include "plantnetwork_data_params.h"


/**  Activations Section  ****************************************************/
ai_handle g_plantnetwork_activations_table[1 + 2] = {
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
  AI_HANDLE_PTR(NULL),
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
};




/**  Weights Section  ********************************************************/
AI_ALIGNED(32)
const ai_u64 s_plantnetwork_weights_array_u64[4276] = {
  0x3c8180d5bba5abd7U, 0x3cf9d72b3ce28340U, 0x3d4502f03d25db1aU, 0xbcf64316bf5316b9U,
  0x3d65436fbcc67df6U, 0xbd0b0bae3da7cd08U, 0x3eaff2293e11a484U, 0xbe757d7d3ea078b8U,
  0x3e9006cbbee641b7U, 0x3d0880cabf6b1ec7U, 0x3ea19767bc79252cU, 0x3ea8f58bbd569e32U,
  0x3d09b6d53d6b0bb2U, 0x3d8134253c132383U, 0xbe76ff47bfab8978U, 0xbed665713d34e7c4U,
  0x3d033c213d2e7396U, 0x3d99cf413f05dd0eU, 0xbd84abfe3dac27dcU, 0x3e877d883d190ebbU,
  0x3e7a8871bea62105U, 0xbf28b3b4bef8c3ffU, 0x3eb679fa3c977257U, 0x3e0aeb353dba9915U,
  0x3d7911563e519b46U, 0x3e431714bccabafbU, 0x3d614b1c3db153b3U, 0x3cd1ab0fbeea738dU,
  0xbe3fec7d3d810a72U, 0x3de6e4963d6534d2U, 0xbd0d3c05bc185d76U, 0x3e0dbdf0bf0c35cdU,
  0xbf248ae0bee44804U, 0xbda0a25e3d1df19dU, 0xbdad46993d0ad7c0U, 0x3f01fbe0beb4a755U,
  0xbda54e69bebc9c7cU, 0xbef003893a0e5aabU, 0xbd6944223d21ca77U, 0xbd9bcae5bf84e5a8U,
  0x3ed2a1a5bbadf451U, 0xbc7a4006bd5da15dU, 0xbd8ed04e3b9fbca6U, 0xbdc75b283cfd41b1U,
  0xbdb8c93dbd9ad37dU, 0x3f4cc98b3ec57957U, 0xbe4880723ef3894aU, 0x3f0b598c3e122472U,
  0xbf14f5a1bf2c5c1fU, 0x3dceb4e63f38aa19U, 0x3f480d54be024411U, 0xbf1fb38dbe2054edU,
  0xbd92e4f4bebd94eeU, 0xbf17c7db3e496433U, 0x3e146a19be90730bU, 0x3e3dbe2bbe585d0aU,
  0xbe5081cebee26b88U, 0x3eac823bbef03508U, 0x3ee1c0093f306139U, 0xbe5a495fbeb20041U,
  0xbf16d8fc3e7b47b9U, 0x3f75c602bea4c922U, 0x3d8ae96dbead764dU, 0xbd2347f43e0ee8d2U,
  0xbef9a0df3d717985U, 0xbf35192fbd294c32U, 0xbebe213ebf091468U, 0x3ec42fb6be13f976U,
  0x3ec00868beecffafU, 0xbd05eceebd765f29U, 0xbe46ec9ebf0c41adU, 0xbdfe7ac7bf0f944fU,
  0x3ed60cc73d578482U, 0x3eedc4143ed81c08U, 0x3edee630bc093f2cU, 0x3eb05db5beaf5da9U,
  0xbe010c7a3d61aad2U, 0x3f4e9bc9be04ba5cU, 0x3d70011ebeced976U, 0xbf397970bed09460U,
  0xbf3572c43e8902ceU, 0x3f8243593ed87a1eU, 0x3edf983ebd99c18aU, 0xbe8f2027be673013U,
  0xbf53ee4e3ee04d8bU, 0x3f5924103d19cbd3U, 0xbe0733723ef441e9U, 0x3ea130953e129c22U,
  0x3e937c04beaced79U, 0x3ed2ce783f2ed1c5U, 0xbe4ffb4abdc3fb25U, 0x3f3875cfbea83868U,
  0xbec63f50bf5d86d7U, 0xbeac1c783ed40381U, 0x3ebb64fb3d1560d1U, 0x3e1aca1abe4f5c36U,
  0x3e0d39093f17e999U, 0x3f2bd9153f278429U, 0xbf2f00e63f00f5d8U, 0x3f362c653f35c3a9U,
  0x3efc9ae03d3f9904U, 0xbe301ae6bf1c28dfU, 0x3e3120f8bdc75636U, 0xbedb0a85bf137bc3U,
  0xbf0171aa3ed53ed0U, 0x3d921b62bf02b328U, 0x3f2ef9dd3eafd3a5U, 0x3e63b45abf292b86U,
  0xbe3ba1d2bee319bdU, 0x3be7c2ac3ee77658U, 0x3efb24543f1a16d8U, 0xbf09a12e3f38d670U,
  0x3f1274013e1bf5c2U, 0x3ebd4c5bbebed7c9U, 0xbd5e9a28bf021bddU, 0x3eaf34683d78bd29U,
  0xbe8a21433e4588c0U, 0x3f29d514bea29a11U, 0x3db29a5c3edbc5b8U, 0x3f5ddb3a3f058054U,
  0x3f1170ee3e3ffaa3U, 0xbe94ef3fbf124152U, 0x3ed0178abef0a004U, 0xbf5ce8d3bf29e112U,
  0xbda06ed5be068819U, 0x3e7f26023f4ba663U, 0x3e6e61f23ef9a7b0U, 0x3e2129cfbf018914U,
  0xbf2653f6bcd5175dU, 0xbf25abf2bd7da03cU, 0xbf29da0ebee490fdU, 0xbee39b25bf30a0faU,
  0xbf2048153f274c4aU, 0x3ded3c45bed433d2U, 0x3ddf1303be14b32eU, 0x3bfeb0583ebdce43U,
  0xbe8cb416be9dec63U, 0x3e3b49a53edd0d5aU, 0x3b08081f3ea4a54cU, 0x3e8ef0f33e4bc15bU,
  0xbefe26ccbf171abbU, 0xbcd03429be564128U, 0xbadb924b3e8ce229U, 0x3e255e77bed9b70bU,
  0xbec594013e64a726U, 0xbf208cfbbf1c496fU, 0xbeb4e3e83e127583U, 0xbe16c427bda8787bU,
  0x3eb9264bbec873c8U, 0xbebbb2293dc554afU, 0x3f2387fc3ee312e5U, 0xbe87e82e3c94b85cU,
  0x3e8be945bdc5dcd6U, 0xbefe5a683ed0afc7U, 0xbf1a2564be10750cU, 0xbee90f963f2153acU,
  0xbf1ead8e3e0a1351U, 0xbee68e813f25667bU, 0x3da94503bd9e42cfU, 0x3f1d1b703f34fe71U,
  0x3c5054e23eff0e33U, 0x3ee3d88c3e2a293dU, 0x3f1b94dfbf240344U, 0xbef39a403de875dfU,
  0x3e3864b0bf2482dcU, 0xbf0f949d3e9be327U, 0x3f1f57963eb1d493U, 0x3e9c3135bcd4564fU,
  0xbeb6e0debeb07009U, 0xbea49ebcbe2057c1U, 0x3c437061be191eccU, 0x3f057ca93f48cf44U,
  0x3ec8697bbf0f9469U, 0x3d9bc1e7bed7c9bfU, 0x3f62d6af3e9cfe15U, 0x3f1c9ac2be8b09c2U,
  0xbb9ba698beae4b26U, 0xbef78f623f3ab948U, 0xbd6f84ca3eb9f672U, 0x3d054d99bce3addaU,
  0x3d5627a73f0c83b7U, 0xbcfa34253d2cbcfaU, 0x3d8c307dbd360b94U, 0x3d82819cbd42b72eU,
  0xbd9726733cbed7a9U, 0x3d8b16923d92213aU, 0x3cb53391bd56950fU, 0x3dd075bf3d5204d5U,
  0x3d266d5cbda5d7bcU, 0x3d9066563cb4b264U, 0x3d9d439c3d28a14bU, 0x3d67a1013dbc3fdcU,
  0x3dbfd46abd11e86cU, 0x3db20901bc9110a8U, 0x3d9ac434bd949c7bU, 0xbd42749b3cb79fbcU,
  0xbdc7653e3d6be7c2U, 0xbd2be82b3c84df7dU, 0x3dd6ece23db771d4U, 0x3d47b857bcd2044fU,
  0xbd94c5203db601c0U, 0xbd88bf18bd87edddU, 0xbcee9db1bd41029bU, 0x3dc7493fbbc16033U,
  0x3c941a85bd9cb297U, 0x3cd2279ebdb80c7eU, 0xbca3185bbdafc5a8U, 0xbda3ad67bc8c4e55U,
  0xbd1e51edbc17c9beU, 0xbd968daebd54c606U, 0xbd837fcfbd0ba085U, 0xbcfd51f7bc9c677aU,
  0x3c7f00d63d959479U, 0xbb66871fbdc697a1U, 0x3dd3ce66bd83b48bU, 0x3db236b8bd543207U,
  0x3d5899f53c05a323U, 0xbc29942cbc11116cU, 0xbc3deec8bd5c14e4U, 0xbda5784dbd829b98U,
  0xbdcf3bbbbdbab0acU, 0x3bea32583d529d82U, 0xbada710abdca1fd8U, 0x3c2a5203bb7ccf23U,
  0xbd3e07593c13a3deU, 0xbd3e09a0bdb3e12eU, 0xbdc3b5aa3d2d0bcaU, 0x3dd38afd3d5eaf31U,
  0xbd1ecd6a3d7a3a85U, 0x3d25d49b3d9a5a34U, 0xbc9fd641bdaf6ea8U, 0xbd47f3a63d875e14U,
  0xbd296745bcde6434U, 0x3d492c2e3d1b88ebU, 0x3d96f2ecbd37ee8dU, 0xbd49fed3bd77029fU,
  0xbd7517c93d24f941U, 0xbcd0b0b43d59ca29U, 0xbd6995c63d67e790U, 0xbd933428bdb2f36dU,
  0xbd989a48bd0e27e7U, 0x3ba258cc3d525687U, 0x3d89ea42bd9ff3e3U, 0x3d033733bc8e97deU,
  0x3c1a6ab03c859839U, 0xbdc72e08bdbe6596U, 0x3d99d9ffbce7b3cdU, 0xbd56d31ebbcb4880U,
  0xbd055501bd662f14U, 0x3d40d04e3d3e1a24U, 0xbd76d12bbd7ef9ecU, 0xbcf467c9bca3c430U,
  0x3c5f15a33d387780U, 0x3d760ad03d8ec92eU, 0xbda7ba8e3dceed21U, 0x3d74e102bda59d63U,
  0xbcdb8a69bda500e8U, 0xb9bbbc47bd836910U, 0x3da89c073d3da4b8U, 0xbd4632c5bd8e2b9bU,
  0x3caa3f723c5a1ebeU, 0x3c6b596d3dd01097U, 0x3ce23f45bd916b07U, 0x3d8fdc9dbcfd0094U,
  0x3dc793af3cfffaffU, 0x3d846b2ebbb4ba17U, 0x3c8f55bf3d30f795U, 0xbca03547bdaa54acU,
  0xbd0e4de93d8b0e97U, 0x3c3903543cae3272U, 0x3db43e983d89746cU, 0xbdaa24283a1d5078U,
  0x3da7d10d3c5ebbfcU, 0x3ce7ef763ccd4343U, 0xbdb2188dbbe39970U, 0xbd0f71b43da441afU,
  0x3ca658ecbd61249dU, 0xbd65b63bbcd1d1bdU, 0xbd129c2e3d400393U, 0xbd4bf953bd7a4201U,
  0xbc8e0e9d3cf2264dU, 0xbdcce9c4bdc5ac6eU, 0x3b853fba3d17928dU, 0x3da76d68bdceffa0U,
  0xbd941dec3d29523fU, 0x3c1383d4bd6551a3U, 0xba4eff05bdbef35eU, 0xbde678de3b465cafU,
  0xbd0492a6bcb09218U, 0xbd8cafd23a8cf737U, 0xbd9cb52ab9a61622U, 0xbcd0bec63dcccf49U,
  0x3db30f71bd90eec8U, 0x3d855cb9bdb99fa2U, 0x3cd68b6e3d25940dU, 0x3bf9dcd63c51d737U,
  0xbd7833793d6a673bU, 0x3daa583fbd8d0ba9U, 0xbba090343b3dd1c3U, 0x3dd33d77bd0b6b81U,
  0x3d37cf813c01a85aU, 0xbd37dcd63da1d346U, 0x3ceab4e23d0d831fU, 0x3d9fc1a1bba079e2U,
  0x3cb8cf45bcd38bdcU, 0xbd0a99e13d548fa6U, 0x3d5ed9173da449a6U, 0xbd6d4409bd9d5cb2U,
  0xbcbd28433cb15d47U, 0x3cf81225bd786bd2U, 0xbd182beb3cb3deeeU, 0xbd76283ebd875c0aU,
  0xbd266c3e3c1422e5U, 0x3dc6b278bcfee715U, 0x3c608d1cbdd3b07fU, 0xbcae9e89bd346ee6U,
  0xbd88d305bd74d169U, 0x3b5713a9bda545d6U, 0xbdae8c3bbd2fce62U, 0xbd35a260bda51b2aU,
  0x3d72a4e33d5fdaf5U, 0x3ae042bbbd5aa9e8U, 0x3c07f2193d1a74b5U, 0xbdd5fe9d3d9ca4e5U,
  0x3da491683bf865e5U, 0x3c9857d8bd9a17ebU, 0xbc9a5d393dae6da6U, 0x3c550ea1bbce0399U,
  0x3da20e233b1fd5f1U, 0x3cc02df23dae5425U, 0xbd1454073d4eab4eU, 0x3cf6bcbdbbbee8ffU,
  0xbd6ba1773c85a307U, 0xbd91ae0bbd8cb9e1U, 0xbd51c3c33cd174e8U, 0x3da4220a3db5ea6cU,
  0xb93bdc5cbd5b9519U, 0x3d836f8dbdcbb525U, 0xbd8b7e723c2a1306U, 0x3dabe3e93d506727U,
  0xbd9a5e94bd128effU, 0xbdd27ce73dc63634U, 0x3db0dad53db04c36U, 0xbd307000bdbd5896U,
  0xbd04ddc5bd7ccafdU, 0x3cb201963d313faeU, 0xbdc43682bdb10b8aU, 0x3d50fdfdbcb98671U,
  0x3c62c3a93d294637U, 0xbc3a223dbd04e46dU, 0xbdbce1173c797a9fU, 0xbd23af873da69f14U,
  0x3daa61f43d2bf649U, 0x39af7f2fbdcb4259U, 0xbdd72b49bdc0612cU, 0x3dabdf95bd8b109dU,
  0x3dc3ca8e3da7da3bU, 0xbd827998bd9cc3bcU, 0x3d0ff3d4bdc9b414U, 0x3da6b70cbc8d7770U,
  0x3d03df363da85f3bU, 0x3da88f6dbdd74a0fU, 0xbc293280bc92f239U, 0xbdb668e6bd337f66U,
  0x3dd789dcbd95cc4fU, 0x3da0691a3d30240bU, 0x3d86354e3c96513bU, 0xbcf1d7a53dbd00afU,
  0xbd104f74bc611e84U, 0xbd44a00bbdc97467U, 0xbd11b054bd85557fU, 0xbdcecba1bc9494cdU,
  0x3cbd2a113dc584cfU, 0x3da49cbcbdbc0401U, 0xbdd5f81b3d21f1cdU, 0xbdb66cbbbd874bceU,
  0x3d837bec3d255bccU, 0x3d54d7ed3d08fa96U, 0xbdb1d946bdc6bb6eU, 0x3dade3d2bbb8bcf5U,
  0xbbf6308f3d40fecbU, 0xbd11a9903d91df88U, 0x3d567ee43dc87d72U, 0x3da2f9a63c4002fdU,
  0x3b0a9a17bdcdceccU, 0xb959a899bd000e7eU, 0xbd8286ca3da764fdU, 0xbc86a3033d97cd27U,
  0x3da3bea6bc2b9071U, 0x3d2ec722bdc4d45eU, 0xbb9c55de3ceb8ba5U, 0xbb928652bd98ae83U,
  0xbd5a37bfbc5a3608U, 0xbd98deaabdd4ef7dU, 0xbdb855a33d362e37U, 0xbc088312bd8dbb62U,
  0xbcab84753dcb7889U, 0x3b8f67973d4dcc93U, 0xbd80c2d4bd6983c8U, 0xbdcbd024bd2e6d8dU,
  0xbcbed11ebb95c348U, 0xbdd3857bb8d5d9c7U, 0xbc0964a73d01e5beU, 0x3d95c30f3d89df24U,
  0xbdcafaa53d154543U, 0xbd2fc8523da61cd5U, 0xbdc5dfe6bcfe8c56U, 0x3db1f5bdbccb3a10U,
  0x3d21c4e6bc773436U, 0xbd8497dcbd0f2237U, 0x3d509b57baa22af9U, 0xbd9f64d03cd9e1f5U,
  0x3da0c99d3cbc89d2U, 0xbd1baa22bc7f0293U, 0xbd9f91c9bdd596c9U, 0x3b9b27fabb8f6a0eU,
  0xbd1d7e543d2c769cU, 0xbce854d7bdcb7e0dU, 0xbdc03471bd8d1b00U, 0xbb41be66bd537edaU,
  0x3db9a851bd85dce7U, 0x3d853f57ba036648U, 0x3d2ff77a3d4225e3U, 0x3d47dee0bdb22a5eU,
  0x3d91184b3b92a8d7U, 0x3dd539ff3dc6f9d0U, 0x3cb3dbb3bc0dcb5fU, 0x3d492ef9bc0814b2U,
  0xbd151206bdc542f8U, 0x3b98cef5bdc34957U, 0xbd1fdd60baba1563U, 0x3d0164d5bdb57c65U,
  0xbd52cacfbd2a38edU, 0xbc53b090bd7e4387U, 0x3ce3ff49bdaa73b4U, 0x3da64bdbbd8beb86U,
  0xbdbf78693a87fbb8U, 0xbc221f433b839cbcU, 0xbdb916cebd9516ffU, 0xbd013e4ebd4e3b65U,
  0x3d882707bda99c15U, 0x3c7bbaa3bdb38c0bU, 0x3d60b5793db8695fU, 0x3dc1a5293d48fa09U,
  0xbd8060f9bd82f929U, 0xbc7b530ebd631b4fU, 0x3d7b8d1ebdbe5ca0U, 0x3dc901f1bdc41fa5U,
  0x3dbbd3ad3dbb49ebU, 0x3cdb8fb13bbee0c3U, 0x3e4937f7bdd01454U, 0xbd541803bdc45ce5U,
  0x3dc10593be1596b4U, 0xbbc8d2fa3e3cd69fU, 0x3dbee39bbd994924U, 0x3ce62e693b68ca6bU,
  0x3b8bccc03dbb97ccU, 0x3d5ac8043cb6a97cU, 0x3e81e865bdd33497U, 0x3ce42b8ebd858647U,
  0xbd2d6b53bdc5bcb1U, 0x3d866b8f3ca3a4a5U, 0x3d959c163dbfd619U, 0xbdea6119bd10102dU,
  0x3d92e76c3e05829eU, 0x3d6764d93d6f2502U, 0x3e3c45523cc42a42U, 0x3cc3cb27bb0cce7aU,
  0x3e833f64be89cc07U, 0xbd1086d33cb7309fU, 0x3e3cfd7bbe25867cU, 0x3dbfb083bce738adU,
  0xbdb825b2bdf170d3U, 0x3e75aa3c3dcc3e07U, 0xbe0e30b8bd943d70U, 0x3d82f3bbbc6269b2U,
  0x3e137b7a3d5bf8eeU, 0x3c466e893c9de837U, 0xbdabbd463d8d60e1U, 0xbcda8d8b3d8f44dfU,
  0x3db071e23c1f3bb6U, 0xbd110e7d3e50af91U, 0xbdea987a3a613f06U, 0xbb9c06b53e16e984U,
  0x3d96ed2b3d12c304U, 0xbccedda9bda5354eU, 0xbca030b8be4b2c36U, 0x3dac83f2bda9fe4dU,
  0x3d474b5e3be85d22U, 0xbe96ecb23ce7c928U, 0x3d8982e13c4c3fc2U, 0x3d3616dcbc49802aU,
  0x3d0ae4b7be4a82a5U, 0xbcc699683b8e4b20U, 0x3d3a795ebdcc7e23U, 0xbbc68e9ebde1740dU,
  0x3db209bb3d36f240U, 0xbd290670bdd65fb8U, 0x3d176f013dcbb535U, 0x3d2a88833d769964U,
  0x3dbf3ff63d188157U, 0x3db393d1bc835498U, 0x3dd0dfd5bd81f643U, 0xbd4a900f3d178d65U,
  0xbdd5fd85bd829108U, 0xbc85da7dbd99ef7aU, 0xbdb70be53d267e23U, 0x3dc6a9103d8ff865U,
  0xbd2989ea3d9edfcfU, 0x3d8433bebd1409c5U, 0x3d73e1cf3c29f008U, 0xbcafcc26bdd74f84U,
  0xbbf14cfcbd10a3eaU, 0x3d2e27f8bcb26a63U, 0x3d42ef0cbdbbc2f0U, 0xbca4c74bbd405762U,
  0xbd69209cbd23e138U, 0x3d88a71ebab73df1U, 0x3dce7aaf3d96d293U, 0xbd1525a23dd462ebU,
  0xbd215606bcef4bdaU, 0x3d3357343d3a0ca6U, 0x3dd7c73cbd647865U, 0xbd972335bb885c2cU,
  0x3cc94d113c2d4686U, 0xbcfe8833bd7d5b26U, 0xbd4c415abd21e916U, 0xbc0929db3d8fb7a7U,
  0xbd65492e3dd81001U, 0xbdc2b36fbdd3cb61U, 0xbd2da209bb18117aU, 0xbd8d48b03c7deb47U,
  0xbd998cf33d8f67b6U, 0xbb95898fbd289b60U, 0x3c1b3045bda474e7U, 0xbdc4bbb4bdabcddfU,
  0xbd8483ad3da844bbU, 0x3d14e883bcb2aa40U, 0x3cc3a7d4bdbf336cU, 0x3daa71b7bd483851U,
  0xbd61fcff3d8b3904U, 0xbd9bd4b83d5cec8aU, 0x3d4359e1bd3b7e22U, 0xbdabc1563c8aedd2U,
  0xbcd8f95dbd9ffb78U, 0xbdbcc11ebd0ec9f6U, 0xbd36e7dfbd9e5c1eU, 0xbdcaae32bd980cdeU,
  0xba43e0c03d11e7adU, 0xbd74003b3d9d361aU, 0x3d74c7f33d86c13dU, 0x3d6169113d737e71U,
  0x3d92fe723d8595d4U, 0x3d4332713d346116U, 0xbd5543d03dd5cd62U, 0x3d7f383f3a605a2bU,
  0xbd966e583caf3458U, 0x3ca7d094bd9385dbU, 0x3dd4bbbabda12150U, 0x3d21bb8e3dbb387bU,
  0xbd6ac4543daceedcU, 0x3d6926b6bd6789dfU, 0x3d7194e73dc2cb8bU, 0x3dad00fabd74bbfcU,
  0x3d43168dbc251722U, 0x3d40589cbdce3eebU, 0xbd397c4c3bc78927U, 0xbd9c13303d940c3eU,
  0x3ce90d62bc8345cfU, 0xbb1953573d03fb37U, 0x3d826ffc3d68af0dU, 0xbb790598bdb0969eU,
  0x3b4df989bdc93b46U, 0x3d971998bc13a6fcU, 0x3ce19836baa69f3cU, 0x3dcd2a1c3bfea01bU,
  0xbd9b7ef1bdba5fb3U, 0x3cfece1e3d9b7226U, 0x3d83d073bd93e6beU, 0x3dbc6247bd6408fcU,
  0x3d089379bd4dfa9fU, 0x3be678a63b486e4aU, 0x3dbe6522bda91686U, 0x3d883cc2bc9a09e3U,
  0xbdc2ec9f3d960951U, 0xbd688ce3bacc2880U, 0x3cffee82bd875efbU, 0x3c32c9813d8d4943U,
  0xbd91a8d7bc55acefU, 0x3c8367e1bdc5c0b0U, 0x3d8f5025bd92a0f0U, 0xbd3d45653cae936fU,
  0xbdb1ff3bbd8ae715U, 0x3d22731fbd03d7bfU, 0xbd3b9c80bc1596beU, 0x3d848b88bd59f45dU,
  0xbd54f7563d9d3fabU, 0x3d1ad4663dd7813dU, 0x3d3d76bdbce1d9d8U, 0x3dcabe5ebd7434f5U,
  0x3a9d53453d9916beU, 0x3d9acba83c999634U, 0x3d0b49863d7848deU, 0xbdb88f0e3d90140cU,
  0x3d0274e23d8a9e3fU, 0x3b4118dfbc21fa89U, 0xbd9be4eb3d8dde38U, 0xbd7ca3f33c9e7733U,
  0xbd9128473d4cc7d3U, 0x3d9b8b89bd847e8cU, 0x3d1ac40abb3d9c24U, 0xbce6ca913dd31c73U,
  0xbdd7e6333d845e5dU, 0x3c7e69163d8a429cU, 0x3da9dfcbbd146ab7U, 0xbd61cbdebd2088f0U,
  0xbc061be5bccacdb6U, 0x3c789b413cbebf95U, 0xbd2a445cbd02003fU, 0xbc9844ae3d135c62U,
  0xbcaaa983bdae534aU, 0xbbab78ef3d87afcbU, 0xbdb44e633cc5025eU, 0xbceffac03dbe1426U,
  0x3dc4ba7abda5c3ccU, 0xbdc3ac25bd5eb5bbU, 0xbd906fecbc716cc0U, 0xbb867c6dbdab7554U,
  0xbd3c13bf3d5ec2b5U, 0xbd126b263dac82b2U, 0xbd21bb363c9b46f0U, 0xbd1489403da3d717U,
  0xbd0afca4ba0df665U, 0x3da7f6b13cd3feabU, 0x3d63cf2bbbf703a2U, 0xbda924fd3dd3a817U,
  0x3c65f1f5bdd1723dU, 0xbbcb35ab3dad7debU, 0xbd999fd7bbe0ee75U, 0xb8a1469c3dae6a56U,
  0xbccdee09bc5aff57U, 0xbd148d32bdbd8465U, 0xbdc1df87bd2e94ccU, 0x3d952dab3c320d27U,
  0xbc0613943dcaa073U, 0x3d09c597bdc972beU, 0x3da46378bd17511bU, 0xbdbc00653b4baf85U,
  0xbd788d88bd7a1a00U, 0x3d6bf827bd5165baU, 0x3bee6ff3bd900926U, 0xbd114bebbd70471eU,
  0x3d857b3b3d682ffdU, 0x3d82bf26bb5711b8U, 0xbda79442bdd0885bU, 0xbdb5ce1fbdc40a64U,
  0x3d0f60e03d937f58U, 0xbdb4f8d13d0c4cd2U, 0x3dd1892e3d8cec7eU, 0x3c59c43c3dba6157U,
  0xbd03c21a3c6f5abaU, 0xbdd07e4cbbc30dcbU, 0xbcf5920e3dc3ece9U, 0x3db81ee7bdc8a463U,
  0xbd73d3733c9bad3aU, 0xbd307a383d2f1d48U, 0x3ce6fb603d6ca9eaU, 0xbd3fdb4f3c152dc5U,
  0x3c5afb343dae5622U, 0x3d84bf963ce48da5U, 0x3d59194a3db56810U, 0xbd9236d0bd8cafebU,
  0x3b819cbd3d29e653U, 0xbda35a29bda9cc3dU, 0xbd099ea93ca85b5dU, 0x3d83b1fdbd5d4e10U,
  0x3d075fb4bd2d4c99U, 0x3d82c372bd651da1U, 0xbd974678bd230c89U, 0x3d0699803b840c9aU,
  0x3d41c4403d94a383U, 0x3cfa2ae6bd941587U, 0x3b9b91443d46ceabU, 0xba98d5ebbd79ca89U,
  0x3da696713d6b46bcU, 0xbd541a4bbd05358cU, 0xbc5cbcccbbbe0c37U, 0x3d252eeabd0ed7c4U,
  0xbd234fe7bd6c6637U, 0xbda358f8bdc97b21U, 0xbd9f0908bd4e2fc9U, 0xbd70ab7cbdbe2632U,
  0x3d9755223d2308a1U, 0xbd95f5c23d4cdc8dU, 0x3d5e537d3cbeaf40U, 0x3dc01d72bd903c11U,
  0xbd90cc6b3c29a5b7U, 0x3dae995cbd3f22c9U, 0xbcf73286bc64ddebU, 0x3d6d691e3d3b983bU,
  0xbc228476bc59ac56U, 0xbd7e90c8bd75f987U, 0xbd147de3bcf19465U, 0xbd820e40bb5584aaU,
  0xbc3ebec33d031a0dU, 0x3dbbdc5bbd0c1276U, 0x3da7d5483cb60d6eU, 0x3d5c86c23d42e9a1U,
  0xbdacf701bd717711U, 0xbbcc191f3c063c1bU, 0x3d54f2b43dc9e3b0U, 0x3c9abf343d968d84U,
  0xbdd016e63cb87b2fU, 0x3c32f4ac3cb550e5U, 0x3d4de6193cca59a1U, 0xbd457597bd57b044U,
  0xbd39512ebd842871U, 0xbd8bbff8bc881133U, 0x3b1674053d61ff78U, 0x3bd16927bd8721abU,
  0x3d9a45043dc0bbd2U, 0xbd817b87bd92ce13U, 0xbc841026bd88f3b1U, 0xbd20f1e0bba26e92U,
  0x3d97106bbd69c72cU, 0xbd2d6f2ebdb457e1U, 0xba6574803d53feb3U, 0x3db469b83d17adfbU,
  0x3c858208bdccd7e6U, 0x3d8edcfcbd8feeedU, 0xbd3df6df3cbb86e5U, 0x3da9eb55bc238ca7U,
  0x3c2e370cbd590952U, 0xbd4c432b3d11101bU, 0xbd0ff82ebad662cfU, 0x3d3e1d16bdb5c9cdU,
  0xbc0938a53da34f0fU, 0x3c033171bba58742U, 0xbdc97576bd1d3a00U, 0x3dbfc281bdafb649U,
  0xbc5a48393dd669d3U, 0x3d8159a9bc878606U, 0x3d9fb0dfbd461bd0U, 0x3d1c16dabd402360U,
  0xbdafa50d3d8d8ae0U, 0x3d29b97f3dc71c0fU, 0xbdd8714ebcfee36fU, 0xbce803183d992c45U,
  0x3c66ab86bd737a3cU, 0x3da82a68bccb5b1eU, 0xbd8e38a43c086187U, 0x3dcf42023d24685cU,
  0x3d0433933cdb1bbeU, 0xbd318da4bcd911cfU, 0x3d0b4cbd3d1abf74U, 0x3c2df778bcc72010U,
  0xbd3cb02fbcc6857eU, 0xbdbc94dd3dac5acfU, 0x3d21377bbdaab2b0U, 0x3e00742abcce5834U,
  0x3dcb1220bcaabb2fU, 0x3da9e2af3d48b93cU, 0xbdc932f63dbe050fU, 0x3d5d1feb3dd2e265U,
  0xbd68f64cbd2d6e68U, 0xbd3fc1bc3dc25850U, 0x3d4be1e43bddb476U, 0xbda16cc4bc047fc7U,
  0xbd0269dcbc01f223U, 0x3c3ac6d6bd9e9c8eU, 0x3d8a95abbd127c41U, 0xbe0b98273d0a24c6U,
  0x3d89fe17bd71d4c2U, 0x3d474b49bcf6813dU, 0x3da3048d3d62984cU, 0xbdab79a43d53a718U,
  0xbdbf4f2d3dd767b0U, 0x3db311a9bdf7f063U, 0x3ccf7272bdb31573U, 0x3d466e143d70f404U,
  0x3dfaccca3cc44aa1U, 0x3cc7c71b3daa4cc3U, 0xbe01f95abcfdb8f1U, 0xbe245c903da47a3dU,
  0xbb67113bbd8d0786U, 0xbb8a4b083e16bb7eU, 0x3cc4d0fd3d6257b7U, 0xbd8bac74bbbd39beU,
  0xbd94695d3db7f6b6U, 0x3deabfd93d2e5d05U, 0x3d8099873d0890f0U, 0xbcc05e40bdb2ab66U,
  0xbd3deddb3cf71f5aU, 0xbd87fe7c3d89b814U, 0x3d94acecbda472c5U, 0xbd2b8e8dbd81e766U,
  0x3dd73b3fbc00673fU, 0xbcf1fd42bc0ccad4U, 0xbd20623ebe1ec807U, 0x3d91cc6ebd812158U,
  0x3d414b5b3d42d422U, 0xbaf268ee3d925290U, 0xbc1638c3bdc960acU, 0xbdbfb8f4bc539c7eU,
  0x3e1725733d5f7bbcU, 0x3cfbb926bd39a9e1U, 0x3c342decbd558059U, 0x3db292143e1a2fc9U,
  0xbd29cacbbcf7858eU, 0x3d355631bda60bafU, 0x3c882323bd71e2c6U, 0xbdb1835a3d527c80U,
  0xbdabd9b9bcee4084U, 0x3cccea293d1d3ba5U, 0x3de7c5f73de1724dU, 0x3a70afc23d896791U,
  0xbccf4efcbdd574caU, 0x3bb6dd93bda571b7U, 0x3d6f9c213d6b525aU, 0x3d8f2398bc62b2a9U,
  0xbd3a0d74bb8bc82aU, 0xbdd3bb9e3db118eeU, 0xbd459447bd15c039U, 0xbd90edc23d104f53U,
  0x3d18355c3bfcba8bU, 0xbd2445c2bc6c8ac6U, 0xbd770c4dbd3922bfU, 0xbdf1febc3db13dc0U,
  0xbd43d14e3dcd5bd6U, 0xbdb00998bc71cc71U, 0xbc8dcc703e17aa2bU, 0xbd27473ebc40edc9U,
  0x3d8c3c9ebd77bf1fU, 0xbde2dbedbdcb4a46U, 0x3d0d0408bc705961U, 0x3c8c92c23d680d20U,
  0xbdafa77b3d8a6169U, 0x3d44004fbbf657a6U, 0xbd9fa7173d3bbcdcU, 0x3d4c69863dbf47ffU,
  0xbce8e03b3dcb98fbU, 0xbd8150b53d9f1b3fU, 0x3d522c903da8b9f0U, 0xbd6201edbdfcc318U,
  0x3d125912bd8d00c0U, 0xbcf01a81bd71058fU, 0xbd60bd163dc6e52fU, 0x3d80d1d03db09819U,
  0xbdb669a63d889e2fU, 0x3dabfe1abdb1cb94U, 0x3ccc87f8bdd6761bU, 0x3d7bb9f2bd698f90U,
  0xbc6fc3cd3e23db66U, 0xbe2ab3a2bd7f25c5U, 0xbcb5ae17bd30b352U, 0xbdc4b23e3d550658U,
  0x3c64c5103c2e8fd7U, 0xbd6ce7ba3d981584U, 0x3d93514ebd0189b4U, 0xbdb0ac3cbd685216U,
  0x3c64b0f5bd637a62U, 0x3d9c24e9bd122a30U, 0x3d942167bdc15d6cU, 0xbda604d1bd7041d9U,
  0xbd8fb0403d848116U, 0xbd22411f3c9c44b2U, 0xbd3b983a3d31110eU, 0x3cf050aa3d00cba8U,
  0x3c1665b43d70e459U, 0xbd04236b3d51e0cdU, 0x3c93be1cbd04a318U, 0x3d9f59e2bd291a8fU,
  0x3dfa53953c171704U, 0xbc7183663dbbea8aU, 0xbdcb2bebbcb91d5fU, 0x3d4b221ebc88056cU,
  0xbda23d9ebd846504U, 0x3d3fc12e3d908935U, 0x3c57f3ddbb266c0dU, 0x3da63d47bc241d40U,
  0xbd55fb503ccbf4bdU, 0xbd17a56f3dd5da54U, 0xbda4faae3c8ffd9cU, 0xbd99ca46bdb2e93fU,
  0x3e06164bbcc10804U, 0xbd75d9e53c649232U, 0xbdb60411bd905c7fU, 0xbd5b0e523d6e6033U,
  0xbc7eda81bc2bda79U, 0x3d3cbe9a3d2b1fd9U, 0x3d2cc5c7bce7fbf1U, 0xbd9891ce3d550712U,
  0xbbb3d333bd0698b9U, 0xbdac515b3d18e37dU, 0x3dd5cecfbd3520ccU, 0x3e008e673d9dfccdU,
  0x3d83a5333d2c0c70U, 0x3daac9663d0d80fdU, 0x3df5d4a5bd976717U, 0xbd55b89e3b99c43cU,
  0x3dcff8a03c4d9f29U, 0x3d4b71fcbcf17dd6U, 0x3d69ceea3d33850eU, 0xbcae55debcd672f3U,
  0x3bd5c4d33d6605f1U, 0xbd937dc43da1bb94U, 0x3d4ced4e3da30729U, 0x3db29e92bd99c801U,
  0x3d9ae2b7bd96793fU, 0xbd7e302f3d304bdcU, 0xbdb26697bd12441cU, 0x3d9d9d29bda7ca13U,
  0x3d5152cd3b7bd909U, 0x3d7633c93dd72b5cU, 0x3d8b8bee3e125c1fU, 0x3d07cf833c4389a2U,
  0x3dfdc41fbd11a464U, 0x3d91dab3bd1a4c6dU, 0x3e26cae0be08d0e0U, 0xbda551ea3cd14ac9U,
  0x3e214ed8bd89275dU, 0x3dabd751bdcc7535U, 0x3d8f4ec43df217ebU, 0x3e000a87bcbb787bU,
  0xbe0c439bbd95cdceU, 0x3e13d524bd1ce666U, 0x3de0f3af3da7a5f9U, 0xbd9917cbbd5814a7U,
  0x3c24a0283dcbbc7fU, 0x3d6ab8923d0f3631U, 0x3cb07cc13d381babU, 0x3cc5a1013cd7aa19U,
  0x3c4a6007bd80e198U, 0xbd61a7f83c54b2d6U, 0x3c7e64833e1cec36U, 0xbcea5a9abd580fddU,
  0x3d0c8d24bd267fc2U, 0xbd096df23d920655U, 0x3cb2ebc33da10e16U, 0xbde4f8ec3d5776baU,
  0x3d34424c3de93ac8U, 0x3d9a56a8bda1a374U, 0xbdb7f212bc4741e3U, 0x3e163368bd94a6c5U,
  0xbbf37c2abc6acab8U, 0xbc25b1bd3d3caf49U, 0x3dbe2b85bdcb2fd4U, 0x3dae42783cefdb6cU,
  0xbc6c147dbd1429d4U, 0x3dda55663dc2281bU, 0xbba71dea3da41312U, 0x3ae0133ebc33a3f4U,
  0xbd909d703c5e4496U, 0xbd2eac8cbdb1594bU, 0xbd9dd46fbc68e5efU, 0xbd52767bbdc8c036U,
  0xbcefe159bd95d483U, 0xbd8077fd3d11c86bU, 0x3d9cc174bca006a5U, 0x3d641129bdbe8fa9U,
  0x3d2f80e1bd063d70U, 0xbdcaceb7bdb55748U, 0xbe15c50a3d7effeaU, 0xbde2849ebd814de8U,
  0x3bccdca3bc1ffafbU, 0x3d413f01bbf099a9U, 0xbd04f1963d435aeaU, 0x3d5d6f2c3b4f2665U,
  0xbd28b2ebbd4df1e7U, 0x3d35cc283dcaec87U, 0xbca1fd313d980838U, 0x3d3d11cebdd7c723U,
  0x3d9261febdbcc6fbU, 0x3d3b2a243ca2d112U, 0xbdc054643dad7e8fU, 0xbdd10ad53de177b7U,
  0xbd67836abdc1cc50U, 0xbdbce5a1bd1db9eaU, 0xbd47516bbdcf76b9U, 0x3d61d37cbd9e4489U,
  0xbde44119bda81cb0U, 0xbc37298b3e1ddb90U, 0x3c8bfe4e3dd4679fU, 0xbd06d2623dbc5608U,
  0x3da8f478bb928ca2U, 0x3cb0cd76bc82d0b5U, 0x3d55bd02bd634e7fU, 0xbd5145353dcbcc05U,
  0x3d37592a3d420d44U, 0x3db61e29bcc4f5dcU, 0x3e66521c3b1e54e7U, 0xbdc15846bd8a7614U,
  0xbd4cd2a2be32c04fU, 0xbd3ad8c73e1c5269U, 0xbba095743d3e7c74U, 0xbdce88cf3da56810U,
  0x3dc0aae03d7cc63aU, 0xbd89a57a3e1cbed6U, 0x3e70c1c43d8cfda9U, 0x3c1d514fbd270a0fU,
  0x3d8159d33d83bea5U, 0x3d41284f3d1178abU, 0x3d0da4ed3e11d456U, 0xbd2475d13c76ee28U,
  0x3cdc9583bcd68cb4U, 0xbdd3e3d63c486848U, 0x3e6eb5993d39f4a3U, 0xbdc755d8bceda65bU,
  0x3e23a1cbbe62a08aU, 0xbd87a0e63e22683eU, 0x3e02c74fbe6398d4U, 0x3d0ed6aebd4cf3abU,
  0xbdb8edfbbde9f5d2U, 0x3e080d053d096af6U, 0xbe2ba544bdbd2a2dU, 0xbd0561513dd4030cU,
  0x3e1694733c616d35U, 0x3e020451bd007d83U, 0x3d0f0f973e55ea69U, 0xbe55acbd3d4fa071U,
  0xbdcfa4223d1d8222U, 0x3ddb10c93e4468baU, 0x3cf69429bdaf36f9U, 0xbd79746b3de2f820U,
  0x3db7eed13e43770eU, 0xbb08c795bc2e4b47U, 0x3b2e830cbdf1040eU, 0x3dd05beebd5e5a27U,
  0x3d31ac2ebd53b2d0U, 0xbea73eb33d825cf6U, 0xbce05ac13d5c1415U, 0x3dc21212bd81b371U,
  0x3db07edbbe835c93U, 0x3ddf75d73d977d97U, 0xbcf108b03d92cef0U, 0x3db0937dbdc4438bU,
  0xbc63121abda2bc76U, 0xbda355503da9401eU, 0x3dc419efbdb8600bU, 0xbd93203dbda8507bU,
  0x3c1f8b273d12a5b1U, 0xbccf625cbd16172dU, 0x3d047a0f3d983040U, 0x3d18ed153cb78951U,
  0xbc8bae2c3dceae57U, 0xbd3a6012bac20bdeU, 0xbda01df4bac5946bU, 0xbd4fc9e63dc12051U,
  0xbcf6ef9abd985123U, 0x3c8bd03f3c0e0f85U, 0xbdc5ac3a3c1fb993U, 0xbdd386fcbc9be7d3U,
  0xbd5bcad83d012acbU, 0xbde0fc65bd02380dU, 0x3d99f0b93d426c38U, 0x3cd8dcb13bab1c15U,
  0xbd7b9c133ba281eaU, 0xbd8a5d9b3d49878aU, 0x3c9b7ca0bd087ea2U, 0x3db228d03a8aa48cU,
  0xbdc84c6e3d23079dU, 0x3d4cf0bd3cf20f85U, 0xbcacae5dbda6af1eU, 0xbd417439bd9d7b20U,
  0x3d441b503d8415a5U, 0x3d91824d3d96cd30U, 0xbdaa4cc23db3cbf5U, 0xbd8698d93dadc8d3U,
  0x3cb35ccb3db0cdbeU, 0x3dac02f43d5e3e1eU, 0xbd9f05093d8d1255U, 0xbaffe7c3bd438e9fU,
  0x3da4fec13da6ca20U, 0x3dc3be433d1f3974U, 0x3d10e3083d2db0b8U, 0xbd16f30cbdc491dfU,
  0xbdd1d5e8bd0c66caU, 0xbda5024dbda8b6e5U, 0x3d1183433d283b18U, 0x3d8c097f3d0e6209U,
  0xbda554e43cbff02cU, 0xbdc2c9c9bd05c0edU, 0xbd8cb4b3bd6ae848U, 0x3cd00e06bc0915fcU,
  0x3db6eb8dbd12bb62U, 0xbd5b3d48bdbbcc96U, 0xbc2c6196bd456419U, 0xbbd281bcbd804e69U,
  0x3d053b003db6d722U, 0xbd03148c3c738fd2U, 0x3d7552b53daa078dU, 0xbd70ffbdbcc6fd8cU,
  0xbd344da5bd1b4f41U, 0xbd62545bbd7082d8U, 0xbc55ebbcbcc4b133U, 0xbdadacc2bd71c157U,
  0x3d9249d33d4747bbU, 0x3c2099833d8c3179U, 0x3db60f123c0169afU, 0x3d89e587bd20cc2fU,
  0x3ba7eb05bd2f8a13U, 0xbdb6719d3be21fedU, 0x3ca6d24e3dc1e9f5U, 0x3d44c570bd0efbb2U,
  0xbcd1173abcc8cf24U, 0xbbbc12573b241863U, 0x38acf39b3d0880c4U, 0xbcb55f623aaf6538U,
  0x3c3727a53c3c0f68U, 0x3c5a0a9fbd408d98U, 0x3d7b1271bc0c18e4U, 0x3d446c9cbca28388U,
  0xbd76f6a13d4c7f20U, 0x3d28b96d3db67c6fU, 0x3dc6a130bd932919U, 0xbd8226483b421fdbU,
  0xbd9305b43c69ac23U, 0xbc7d18b13d9a782dU, 0xbc6a1a7f3dc6fd93U, 0x3db9f3243cdb6266U,
  0x3dce197f3d882d08U, 0xbd2fbaaf3dc87a7aU, 0x3db5a819bd08ca3aU, 0x3dc0fec83db86c4bU,
  0xbc836c273d8704f4U, 0x3c6ec63dbbe1841cU, 0x3d9b9911bd1b693cU, 0xbc9d056f3d81152aU,
  0x3c4404d7babd7780U, 0xbcf4050f3dca5f86U, 0x3cfe22ff3c20c527U, 0xbe0aeb943da008f8U,
  0xbe017c0a3c87b455U, 0xbd8f3e123d2ce1c2U, 0x3cf04ed4bdca09cfU, 0x3d83df0e3c92db1eU,
  0xbdc1241c3d0327d9U, 0xbac6d6fabc6ce179U, 0x3c81746fbcc365a5U, 0x3dc4d595bc6316f1U,
  0x3df108d3bc11bab8U, 0xbdf9ed1abd777988U, 0xbd5114a6ba78f2fcU, 0xbe011c94ba8cdcedU,
  0x3c06642abe00ea46U, 0xbcdba9123e2dcbbdU, 0xbbb9defe3db14eadU, 0x3c20cccc3da6f46dU,
  0xbe0840c7bd6a72dcU, 0x3dd33048bd8146c4U, 0xbd4bc738bd93e16aU, 0xbd8b60b03cc42865U,
  0x3d65e3eb3c00bc21U, 0xbd559cf33c562071U, 0xbda9d8ef3d8af7aeU, 0x3d5350e13bdb3f74U,
  0x3d05f5a3bcf64a0bU, 0x3cf6d2ca3d999c14U, 0x3d8031a23d360768U, 0xbd700ae93cc3b98bU,
  0x3d160e3bbd87dab0U, 0xba6b42cc3bce0cfdU, 0x3c164c2e3cbc4ccfU, 0xbdaf814b3b40ab11U,
  0x3e044cee3cdf8c3bU, 0xbb8027dbbdc0fe05U, 0x3d9d80b2bc19fe1fU, 0xbd7d293f3e0d40e9U,
  0xbcc9e400bdaf4660U, 0xbda24ef13d0028b9U, 0xbd9a4af23d527cd0U, 0xbd40974cbda77a5aU,
  0x3d823de63c43acadU, 0xbd4a84cf3da52563U, 0x3d4f717b3cf5e482U, 0x3c0311dfbdb455ffU,
  0xbc8ea7cbbdc49079U, 0x3cc82aa3bda8bf5bU, 0xbc7580ab3d598bc2U, 0xbd3c36283d5fada4U,
  0xbd4045d53a92014fU, 0xba1f1401bd8118f7U, 0xbd9b44123d96ba70U, 0xbd7c8f963d99fcc5U,
  0xbdad170a3dc43dc1U, 0xbdaa767e3c93d5b1U, 0x3d0bcd003cde3d76U, 0x3d3809773c8017a3U,
  0xbdd43bac3c4446aeU, 0x3ccc6c3bbc99eb69U, 0x3d3e3a5abc1c20f9U, 0x3dd0a406bc9cb79fU,
  0x3db5387f3d04742eU, 0xbd8d13293cfd78daU, 0xbd9b269e3b714fb3U, 0x3c998fe3bd0503e0U,
  0x3da38a94bd4bce8bU, 0x3adee492bc161994U, 0xbd768e143ce05c39U, 0xbcd7572cbdb0e30eU,
  0xbb8e8dab3d656615U, 0x3c3882073db4b45fU, 0xbc3fa6023dae4950U, 0xbd8581873d3d88deU,
  0x3c32223db9785da1U, 0xbd19f854bd8de3bcU, 0xbdd10002bd01094aU, 0xbc4d90f43d92f7a4U,
  0xbd999c04bd94b1e6U, 0xbd84cac93d500bcaU, 0xbca418acbcff5ce5U, 0x3d8d4c67bd011dd5U,
  0xbdd525d8bbd028eaU, 0xbda26addbdd4a5fcU, 0x3dceb62b3d8fcc4aU, 0x3c13cf563d1b4bd5U,
  0xbd901385bdaa31a2U, 0x3d36cc863da5d80fU, 0xbd593f21bd93828cU, 0xbad6e412bc194c24U,
  0x3d7bb7f3bdbac026U, 0x3d6638dfbdd1bbdbU, 0xbdfad4093cc527acU, 0xba1dee21bd8bbf1fU,
  0x3da6715c3d903f43U, 0x3dc0ee1ebc13158aU, 0x3c6dadd43d01dea7U, 0xbdb8ae5a3daf66c8U,
  0x3d1bcefbbd778706U, 0x3dbe59b9bd8f5734U, 0xbd78aaec3dfc1b89U, 0xbe0ddaa6bdcb28a6U,
  0xbc24730dbd90747aU, 0xbe29b761bcdf8f42U, 0x3b3926d3bc544042U, 0xbd1130383dd41b6eU,
  0xbb7e5b44bd344204U, 0x3daa71dcbd6e34e0U, 0xbade95d43b6b836bU, 0xbc39cfb13e05fb29U,
  0xbd73516a3d5b32afU, 0x3cbfb0163cc2534aU, 0xbd89b0e0bdb92833U, 0x3d05c19fbdfe0101U,
  0x3d7ac3ce39a998b4U, 0xbdaca5c13d274120U, 0x3d261544bd486f82U, 0x3d69c083bde2fff6U,
  0xbd8291243cc034c4U, 0xbbc26cf7bdf60934U, 0x3c1be2953ab33690U, 0xbdecdda43cb9c109U,
  0x3da2b1debcf4efb1U, 0xbd60ac383d8a5ab6U, 0x3e2a586d3d79e844U, 0x3c8d3202bd61bce9U,
  0xbd4837843cd9502bU, 0x3d9a253a3d01a3e3U, 0xbe09b2ac3d000a8eU, 0x3d60bad9bd1b071bU,
  0x3d8b32c63deea278U, 0x3dc81ca03d6a46d0U, 0x3cf132563d9d3b24U, 0x3d8b6950bd0c50d2U,
  0x3d150f8a3dc78948U, 0x3c5291e33c3a4557U, 0xbc11d5923d9f5789U, 0x3d886578bdc18c2fU,
  0xbd9b986d3c067defU, 0xbdbc0322bc7c60edU, 0xbd26af38bc845663U, 0xbcd285bfbdd1a3c3U,
  0xbda2f3a4bd0e8ae2U, 0x3cae86e2bcaa36e0U, 0xbd807238bd9841ceU, 0x3ccdde4abd38b280U,
  0x3c9ec7e2bda4abbbU, 0xbd22bff43dc61fe9U, 0xbdafeac03dd4a657U, 0x3c0656fdbd795898U,
  0x3938bd7abdb1a763U, 0xbc13bc8dbd30b9f3U, 0x3d89a9abbd23de6cU, 0x3d5da02c3dcc3592U,
  0xbd0d8260bd347701U, 0xbd5b85403d9bb826U, 0x3d8485193d5ffa26U, 0x3dba01a5bd13a3f8U,
  0xbd376f68bd8e0124U, 0x3d0be733bdcd8bf0U, 0x3d58d59fbd3aa15fU, 0xbd402568bcac2e87U,
  0xbdc30333bda8d6d7U, 0x3d9ff9263dd50882U, 0x3dc7fd2bbc5d5b6dU, 0xbdc4ca083d905641U,
  0xbcd5fb29bd68ad7aU, 0x3c8dccd6bd82b284U, 0xba96c0bc3d5df548U, 0xbd93605bbdbe78c7U,
  0xbd9b3494bd875507U, 0xbca1821d3d82f87dU, 0xbbe0bf29bd583fe7U, 0x3d8fdd843dc0b0fcU,
  0xbd4f5e1c3c580df0U, 0xbd16dad5bda177beU, 0x3d5fa06c3cd1842fU, 0x3d3defb9bd8b520bU,
  0xbdc2cff7bd324f00U, 0x3da700b33d0678c6U, 0xbd0600413d12095cU, 0x3d8f0420bc16aca2U,
  0x3dc2c8fcbd8a91e7U, 0x3d93f9153da03468U, 0x3d783da23cd1f939U, 0x3dab9d0d3d9b5aabU,
  0xbdd465bfbd9a6f1bU, 0x3dbe8b123c94eda6U, 0x3d8c5182bd76caf0U, 0xbd0d1c40bda44573U,
  0xbdac32c2bdcdd091U, 0x3d5952ae3d648909U, 0x3d2a46d5bd9a0b83U, 0xbc1959fc3d579c45U,
  0xbcb9ac783c860781U, 0x3d9b41f33d8ed902U, 0xbd982f54bd778c03U, 0xbd2f79a0bd6f6260U,
  0xbd87cf203d92e192U, 0x3ce22ca8bdc1d229U, 0x3ca123ea3d8320b3U, 0x3d366a37bd872066U,
  0x3d18a22abdab1f07U, 0x3d30d212bdb670e2U, 0xbd2526f6bd4ddafaU, 0x3dafeaf0bdbf23ddU,
  0xbdc14928bcda5d1eU, 0xbdc4b7c6bcf1d93fU, 0xbdbe91b8bd319ab2U, 0x3d5d22c8bd66b77bU,
  0xbd99c3d0bbea2e23U, 0x3d1bee7c3cf9aa61U, 0x3d5454d2bd311cdcU, 0x3d65b9cfbdbdd4eaU,
  0x3d46c082bdd215eaU, 0x3d6196353da340dbU, 0xbd30c0f4bc569d04U, 0x3c8f8b6bbd124e07U,
  0xbc94f0653ccd5547U, 0x3d80cb753db77b07U, 0x3d32fabd3db3b850U, 0xbdb66ddb3d533083U,
  0x3c6dd20dbd67cc34U, 0xbd639a643d89aeb4U, 0xbda8359d3db5f3baU, 0xbd9c0a4fbdb98de9U,
  0x3d21113cbdcf7e83U, 0xbd6c66ecbd211af3U, 0xbd354476bd9186d0U, 0xbc6cd7eebcde7cacU,
  0x3c80b4c2bdc5e01dU, 0x3dce9b833d07df53U, 0xbd90992e3da138cbU, 0x3ce1410abd4f6714U,
  0x3d90565cbd86c31aU, 0x3d178748bdb4232eU, 0x3db0aa94bc73d818U, 0xbd3b0b76bd699ca7U,
  0x3ca81445bdc6b730U, 0x3dc991b63cb9b0cbU, 0x3d527bbbbd7e8bf2U, 0x3d869e5cbd682431U,
  0xbc7e01a0bda032c8U, 0xbb54ca5abc01dbd7U, 0x3d083a993da09b52U, 0x3dd6b874bc54836eU,
  0xbdcdf683bd95753aU, 0x3d9746d0bc852720U, 0xbd326d0f3bddfbcdU, 0xbc23722cbdd49a7aU,
  0x3dcf3c59bd69a943U, 0xbdc737d43da76fc0U, 0xbd85a4dc3d7c8131U, 0x3d7a0ece3cae1f75U,
  0xbd984b86bd164c8dU, 0x3dbfc880bd4fd638U, 0xbcd4b1393dd0a793U, 0xbdcf11ad3d83e5d0U,
  0xbd54c23ebda3c77eU, 0xbd1e3d89bcf78d05U, 0xbd79fb863d85429fU, 0xbc7e7d963d36e9c5U,
  0x3d218ee53d6b0944U, 0xbd37478abdc7feebU, 0x3d1a90443d64fe5bU, 0x3d8937903ca0da44U,
  0x3c166bfa3dba5550U, 0x3cdb87fa3d7fe047U, 0xbc386783bbdd58b5U, 0xbc92a1073cee6f47U,
  0xbcea4d3ebd091417U, 0x3d3444b73dabf9c3U, 0xbd5d6e71bdbf6211U, 0xbc81e0313dc642afU,
  0xbd4009823dafbdc1U, 0xbd79ff3a3d2d0a4eU, 0xbdbb50513da09e74U, 0x3c10f0653d3d2b59U,
  0x3cfdf7efbd770253U, 0x3d9eab97bc9f477cU, 0xbdb8c4ad3dbf144cU, 0x3c5f329f3d5916a2U,
  0x3dc1f4c9bdab6cfdU, 0xbd0f20f73d606645U, 0x3d8011e8bd17bb19U, 0xbd3a890b3d517a51U,
  0x3d2e19b63db65b61U, 0xbbd0dd1ebd08824fU, 0xba3fa48b3aaad575U, 0xbd58dc87bd9625bcU,
  0xbdc5d88bbc960ef4U, 0xbda7256d3d51eca6U, 0x3d37cf4e3dcd9a50U, 0xbd8682a13d2e18f5U,
  0x3d1bcadd3b8f725cU, 0xbd7822c1bdc1d329U, 0x3d0a637bbd0f38d9U, 0xbd115861bd78bb62U,
  0x3dd2ec3fbd7ecebcU, 0xbca4e0573be9b56cU, 0x3c592b67bdc5a37fU, 0x3c9c046a3dcbe275U,
  0xbdc546433dc14d5bU, 0x3d850471bd29d48fU, 0x3d87b4bc3d05830aU, 0xbdaf36dcbb0522ddU,
  0x3cd07f3abd4bb5b9U, 0xbdd55e963dc7e522U, 0xbdb7e8263ce536abU, 0xbcf9a115bcbda047U,
  0x3e1828bcbda5c2d1U, 0xbdbcf33a3d80e293U, 0x3da36433beb3e181U, 0xbd54e6fe3e022c09U,
  0xbdd9db51bdc21fa4U, 0x3d27f70a3d748feeU, 0x3d950a4cbd025739U, 0x3d73d53c3e579fd0U,
  0x3eb35629bd9ba391U, 0x3ca05bfebcee3898U, 0xbdce5fd03d2523c1U, 0xbd6fe674bdda8503U,
  0xbdbbabe23e239f3bU, 0xbe19074abdd092e7U, 0xbafe0aef3d20c0d4U, 0x3c1afc583e0043bdU,
  0x3e877b7dbcc4e952U, 0x3c347ba33d5a2868U, 0x3ec1b7b1be8bbde4U, 0xbb18a3883e01512bU,
  0x3e5dfe23bec31456U, 0x3daa453ebd2b0d06U, 0x3dd852f1bdc47e80U, 0x3eaff0f63cd71e25U,
  0xbde57608bea577baU, 0xbd18b4b93d2be1a7U, 0x3e0ba9c8bd81cc06U, 0x3dab9c7e3d32baecU,
  0x3cdc8fb23e528f80U, 0xbe37f28d3d2d264bU, 0x3c0983873cdfa1d5U, 0x3d871fd03e69d1efU,
  0xbd93d54ebdfc6bedU, 0x3d14fd3e3e5f1a0aU, 0xbc9389d53e8a8eabU, 0x3d9caae33b5bc6cbU,
  0x3d6c6153bdb67ed9U, 0x3e2e0b603dd823c7U, 0x3d631179bdbf0d1aU, 0xbee6ff013e64d673U,
  0x3a8de1e43d38744eU, 0x3e0059af3d8e6093U, 0xbd00764fbebcda76U, 0x3d33ae8ebce3d730U,
  0xbd3c42f9bd1bf93dU, 0x3da7aaecbc192deaU, 0xbd002d16bdc02abaU, 0xbd901b92bd2b4f46U,
  0xbdb48cc83de161adU, 0x3d0e2222bce4e505U, 0x3dc13f793d3e699fU, 0x3e0b06523db9f44cU,
  0x3cc8f22a3d52e17eU, 0x3cf3ead93c43c6e7U, 0x3d3217a13d9238baU, 0xbda93f69bdc2f646U,
  0x3d1bfa24bc293a16U, 0xbd8753c83c8663bcU, 0x3c9e68993d88a13dU, 0x3db963ef3dde5137U,
  0xbdbe2ba33d951993U, 0x3d88a0f6bdbd88f5U, 0xbcb0cf9bbcd766eeU, 0x3e244a193cf77c12U,
  0xbdb4f8b63de48f5cU, 0x3d9a84a2bd47a88cU, 0x3d020caabd2bc81aU, 0x3c08cad6bd969d87U,
  0x3d7e090cbdd61d68U, 0x3d58832dbbb03132U, 0x3b7d71313bf32ec5U, 0xbd68533a3dd00e91U,
  0x3c0776a93dd54d3aU, 0xbc1e4ca0bd8a1bf0U, 0x3da6cc74bd2381abU, 0xbcba97863dbfa72cU,
  0xbe015e4cbd846a01U, 0xbb928c943d6715c2U, 0x3cf7f79e3d91b012U, 0x3dc7ed903df2013aU,
  0xbc3930443d1acd46U, 0x3d171804bda8c688U, 0x3de49e1e3d44d596U, 0xbd7eb6c33c936d38U,
  0x3cf867ef3cec460bU, 0x3db4a0a1bc7237b0U, 0x3da72da73d5b2630U, 0xbdd39e823d64fe07U,
  0xbd47f33dbdad0854U, 0xbba0464cbc4bbcdaU, 0x3d58bb3b3dc6b33bU, 0x3dbee1103d676414U,
  0x3d57cf0a3dd36203U, 0x3c17dee33d886768U, 0x3cf5f9973d19e959U, 0x3dae39663c07790cU,
  0x3d4fb977bd712cb5U, 0x3d56c1a1bd93895bU, 0xbdcfa63ebd929f9bU, 0x3dc0adf5bd90e9caU,
  0xbdad7a1bbc9095c0U, 0x3d96c1913db1632dU, 0xbd2f52f4bdb1fcfeU, 0xbae6476ebd15e608U,
  0x3dd130523d6ebc59U, 0xbb8dbccebc8427d3U, 0xbb327c6c3db8dc16U, 0xbcb87be63bff4bcdU,
  0xbc57a1743dba6a3fU, 0xbd9e70323daea0acU, 0xbd502560bd9250cbU, 0x3d771b883d844793U,
  0xbdc09e753d30030bU, 0x3a6612b6bd46e52aU, 0xbd9c89a1bda58debU, 0xbda83d19bc1ad281U,
  0x3d8975e9bd5a2affU, 0xbd9943363dc6a2e0U, 0xbd6ac478bcf811abU, 0x3d39db563dc16229U,
  0x3dc2d136bd065f87U, 0xbdcb99683dcafb7dU, 0xbdd64fdfbd7d8737U, 0xbd27c59cbc48d67aU,
  0xbd1e6cb43bd8c49eU, 0x3c157390bd9f4f7dU, 0xbdb622c23c6b7a4aU, 0x3c9bf81cbc2bc72aU,
  0xbd40cc233d236376U, 0x3d0c21cdbdc52a69U, 0xbd1fb614bdc01077U, 0x3d9f957a3c67fcc9U,
  0xbdc24a32bd9bc13bU, 0xbd077fc0bdc62a5aU, 0x3d25f1333bae631aU, 0x3e14ca14bdd5a8b1U,
  0xbd90fed53db27fc7U, 0x3b8d9852bd962864U, 0xbc476aa9bca42302U, 0xbd94d7b0bdf9a3a5U,
  0xbcc54d9fbd8449ebU, 0x3d9fc6993d0eda0aU, 0x3d8881ef3dd29cdeU, 0x3dc65c433d939068U,
  0x3dab58653d69d26aU, 0xbd9f9e563dc8af5dU, 0xbd918d49bca1fe17U, 0xbd1f3a353e00c146U,
  0x3d09617ebd8d766fU, 0xbda6d5c4bd9269d4U, 0xbc47ef873d4b4d34U, 0x3d722bfd3d920f29U,
  0xbd57718dbd3951f1U, 0x3ded1be0bdefde6dU, 0xbca5282f3d800aabU, 0x3de4b73fbe5a7f94U,
  0xbd3342943c194552U, 0xbd235a8dbd43bca9U, 0x3e171b52bd10e48fU, 0xbde948bfbe0c5e5cU,
  0x3cf357703d72e7c1U, 0xbd877c1cbc986289U, 0x3e0152853d24d4b3U, 0x3db32730b9b4afa4U,
  0xbd9266c03d82d6bcU, 0x3dd2ac73bd2550ccU, 0x3cfb838b3dead8b2U, 0x3d664b1a3c07f3a8U,
  0x3dd676d8bd3d96f7U, 0xbbe045573b1e22f0U, 0x3d95614fbd6bd706U, 0xbd9db47cbd0370ccU,
  0x3dbb2d5c3c47d00dU, 0xbd8c49c13d655aabU, 0xbdc2fae13ced6b49U, 0xbcf6ff9739d4d462U,
  0x3b97cccbba8393d8U, 0xbd9dc6d1bc6231e2U, 0xbda4b00cbdc19ebcU, 0xbd2c8509bc7383faU,
  0xbd4b475abd219183U, 0x3d0406843d470c20U, 0xbd01ff80bcde2703U, 0xbdb2b225bdd28330U,
  0xbd900d40bd51afb7U, 0xbc682da23daabc76U, 0x3d90b60abdb3dc4aU, 0xbd9d71c2bd6047a4U,
  0x3c9e681dbd7b883bU, 0xbc6bde123d7b0679U, 0x3c9689893d87fed7U, 0x3cfaa6ef3dd5260fU,
  0xbdce8509bcb1a8e3U, 0x3dcf34dd3dabac4bU, 0x3d9f5a02baa25d37U, 0x3d589252bb94e0cdU,
  0x3bc9fbf4bd1bf9adU, 0x3da641cdbd50b233U, 0xbd7740bebc281692U, 0xbd62f6b43dc85f01U,
  0xbdae46babd63cb57U, 0xbd7af6a1bdbc93dbU, 0x3ce6d19e3dc85710U, 0xbda0498c3d4fb986U,
  0x3badfe96bae57260U, 0xbdc0b98f3d076710U, 0xbd8e72ffbcc45869U, 0xbdb07c69bd56892cU,
  0xbd281024bc81c9e0U, 0xbd959e7a3b0103b8U, 0xbdb3f10c3daa9dabU, 0xbcdfb7683ba33fd3U,
  0xbdbbad59bd44d33fU, 0xbdc6e7d3bd10dba7U, 0x3dae3450bdc16e40U, 0x3d7a6af73cb532b7U,
  0xbda7a814bd8ac8e0U, 0x3d8bdbd43c742f1cU, 0x3d1f4c0cbd44c64eU, 0xbd8b7e1a3cefc788U,
  0x3d81ef1abdbb7c42U, 0x3d9cdd763dc547f0U, 0xbc846352bdd70de0U, 0x3d77112a3d3c102bU,
  0x3ca127033d38e373U, 0xbd7cf2063cd44a87U, 0xbabd68ebbd6667c7U, 0x3c719d19bdcb5388U,
  0x3d9b50cdbd9bf406U, 0xbca9ebe4bc297dc8U, 0xbc46dc8a3d9a41b0U, 0xbc18d866bb958d30U,
  0x3c40f131bd324a17U, 0x3d7b63bb3db5e844U, 0x3d07be193da9a54dU, 0x3d8f6b663caf45d4U,
  0x3c9ea504bd5eaf7bU, 0xbdcb3cd83d66917eU, 0x3c257e983d7f46b1U, 0xbccbe4b23dbc504eU,
  0xbd52b40cbca8b126U, 0xbc68a9adbcb589fcU, 0x3ca3f6d53d53b012U, 0xbd4381303db413e6U,
  0xbcdb1c073d665056U, 0x3d53e4c1bd4646b5U, 0x3d2da3173dadf3a2U, 0xbcc86347bdb7773cU,
  0xbd85dc6e3dbf734eU, 0xbd3ba550bb3df17dU, 0x3d887d0abdad5b69U, 0xbdc93aa2bd87581eU,
  0xbd60f87dbbbc73d3U, 0xbd684c35bdaff2bfU, 0x3da5688bbc5365f3U, 0xbd6e135bbda33ba8U,
  0xbc94dd4b3cf12751U, 0x3d89a6213da2375fU, 0xbdacbd953c80794dU, 0xbd4c82903da0ac1bU,
  0xbda46b363d5c7ec7U, 0xbd241edb3cd0a6c5U, 0xbd9138e53dd7154eU, 0x3cf775fbbd83df16U,
  0x3d7a55ef3d007402U, 0x3d271931bd8b7635U, 0xbcaf1458bcc32b08U, 0xbd6d1842bd2fc033U,
  0xbd6f95553dc22117U, 0x3c870e81ba1b591bU, 0xbdbc5572bd5f1d91U, 0xbd045fd5bd8af8b2U,
  0x3d9e2615bc9a8728U, 0xbc1e7fd7bcdf8063U, 0x3cabcfb8bd1eb4b6U, 0x3d884cb3bdcd1a3cU,
  0x3cf36c24bce0c8acU, 0xbc036dc03ca3c6d0U, 0x3ca27f2f3cab99c3U, 0x3b8d069ebb483efbU,
  0x3d8779c83dbaabf3U, 0x3d9cb9213dc69047U, 0xbda17d7ebd04eaa7U, 0x3d7d2fa3bb00c761U,
  0x3d0e3314bdfff837U, 0x3db0c5433c8a9bc8U, 0xbe47436e3d4591a3U, 0xbd90497cbd01147cU,
  0xbe1b3c533ce50811U, 0xbc8f9acb3afbe8ddU, 0xbe29e96e3e22bc33U, 0x3d90f650bd0250a3U,
  0xbd686e1b3c15bb3eU, 0xbe2ca33a3d8dfe86U, 0x3d97fc28bd545aa8U, 0xbd18e0cbbd59b774U,
  0x3d934a8abd6a737dU, 0x3d478b43bda2811dU, 0x3cbb9331bd35aa9bU, 0x3dd89bf93b774b4dU,
  0x3c61403a3c4475d2U, 0x3e1b1a343db5bf9eU, 0xbd5ace57baaeb493U, 0x3d285538bd5c4b94U,
  0x3db2f238be377955U, 0xbd7a42f9bd8043f0U, 0x3da2bcab3dbd5a72U, 0xbcfb27963da13b1eU,
  0x3da4a0f93d8988efU, 0x3ddf8e3ebca3ae57U, 0x3ca3ddc1be14edfeU, 0xbdb16163bdd3036bU,
  0xbc26d0d93e0e7d3eU, 0xbe1e8277ba702ac2U, 0xbc13dffe3d8f38a3U, 0x3d36564cbdbccb51U,
  0xbd882a4f3d52a52aU, 0xbdc80b97bd795e74U, 0xbdce4e14bdad4a02U, 0xbcaebb033d2ad00eU,
  0x3cdf747e3d9ba802U, 0x3d92b446bd463b8fU, 0x3dcce9633db5962aU, 0x3d9a96cb3d92377eU,
  0xbd5eb530bd492098U, 0xbda727e6bcaea3e1U, 0xbd910f82bd4e1154U, 0xbdbd215fbb774dadU,
  0x3dbae43d3d3b8aaaU, 0xbd8b8e81bd93de58U, 0xbc8d2993bd5da27cU, 0xbd7836653ca701c1U,
  0x3dd28c223cafbc13U, 0xbb635974bd06ea27U, 0xbc55e4bd3d8fa58dU, 0xbd94edc63dd63b93U,
  0xbd1c3ff53cd35b36U, 0x3d9494b03dae401dU, 0x3d440812bcdf14ffU, 0xbcb2ce75bda609daU,
  0xbdc8e2c6bd8e0f4fU, 0xbdbeed3ebdb1091eU, 0xbdac2e7c3d65ce6eU, 0x3da7d4393dcf85ddU,
  0x3d9e238abd28894cU, 0x3d39b933bae370bdU, 0x3d3452153da34c0cU, 0xbdd0873bbd4445b1U,
  0xba9482243c124308U, 0x3cf521a53d86b017U, 0xbd15eafdbcad2283U, 0x3d2223c8bd83af4aU,
  0xbc4daa293d16b6aaU, 0x3d0e02fbbd9cf749U, 0x3d14b48fbd423ec4U, 0x3da09fda3dd78412U,
  0x3d032444bcc8736dU, 0x3da148dbbbb8cbbaU, 0x3c3930ddbcbe6a79U, 0xbdb587c53d8a259aU,
  0x3c0b4ac7bd06aad4U, 0xbdbf69033dd5fc2eU, 0x3db8a8943cdd8a28U, 0x3b282cd9bcafaa11U,
  0x3cf5f92e3d334b37U, 0xbdb90cb13dcc46dfU, 0x3d996e5b3d2f6260U, 0x3d8e4a08bda36bd0U,
  0xbd3c5b10bd27ff26U, 0x3cb881663a692e37U, 0xbdd54a663dc2775fU, 0xbcc89cd43dbf26b3U,
  0xbdba62eebd2aea4cU, 0xbcccf6fd3dd2be7fU, 0x3be9ae023d8e7f1dU, 0xbda4aa173d6c110dU,
  0xbd70cf0cbdb60689U, 0xbd7c9e773b4b9dfaU, 0xbdc711323d4b70f0U, 0xbcab1785bd1177beU,
  0x3c54e9593dc8b43aU, 0xbc0c0a8c3d3d50fbU, 0x3ccab005bd029f61U, 0xbc652487bce41a99U,
  0x3d5dff6fbcfcaa90U, 0xbd9942433d3ce962U, 0x3d979f91bdcf78e5U, 0xbdac2865bdb3c2b8U,
  0xbcbf291cbc7f6010U, 0x3d50b0283d651769U, 0xbd483a3b3cf0d26fU, 0xbd18ddaebcfa5ca1U,
  0x3d8fa3d03d2c07f5U, 0x3dd6119abd012e9cU, 0x3d1eab463d339cebU, 0xbc11afbbbc646683U,
  0xbdbf6b5fbba40882U, 0x3c9af649bdbb4d4fU, 0xbc346045bd4e5ef1U, 0xbda09eacbda363c2U,
  0xbd935e833dd1c70eU, 0xbd3d833e3dbf942fU, 0x3daae89a3dcd4050U, 0x3dcc5f36bccd0c92U,
  0x3ca6bbf2bd8473f4U, 0xbd08df2dbdb8ca6aU, 0x3db52eecbd8386d2U, 0x3db70d003abd12b3U,
  0xbdbe321abd44e8bbU, 0x3dab57f33d954ca5U, 0xbc8f4db03c3f82b7U, 0x3dc87550bdc3ad94U,
  0x3d9973febd83c55bU, 0x3c0f995ebd238c4cU, 0x3d40791fbdbb665cU, 0xba9a2d33bd9ec39fU,
  0x3b153dca3da5650bU, 0xbd1f66373d402b6fU, 0xbd0839c53d269acaU, 0x3dafc4853db6be58U,
  0x3dd55fcbbd518933U, 0x3cce0fc33d9e2bffU, 0xbd05c3633d6a4bc3U, 0xbdb84a61bcf1bdbcU,
  0xbd00ff633d145768U, 0x3b398c13bc93e94eU, 0x3d6a0fd43b6bce4dU, 0xbd24c842bd921baaU,
  0x3d6bccd13dbd06e8U, 0xbdcc727a3d9c7d1aU, 0x3d070918bdc031b3U, 0x3dadf1afbd0ad554U,
  0xbcbb07bebd45994cU, 0x3d8ed792bd9077ecU, 0xbdcfa3ddbd828fd6U, 0x3cb93d703ce3333bU,
  0xbd5c91423bfe4d9bU, 0xbd918ebabd3b6d20U, 0x3caa0efd3c10673cU, 0xbd04871b3c9bb3e3U,
  0xbd07f9633cccf6b6U, 0x3d8748643c2bca95U, 0xbd9436a4bb70e4edU, 0xbd90fe203d8cb1eeU,
  0x3ceba3e5bdc6b555U, 0xbdb5213abdc671cfU, 0x3dc3d7103b01db51U, 0xbd8a475dbd7957efU,
  0xbdc99a69bdc3d42cU, 0xbdbc7a3abd4271a8U, 0xbcb6d2af3d299b8bU, 0xbc83585d3d4dc486U,
  0xbd80f9b4bd547709U, 0xbdbb95e0bd11e3a2U, 0xbd6637f7bd2f8433U, 0xbcd8cbe7bc4d44e2U,
  0x3d9a4c423dbb6f65U, 0x3d9c6b5c3c52a9adU, 0xbca3c2fa3d3abcd7U, 0x3d99e109bd237d1aU,
  0x3d9724e4bd0dc531U, 0xbd65889dbc823c41U, 0xbd232939bdb37525U, 0xbd113321bd9bf040U,
  0xbda3d197bdce5576U, 0xbd6503883d99b470U, 0x3d79e6cf3bcabe50U, 0xbdac1a46bd179228U,
  0x3d3824223d8a1187U, 0xbd1b7cbbbd547fc8U, 0xbd7568febc60b241U, 0x3dc7bed53c917798U,
  0x3d52f8a53d25f5bbU, 0x3db8f3db3dd776ecU, 0xbca823e83d126c28U, 0x3cf2ff2a3da4b830U,
  0xbd9e6aa5bddae47fU, 0x3d3c19d93db84f85U, 0xbd0cc1523d2caae1U, 0xbc65ac413d1d2506U,
  0xbd9f80233c933e16U, 0xbc2bc8673dc78d99U, 0x3dad646a3dbd3c94U, 0x3d8e9341bdcd06e8U,
  0xbdb950adbcd7a12bU, 0xbdabaa8bbdd034f9U, 0x3db8b77ebd88c09fU, 0x3d23a2b33d68beb4U,
  0xbda4b0b1bd8bcd5fU, 0x3dcc1b41bce10907U, 0x3cd7a0ab3d9d3428U, 0xbd24915e3d9322e1U,
  0x3d5787043d2401bdU, 0xbd163ec63d326a78U, 0xbda080a1bdbabcbcU, 0x3cff3d67bd4a4f97U,
  0xbce57a23bd144856U, 0x3dd9f214bd8878f4U, 0xbd7d104e3cdd70ddU, 0xbc0b0e063daddb12U,
  0xbd7bd85dbd67572fU, 0x3c181695bcaa1fd6U, 0xbb1bc0febd12b4f0U, 0x399e543fbcb07d63U,
  0xbd960002bc9431d9U, 0xbd56e95b3db43554U, 0xbda6dca13d6e6944U, 0x3d692b72bd285801U,
  0x3dad398abd95f63bU, 0xbd2d1f9dbd084c61U, 0x3d9ae1573d445b2aU, 0xbcd2eb223db7f8e3U,
  0xbd4ed703bd000168U, 0xbdba3d823e0118a6U, 0x3cf653a4bd7f0622U, 0xbc8061fe3db6a71aU,
  0x3c8cc5d73bf69c99U, 0x3d7182d33b59f909U, 0x3d3384533d0bc6adU, 0x3de27a0f3d7ab39fU,
  0xbd4a62a6bdb47753U, 0x3d95772abd9d6051U, 0xbcb258d4bd9c2fd5U, 0x3c9377c0bd284c45U,
  0xbd289be63db3cfe4U, 0xbd860601bdb16b71U, 0x3de1b43c3aef1f6dU, 0x3d87f4b8bc832ca5U,
  0xbd5222dabdc55f7fU, 0xbda34b18bdd2ee40U, 0x3d96f26d3d1fac4dU, 0x3cca16e53de18abcU,
  0xbdbc3008bdcb3f02U, 0xbdd21507bd36a5c1U, 0x3dc4cff73d88e450U, 0xbce92e26bde963d0U,
  0xbd42ea1abdcf3e70U, 0xbd7c7e233d60e4beU, 0xbd87561abdb6d439U, 0x3d188b76bcb4c384U,
  0xbccb9a70bc6e24a3U, 0xbd6b3322bdb44ea3U, 0xbda346d9be01549fU, 0x3d6167173dd1396eU,
  0x3d12d2b23d86da2cU, 0x3cb804433d0290f9U, 0xbd97d1dd3dbd9838U, 0x3be810ee3d3fe70cU,
  0xbd4b83e2bdac40ebU, 0xb9fa85bc3c0a9652U, 0x3ae7b4943daeabb5U, 0xbd4b9d163d0a920bU,
  0xbd14439dbd115037U, 0xbdcf0d6bbd0beff6U, 0xbd72e4803dc35ad4U, 0xbd735b2d3c773cedU,
  0x3e1d73de3daa1334U, 0x3d0e21cebd15a6ebU, 0x3e2b8d75bd59704eU, 0x3d8ac9453e01547cU,
  0x3e09c4e6bbc4af31U, 0x3d840979bbef412dU, 0xbcb573adbd0628afU, 0x3df29128bcbe2c06U,
  0x3b4ba6783ca17d30U, 0xbd91a813bdb793f4U, 0x3de3ec7dbd6c8216U, 0x3de795593cb3715cU,
  0x3d59d1c03d0f7eb1U, 0xbe09e0823bd24750U, 0x3d5058663cad842fU, 0xbb298ce83c031978U,
  0xbd86db4d3c85a2f2U, 0x3c1df219bd669416U, 0x3bcc9363bd836550U, 0x3de7e772bcdaa2d7U,
  0x3c96f678bd74607fU, 0x3d77a094bd4e5db3U, 0xbc84de71bcd1dabdU, 0xbd8b44273d8013cdU,
  0x3d912e01bd5b3bb7U, 0x3d978f523ce59f6fU, 0x3c3a2f86be14a295U, 0x3d74e03fbd32a5eeU,
  0x3db81d68bdc5bd7bU, 0x3c2f7f26bc1867caU, 0x3a131b893d8a4333U, 0xbd11869abd881d33U,
  0x3d6cf8d93d7869beU, 0xbda10bca3d3df479U, 0x3d8a3c21ba7aa4b1U, 0xbb425ee2bd992f7dU,
  0x3d87302239937f75U, 0x3b534cd9bba3ca88U, 0x3db8c383bb6ee227U, 0xbd138687bd0b489aU,
  0x3d8588083b49fa0eU, 0xbda0af083cfcea82U, 0x3d1f70963d333711U, 0xbdc73ccbbd5da093U,
  0xbd35fb8a3d08309dU, 0xbca366ab3dd29156U, 0xbdb42aec3c163be1U, 0xbd8a529dbd366434U,
  0xbdb025a1bd84d479U, 0xbd97f6813d349c8fU, 0xbd652a573dd88f16U, 0x3d73ad09bd204706U,
  0xbd38be9fbc7a06c5U, 0xbd0359aa3ba5650bU, 0x3daa98153c5c3be0U, 0x3d8c5935bdb649e9U,
  0x3dc75af03dc16b48U, 0xbdb1ab7bbd360b95U, 0xbd911522bd8ce77fU, 0xbd16a6e1bd021488U,
  0x3d85adfb3c1ac0b2U, 0x3d01d6ff3dc1cfcfU, 0x3dc03cacbd759d61U, 0xbda13d6abdce4745U,
  0xbde6a35d3bc30e39U, 0x3d3d74523d5dcb88U, 0xbd7aa321bd7ff2acU, 0x3cd54d303d97d1cdU,
  0x3e14a7afbc7d03cbU, 0xbdbaa799be0117ffU, 0xbbd196163daf6842U, 0x3c25d1143dab5100U,
  0xbdc48d24bd30512dU, 0xbda28be03dd5a20dU, 0x3d9b87463c19baebU, 0x3d42e2803dbb32c5U,
  0xbc8b3e9bbe2ba3f8U, 0xbcebc8a9bba32b3bU, 0x3d98d4203b2e1a5eU, 0xbd2df3873d70c545U,
  0x3ca218a5bd97f37fU, 0xbd72b5a7bce0d6e7U, 0x3e35f6a7bda7c16aU, 0x3d89cf393d595c28U,
  0x3c9b23623d85f1e5U, 0xbdb1c7c53cc485cdU, 0xbdc30b233d9d41f3U, 0xbbb857e43bb2b5f4U,
  0x3d68fabdbd013eebU, 0x3cb7f0113d860241U, 0x3e5c1e9ebbce0855U, 0x3d5a7a9ebd79cc84U,
  0x3e720800bdafd613U, 0xbdbe18b4bcdff7e2U, 0x3d902da1be07eb24U, 0xbd385806bce49784U,
  0xbdb22ffebd6f369cU, 0xbc3acb06bd71258aU, 0xbdc8e20bbc51c79dU, 0xbd92bd83bda1e88bU,
  0xbd0a06393ce879a6U, 0x3dd3da4d3d45435bU, 0xbdaef3203dd56f8dU, 0xbd9e3a24bd73bf82U,
  0x3daa6111bbfabe0cU, 0x3dacb2013d9cd056U, 0x3d5194d53ca4a056U, 0x3dadb6bf3dda292bU,
  0x3d585bfc3dad2388U, 0xbd5322f7bd77bf56U, 0xbc814f77be3e3439U, 0x3e11e5efbd6177bfU,
  0xbd91702cbd1ad75eU, 0xbe2f59ad3d300337U, 0x3d474517bd6db912U, 0xbbe6345cbd8d7897U,
  0xbcff5518bdd1976eU, 0x3bf4d724bd7170c7U, 0xbd018fa83c706d21U, 0x3d570ebcbc87ae41U,
  0x3cb7f5703d9c734cU, 0xbcf3afb53ba74dfcU, 0xbce88a5ab934e605U, 0xbb2ee8923c97eee1U,
  0x3d6e34b3bdb17c33U, 0x3dc1e6ed3d68e3d4U, 0x3e02314abd3866ddU, 0x3d2c5a723cd2a327U,
  0x3d9c46a63d754477U, 0x3c7809153d0d914bU, 0x3d9dc39cbd692027U, 0xbd0f5a0e3d2e74c4U,
  0xbdd01880bd8a434cU, 0xbd0af1ab3d90ef3fU, 0x3d361becbd46313eU, 0x3df1924cbcca6bb6U,
  0x3e619f4b3c6bd316U, 0x3e9ba1d83d8186b2U, 0x3d95b0e73da5c4deU, 0x3e10eb4dbdedcf92U,
  0xbd4e12a93d16383dU, 0x3c9066623e21e90dU, 0x3df783543c759dd9U, 0xbd54ac84bdf651adU,
  0x3debf12bbdbabd41U, 0x3e26d4ce3d76cbb8U, 0xbd459ce53dc01d9cU, 0x3cb273e33d3e050cU,
  0xbdb261ccbdc9e7faU, 0xbd98ced3bd30c2b3U, 0x3c77ceb23daf7945U, 0x3dd92621bd276c29U,
  0xbb8e23a73d821362U, 0x3dadff1e3e2da84cU, 0x3e1ffeeebdd3c50aU, 0x3e246378be187a55U,
  0x3e0c710fbb88a6faU, 0xbbbc530dbd1338e7U, 0xbe0204143d212f57U, 0x3dd126283d1b2125U,
  0xbc66bcccbcc57d37U, 0x3c20f077be21267fU, 0x3e4496d23d9ace93U, 0xbd3e79593d9be9e1U,
  0x3ba2e26dbd9e00eeU, 0xbdb830a0bda8c34fU, 0x3d74191b3cc321adU, 0x3d8677e33c86f986U,
  0xbd9fdd75bd357f22U, 0xbdc68b943d1a628bU, 0xbca5293f3d9208b4U, 0xbdb007e73d86452eU,
  0x3cb33a82bd0b88f6U, 0xbc2e4ce33da9efbcU, 0x3d6a78d13cf23372U, 0x3d8700e0bd97e240U,
  0xbd9c1732bd09a275U, 0xbcf94c92bc980d76U, 0x3cf0e994bcc4c167U, 0xbdbb4dfcbd0cd7d6U,
  0x3ddf2f10bb65ebd4U, 0x3afc5bb43cbb0ce9U, 0xbd1b57063d35cbc8U, 0x3d4755a7bc9acf8cU,
  0xbc6d61a9bd89978fU, 0xbdcc3ca1bcb2e78fU, 0xbdb042613d53d26cU, 0xbd2e5c8dbd17d0ceU,
  0x3db95c743d3a5e9fU, 0x3c2e9e4b3db732b7U, 0x3dcd120e3d7fa94cU, 0x3ddd332dbd30e80bU,
  0x3d3d2688bd910223U, 0x3d05930bbd1ca6a4U, 0xbce68574bcf1af24U, 0xbcb93d153dd58de3U,
  0x3d95f9fe3d8d4f68U, 0xbc5faff7bc6b6defU, 0xbd1711a53d838aabU, 0xbd4f0dc73d0228d4U,
  0x3db59f30bcbfe442U, 0xb724e7a0bd005196U, 0x3c87e45ebc778392U, 0x3c9b78123d77a05aU,
  0xbdc0e63c3d6fa6fcU, 0xbdbce649bc21a6c1U, 0xbdbe64e13d3a78acU, 0xbda7c3e9bbbf0a5bU,
  0xbd8001febcb12f99U, 0x3ce52df6bd758b9fU, 0xbd9fcc66bd116d55U, 0x3deee670bcb173b3U,
  0x3cbd96bebd63f873U, 0x3dd820b3bd814361U, 0xbd8f92b8bd8df7f0U, 0xbdae6a773dc04dedU,
  0xbd4f2ec33c99fc28U, 0x3d5d81033c0dbc5dU, 0xbbf01b4abd612afdU, 0x3ca483eebc8c5a69U,
  0x3db8b11e3da251adU, 0xbd67083abcd87a2dU, 0x3a0a658f3d8bfea7U, 0x3dbf1635bd99e93fU,
  0x3d4c74503d3957aaU, 0xbe1bed563cbf67ecU, 0x3d1b07ccbdb5738bU, 0xbe21b9b33dff6c8aU,
  0x3d8f11e4bca5407bU, 0xbd6e4fde3e1551afU, 0xbcd765e43d415e50U, 0xbc29069fbd4fb999U,
  0xbb36b5eebdd288f6U, 0x3d3fbbf53d1b32a7U, 0xbd1e84af3d0d8594U, 0xbd7edfa5bbb5f28cU,
  0x3c9c39bbbd8bbc9dU, 0x3c54eb2fbcd714b8U, 0x3cb7b55a3b93e1ffU, 0x3dab98b03dbabd2aU,
  0xbd3f720cbdc74912U, 0x3c25276a3d0affd8U, 0xbdbb87e7bc87c526U, 0x3d934aeebdc7fc85U,
  0x3d6ca5f6bcf6d70fU, 0x3d91b9d43d85aa39U, 0x3c3415483b35efb5U, 0x3d4d007a3dd122e8U,
  0x3e0c22963db8b10cU, 0xbc6eb443bdf1fa0bU, 0x3dc376e6bd919519U, 0x3d99efe2bc0e6313U,
  0xbe2ea3353def5e18U, 0x3d04f60cbd85881dU, 0xbdaf8ebc3dec90b0U, 0xbd367bf1bd0c76d9U,
  0x3db4735ebcb7d12cU, 0xbcff33a03cb21071U, 0x3ca71a5fbd797083U, 0xbd8cec7abd9fe0eeU,
  0x3d4b0c79bb95494fU, 0x3da721dc3d1dc72aU, 0xbdac32efbd05877bU, 0x3cbc34f43d9c3255U,
  0xbc05f8653d8b41d7U, 0xbdd4a5c73db6d366U, 0x3cc8f95ebd5f523bU, 0x3b6cd170bd8c21e7U,
  0x3d994bd63d13841eU, 0xbc3a5812bd0eb5fcU, 0xbd0bec58bd54d4a7U, 0x3d752ce4bd9d50e5U,
  0x3dbbe999bd57f28eU, 0x3bb5bdec3d744f0cU, 0xbd41b2c6bdd168f5U, 0x3dcd1dfe3d66a114U,
  0xbdc01aa03c7f4da7U, 0x3d0269033db34004U, 0xbd63dc8ebda2a7d2U, 0x3cb64023bddf715bU,
  0xbc9d7bf03d7c3137U, 0xbb8c5771bdb6fc0dU, 0x3d39258e3d8839beU, 0xbdb241303d9379afU,
  0xbd5456553cf20722U, 0x3d1ea17f3d8d8a56U, 0x3dcd3885bca21a81U, 0xbbaae5b2bd086c1bU,
  0x3d2614b1bdd78b8dU, 0x3dc6aa373d89937aU, 0xbb927a243b00638bU, 0x3d92b6ea3d576b9bU,
  0x3d6d5e903d3a0b89U, 0xbc4b95dfbdbc4aceU, 0xbd7a01693cb514e6U, 0x3d97045bbdd69d28U,
  0xbcca1bfb3d2cb8b1U, 0xbdb8534ebd599a88U, 0x3d7a41babd35e7f0U, 0x3d05225e3c86f090U,
  0xbd80d74d3bcd2f83U, 0x3d1f36953d66c07eU, 0xbd27841fbd954d17U, 0x3c81bec5bd5b3f02U,
  0x3da66fc93db6388eU, 0x3d80fae23d8cdd4aU, 0x3dce1c9a3d31be5bU, 0x3ca5c3273dc9121eU,
  0xbda142353d0d30e3U, 0xbdca83e53d1bea2eU, 0xbdb5d11f3dca24b7U, 0xbda50bbbbd699bb5U,
  0x3dc499b9bc8141d9U, 0xbd5aabfbbd4b8784U, 0x3daf2f4c3d903feeU, 0xbdd68184bd35caf1U,
  0xbdc80fa7bd545fbcU, 0x3c7a458dbb3e9875U, 0xbd58d6203d75964fU, 0xbcf95a9e3d958f81U,
  0xbd9d61a23dc66da7U, 0x3d2b0216bdcd8193U, 0xbbbcd9ee3d054725U, 0xbd8f66d53cf89f2fU,
  0xbd40929a3c45d4d1U, 0xbc168059bdb819b1U, 0xbcd47e8fbb169559U, 0xbd06f16b3d98dd5bU,
  0x3db886883b819362U, 0xbd0a633f3d840e73U, 0xbd13aaba3d35d0c5U, 0xbda20abd3d9b953cU,
  0x3cf0a93cbd7bf4bcU, 0xbd03a6d63dba5a06U, 0x3d952bf03cfd6f01U, 0x3db2c6a7bdbcdf54U,
  0xbd2698e6bcd0f4c9U, 0x3da22bad3c99f1d7U, 0x3cc4bb683db26c73U, 0xbdca09e63d637059U,
  0xbd28001bbcbf235fU, 0x3cc0e4413de83c9cU, 0xbd1ac9ae3dea5f0eU, 0xbd883e263daae768U,
  0xbdc4fc41bd6ee4c6U, 0xbcbc321ebd48f898U, 0xbd2ec477bb746694U, 0x3dd312053d3ab3e2U,
  0x3c682d4c3da06b5eU, 0x3d5127c6bc95e3b9U, 0xbdef042ebd2f4b78U, 0xbd533d133ccaafb2U,
  0xbdae20343d46bb17U, 0xbd6b56bbbdbc7c67U, 0x3d0e498a3db060f8U, 0x3d6939a9bd215d56U,
  0xbd058c85bdc1cf79U, 0x3d582e8f3b92ac51U, 0x3d4e46173b4419dcU, 0xbd97b25abbaa0a7dU,
  0xbddb9c023da88259U, 0xbd321de13d17a51bU, 0xbddfb1d3bd6b91f0U, 0x3cbf6c6cbdb9e12fU,
  0xbd8f34b1bd93b50cU, 0x3d34cae5bc07e437U, 0xbd0cf1743d49a454U, 0xbd2cb8393dc9a963U,
  0x3d578dd43dd074d3U, 0x3db0a9c13d033344U, 0x3c99fa943da21163U, 0x3d5393113daf994dU,
  0xbdb06e82bdcb131aU, 0x3d98fffcbdb4b534U, 0xbca8016a3cc2cde5U, 0x3d8c99e83d6b9f2bU,
  0x3cd4da9bbdcf06b6U, 0x3d9024583d0423cfU, 0xbd1f5543bdea5c34U, 0xbc7598c0bd95f420U,
  0xbdb1aad2bb09894aU, 0x3a72d2cebd2cff7fU, 0x3da8669c3af6b773U, 0x3b552981bc8d18e5U,
  0x3d1c62a9bdf8ebd1U, 0x3db7b2fabdd14b35U, 0x3d898956bbbf6d2aU, 0x3d57e914bd8b82e3U,
  0x3d53ae033d72bc1cU, 0xbd7234ec3d9d3323U, 0x3d9eea1f3cf8e596U, 0xbdc1a5c4bd5338a4U,
  0xbdb72370bdc76ff4U, 0x3c7526db3dd1521aU, 0x3da2e38fbd8398edU, 0x3badaf2dbdb95655U,
  0x3bdf2406bc4c798eU, 0x3bdd0c7ebd86c76bU, 0xbca201763d782851U, 0xbb5feb4d3d60e877U,
  0x3af5ccd73cc9bcb7U, 0xbd95ba083d910fb3U, 0xbca50254bd6b149dU, 0x3dcd96bf3d69d185U,
  0x3c04784e3d65db49U, 0x3db61babbd9d2fe8U, 0xbdd4f9673bf8da2cU, 0xbcc4cfb73c63407dU,
  0xbbef5ad0bd931185U, 0x3c9b90e6bda00a2dU, 0xbd89e69c3c87887fU, 0x3d1e29d9bda4978fU,
  0xbc91a0fcbcccb350U, 0xbc87679fbd69123cU, 0xbd9b6eabbd3b6cc6U, 0xbda4e1c4bd59325eU,
  0xbcf695ea3c899625U, 0xbd12dade3c7f91d0U, 0x3dcb0fb5bd84c8e7U, 0x3b6350843d21af5eU,
  0x3d3136f4bc574a5bU, 0x3d1d13a2bd330df3U, 0xbd918440bd953bdaU, 0x3d76a57dbca9764aU,
  0x3ced0d17bd412d1dU, 0x3dc9509dbd2a31d1U, 0xbdb12a3fbd8b2041U, 0x3d88262c3d9bd4ceU,
  0x3c8ad13dbda9abf3U, 0xbd926cd63d28f1c1U, 0xbd71d4e83c78ff97U, 0xbca9d2643c6661beU,
  0xbd18cac93d50eba4U, 0x3db2c0e53cbf1531U, 0xbd30425dbdcd81c2U, 0x3d1fb12ebd98a180U,
  0x3dc6d686bcc25665U, 0x3cb5c9d6bd705d57U, 0xbdc5a711bdc5aa11U, 0x3d967c7b3d85a4c0U,
  0x3ccab4d1bd4a0d48U, 0xbd37232c3d69742bU, 0xbdc35f033d8b7eebU, 0xbbded5573da0b015U,
  0x3d5aee73bd9575e0U, 0xbd9370a63d9ea0eaU, 0x3d4e75a13d7965b8U, 0xbda59dfabce9edf2U,
  0xbd871b7d3d891f8aU, 0x3c9d18273d1d5348U, 0xbd0b3a0a3cffd4d0U, 0xbdbe4cbdbc8fc056U,
  0x3dd49c2ebcab6cadU, 0xbc1fec273c9a2428U, 0x3d6412e3bcbca70fU, 0x3cfe34ba3d85f131U,
  0xbd9d710e3d8f363fU, 0xbd99f049bc525fedU, 0xbc5a23f4bd9c8b84U, 0x3d255e553dca8b06U,
  0x3d8ae21bbdc1f0a7U, 0xbda2af2d3da0b86fU, 0x3cbfbdf4bdb467a3U, 0xbb9eae633d90f3f3U,
  0xbcf60f103b9241a9U, 0x3daef873bd4636dbU, 0x3d078a38ba4e7246U, 0x3dc5b5113cae37d9U,
  0xba6e442ebca106c2U, 0xbc6e2041bd05644eU, 0x3d9873023dc0d641U, 0xbda16abf3d9dfcfcU,
  0x3d12acb5bd7d66daU, 0xbab76680bd5bdc75U, 0xbd694b6abd70928fU, 0xbd0f1e58bd6afc0fU,
  0xbd939034bdb81406U, 0x3c93915c3dc272f9U, 0xbafd7d4bbcdb31fdU, 0xbd9325eabda5790aU,
  0x3dc30ebbbd005428U, 0x3d20a5d53d4b3beaU, 0x3d22b4b63c961366U, 0x3da28c223dbd556eU,
  0xbd2cfc383d65e88fU, 0xbe0af1a53d69b660U, 0xbd8869963d1d2678U, 0x3d834c293c82e1adU,
  0x3d289d3ebd7d6f3aU, 0x3ccf29f1bc57b1b5U, 0xbd0e9a643c9eb02cU, 0xbc66302dbd467ca5U,
  0xbd4a5e04bd5d1c97U, 0xbd388ac9bccaffbaU, 0xbdadaa7bbd50baa8U, 0x3d4af19f3d9f0917U,
  0x3c400b0e3da551e3U, 0xbe36f7343e00182aU, 0xbdb53751bda34009U, 0x3b3cc974bd720aebU,
  0xbd338d4abd066b3aU, 0x3d8013e83d9481afU, 0x3d0a6802bcab92e8U, 0x3df212263d992acfU,
  0x3d6c4fb6bca291b0U, 0xbd8075323d924ab2U, 0xbc925f463d2154acU, 0xbd9eb7afbd57f75bU,
  0xbdc4f6eabd91d2ddU, 0xbdab7bec3ddef6f3U, 0x3d8904d13d99de63U, 0x3db2bd19bd27c210U,
  0x3dcaa6253d85250eU, 0xbc4e766cbdf6f35fU, 0xbb1f8ce9bd195ea9U, 0x3d0decef3d64af94U,
  0x3d1e099f3cbe2861U, 0x3c8043c2bd0fc0a0U, 0x3e10a96538e3dec8U, 0xbcfda0a03d893de0U,
  0xbd42e3423dd75285U, 0x3c82051f3d2e85eeU, 0x3bad15d8bc5a50c9U, 0xbd33ba733d6d275eU,
  0xbda11ab0bc203aefU, 0xbd33ceec3cde69b1U, 0x3d8e2f2f3d9c893fU, 0x3dcc0a19bc3f17d8U,
  0xbd6c598d3da7ea78U, 0x3d9f5aa5bdabe959U, 0xbd807a1abd6d251fU, 0x3d7c1b323d8ee618U,
  0xbde614a03da67973U, 0x3c86c95c3d83c159U, 0x3bb9e50eb978a8b9U, 0x3d4be663bd8c0e16U,
  0xbd15fca73da776c3U, 0xbd12806dbda0f64eU, 0xbdb93c62bc8a98edU, 0xbd750a123c257645U,
  0xbbbbb47a3c82a5b7U, 0xbcdf258f3d104d67U, 0x3d8a1f583c175e88U, 0x3cc396f73d9ee94cU,
  0x3c5a651a3cf11f3dU, 0xbc9cf53ebd367a80U, 0xbdca7eda3dc02a8fU, 0x3d484b94bdb1f0d3U,
  0x3dbfb132bd4abe10U, 0x3d9652ed3d7faf3cU, 0x3d993990bdc971bbU, 0x3c8aae203d4579fdU,
  0x3d52b401bd6e0e44U, 0xbd24591e3d386d9eU, 0xbdba36113bdc9a5aU, 0xbd4a273c3d7bcc2fU,
  0x3d17f7d6bd40b479U, 0x3db04869bc984e84U, 0x3dba37a9bdebede1U, 0xbd774596bd8d837aU,
  0x3d7810803cbf016eU, 0x3d83cd36bdbe4363U, 0xbc8ae8b1bb67c1daU, 0x3db71431bd0a69daU,
  0xbd8a56a23c05c35fU, 0x3d0ed4be3ce04219U, 0xbc5907b43cf64a43U, 0xbdc9c7893dba146bU,
  0x3db6b35fbd8346e4U, 0x3c872be73d012924U, 0x3d19b3d6bd332a11U, 0xbd4dd6c1bd59ec6cU,
  0xbd8aea52bd9adf18U, 0x3ccf2e9dbd14f113U, 0x3d408a68bcbc55c9U, 0x3dc5f9dfbda47935U,
  0x3dbdee823d01e70eU, 0x3d6e17ae3dadb5ebU, 0xbd5cd9363c6f32efU, 0xbdab9740bd06d472U,
  0x3d070388bc9a01bcU, 0xbc06f972bdab6aecU, 0xbd3b6ba13d4ed6f3U, 0xbd94f8023d5e7355U,
  0xbdd435bbbdbd6820U, 0x3d812cbe3cbbd7e3U, 0xbd8fe53fbbd1b9f0U, 0x3d2965093cbe4d97U,
  0x3c7bf7753dcf92ffU, 0x3dab321a3dd0fe3eU, 0x3d8a3f6ebda4ff7cU, 0xbd964db3bd43bed9U,
  0x3d81ff4f3d9dd5a6U, 0xbd9b369a3d99d8d1U, 0xbdbbf46b3da64864U, 0x3b88f2fdbd304858U,
  0xbdd2355bbd6b1e72U, 0xbd87e2a0bd45593cU, 0xbd70e5ca3d8f5627U, 0xbce6f1953dbb3397U,
  0xbd796d6abd7c2bc6U, 0x3cf21e3d3dd57b36U, 0x3dbd925d3dc5b436U, 0x3add5ee13d487e81U,
  0x3cd828d43dbf33a0U, 0x3d966f38bdc44053U, 0xbd9dc075bd3620e3U, 0xbcef935f3d46140eU,
  0xbd9f038c3dc7584aU, 0xbd83e23e3da6812bU, 0x3dc0c3d8bb33d3d6U, 0xbdc73d33bd5d9727U,
  0xbdb2e06dbd83a220U, 0xbcff57eb3dc3609aU, 0x3a5cfdc0bdb6921aU, 0xbd9af7ac3d25319aU,
  0x3d81c808bd82bb10U, 0xbdd413273e0cdae5U, 0x3d0da0553bdacf37U, 0xbd73699c3bc161dbU,
  0x3d93f89f3d6bddc7U, 0xbabbf9683bb4225dU, 0x3e09c757bc8789acU, 0xbadf2d35bcee3e6fU,
  0xbd501677bc31c021U, 0xbc8abbd73d73bba6U, 0x3dba6dfb3cbc31bdU, 0xbdfe5041bd6255ffU,
  0x3d6a026a3cdec8d5U, 0x3dc83ff8bcdaaba2U, 0x3e03d2163d99f5c2U, 0x3d616813bd9d7e46U,
  0x3e4d72a3bdcfcd88U, 0x3d91d39fbba14b0dU, 0x3e00b3c3be402884U, 0xbdcb17a43d75298dU,
  0x3ce2317e3d1e9e0dU, 0x3dbeea17bb12af16U, 0xbd94b074bd8ac10dU, 0x3bd5a24c3d2f5187U,
  0xba073bdfbd966a93U, 0x3d59863ebd973b27U, 0x3d0fd8b5bc6d0963U, 0xbd2332e0bd316fd2U,
  0x3a6bfc5dbd470d0bU, 0x3d8eb78f3df36842U, 0xbdbf34d5bcc3b3c8U, 0x3dc666febbf57effU,
  0x3bbaf96b3d92d895U, 0x3d1e80b53da56594U, 0xbd820e65be058118U, 0x3dd3c5e13d9ed2c8U,
  0x3ce3bb453dc1b532U, 0xbd9824793de0d7bdU, 0xbdf7f4acbd6c84fcU, 0xbd7e57edbd49b90dU,
  0x3d8f236cbdcd411eU, 0xbcfc101f3d650d8aU, 0x3cbfc5893d960799U, 0x3d6df6b6be020395U,
  0x3d9e674a3b8ea4beU, 0xbd8ba03d3d102f84U, 0xbc47b02f3cc5573cU, 0xbd349a6e3da476c0U,
  0x3dae5d72bdd11ce0U, 0xbcf7c2803d8be61eU, 0xbd9cc924bb104854U, 0x3dbf0debbdc6b4a7U,
  0x3d1254703d9be054U, 0x3cd6b3f1bcfb378bU, 0xbdc521e83d1e5048U, 0x3d55df9bbd2457d4U,
  0xbcb0500c3b28901bU, 0xbd35d6a9bdb345d7U, 0xbcaa1dd53d32d606U, 0xbd630930bdcdc69dU,
  0xba9fef293d9b2a6dU, 0xbdcfd63e3b7ed808U, 0x3db7943f3ca7e5b6U, 0x3cd44a20bcdcba15U,
  0xbd4052b13d8f83d3U, 0x3dd41bbe3d1edde2U, 0xbc00cd623d536ca7U, 0xbd8cc7afbc4549dfU,
  0x3d3d4c3d3d8347a3U, 0x3d8eff393daa26bfU, 0xbc9374d3bd9e2f41U, 0xbda340a13d98127eU,
  0xbd9b180b3ce86c9fU, 0xbd12a56ebda216feU, 0xbc1b7ab23d226788U, 0x3c975e28bdb92cb6U,
  0xbd5725983cee0c6cU, 0x3bbf86923d89bbf3U, 0xbd9e99193d5a553fU, 0x3d339c513da3e051U,
  0xbda2d566bda50ab9U, 0x3dd1c7d9bcd0f24fU, 0x3cbe3529bda78886U, 0xbc3df4c13d29a56aU,
  0xbdc585f4bcdf23e6U, 0xbd60e4513d4c665aU, 0xbaf88e283dc1e64cU, 0x3dc7209fbdccf333U,
  0x3dc042ea3c726034U, 0x3c1aa5cfbdb1e967U, 0x3cacacfabdba6e90U, 0xbd7766493d126e5eU,
  0xbd43e313bda5db77U, 0xbd9bb41c3d0457c7U, 0xbd2e4eb9bd0d9880U, 0xbda86d463db52011U,
  0xbdcbe34a3cb0477bU, 0xbdc4b31dbd2a28d4U, 0xbd013fab3db8f711U, 0x3dc4110dbc376281U,
  0x3d0d553bbcade7bcU, 0x3d64ffc93cef13ceU, 0x3da7b12abdd6648aU, 0xbdbd0556bd220b6eU,
  0xbdb474883d5917c7U, 0xbccc4f70bdc8ada6U, 0xbc409df8bd9fb66eU, 0xbd87ee543d981501U,
  0xbd8cf0c6bdd6c683U, 0x3d3a3956bd2f332aU, 0x3dc0e2b7bc9ba523U, 0xbdd7e479bb282213U,
  0x3d03635e3d1c3026U, 0x3d0584233d7d2d4eU, 0x3ccb0a633b1840afU, 0x3d6f322c3d453de5U,
  0xbbb1ae033d848fb9U, 0xbd23c868bdcf7128U, 0xbcb3ec08bd84b694U, 0x3da3b67b3c5ab4f5U,
  0x3cb370e23d21a20aU, 0xbd1820b43d3a8e5dU, 0x3d4023463da8baccU, 0x3d809f813c33be26U,
  0x3d0dade6bdaa3083U, 0x3d414a40bdb87886U, 0xbdcd68d5bdd190fcU, 0x3d80b813bd4d885dU,
  0x3ccff0913da60180U, 0x3db41fe03dac6095U, 0x3a9e300d3d29a3bcU, 0x3c06d0863d3cf0baU,
  0x3cfe41dd3d9a7858U, 0x3d93f286bdbd19ffU, 0xbd9f6070bd07008dU, 0xbdaef2003cf65fbfU,
  0xbca5bcd4bbe21281U, 0x3db717bd3d8ac531U, 0xbcf4417d3d7dd56fU, 0x3e072e5c3d0ed9b6U,
  0xbd004ca53dc0b1bcU, 0x3de910fabc059fcdU, 0x3d75c1b13d0d498bU, 0x3dc412733dc8fe52U,
  0xbd061353bdca2487U, 0xbda6aa49bda91851U, 0xbcbbf5143da78db8U, 0x3d9bf4bc3c90bb00U,
  0x3d9d405ebdb52b93U, 0xbd10a1cc3d1f6605U, 0x3ce94380bdcb901cU, 0xbce359a1bdee5daaU,
  0xbdb1e0273dd73093U, 0x3d7103a6bc27152eU, 0x3d1543f93db71be4U, 0x3cbaed8d3dc312a3U,
  0x3ddeac933d5b37bcU, 0x3d60dc62bdee87b1U, 0xbd97e1753d8133c1U, 0x3cedd232bc86e1b6U,
  0xbca54ffc3d4bfc4fU, 0xbdb9374e3cf0f220U, 0x3d2cf150bd567b5fU, 0x3d4d55e2bdd255faU,
  0xbdcec6d5bd7f77b4U, 0x3dda3021bc85df5bU, 0x3d8a4058bd5cde20U, 0xbdc471353e015768U,
  0x3d3931e53b9140f5U, 0xbdab2d3cbbecf181U, 0x3c52c89b3c31735aU, 0xbdd106f3bd95a671U,
  0xbd336b3b3d15a21eU, 0x3d572ea43da13232U, 0xbd6995353dd0b3c6U, 0x3dd4eceabd77eba8U,
  0x3e011533bdc3aeddU, 0x3dd21d9f3db54d31U, 0xbb862f96bd121f7cU, 0x3dbc72a63d14f861U,
  0xbcd610abbd18d73eU, 0xbcf494c4bca536a9U, 0xbcc6a9503d82dc30U, 0x3dc9aa2ebc5fe994U,
  0xbdcbe983bdcc88c0U, 0xbd1568433cb9459cU, 0xbcbb9d543dbbe4b8U, 0xbdc7646e3d6f4414U,
  0x3dc8a4293c34bd32U, 0xbdaf1666bc2d4d35U, 0x3dcaf7133d509355U, 0xbb60b0053d389a0bU,
  0xbd04899b3db869fcU, 0xbd451e68bd41f663U, 0x3d1abb823d0daac8U, 0xbdcac5c6bd9aaf57U,
  0x3d51cfdbbd2b6629U, 0xbc36086abbd5e35fU, 0x3d6349913d392f02U, 0x3ca25e0dbd2febe6U,
  0x3c42243bbbc1f022U, 0x3d5f6ed23d74c8e7U, 0x3d854358bcb32cafU, 0xbc4b8981bd96329bU,
  0x3db642e3bdc0a478U, 0x3b7d93633c66833dU, 0xbc94d53cbdb5ce18U, 0xbdd696293b348a01U,
  0x3ce85f2d3d7d6908U, 0x3d23dabebdb1ed06U, 0xbc778368bd8341f0U, 0x399700703d0add52U,
  0x3dc1a8b6bda5437dU, 0xbdb69a4e3d423e56U, 0xbce4eeab3cc6e241U, 0x3d0ea7573dc5c4cbU,
  0x3d8ee0c23d3d8bd2U, 0x3dd6bc12bd116dd9U, 0xbda71fad3cc441ddU, 0xbc75fd0c3d9a293fU,
  0x3c17bf9f3c6d167aU, 0xbd2f26913c9b5bbdU, 0xbc9e2fdb3c6b6f8aU, 0x3c9163c0bdb90d60U,
  0xbdc14606bc96080dU, 0x3cd1343f3b642921U, 0x3dc36cf73be0c4b6U, 0x3daffa873dcd54dbU,
  0xbdd373263d3c21a0U, 0x3d851995bd7f1600U, 0xbd5ee7e6bd171e64U, 0xbc7bcb1fbda84724U,
  0x3d6f0f863d7b72eaU, 0x3d7950e13db84c27U, 0xbd03cb673cec07feU, 0x3dd6f0d9bd915499U,
  0x3dbfbd0e3d576666U, 0xbd94e2bcbd461c63U, 0xbdaf355e3d72c80cU, 0x3d2f7413bcbb5451U,
  0xbb84241d3dc07bbaU, 0x3cdf5d05bda378e6U, 0x3dcec441bdbe79fdU, 0xbdd0e5c1bb5dd873U,
  0x3d1f55de3d81e3beU, 0xbd97aefbbdcaa2a1U, 0x3b2008cf3d96c5edU, 0x3b4e950d3da6f2b6U,
  0xbd1a7ebf3d2b0686U, 0x3d1af0f0bb5ec1edU, 0x3d9150273da38f9bU, 0xbd4c7bed3d3df610U,
  0xbd2772223d828700U, 0xbdcd97debdac081eU, 0x3d507cff3d53b7a9U, 0xbce753febbb81bf2U,
  0x3ca1c70fbdccb83cU, 0x3daf0554bcf2a248U, 0xbde2c63239fd6b76U, 0xbdcb0678bd166d99U,
  0x3da5292f3d7c1848U, 0x3d0c6f123bcd8f98U, 0xbd9f1711bd83a82bU, 0xbd8f0d2c3d948809U,
  0x3c890a4fbdb3f995U, 0xbd7f2c033dd79e25U, 0x3d0e1f803dac0503U, 0x3dce115f3d888c97U,
  0x3d207c243d94a394U, 0xbdbe7129bd81ead6U, 0xbd946f213d480443U, 0x3dc5416bbd81b042U,
  0x3da0f6813dc3c03fU, 0xbd0efbff3b99624bU, 0x3daf2e96bd4dab93U, 0x3cf981ff3db89c45U,
  0x3cd12252bcc0ce6dU, 0xbd227ae73dbe9b96U, 0xbdb22c443da2fab0U, 0x3cdb7087bdb4a301U,
  0x3d51a062bd08fe30U, 0x3dd242183bb34823U, 0x3c69147f3d763208U, 0xbce36a593db60350U,
  0x3a7af6cfbd553248U, 0xbd0c2cd33d340367U, 0x3cc9d9623d4c9a64U, 0x3cd1f0c33da30796U,
  0xbcc0b9b83d842107U, 0x3d7788433d17ad62U, 0xbc20546b3d833602U, 0xbc8e6ef83dc1af42U,
  0x3c52bf81bdbc4346U, 0x3d3ee4ab3d1afa6dU, 0x3d0de65ebdd16b96U, 0xbd25fd283d25df33U,
  0xbd5dc838bdb5607fU, 0x3d046936bd88df08U, 0x3cb8b969bdc5efc8U, 0x3d9332153d672481U,
  0xbdbca1853dc57620U, 0xbd7adbeabda81d87U, 0xbcc37db2bd478076U, 0x3db214e43da429f5U,
  0x3cf7e6b4bd0e4155U, 0xbda1ddbebd0d580bU, 0x3d86d0c13d9cdda1U, 0xbc6bb7dc3d5ebd0dU,
  0x3c6a42083dc54acdU, 0xbdc09accbc6089acU, 0xbd9dbde1bcaf6fcbU, 0x3db3f52abda6facbU,
  0x3cd079febba3b106U, 0xbdd30744bca3a328U, 0xbc9bb6863c4292a1U, 0x3d5c134cbd1a8991U,
  0x3d2f76913b9c1b02U, 0x3cf9a2243ca42805U, 0xbc66fe043d9c9350U, 0x3d0f56da3dc958fbU,
  0x3da6b050bd9f291cU, 0xbd31af1b3d9ef9a6U, 0xbd96825dbd728f34U, 0xbd6ce10b3d103e1aU,
  0x3d4d4a3bbd87c682U, 0x3d553e38bdc02329U, 0xbd3fdb65bd985b5eU, 0xbcd94cc8bce81f4cU,
  0x3ca29420bdc47903U, 0xbcb1e8303dab5cfbU, 0x3d7ace623c0be6f9U, 0xbdd639dfbcedd964U,
  0xbc8165343dc6e836U, 0xbbbdbe9a3cfff8eeU, 0x3d8c0bd5bdaeabd4U, 0x3dabeb9bbd76c047U,
  0x3da01a033dd3abfdU, 0x3d23e41b3d525d86U, 0xbd067a713caeb181U, 0x3da8629a3dbf4670U,
  0x3dcf5695bd076da5U, 0x3d8d4d91bd49f336U, 0xbdc7aae03d2739a8U, 0x3c20fedc3d6cb5aaU,
  0xbdb332f8bd3f6f10U, 0x3c8ff147bdc0029aU, 0xbce41d283c3ef32aU, 0x3ca035ec3d51432fU,
  0xbbf628fb3c3d05b1U, 0x3dd13c303cf6b7f0U, 0xbdccc3d03d7b1c0eU, 0x3d77bceb3dd2999eU,
  0xbd6a58173d93b275U, 0xbd6b88fa3c01148dU, 0xbd4fb5d03d9bed76U, 0x3db41635bc72a882U,
  0xbc4912623dcf5bd7U, 0xbc016384bc184b1aU, 0x3e0937a0bdaf5c61U, 0x3b20ff8b3d2d7d85U,
  0xbcccde123db6a7e5U, 0xbdcd1d8fbc85d585U, 0xbdaef51fbd169cf8U, 0x3db5b7c5bd937bffU,
  0x3d9d171ebd15905aU, 0x3d8021a93cc9c0b5U, 0x3df98862bc8f994eU, 0xbd056bda3ac49f43U,
  0x3c2740b53db2c8aeU, 0x3c9749ff3dce3eacU, 0xbd4be1c73d7a0fb2U, 0xbd6c40b73dbe238eU,
  0x3dbe981abcc8e720U, 0x3cd86207bdf03a9bU, 0x3da04c2dbc5771d3U, 0x3e3de14ebd20c88aU,
  0x3e80d86abdff1bd5U, 0x3c31ca66bbcea610U, 0x3e10d0f3be0d4968U, 0x3db0b04cbcfe3e18U,
  0x3d984a6b3dc3a5b6U, 0x3e2d10243d0fed9dU, 0x3c2361d13ce2e512U, 0x3e00166ebd935d74U,
  0x3c8f15fe3dce176cU, 0x3cc039e5bccbf7a3U, 0x3dad9e77bbdec2a9U, 0xbc428b823a68dde4U,
  0x3c1a45223d8ac508U, 0xbc96b50f3bc1a616U, 0xbc3306333d7f9b1dU, 0xbdc8d1ff3e457565U,
  0x3da35c613e06422eU, 0x3de29a8a3d39aac4U, 0x3dc11cdabdf43c1dU, 0x3e0c7d8f3d8b8c9aU,
  0x3d136c45bd097edfU, 0xbe59939b3db8c58eU, 0x3d63b88f3d1c6457U, 0xbd03b040bd9dc95dU,
  0xbdd15ffa3b371715U, 0x3d07b6a5bd6a07e0U, 0xbd8ae34f3d603635U, 0xbd1fb1653dd333f5U,
  0x3db84ee03dab76c2U, 0x3d3f01603c9789f7U, 0x3d8ef2643d1a2dfdU, 0x3b2e0d09bdb22d8eU,
  0x3b91ed0c3d8d60fdU, 0x3cf714853bb3eec0U, 0x3d930091bdbe3160U, 0x3dab1c83bd1be947U,
  0x3cad918f3d8851daU, 0x3dba8549bdaa47b6U, 0xbcb55dcfbdc67324U, 0xbaad6cd2bd1798f6U,
  0xbbba387bbdaae9d5U, 0xbdbee788bd5ef815U, 0x3d63cc3d3c076b7eU, 0x3da4d687bdb13752U,
  0x3d8540503c4feaa8U, 0xbdc230d03cebe52aU, 0x3d3bc620bd88ca63U, 0xbd4dc0e7bd1ebf7cU,
  0xbc692c08bdcff49eU, 0xbd81d2eabd848ad0U, 0x3cfdde76bd8db352U, 0x3d752e1c3dbdf426U,
  0xbdba04433d2e37ccU, 0xbdd14dd33dc75db0U, 0x3d1a6a73bc5faf53U, 0x3dd4922d3c00231bU,
  0x3d13fae23d031a0aU, 0xbdc60161bc52e842U, 0xbd9fa92c3d839f25U, 0xbd607dc6bd351fadU,
  0x3c80b927ba3bb9f1U, 0xbd6ae088bc271daeU, 0x3cd179be3cab2ff5U, 0xbda595be3d040434U,
  0xbdab17953d0533c1U, 0x3cf8a3c23d8435e7U, 0x3dc47a7d3db15be5U, 0xbd7de96b3d9e1ac6U,
  0x3dce5483bb499d3dU, 0xbd8f7f13bd38ebc8U, 0xbd1484e63da85e3cU, 0xbdbd28a8bd0bd98eU,
  0x3cda36cdbc4fa980U, 0xbdb7d5d43d95d9d1U, 0x3d5426a6bd23ca10U, 0xbd9a09c83df559c1U,
  0x3c35dc1cbcf4f013U, 0x3d6873b43d39f592U, 0xbd620bb23d3560d9U, 0x3b6d69dbbd1ff498U,
  0x3e31f1d93ca58d0bU, 0x3c5f1c20bd71420bU, 0x3bca014cbdacd3b7U, 0xbdbd9d00bd817566U,
  0xbccf0cc13d017b1bU, 0xbb89cc793d86ed8aU, 0xbb09ba92bceb33f5U, 0x3b491c01bd163e85U,
  0x3e24a9f33c2e4d23U, 0xbdc9bb96bdc0a717U, 0x3e1d1428bd7dc701U, 0x3d77c2a5bd17fcd3U,
  0x3e4d9c3fbd73f08fU, 0xbd7cc80fbcbb9345U, 0xbdc802c5bd6b469fU, 0x3e21fa743d190130U,
  0xbdea47f93c3c9d51U, 0xbdb94a913acd05e0U, 0x3ce9f4aabd69fb01U, 0x3c7eaaffbc9e2985U,
  0x3d83b4dfbbae4627U, 0xbd74a5c5bd8b2b36U, 0xbc5ee6debbdb507dU, 0x3d0ba58f3c22f457U,
  0x3c8acb6dbcf1d7baU, 0x3d841cb43df491b6U, 0xbd2e24273d9e8ea6U, 0x3d512d9f3dd3c5e4U,
  0x3d498526bb26ce38U, 0x3e24a7783c840003U, 0xbdd22781bd760d78U, 0xbe1adbf83e0b39b7U,
  0xbdcb15c83db6fb7aU, 0x3db6d0ab3d81328eU, 0x3dd50f8ebdebdd9aU, 0x3d057aaabc33caa4U,
  0xbb84cfea3d844534U, 0x3e18a4d2bdd29cb3U, 0x3d6b07f43d9a8500U, 0x3d611e50be72209cU,
  0xbdd61bfc3db10929U, 0x3d5588abbd2b3259U, 0x3dc7c14fbd5c1efbU, 0x3d91e7873d96de5fU,
  0x3d01f6963e087772U, 0x3df3f61dbd2dd2b3U, 0xbdd65970bded950dU, 0xbd7fd1e63c033326U,
  0x3c1b1b2c3d8298fcU, 0x3d97acb23d966629U, 0xbd8b956abbe8cbefU, 0xbd99a93d3d006529U,
  0xbddb2a203c99235cU, 0x3d8b7231bd879bf5U, 0xbd9239793ce60d10U, 0x3d84b208bd6b6439U,
  0xbd460acb3e16a6fbU, 0x3e4496a1be460a79U, 0x3d3b5b2dbde5239dU, 0x3da58566bc8837efU,
  0x3e58eb2f3da28c88U, 0xbd5113f5bd67a6a1U, 0x3c833043bc91dfabU, 0x3dab62fcbdabb384U,
  0xba99b315bd9ac407U, 0xbd5cc4403e34dc15U, 0xbde5072d3bfadcdcU, 0xbd747472bdd5f8eaU,
  0xbbed9d293e3f4735U, 0xbd2570bdbda08ef4U, 0xbdb14bbe3e19d671U, 0x3dc5ebdd3dfa1d45U,
  0xbcf60201bd855f87U, 0x3dfa1203bd3457f6U, 0x3d4620113cb187feU, 0xbd5205c03d8f008dU,
  0xbe2329b43d00f613U, 0x3bcf57ef3bcbfb4cU, 0x3de7e5dc3dd9878fU, 0x3dd117cdbe644366U,
  0xbd72809abdaf98acU, 0x3d1a83233d972468U, 0xbdb43708bde3444bU, 0xbda4d34a3dabf49fU,
  0xbd3aeb6abd724a30U, 0x3da74dbb3d25769cU, 0x3d1c134cbdcaa345U, 0x3da927be3cbfdb82U,
  0xbdceeb963bf3a106U, 0xbd1ecb8bbcd20d30U, 0x3caa33d13d91f559U, 0x3d86dcf13c019b4cU,
  0xbdabd425bdbe6b8fU, 0xbcae34933dbe5d52U, 0xbdba1683bd39aa15U, 0xbc22048e3db9c208U,
  0x3d852d90bd8d929fU, 0x3c283304bd766c57U, 0x3d2885eabd28f652U, 0xba6012363d73a03dU,
  0xbd4787513d5c511aU, 0x3c33dd84bd24b8b5U, 0x3bf48708bdadb113U, 0x3dae7cddbd5eb8e6U,
  0x3d830e38bd8148eeU, 0x3d0d824d3d4e486bU, 0x3d948a963d4f5de3U, 0xbd832b03bdb26c85U,
  0xbcfc50d13dd20106U, 0x3dc2d887bd9cf650U, 0x3d666bf1bc6aab6dU, 0x3d7398d13d8e1936U,
  0xbdd2e693bdc36758U, 0x3dd2698cbd9346a3U, 0xbd91ce243cb8c6a1U, 0x3daeced63db8c995U,
  0xbd79f9fcbd80db86U, 0xbd7d35f4bcc1eabfU, 0xbd8a5a6cbd4d5d49U, 0x3dad8151bdbb59e1U,
  0xbcf7ade33d90d166U, 0x3dc12a423ca1b8d0U, 0x3dcefee53d14960eU, 0x3d0733fc3d94dda8U,
  0xbd7321133dc4ea14U, 0xbd293641bd8a9051U, 0x3d4f5ba6bbf64b59U, 0x3d680ccb3ce7e176U,
  0x3c8002efbc513b98U, 0xba8438babd2c70bcU, 0x3cfb2705bcbc8a07U, 0x3d902bf2bc76fac6U,
  0x3dd686ae3c426ad2U, 0xbdd4f616bd17e9ceU, 0x3b5d37083cadedc2U, 0x3d5515cb3d85a546U,
  0xbc2c03d93cd71da2U, 0xbcbd72033c3a1310U, 0xbd88c4a53d9aa578U, 0xbd485fc7bd244f42U,
  0x3c1054f23d862b39U, 0xbd9e99ff3c18e6bdU, 0x3bf9420cbcdcca40U, 0xbd6dd39cbd652c92U,
  0x3ce6fb693db7a3dbU, 0xbd8f6beebc567c70U, 0x3db77f753bfe857fU, 0xbdafd8333d22c153U,
  0xbd8e9311bd143892U, 0x3dcb00cf3da4bf44U, 0xbd9a92b03da819dbU, 0x3d48a3d83bca0c0eU,
  0xbd14553bbdb30c86U, 0xbcf339d1bd917a01U, 0xbd6f20e9bdccf0fbU, 0xbd8d52043cfac847U,
  0xbdc14be73da4418dU, 0x3d1727ac3d2616b9U, 0x3d8194dcbd3e7035U, 0xbdae3d3dbc9832d2U,
  0xbbd596293db9e40bU, 0xbc73447bbd832e0bU, 0xbdb3a2d43d0c3324U, 0xbd09576abc53b939U,
  0x3d60e0cebd818b39U, 0x3d864df43cc5969dU, 0xbdcbafd9bdaf5977U, 0x3bd577dcbd21560dU,
  0xbca0138f3d179312U, 0xbd3fbca43db144b3U, 0x3d160c963cf7476bU, 0x3c576c49bdd73a8cU,
  0xbd858aa1bdca7f31U, 0xbd4274ff3cd66938U, 0xbd33ead9bc8ee315U, 0xbd2bb4b7bc416dc0U,
  0x3db8ad3ebc49a081U, 0xbd6d219cbb1a6e6eU, 0x3db3cc863d5bbb7bU, 0xbd5b7e793bc5e6e8U,
  0xbdd4cf563c11ad6eU, 0x3cdcb535bd9ac737U, 0xbcebc03e3d929cd9U, 0xbd0c7b2f3c4bfba1U,
  0x3c82f446bd78c14dU, 0xbd73d351bd0ac45cU, 0x3dc222f73c60e5b3U, 0xbc8c6740bc22f0f4U,
  0xbd89bcdcbbb51c06U, 0xbd46cef73cfb63deU, 0xbdb3b4b4bc19c8d0U, 0x3d3315c1bd9b9c49U,
  0x3d8b5985bb11cc32U, 0xbd4829f63d43ee4aU, 0xbd2c1dbc3d809159U, 0x3c033112bc24129cU,
  0x3d90fa02bd25bfdfU, 0xbd6c4b443c88886fU, 0x3c5d9010bb28698fU, 0xbdc3c14a3dd13042U,
  0xbccf408d3cfde092U, 0x3d1fc8363d4821e5U, 0xbda939fbbcd6a3baU, 0xbd4128e1bcc352f0U,
  0x3d34b5b33d7ad719U, 0x3da01b3fbd66d680U, 0x3d84b6303db5a194U, 0xbc70e59d3dbebb3cU,
  0xbdcbbb9c3dd11158U, 0xbc922ca2bda60bf1U, 0x3bbe56303c2b17feU, 0x3cb712ae3ccb7e93U,
  0xbd44af37bd26e351U, 0xbd8a584cbdcc801bU, 0xbd574f243d68b075U, 0x3dcbb1213d7305e3U,
  0x3dccaf623d6510f9U, 0xbdd37e283d523cb9U, 0xbdac6feabbba8440U, 0x3c9c86c5bd1ce038U,
  0x3dc3a3abbd2ea880U, 0xbd02e3c8bdcf8b4eU, 0x3d3bbfc53d116879U, 0x3d3a9a08bd672351U,
  0xbd1e9e1ebcae79b5U, 0x3bd7ac86bda8c0aeU, 0xbdce58483cd680b4U, 0x3cd0cc683d88d1faU,
  0xbd4f0a5abdae3d8fU, 0xbce2d240bd761c1eU, 0xbc6d8b36bd2d7b5dU, 0x3ccd49043c82edacU,
  0xbdd2fb21bdb79eb0U, 0xbcf7ca7cbdc13fa3U, 0x3c775879bd95248bU, 0x3ca4a33f3dc512deU,
  0x3d83b87b3cf6882fU, 0x3daff058bd8d6d55U, 0x3ce3172c3d16ff1bU, 0xbd191bfcbdbe104dU,
  0x3d64bc0f3db200ecU, 0x3dbaa5f1bd3aefc1U, 0xbd4c429cbcb6bb40U, 0x3cdab6fdbd9e0e6dU,
  0xbcb343fabd5e79b7U, 0xbd98b820bdbfb2efU, 0xbcefd006bd84b502U, 0xbd50a3cbbd699f47U,
  0xbdc44b02bd6b8a6cU, 0x3dacc2683d9a4f54U, 0x3c42de06bd9bf644U, 0xbcf32b183da47bf8U,
  0x3d6a6901bd4ea16dU, 0xbd53b0d6bd8c54abU, 0x3d7f0665bdd5f06aU, 0x3d17f6943da0fbaaU,
  0x3c7e0f46bcef24fbU, 0xbd899547bbf40739U, 0x3db5cf173d69854bU, 0xbdb9f87b3dbc6f5aU,
  0x3bba30353d882575U, 0xbc874a43bd85531cU, 0x3d315c67bd07d5c6U, 0xbd89701f3be24b2fU,
  0xbb9260b1bd770690U, 0x3d39f4753d744876U, 0x3d3181e63d898693U, 0xbd6260c13cb4949dU,
  0x3db48e23bd9325b7U, 0x3d8ac4113d927e19U, 0x3cd7b37e3db24306U, 0x3c9c36723dcd274bU,
  0x3da6aebe3c45892aU, 0x3db7aae1bdc61058U, 0x3db3b36b3c34dee4U, 0x3d2ac67f3d9b01dbU,
  0x3c7b1b5abd6b4056U, 0x3dc9ed683d0525baU, 0x3d883ff8bd40255dU, 0x3e19dd11bc93eb13U,
  0x3dd58842bd45601bU, 0xbdca83ee3b83b3e2U, 0x3d0209e83ce0967fU, 0xbd35033e3da56b82U,
  0xbc3b96373d31f47cU, 0xbce020e0bc428edcU, 0xbdab84f5bddc651cU, 0x3e006e113d2971f5U,
  0x3c939cac3dddf4c2U, 0xbcb59798bdabe0c9U, 0xbd7ebbed3e1589a4U, 0x3da48492bdc13716U,
  0xbbbaed3bbddbe0d5U, 0xbdaa90b6bd3f1b75U, 0xbc7498413dc56e73U, 0xbd81a1af3d4d6a96U,
  0xbd00ff283e0f11ffU, 0x3db419473dd00cc3U, 0x3c8ca5c5bdde0457U, 0x3e020103bd7ab820U,
  0xbd0c5d583d976cf8U, 0xbd3d187c3d1491ccU, 0x3ce1d7263defee27U, 0x3d778f60bdb831f8U,
  0x3cae6d8abd9ff78bU, 0x3df3e2ff3d8bd8c3U, 0x3d4702633db73d93U, 0xbe2f3a62bd9444bcU,
  0xbc933547bd27478fU, 0x3dc1b7803e0015cbU, 0x3d6fea63bd470191U, 0x3dd7399cbd80d09bU,
  0x3ceb79eebd2db4c8U, 0xbe0b30613afc1cb7U, 0xbd6c29253d7b9376U, 0xbdb854c6bc072117U,
  0x3d988374bd0cf86eU, 0x3d3ef982bc56caf7U, 0x3d2c47a23d6ca3c5U, 0xbd1e406a3cf6bff2U,
  0x3d8fc471bdd276a1U, 0x3d4f9949bdf3372dU, 0x3d859453bcb5716aU, 0xbe3007423d92e442U,
  0xbe3a5b5d3dc9e422U, 0xbda0564ebd67a37dU, 0xbd029489be0bf564U, 0x3bd767813bbc3114U,
  0xbd180b473daa31a0U, 0xbc908ac43cb6c36aU, 0xbd8be6363dc1e773U, 0xbc127f943d7a1dccU,
  0x3d247f193e0a65efU, 0xbd8a4e903d863488U, 0xbc3656cf3d785796U, 0xbc9c04f5bdb70901U,
  0x3dd0622cbdd570aaU, 0x3da72aef3d33328dU, 0x3decbbd6bd2327acU, 0xbd75f67bbdc691d5U,
  0x3db55216be190fb4U, 0xbdd5b736bd91efeaU, 0x3ba6ca81bd63e85dU, 0x3c0461d33e36047aU,
  0x3cbcd54e3d457187U, 0x3ce3cfafbcc65728U, 0x3e2265bfbcadfe4bU, 0x3dba2063be02b6eeU,
  0x3d27c4fcbd33916bU, 0x3d320f053d04e97cU, 0xbdc8820e3d202c66U, 0xbd5e7adbbc8c6a35U,
  0x3d8d3d443d2392b9U, 0x3dc9e211bd4c589eU, 0x3d9815ddbd47ccc4U, 0x3d18fd323d74d470U,
  0x3cd3cc7ebd4c9ac5U, 0xbdaf5df63d3ca812U, 0xbd4ef8fabc147b70U, 0xbdbc78a23db8d4adU,
  0x3de7febbbd5e0d90U, 0xbdb9a9733d5db7cbU, 0xbda2c2c33da4b977U, 0x3dc70db7bd807732U,
  0xbd86f5143a6eeb54U, 0xbdc94f433c9a9055U, 0x3c9e38d83d3a07d2U, 0x3c653bc33cf8ed7aU,
  0x3ddbc2043d9b7017U, 0xbd914513bc7e2214U, 0x3cd11119be0b48c2U, 0xbd5054b93cf46d39U,
  0x3de5ae41bd6ab81eU, 0x3d89f9acbdcf6403U, 0xbd9271033d92f65bU, 0xbc86262cbd2acdf7U,
  0x3cb7306cbe36bb35U, 0xbd8f421c3dbc1ab3U, 0x3c59534f3d5d9c2aU, 0xbd82a105bdb50ed0U,
  0xbdc2f9843c2d82e0U, 0xbc6da356bd89b6b5U, 0x3dc4693e3d0e6089U, 0xbdafdcb53de418bfU,
  0xbdefadfdbcc01c84U, 0x3caee0053e0f6a44U, 0x3cbf25403d702bf1U, 0x3d6c6efcbd8545acU,
  0xbd70ab22bde8b921U, 0x3dfc9e8ebdd48153U, 0x3d66b83fbc559737U, 0xbdfb8a833c97117bU,
  0x3a9ba08f3dc8f3c7U, 0x3d9690f23d0f4e23U, 0x3da12c5ebd7bfe1aU, 0x3de83bdfbbe3b298U,
  0x3d5a32f0bcc189b8U, 0x3d85e345bd32bb4dU, 0x3d364fc4bd5f0aa5U, 0x3da930213db36e72U,
  0x3da47158bccd89b4U, 0xbd1f8d1e3ca672a4U, 0x3d8df8b0bdb677e5U, 0x3d11f6d73d8a5987U,
  0xbda0d4203d1a4ac7U, 0xbd8359dc3dc88ac4U, 0x3db6ff7fbdbfca71U, 0x3d5964793d8b90f5U,
  0xbcff4fecbd342dacU, 0xbd2683dabbf2094dU, 0x3c694b3abbdbd007U, 0xbd77a4fdbc3dd7f9U,
  0xbd5e842bbd3a83d5U, 0x3cb7bbf4bd3f454cU, 0x3daf4df03c5d4307U, 0x3d8f8086bd51aa21U,
  0x3daaeb9a3d890b88U, 0xbdb9825bbaa32e3dU, 0xbb09e70b3c95ced4U, 0x3cf6429dbaa491b3U,
  0xbd7db918bc030b99U, 0xbd8420af3cd62d04U, 0x3d0a88ac3d32e4eeU, 0xbd0229813d933419U,
  0x3db16904bd67195dU, 0xbd8e72733d5809a0U, 0x3d492635bc46eb59U, 0xbb86c49e3af21e55U,
  0x3c31b0253dadefa6U, 0x3d392f6e3db37abfU, 0xbb75b0c13dbdc424U, 0x3d10f8b93de499c8U,
  0x3db83884bc833762U, 0xbd53516c3c1cf67eU, 0x3c8547c1bdd1e19bU, 0x3cf34a74bd59b775U,
  0xbccbf05bbdd6b9d2U, 0x3d60736abd01d03cU, 0x3dc93a82bd0a20d0U, 0xbb23b183bbd47b14U,
  0xbd9115eebbef2f96U, 0x3d5783a53ca41653U, 0x3d47c0083daf2a09U, 0x3db93aca3d923f72U,
  0xbdd00ddd3c322cf7U, 0x3d598c57bd83aa03U, 0xbd3fe3b63c9bbaa6U, 0x3cd835b1bd880d47U,
  0xbd4dcb303db79aeaU, 0xbdb3f22c3d3493c5U, 0x3c9bcb7cbdc7dfaaU, 0x3d8f04a9bcd941efU,
  0x3d16139bbd707201U, 0xbdbe017dbc540b4cU, 0x39ba886cbd82ac9eU, 0x3d9514d4bd9ece2cU,
  0xbd4feb31bdb87f8bU, 0xbd507110bcf319aeU, 0x3c996215bda9026eU, 0x3d8943f2bdacd16dU,
  0xbd0e9e763dcd7976U, 0x3d7343083d18702aU, 0xbda975e33d55c283U, 0xbcf5d37b3d853451U,
  0xbdd4bd783ce9e662U, 0xbda62caa3b99eb5cU, 0xba57292e3cfa247cU, 0x3d025a67bd0a7619U,
  0xbc3463b4bcd99fcfU, 0x3d4cfe833d9086b0U, 0x3c70b501bd81f402U, 0xbd70099d3daa5ee3U,
  0xbd991255bd972698U, 0xbd463cbbbd9c4eb8U, 0xbdb4505dbdc83efaU, 0xbd442de2bdd72c45U,
  0xbd6b088cbdaf6adbU, 0xbb8a93503c8cde7bU, 0xbd81e91d3d5f18c1U, 0x3dbe4aa23d40daa7U,
  0x3d78656eba3daf3dU, 0xbd9796e5baa76875U, 0xbd8026673d6e13caU, 0xbca6182abd68f15dU,
  0x3d51a24d3dae8bc4U, 0x3c8d5155bdae06c5U, 0xbda33550bcf1d741U, 0x3e247d69bd5e582dU,
  0xbb7789f03dd31898U, 0xbc1185d5be39793aU, 0xbbeead0e3db00835U, 0xbda189e73b911182U,
  0xbd541637bd81d31dU, 0xbd685a5fbb3ba097U, 0xbc70d0e43da854ccU, 0x3e445ce13d83e9d6U,
  0x3db04f99bda7aad4U, 0xbc6bba05bc307938U, 0xbd6795933d8d28d9U, 0xbdc039ff3dd53249U,
  0xbae106ba3d99195fU, 0x3ca0505cbc63202dU, 0x3d2e2e063dfb5edcU, 0x3de2afa93cafdbf5U,
  0x3c8bcb163d0d7d19U, 0x3d804a57be0630b1U, 0x3d8d2aea3e1e4b7cU, 0x3dff5becbdf2ce64U,
  0xbd48f5c8bceb7320U, 0xbd399e3fbe0185c0U, 0x3cfae6bf3d79ead9U, 0x3b9c561ebdc608d9U,
  0x3d3e9ef23d4472c9U, 0x3b976dd3bd67ef3dU, 0x3cf966c7bd393195U, 0xbcaf51023d62d31aU,
  0xbc3736a33d46724fU, 0xbd27044abc8fcef7U, 0xbdbf59d13d134661U, 0x3d4c5b0dbcdb7425U,
  0xbd67aa923c7a694fU, 0xbdc7f473bb5125d0U, 0xbc872eb7bda57601U, 0x3d7cc4263c8f4b1dU,
  0x3de960593bc23984U, 0xbda823073bfbe5feU, 0xbe3fd8513ddb10ecU, 0xbd7a39183db7eafdU,
  0x3d91088c3d2099e8U, 0x3d3b9ba6bd52ded6U, 0x3d4412aabda528edU, 0xbd8ed352bd84cb70U,
  0xbcf4adf3be09eb58U, 0xbc856b8c3db955adU, 0x3802ebd8bdb2cd9eU, 0xbcedf56a3d6da737U,
  0xbd6beff4bd2c710aU, 0x3d9f643dbd767dfcU, 0xbc0a5456bd9d3ef6U, 0x3dd177753bfc76a5U,
  0xbcac0294bda1132fU, 0x3d815c2abdd39b6eU, 0x3d9d33cc3dc814d1U, 0x3db9894dbd4d5c86U,
  0xbc6fc8523d841649U, 0xbc651a05bd2595c5U, 0xbd318431bd24e1c4U, 0x3ca255e73d147052U,
  0x3d635d883ae78c6dU, 0xbd44ee173dba5537U, 0xbdc17aa13dabd03cU, 0xbdb63693bd395f9dU,
  0x3c0268c9bd28986dU, 0xbd3b1dcdbc9642e3U, 0x3be3fcadbd9aeb77U, 0xbda751cd3c8d33f8U,
  0x3dc55334bd6415a3U, 0xbcddb7ccbd6ef1e1U, 0x3da91b88bd9ea0a4U, 0xbda3ed6d3d7a18c9U,
  0x3d7f16f93c9852b5U, 0x3d30729fbd8b6abeU, 0x3b9d6523bd8c3f29U, 0x3d3857ba3c0d50d5U,
  0x3d1f3d49bc562166U, 0xbd44e41f3dc62a26U, 0x3d168f003d78e19eU, 0xbc39e96ebd7b096eU,
  0xbd9426e0bd3db9b4U, 0x3ce897da3c053963U, 0x3c6701b03a0d1daaU, 0xbc40542e3d682830U,
  0xbdd168b9bd2b9196U, 0x3d8718e8bd4bb6d0U, 0x3dc3fa60bd9972eeU, 0xbd9cbc533cfa5d82U,
  0x3da67282bd58996fU, 0x3daf5cc23d86029eU, 0x3d30d72b3c0382b3U, 0x3d7f4ccdbdc82abdU,
  0x3dcbeb4bbd108b9bU, 0x3da8eaca3dd71ddbU, 0xbdbd14f0bdb00a9eU, 0xbd54d88dbd509509U,
  0xbd8962b2bcd97ce4U, 0x3bcc11f3bdcf10b2U, 0x3cf88984bd7c128cU, 0xbcd50ff43d0ded03U,
  0xbdb13f0dba99f2f9U, 0x3ced1ea73cd8388aU, 0xbc5e2cf73d6ee01aU, 0x3d9ca9623d09f98fU,
  0x3d70d3623d693b5dU, 0x3dd45f8cbd69542dU, 0x3dda1f72bd93c724U, 0xbd09fa30bcef850cU,
  0xbd7177eabc34bda0U, 0xbd369bcdbd8adb39U, 0x3d602542bd4d75edU, 0xbc72ef7f3db0ac23U,
  0xbce4353f3d5da1b9U, 0xbdc80492bd7c4879U, 0x3d856fa7bdb5e098U, 0xbce3126fbd1cc68dU,
  0x3d707aad3bbea754U, 0xbcec5b2ebdd66532U, 0xbd4a7498bd87162bU, 0x3db6b797bd9b6291U,
  0x3c122e653d5773b7U, 0x3cea9aa03cd1ccf8U, 0x3b9b50f03da94fc0U, 0xbd1882f6bc937d78U,
  0x3da0f4adbd2ec927U, 0x3c80b0e53d121785U, 0xbd84b1ec3dac15b2U, 0xbd4b1234bc994dacU,
  0x3c855553bd176497U, 0x3d94fb2dbd4fe3feU, 0xbbd1296dbdb03866U, 0x3c194982bdbae2dfU,
  0x3dd197e13ce7e6b3U, 0xbd96389a3da7f2c2U, 0x3d8b28b2bd840b7aU, 0x3da9b0123b3ff74eU,
  0xbd90a7c8be9e6d83U, 0xbd6ee2563dbb893dU, 0xbc221b06bc845ea7U, 0x3d6d2432bd61bd53U,
  0x3d6791a1bd3f3385U, 0xbcd0d9f33dec0974U, 0x3e83f8113d1301ebU, 0xbdd10fae3d717946U,
  0xbd84804dbda27643U, 0x3cfc00d8bdde355dU, 0x3c4eacd23e2b0a56U, 0xbdd0bc083dd43a76U,
  0xbd8a55e73dd49fd2U, 0x3d0627993defe931U, 0x3e97a61a3dbff885U, 0x3d857acebcc88692U,
  0x3e91ca13bea35f75U, 0x3d8a26993e375f1cU, 0x3e735840be410e21U, 0x3c883d973d1ed4a2U,
  0xbd98a987bd363c06U, 0x3e4f5ba23d703947U, 0xbde52201be8448c2U, 0x3d98a81bbc8e828eU,
  0x3ba529833a444707U, 0x3e3378d03d89588dU, 0x3dc3e2b03df00c58U, 0xbe0e5e453c151621U,
  0xbd4d8410bd040be7U, 0xbdad0f4e3e0daf8eU, 0xbe33b970bd2ed74fU, 0x3a6a51df3d0be405U,
  0xbd5c6aad3e6c7073U, 0xbcca7be2bd86d1baU, 0x3e216585bd917ed9U, 0x3e1366273db37717U,
  0xbb87dbb03d430d9cU, 0xbe8e90bb3e2fb1a9U, 0xbd683f0dbc3aca40U, 0x3d173eb7bdaebaa1U,
  0xbc2706ebbeacaa63U, 0xbd45d9d1bd90d92dU, 0x3da90426bd0fbe01U, 0x3bb3ea9f3d008677U,
  0xbd42864a3ce8480dU, 0x3d2b68ab3dd665f1U, 0x3c29aeb2bdc98702U, 0x3c8a3972bd75de37U,
  0x3d1cb198ba7100c2U, 0xbd923c7dbd2fa3f4U, 0x3c95d2dbbd04c081U, 0xbca105e23da4e3bbU,
  0x3c1a96abbd79979aU, 0x3da69eb63d9972fcU, 0xbd2ad2debdc96b9cU, 0xbdb08cff3c3a63dbU,
  0xbdb3359bbcd8683aU, 0x3d9144d8bd8acd6aU, 0xbd2211823d5e902eU, 0x3dd24cb8bd8c88aeU,
  0x3d2a7a92bdb4e767U, 0x3c6afe43bdbfebbcU, 0x3db42157bd953ba3U, 0xbc934c77bd8838b9U,
  0x3bd84234bda1dfd0U, 0x3d55b2ac3ac11fa6U, 0xbdafe0653d862e86U, 0xbd895662bc75bc64U,
  0x3d8e2273bdad137eU, 0x3d09980fbc970b70U, 0xbdbdd7b03cf27354U, 0x3ad4d6cd3d72c55dU,
  0xbc968dcdbcb9ecf2U, 0xbd8e50d63cb14490U, 0xbd8466d6bdc08292U, 0x3cf24af1bd5a06f8U,
  0xbd423dd23d9d57e7U, 0xbcb37c6bbd66bca0U, 0xbbcb3db2bd71efcfU, 0xbdbd5c503d2df173U,
  0xbd8574b7bdb039b0U, 0x3cfdb8373dba5601U, 0x3d2472713cc25f31U, 0x3d335e2c3d12a9e1U,
  0x3d5504cd3d615a79U, 0x3d2306013d8c62f9U, 0x3daae65bbccb8819U, 0x3ce719fa3d027299U,
  0x3cb9d1ccbdcaec75U, 0x3cd195323d307a8aU, 0x3d07a6c83d498913U, 0x3d2d5080bdbf0d07U,
  0x3dbe204b3cd8e006U, 0x3b6b25193d312f4bU, 0x3bc7b8553da80e2dU, 0xbc62dfc73dd31e14U,
  0xbd62e4e13d8db535U, 0xbdd5397abdc39b16U, 0x3d295604bcecdfe3U, 0x3daf391abd811998U,
  0x3db5e5efbd6ddc64U, 0x3c537b8abdc9741cU, 0xbcf4e49dbc1ae3d0U, 0xbc61d7b83daf37b5U,
  0xbca49991bb7ca187U, 0xbdae5e0fbd61f135U, 0x3dc4fa6dbdb3e1ceU, 0x3d6835143d812ce7U,
  0xbd1fa6d03b7ad759U, 0xbdcb285a3d9c45fbU, 0xbb9cef64bda54a06U, 0x3dad65e9bc392ab3U,
  0xbdcea7803cf1adc6U, 0xbcebef973d139c55U, 0xbdd8f479bc863d6dU, 0xbd13a11d3cc96659U,
  0xbd6660d43da562ccU, 0x3cd2a9fb3dbd5c17U, 0xbbd3b48f3ca0131bU, 0x3dc5eb54bd9ab040U,
  0x3d38cd11bbbaba61U, 0x3d72d96e3be8bcb7U, 0x3d4965543dc81878U, 0xbdb62ecf3dc355deU,
  0x3dae80a03d8f66ffU, 0x3d925486bdaae319U, 0x3db24d1b3c7d0e22U, 0xbbfaf65a3dbac83dU,
  0xbd873c08bdc8ad02U, 0x3d41b0673d034172U, 0xbdc0097d3bf44ac9U, 0xbdb07f713d38bde1U,
  0xbbb390e23da55aa9U, 0xbdf3583abdb2ab24U, 0xbbb7dbd1bb499177U, 0xbca1dd9f3de01b4cU,
  0x3d886cbb3d3bcbf6U, 0xbdb00016bd34f779U, 0xbd8b7e723d6dcb42U, 0x3c9509cabd32e246U,
  0x3c75754fbd8f405bU, 0x3d14d3423d0e8f78U, 0x3d4459893a7a445cU, 0xbc9ed09d3dc31e63U,
  0x3d85292c3d9ed5c6U, 0x3d84dd9bbd964cebU, 0x3dd345a93d2caadeU, 0x3d24d681bd9e3ebbU,
  0x3dd48641bcdbcf00U, 0xbd9757adbc781c32U, 0xbe03b72cbd293c2eU, 0xbe027fb93d8b9ebcU,
  0xbdcbdca2bcfc4d86U, 0xbe19c6673dc805c3U, 0xbd6f99b93d89499eU, 0xbdca5ce83cb23e89U,
  0xbdaa6f033d7b99a3U, 0x3e142a4d3db72d90U, 0xbd61e1efbd5e1411U, 0x3db24aefbd5c7910U,
  0x3d8bb63cbd8bfb71U, 0x3dccc661bc9d16e4U, 0xbaf279793d5f01a2U, 0xbdb738efbd0c1258U,
  0x3de2f82fb929a195U, 0xbcc6d57ebd45b168U, 0xbc8bd06cbe22743dU, 0x3ce327bebdeb0b15U,
  0xbc48de383bac94a7U, 0xbd5e48ba3d6efe85U, 0xbde994efbdc96470U, 0xbdce29aa3d2fcdf1U,
  0x3de16ceb3d8dd806U, 0x3da94f6cbd9d7242U, 0xbd3c7fcabdd342a5U, 0x3d99489c3dd07858U,
  0xbc18061dbc0ae509U, 0xbdc25b9f3d98e568U, 0x3d43fc8ebd3fa877U, 0x3da366bfbdcc110aU,
  0xbdab22cabdbe72aeU, 0x3d95666d3cea5d9dU, 0xbdc33f823da85122U, 0xbdcbd4d8bdbbe798U,
  0xbc817a503d632103U, 0xbd00ba773d893d85U, 0xbdb778253d50bd21U, 0x3c6a72143d9129c7U,
  0xbccf84afbd8c64d9U, 0xbda96d7f3d5a55dcU, 0xbb13ff4a3d500f33U, 0xbc9366923c25eea2U,
  0x3a346247bac90b63U, 0xbc719abf3da4b278U, 0x3dbf1c763d08892dU, 0xbc40f51a3be1a711U,
  0x3a99b3c5bd3fa1beU, 0x3db7793cbdcc33d1U, 0x3d9e62d3bdb5aa5dU, 0x3d2b8ec5bda4a86dU,
  0x3d8bba243c3e21d2U, 0xbcc0b71e3dcfca8aU, 0xbd8d5c5e3dc97bd1U, 0xbd99a171bda13441U,
  0xbdbb95503d0be755U, 0xbdc48684bd946205U, 0xbcfd8f513c72de1fU, 0x3da7af50bd863d5cU,
  0xbd5e3f2cbcd2a604U, 0x3c46af61bd139324U, 0xbd28a9fc3cecd77cU, 0xbcf5c24ebbdb0284U,
  0xbda6f486bd93852aU, 0xbb42de4e3da95489U, 0x3cac15323d6f6125U, 0xbda8299d3d7ad0f3U,
  0x3b966e07bc8ae77cU, 0xbc3627a93d6b9c59U, 0xbd3b93ffbb74e50bU, 0xbd95da003d1b9106U,
  0xbd6aa218bc940576U, 0xbb746328bd5fbc91U, 0x3cc67be9bd1f2f4eU, 0x3d5ac9a8bdc99b89U,
  0xbd1104673d04ecc2U, 0xbdacb96f3d420144U, 0x3cc6609cbd5042b1U, 0x3db590d2bdacbb11U,
  0xbcdc39ef3d5977afU, 0xbd48f9733dada616U, 0xbdb1ae383cf11ae9U, 0x3da60c653d90f0eeU,
  0x3dcbfc5e3d2d3238U, 0xbc7a8581bdbaa6b7U, 0x3ce463fbbd2ec4ffU, 0x3d042ee0bd8e268bU,
  0xbdd424c0bdc0b9b5U, 0x3d4675ed3d6f884dU, 0xbd5269b5bdb66de3U, 0x3c2dd0db3d41a4caU,
  0x3dcd0cf2bc9de680U, 0x3c9b53373dbc21e1U, 0xbda1cccbbd625b83U, 0xbd60a1aebdd75931U,
  0xbda891edbd97b1a4U, 0x3dcc0befbd81ee72U, 0xbbdd2260bbb3e39cU, 0x3dc2e51c3cb76d6bU,
  0xbd3055443da38f1cU, 0x3d1c0e033ca4248dU, 0xbda9569d3d276e28U, 0x3cb6082ebd8985b9U,
  0xbd9cea06bd793229U, 0xbc6345eb3d6ad297U, 0x3ce8b98bbd8e0e49U, 0xbd9181d2bda87919U,
  0x3ab14fdc3c6b0648U, 0x3ca4fe12bd6da2f2U, 0xbd980fcbbdc19e5fU, 0x3d232d443d4754f3U,
  0xbcdabea4bda028e5U, 0x3cc7e3cabd39ce08U, 0xbdc511283c19c500U, 0xbd102ae63db927dbU,
  0xbdad67babd8ce735U, 0xbc9db6eb3d81ed0cU, 0x3db6816d3d1425d8U, 0xbdc385c03aaf4ef1U,
  0x3dae936aba9d1f53U, 0xbd243b86bbdc5e22U, 0x3d9d503f3d3c963cU, 0x3ca878113c8b3ad0U,
  0x3d46066b3dd2862aU, 0x3db7929e3cfc85e4U, 0xbd8a5cfe3d9cc905U, 0x3dbce5183d922bbeU,
  0x3d8356113d54b5d4U, 0xbd276b13bd2121e3U, 0xbd8ed697bdd1e29fU, 0x3d4f986f3db0ed1bU,
  0xbda6f0fcbd5c2253U, 0xbd3dd6043dacd2a0U, 0xbd17f9c8bd8ba01dU, 0xbd9000de3c02cc2fU,
  0x3d661e7cbd964787U, 0xbcfaac17bc3ec2bdU, 0xbdd60188bd46c512U, 0x3d60c6bbbd4d50e0U,
  0xbc1bcdc9bda73344U, 0xbdd49ebf3dc48ae9U, 0x3c44d6a23caf2dd7U, 0x3d814dc43d92f9a1U,
  0xbd451d973d3465e3U, 0x3da302c03d4f848dU, 0xbdb83c2c3db3c4a3U, 0x3c1f3e4a3cc2cd39U,
  0x3c9e5d823b7901ceU, 0xbc8eb71b3d1e505fU, 0xbd925c3a3d2ec4c2U, 0x3dace6eebda48abaU,
  0x3bd90101bc23013cU, 0xbd53682fbdc7b0e2U, 0xba9e96043d4727c7U, 0xbdcd4b24bdd1c757U,
  0xbd58b8a5bd01ba01U, 0xbd8f797a3cb07809U, 0x3c97c0fa3b7869e4U, 0xbc8f4155bd91d893U,
  0xbdb141f53dbc6a05U, 0x3ce7d7e5bdc3adb8U, 0xbb5df68f3c4bf0bbU, 0x3d6976d1bd9d3995U,
  0xbd7360633cb81e8aU, 0xbd3339cabd454f6aU, 0x3d8102993cdff29bU, 0x3daeb18ebcc131e6U,
  0x3dca65c13c8e5e64U, 0xbd9e2f3cbdcda0ebU, 0x3c27ed71bd6a1ee3U, 0xbdda85d13d048034U,
  0xbcc598e4bd9fd077U, 0xbc888e173dd2c72fU, 0xbc81b25a3ca3e6d2U, 0xbdb27afabd4fa5f4U,
  0x3c4a036dbc90fecbU, 0xbd883590bdba7df0U, 0x3d913a733dd3e1deU, 0x3d46f98cbcce93deU,
  0x3dca626abbd15de1U, 0x3d8a19a73dc738f8U, 0x3caf4d2cbbbdf274U, 0x3c8a3e52bdc3cae5U,
  0xbd51bcc13dc0bfa8U, 0xbd74a164bb93b41aU, 0xbd8134bc3d34ea37U, 0x3d8a5991bda7b1b1U,
  0x3db56847bd6595b5U, 0x3b9b1e7bbd0bd0a0U, 0xbda680ebbc6dea90U, 0x3daf433ebcb1e44bU,
  0x3dad75b1bdd059cdU, 0x3d862c583d20fbdbU, 0xbda446da3ccd3c00U, 0xbd4715153d1ba9deU,
  0xbdb711b33d5476fbU, 0xbdb3e838bce1b927U, 0xbdd1e7a23c2f68afU, 0xbdba33ecbd3faf5aU,
  0x3daa7d43bd23ba3fU, 0x3d2f2f413b13f2feU, 0xbd9497debd89c7a7U, 0xbd0429a23dc39026U,
  0xbaad7186bd0db3d2U, 0x3cb7e2bdbcaf42b2U, 0xbd6e3b993dd2a7f7U, 0x3db7f54aba69c5afU,
  0xbce02a263d15bb4eU, 0xbcd9c549bdbc869bU, 0xbdbdcf193d30ef6dU, 0x3cbe271a3cdbeb67U,
  0xbd87d8dbbd85ed23U, 0x3dbab474bcec9d03U, 0x3d16d54abd3aaeaaU, 0xbd93a4bfbd7e363fU,
  0x3c7876163ce7957eU, 0x3c25a2dcbcbb6744U, 0x3dd31fb3bdc3e1e9U, 0xbc88ef853cdee6bfU,
  0xbca686febd97c1c3U, 0x3d54be65bb6911fcU, 0x3dd741a23db9a571U, 0xbdaf9db8bdc7ed46U,
  0x3db51d3c3c2d05e4U, 0xbdd28c1cbd9f9b78U, 0xbd5e94693c225d11U, 0x3da911533dc1c6eaU,
  0xbbf448be3db0f107U, 0x3d8d0f0fbd9c9275U, 0xbdaf5edcbd036a17U, 0xbca96cecbd98e2a9U,
  0xbd84c526bd9b261eU, 0xbd573629bc8a7ea8U, 0xbdc5ad26bcef61a4U, 0xbd287102bd974e19U,
  0xbcb863e1baa55decU, 0xbc8fedde3d77c600U, 0x3d72a763bdceb87bU, 0xbd27feaf3dc90470U,
  0x3db45537bd8701c3U, 0xbd4196463d912911U, 0xbc39f7023d81a80cU, 0xbdadc8983dc69d02U,
  0x3d25a6b3bd7043ccU, 0x3dc06f24bd7c88ecU, 0xbd8e4c653d6ad685U, 0xbdd17aaf3d1c5033U,
  0x3d1f5024bcd75da8U, 0xbca83cea3c1d31d6U, 0x3b1b142fbd0e8815U, 0x3c53a9a6bc6a3cd9U,
  0xbd9cdb3e3ced4b82U, 0x3d0d99b33d975df4U, 0x3da2a376bd4c2d9dU, 0xbd2b8748bce5f3f6U,
  0x3dc4d1fdbcb6ea5aU, 0xbcdb14893c866986U, 0xbd8e27643d2cde0dU, 0x3c1af801bd28144dU,
  0x3cb06be33ce43be5U, 0x3da0b5563db9d954U, 0xbc290ec5bd7cd3e2U, 0x3d88dbcabcc0986bU,
  0x3bf6ccb03bc063f5U, 0x3d90e327bda666e4U, 0xbd02cef33c5cff29U, 0xbd6c2400bdae583dU,
  0x3da0d49d3be8eee1U, 0xbc79f67bbd7da088U, 0x3d9d9ace3dc1e7f0U, 0x3d7bbaabbdcfe91fU,
  0xbcf29f6c3ceee6eeU, 0xbd6e4bbd3c6151dfU, 0xbd9752fd3ce89fe4U, 0xbd96a9fb3d5ad486U,
  0xbc2e04aa3dbd63faU, 0xbd5d7a3ebd9832ecU, 0x3d96665dbd616e7cU, 0xb9ef15413d8dc0adU,
  0x3dacf3cc3d9ebc4eU, 0x3cba2f02bd304a1eU, 0xbdb039dcbdbe0f20U, 0xbc5da5a8bd7192b6U,
  0xbce5b17a3a458e2cU, 0xbb3d2f1cbd38dc39U, 0xbddb58763cabfbfeU, 0xbc8f3622bd81cf36U,
  0xbcda133dbd9713b8U, 0x3dc1ba8cbbb07443U, 0xbd49b2ca3d598defU, 0xbce64d1f3d546ef4U,
  0x3d0bbb34bd4ace8aU, 0xbdd67481bc458651U, 0x3d69e03cbd70c96fU, 0xbd0730f0bce6bb61U,
  0x3d7be21bbdb71b66U, 0xbcb0953bbda86b71U, 0xbc0e37613d8e1ff6U, 0x3d8fa521bcd9d15bU,
  0xbc8393353d045beaU, 0x3d4cbc6dbdada027U, 0x3dbdf782bdc28f2aU, 0x3dc69479bda60836U,
  0x3da52e823dd6803cU, 0xbcdaf8983d92c225U, 0x3da183e63dd18596U, 0xbdd31a1c3c4676a9U,
  0x3cf3199e3d4955bfU, 0xbc9abf9ebcdcd82cU, 0x3d5ddbdbbdd52b18U, 0x3d079e7b3da0415cU,
  0xbdc80dcd3ce6f5ceU, 0x3d966ef8bc7e28fdU, 0x3ca4d66abd9c72aeU, 0xbd3e3d6f3c9ba59aU,
  0x3d9ce4c83d3d3981U, 0x3dcfe405bcfa75ffU, 0xbcae100dbdb0d031U, 0x3d13ea5cbc7b16e2U,
  0xbbc179cc3cb20142U, 0xbd092095bd29d8a6U, 0xbda49c82bda0eb06U, 0xbd9436b7bdd089c4U,
  0xbd2c4fbd3d5e99bdU, 0x3d0b7fb53c920fb5U, 0x3db8f99ebd83de3aU, 0x3d2f91d43d050eeaU,
  0xbd77ad553d92ecafU, 0xbdacf879bd8a1829U, 0x3da3fad83d1d4d4eU, 0x3d0a1636bd996754U,
  0x3cd1e2773dbc8c72U, 0x3d7e34c23da81314U, 0x3d27c3de3d856108U, 0x3d070aa83d70efcfU,
  0x3d57206c3ca0f568U, 0xbdcfc1b23da772baU, 0xbd17f56c3d8f73beU, 0x3d31fa1b3d33fdfcU,
  0xbcd4b0b4bdce6c0aU, 0x3c5651e53c5716e1U, 0x3ce4378bbd35f464U, 0x3d1eb2e43ca55549U,
  0xbcf0e1973c892930U, 0xbcdadba03d9bf6b9U, 0xbcac2c32bdd46a8cU, 0xbdbf392ebdc3b56eU,
  0x3dd4a5883d99b7e9U, 0xbd44c1ddbd305e57U, 0x3bd025293d6629aaU, 0xbda477a23d438f47U,
  0x3dc838763d81c4ffU, 0xbd8fab943c1f1ac7U, 0xbd1efbf8bd973d4aU, 0x3cfac2e03dcb4ed9U,
  0xbd86b623bdacfd03U, 0xbd9d84a73dbf8addU, 0xbcbe6f38bda47a0cU, 0xbc9fabccbd92f144U,
  0xbdd5823cbb203c0cU, 0xbc8e06cdbcde27e9U, 0x3cf68307bd891242U, 0x3ce21158bcbcc4e0U,
  0xbcdfc1c3bdad59e2U, 0x3d7d6f85bbcbc805U, 0x3cdf7bcdbdba9b62U, 0x3dc93b763cc852f0U,
  0xbcced0d1bdaa3444U, 0x3dad3c90bd4c1447U, 0xbc9c61593d2ccf69U, 0xbcd6c89a3da21ea3U,
  0x3d4b3e78bdc9f617U, 0x3c15d9723d966c33U, 0x3dc7e931bd79ccd1U, 0x3dca3107bd81dd7fU,
  0x3ce3f037bd2e2e52U, 0x3dd1dff03dae2bb2U, 0x3dd36d663d2579b3U, 0x3dd24acd3d9c2b8dU,
  0xbda6cf413d8dac28U, 0xbdaf131c3d192efdU, 0x3cf8f2143d4a698cU, 0xbda88a773d8fb201U,
  0x3bc29a31bd0be571U, 0x3cbf0a63bd41e0f4U, 0x3db11d083d9a52e6U, 0x3da4713ebd9bd462U,
  0x3d67801e38ad2511U, 0xbdb65212bc6be90eU, 0x3bc5af2f3c894661U, 0xbda878d3bdaabe77U,
  0xbdb52a2a3cfc97c0U, 0xbe12cdf43d8ca9f8U, 0xbd993f6cbd508eaeU, 0xbdc0d768bdd12eb5U,
  0x3de4a05ebc871c7bU, 0x3e18f63c3c2d5295U, 0xbb603dabbb3fa82eU, 0xbe652a553ddb3d3eU,
  0x3cb23f923db75027U, 0xbce3309b3d85d1c3U, 0xbdab58923d4a7922U, 0xbd4a806d3c918629U,
  0xbe72a7613dce6fb1U, 0x3dd342cebdd0d2a9U, 0xbca22cf3bd0f84ceU, 0x3e45102f3d26a93bU,
  0xbbdf0c89bc727654U, 0x3d196ce33d6fa09bU, 0xbda5a509bcf9de8fU, 0xbd85d3423d955cebU,
  0x3dcb98efbc13013aU, 0xbc7d01983d8b3c3dU, 0x3db6551c3d87922eU, 0xbcd7c4bcbdd5e30eU,
  0x3d0b2544bc893523U, 0x3d03b0a5bdd300b1U, 0xbd9e447ebc83a623U, 0x3da1359d3d89223eU,
  0xbcc13c39bc9ac1a8U, 0xbcd50b433d6ec68fU, 0xbcee0b673de64a9fU, 0xbd312c77bd78bbf8U,
  0xbd5a9a683d63b393U, 0x3bc64a9bbc1a2f2cU, 0x3b38797b3e46c43dU, 0x3dd5ea3a3cdc26b2U,
  0xbd0474debd4db719U, 0xbe28437b3db6877fU, 0xbb933a2abd979594U, 0xbd0e4e753dc5b4ecU,
  0x3db9d568bd25639bU, 0x3d37b0773d917363U, 0xbdbe721fbdd498dbU, 0xbd9fbf03U,
};


ai_handle g_plantnetwork_weights_table[1 + 2] = {
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
  AI_HANDLE_PTR(s_plantnetwork_weights_array_u64),
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
};

