#!/bin/bash
MINMAX_FILEPATH="../Data/NNmodel/minmax.json"
NORMALIZATION_T_FILEPATH="../Data/Ctemplates/normalization_t.c"
NORMALIZATION_OUTPUT="../Data/Cmodel/normalization.c"

# Parse JSON file and extract values
mapfile -t max_values < <(jq -r '.[].[].max' $MINMAX_FILEPATH)
mapfile -t min_values < <(jq -r '.[].[].min' $MINMAX_FILEPATH)
mapfile -t features   < <(jq -r '.[] | keys[]' $MINMAX_FILEPATH)

# Create the replacement text
echo -e "Normalization set points:\n\n Features   | Min        | Max        \n--------------------------------------"
for ((i=0; i<${#max_values[@]}; i++)); do
    if [ $i -eq 0 ]; then
        text="    {${max_values[i]}, ${min_values[i]}}"
    else
        text+=",\n    {${max_values[i]}, ${min_values[i]}}"
    fi
    printf " %-10s | %-10s | %-10s \n" ${features[i]} ${min_values[i]} ${max_values[i]}
done

# Create a new file with substituted values
cp $NORMALIZATION_T_FILEPATH $NORMALIZATION_OUTPUT

# Replace the placeholder with the replacement text
sed -i "s|\s*\/\/INSERT HERE\s*|$text|" $NORMALIZATION_OUTPUT

echo -e "\nUpdated in $NORMALIZATION_OUTPUT"
