#!/bin/bash
source ./set-env.sh
NNMODEL_PATH=../Data/NNmodel/*.onnx
OUTPUT_PATH=../Data/Cmodel
FIRMWARE_CODE_PATH=../STM32CubeIDE/Application/User/X-CUBE-AI/App
MINMAX_FILEPATH=../Data/NNmodel/minmax.json
NAME=plantnetwork

answer=""
while [[ $# -gt 0 ]]; do
    case "$1" in
        -y)
            answer=Y
            ;;
        *)
            echo "Unknown option: $1"
            exit 1
            ;;
    esac
    shift
done

function update_code () {
    echo "Updating code on firmware..."
    mkdir -p ${FIRMWARE_CODE_PATH}
    cp -t ${FIRMWARE_CODE_PATH} ${OUTPUT_PATH}/*.[ch]
}

${XCUBEAI_PATH} generate --type onnx -n $NAME -m ${NNMODEL_PATH} -o ${OUTPUT_PATH}

if [[ -f $MINMAX_FILEPATH ]]; then
    ./update-normalization.sh
fi

while true; do
    if [[ $answer == "" ]]; then
        read -r -p "Do you wish to update the code on firmware? (Y/N): " answer
    fi
    case $answer in
        [Yy]* )
            update_code
            break;;
        [Nn]* )
            exit;;
        * )
            answer=""
            echo "Please answer Y or N.";;
    esac
done
