/*
 * hdc2080.c
 *
 *  Created on: Feb 14, 2023
 *      Author: mw
 */
#include "hdc2080.h"
extern I2C_HandleTypeDef hi2c2;

static uint8_t device_addr = HDC2080_ADDR1; // device addr with addr to gnd
//static uint8_t meas_config = 0x00; // meas_config register value and does not permform a measuremente
static uint8_t start_meas = 0x01; // starts a measurement with the same configuration set with meas_config
static uint8_t dev_config = 0x00; // device config to have mesurements triggered vis i2c and heater turned off
static uint8_t dev_config_low_res = 0xF1; // starts a measure with 11 bits resolution
// this is the reset value
static uint32_t full_range = 65536; // constant to evaluate the correct temperature and rh

uint8_t hdc2080_init()
{

	if (HAL_I2C_IsDeviceReady(&hi2c2, device_addr << 1, 1, 2000) != HAL_OK)
	{
		/* Return false */
		return 0;
	}

	hdc2080_writedata(device_addr, HDC2080_MEAS_CONFIG, dev_config); // Performs a measurement if the device is ready
	return 1;
}

void hdc2080_writedata(uint8_t device_addr, uint8_t register_addr, uint8_t data)
{
	uint8_t buffer[2];
	buffer[0] = register_addr;
	buffer[1] = data;
	HAL_I2C_Master_Transmit(&hi2c2, device_addr<<1, buffer, 2, 50);
}

uint16_t hdc2080_readtemp()
{
	uint8_t send_buffer[2] = {HDC2080_MEAS_CONFIG, start_meas};
	uint8_t temp_low = 0;
	uint8_t temp_high = 0;
	uint16_t received_data;
	uint8_t addr_temp = HDC2080_TEMP_HIGH;
	HAL_I2C_Master_Transmit(&hi2c2, device_addr<<1, send_buffer, 2, 50); //Starts a Measurements
	HAL_I2C_Master_Transmit(&hi2c2, device_addr<<1, &addr_temp, 1, 50); // Changes pointer position to read Temp MSB
	HAL_I2C_Master_Receive(&hi2c2, device_addr<<1, &temp_high, 1, 50); // Reads the Temp MSB
	addr_temp = HDC2080_TEMP_LOW;
	HAL_I2C_Master_Transmit(&hi2c2, device_addr<<1, &addr_temp, 1, 50); // Changes pointer position to read Temp LSB
	HAL_I2C_Master_Receive(&hi2c2, device_addr<<1, &temp_low, 1, 50); // Reads the Temp LSB
	received_data = (temp_high << 8) | temp_low;



	return received_data;
}

uint16_t hdc2080_readrh()
{
	uint8_t send_buffer[2] = {HDC2080_MEAS_CONFIG, start_meas};
	uint8_t rh_low = 0;
	uint8_t rh_high = 0;
	uint16_t received_rh;
	uint8_t addr_rh = HDC2080_HUM_HIGH;
	HAL_I2C_Master_Transmit(&hi2c2, device_addr<<1, send_buffer, 2, 50); //Starts a Measurements
	HAL_I2C_Master_Transmit(&hi2c2, device_addr<<1, &addr_rh, 1, 50); // Changes pointer position to read RH MSB
	HAL_I2C_Master_Receive(&hi2c2, device_addr<<1, &rh_high, 1, 50); // Reads the RH MSB
	addr_rh = HDC2080_HUM_LOW;
	HAL_I2C_Master_Transmit(&hi2c2, device_addr<<1, &addr_rh, 1, 50); // Changes pointer position to read RH LSB
	HAL_I2C_Master_Receive(&hi2c2, device_addr<<1, &rh_low, 1, 50); // Reads the RH LSB
	received_rh = (rh_high << 8) | rh_low;

	return received_rh;
}

float hdc2080_calculate_temp()
{
	uint16_t raw_temp;
	float temp;
	raw_temp = hdc2080_readtemp();
	temp = ((raw_temp * 165) / full_range) - 40.5;
	return temp;
}

float hdc2080_calculate_rh()
{
	uint16_t raw_rh;
	float rh;
	raw_rh = hdc2080_readrh();
	rh = (raw_rh * 100) / full_range;
	return rh;
}
