/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * @file           : main.c
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * Copyright (c) 2021 STMicroelectronics.
 * All rights reserved.
 *
 * This software is licensed under terms that can be found in the LICENSE file
 * in the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "i2c.h"
#include "app_lorawan.h"
#include "tim.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "adc.h"
#include "adc_if.h"
#include "hdc2080.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
//uint8_t sen_4_main = 0;
//uint8_t sen_3_main = 0;
//uint8_t val_1 = 0;
//uint8_t val_2 = 0;
//float temp_main = 0;
//uint8_t flag_i2c = 0;
uint8_t flag_init_hdc = 0;
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */
//uint8_t sen_bz_1_main();
//uint8_t sen_bz_2_main();
/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* Init STM genuine check (CRC) */
  __HAL_RCC_CRC_CLK_ENABLE();

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_LoRaWAN_Init();
  MX_I2C2_Init();
  MX_TIM1_Init();
  MX_TIM2_Init();
  /* USER CODE BEGIN 2 */
  HAL_GPIO_WritePin(GPIOB, EN_SEN_3_Pin, GPIO_PIN_RESET);
  HAL_GPIO_WritePin(GPIOC, EN_SEN_1_Pin, GPIO_PIN_RESET);
  HAL_GPIO_WritePin(GPIOA, EN_SEN_4_Pin, GPIO_PIN_RESET);
  HAL_GPIO_WritePin(GPIOB, EN_SEN_2_Pin, GPIO_PIN_RESET);
  HAL_GPIO_WritePin(GPIOA, IMP_EN_Pin, GPIO_PIN_RESET);
  HAL_GPIO_WritePin(GPIOC, EN_WT_Pin, GPIO_PIN_RESET);
  CLEAR_BIT(DBGMCU->CR, DBGMCU_CR_DBG_STOP);
  CLEAR_BIT(DBGMCU->CR, DBGMCU_CR_DBG_SLEEP);
  CLEAR_BIT(DBGMCU->CR, DBGMCU_CR_DBG_STANDBY);
//  flag_init_hdc = hdc2080_init();
//  MX_ADC_Init();
//  HAL_ADC_DeInit(&hadc);
//  MX_ADC_Init();
//  sen_4_main = sen_bz_1_main();
//  sen_3_main = sen_bz_2_main();
//  flag_i2c = hdc2080_init();
//  temp_main = hdc2080_calculate_temp();
//  HAL_GPIO_WritePin(GPIOA, IMP_EN_Pin, GPIO_PIN_SET); //Start Impedance Modulus
//  HAL_GPIO_WritePin(GPIOA, IMP_EN_Pin, GPIO_PIN_RESET); //Start Impedance Modulus
//
//  HAL_GPIO_WritePin(GPIOC, EN_WT_Pin, GPIO_PIN_SET); //Start Watermark Measurement
//  HAL_GPIO_WritePin(GPIOC, EN_WT_Pin, GPIO_PIN_RESET); //Start Watermark Measurement
//
//  HAL_GPIO_WritePin(GPIOB, EN_SEN_3_Pin, GPIO_PIN_SET); // Set pin to power voltage divider on adc in 7
//  HAL_GPIO_WritePin(GPIOB, EN_SEN_3_Pin, GPIO_PIN_RESET); // Set pin to power voltage divider on adc in 7
//
//  HAL_GPIO_WritePin(GPIOC, EN_SEN_1_Pin, GPIO_PIN_SET); // Set pin to power voltage divider on adc in 7
//  HAL_GPIO_WritePin(GPIOC, EN_SEN_1_Pin, GPIO_PIN_RESET); // Set pin to power voltage divider on adc in 7
//
//  HAL_GPIO_WritePin(GPIOA, EN_SEN_4_Pin, GPIO_PIN_SET); // Set pin to power voltage divider on adc in 7
//  HAL_GPIO_WritePin(GPIOA, EN_SEN_4_Pin, GPIO_PIN_RESET); // Set pin to power voltage divider on adc in 7
//
//  HAL_GPIO_WritePin(GPIOB, EN_SEN_2_Pin, GPIO_PIN_SET); // Set pin to power voltage divider on adc in 7
//  HAL_GPIO_WritePin(GPIOB, EN_SEN_2_Pin, GPIO_PIN_RESET); // Set pin to power voltage divider on adc in 7



  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
	while (1)
	{
    /* USER CODE END WHILE */
    MX_LoRaWAN_Process();

    /* USER CODE BEGIN 3 */
	}
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure LSE Drive Capability
  */
  HAL_PWR_EnableBkUpAccess();
  __HAL_RCC_LSEDRIVE_CONFIG(RCC_LSEDRIVE_LOW);

  /** Configure the main internal regulator output voltage
  */
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_LSE|RCC_OSCILLATORTYPE_MSI;
  RCC_OscInitStruct.LSEState = RCC_LSE_ON;
  RCC_OscInitStruct.MSIState = RCC_MSI_ON;
  RCC_OscInitStruct.MSICalibrationValue = RCC_MSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.MSIClockRange = RCC_MSIRANGE_11;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_NONE;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure the SYSCLKSource, HCLK, PCLK1 and PCLK2 clocks dividers
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK3|RCC_CLOCKTYPE_HCLK
                              |RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1
                              |RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_MSI;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.AHBCLK3Divider = RCC_SYSCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */
// Enable and read ADC in 7
//uint8_t sen_bz_1_main()
//{
//	uint8_t sen_1 = 0;
//	HAL_GPIO_WritePin(GPIOB, EN_SEN_3_Pin, GPIO_PIN_SET); // Set pin to power voltage divider on adc in 7
//	HAL_Delay(200);
//	ADC_ChannelConfTypeDef sConfig = {0};
//	sConfig.Channel = ADC_CHANNEL_7;
//	sConfig.Rank = ADC_REGULAR_RANK_1;
//	if (HAL_ADC_ConfigChannel(&hadc, &sConfig) != HAL_OK)
//	{
//		Error_Handler();
//	}
//
//	HAL_ADC_Start(&hadc);
//	HAL_ADC_PollForConversion(&hadc, 1000);
//	sen_1 = HAL_ADC_GetValue(&hadc);
//	HAL_GPIO_WritePin(GPIOB, EN_SEN_3_Pin, GPIO_PIN_RESET); // Set pin to STOP power voltage divider on adc in 7
//
//	return sen_1;
//}
//
//// Enable and read ADC in 2
//uint8_t sen_bz_2_main()
//{
//	uint8_t sen_2 = 0;
//	HAL_GPIO_WritePin(GPIOC, EN_SEN_1_Pin, GPIO_PIN_SET); // Set pin to power voltage divider on adc in 7
//	HAL_Delay(200);
//	ADC_ChannelConfTypeDef sConfig = {0};
//	sConfig.Channel = ADC_CHANNEL_2;
//	sConfig.Rank = ADC_REGULAR_RANK_1;
//	if (HAL_ADC_ConfigChannel(&hadc, &sConfig) != HAL_OK)
//	{
//		Error_Handler();
//	}
//
//	HAL_ADC_Start(&hadc);
//	HAL_ADC_PollForConversion(&hadc, 1000);
//	sen_2 = HAL_ADC_GetValue(&hadc);
//	HAL_GPIO_WritePin(GPIOC, EN_SEN_1_Pin, GPIO_PIN_RESET); // Set pin to STOP power voltage divider on adc in 7
//
//	return sen_2;
//}

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
	/* User can add his own implementation to report the HAL error return state */
	__disable_irq();
	while (1)
	{
		NVIC_SystemReset();
	}
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
	/* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
	while (1)
	{
	}
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
