#include "stdint.h"
#include "math.h"
#include "stm32wlxx_hal.h"


#ifndef HDC2080_H_
#define HDC2080_H_

#define HDC2080_ADDR1 0x40 // If ADDR GND or floating
#define HDC2080_ADDR2 0x41 // VDD
 
// Register Addresses
#define HDC2080_TEMP_LOW	0x00
#define HDC2080_TEMP_HIGH	0x01
#define HDC2080_HUM_LOW 	0x02
#define HDC2080_HUM_HIGH 	0x03
#define HDC2080_DRDY        0x04
#define HDC2080_TMAX		0X05
#define HDC2080_HMAX		0X06
#define HDC2080_TINT_EN		0X07
#define HDC2080_T_OFF_ADJ	0X08
#define HDC2080_H_OFF_ADJ	0X09
#define HDC2080_T_THR_LOW	0X0A
#define HDC2080_T_THR_HIGH	0X0B
#define HDC2080_H_THR_LOW	0X0C
#define HDC2080_H_THR_HIGH	0X0D
#define HDC2080_RST_INT_CONF		0X0E
#define HDC2080_MEAS_CONFIG			0X0F
#define HDC2080_MAN_ID_LOW			0XFC
#define HDC2080_MAN_ID_HIGH			0XFD
#define HDC2080_DEV_ID_LOW			0XFE
#define HDC2080_DEV_ID_HIGH			0XFF

// LIST OF FUNCTIONS
void hdc2080_writedata(uint8_t device_addr, uint8_t register_addr, uint8_t data ); //This function is used to write data to different registers.

uint16_t hdc2080_readtemp(); // reads temperature
uint8_t hdc2080_init(); // initialize the sensor in trigger mode and permorms one measurement
float hdc2080_calculate_temp(); // reads temperature from the sensor and converts it into decimal numbers
uint16_t hdc2080_readrh(); // reads humidity
float hdc2080_calculate_rh(); // reads humidity from the sensor and converts it into decimal numbers




#endif
