#include "bfp_fpga.h"
#include "matrix_multiply.h"
#include <hls_math.h>
#include <ap_int.h>
#include <ap_fixed.h>
#include <iostream>
void generateRandomMatrix(double matrix[MATRIX_SIZE][MATRIX_SIZE]) {
	    for (int i = 0; i < MATRIX_SIZE; i++) {
	        for (int j = 0; j < MATRIX_SIZE; j++) {
	            matrix[i][j] = -100.0 + static_cast<double>(rand()) / (static_cast<double>(RAND_MAX/200.0));
	        }
	    }
	}
void generateRandomdoublearray(double a[ARRAY_SIZE]) {
	    for (int i = 0; i < ARRAY_SIZE; i++) {
	    	a[i] = -100.0 + static_cast<double>(rand()) / (static_cast<double>(RAND_MAX/200.0));
	    }
	}
void printMatrix(const double matrix[MATRIX_SIZE][MATRIX_SIZE]) {
    for (int i = 0; i < MATRIX_SIZE; i++) {
        for (int j = 0; j < MATRIX_SIZE; j++) {
            std::cout << std::setw(10) << std::fixed << matrix[i][j] << " ";
        }
        std::cout << std::endl;
    }
}
int main() {
  std::srand(static_cast<unsigned int>(std::time(nullptr)));

  double Amatrix[MATRIX_SIZE][MATRIX_SIZE];
    double Bmatrix[MATRIX_SIZE][MATRIX_SIZE];

    generateRandomMatrix(Amatrix);
    generateRandomMatrix(Bmatrix);
    std::cout << "\nAmatrix:" << std::endl;
    printMatrix(Amatrix);

    std::cout << "\nBmatrix:" << std::endl;
    printMatrix(Bmatrix);
	//double input_A[MATRIX_SIZE], input_B[MATRIX_SIZE];
	double Cmatrix_bfp[MATRIX_SIZE][MATRIX_SIZE] = {0};
	//double array1[MATRIX_SIZE][MATRIX_SIZE]= {0};
     /* double Amatrix[7][7] = {
    	      {1, 1, 1, 1, 1, 1, 1},
    	        {1, 1, 1, 1, 1, 1, 1},
    			{1, 1, 1, 1, 1, 1, 1},
				{1, 1, 1, 1, 1, 1, 1},
				{1, 1, 1, 1, 1, 1, 1},
				{1, 1, 1, 1, 1, 1, 1},
				{1, 1, 1, 1, 1, 1, 1}
    };

     double Bmatrix[7][7] = {
      	      {1, 1, 1, 1, 1, 1, 1},
       	        {1, 1, 1, 1, 1, 1, 1},
       			{1, 1, 1, 1, 1, 1, 1},
   				{1, 1, 1, 1, 1, 1, 1},
   				{1, 1, 1, 1, 1, 1, 1},
   				{1, 1, 1, 1, 1, 1, 1},
   				{1, 1, 1, 1, 1, 1, 1}
    };*/
     double Cmatrix[MATRIX_SIZE][MATRIX_SIZE];
	BfpMatrix::bfp_t bfpa;
	BfpMatrix::bfp_t bfpb;
	BfpMatrix::bfp_dot_product_t C_matrix_data;
	double array[MATRIX_SIZE][MATRIX_SIZE]={0};
	double result_array=0;
	BfpMatrix bfp_matrix_multiply;
	double input_A[MATRIX_SIZE]={0}, input_B[MATRIX_SIZE]={0};
	for(int i = 0; i < MATRIX_SIZE; ++i) {
	    for(int k = 0; k < MATRIX_SIZE; ++k) {
	        input_A[k]= Amatrix[i][k];
	    }
	    for(int j = 0; j < MATRIX_SIZE; ++j) {
	        for(int k = 0; k < MATRIX_SIZE; ++k) {
	            input_B[k] = Bmatrix[k][j];
	        }
	        BfpMatrix::bfp_t bfpa=init(input_A);
	        BfpMatrix::bfp_t bfpb=init(input_B);
	        C_matrix_data=matrix_multiply(bfpa,bfpb);
	        //std::cout << "result_array1111: " << result_array<< std::endl;
	        bfp_matrix_multiply.to_double_array(C_matrix_data.data,C_matrix_data.exp, result_array);
	        array[i][j]=result_array;
	    }

	}
	double max_diff = 0.0;
	double sum_diff = 0.0;
	for (int i = 0; i < MATRIX_SIZE; ++i) {
		for (int j = 0; j < MATRIX_SIZE; ++j) {
			for (int k = 0; k < MATRIX_SIZE; ++k) {
				Cmatrix[i][j] += Amatrix[i][k] * Bmatrix[k][j];
			}
		}
	}

	std::cout << "matrix C computered by fp:\n";
	for (int i = 0; i < MATRIX_SIZE; ++i) {
		for (int j = 0; j < MATRIX_SIZE; ++j) {
			std::cout << std::setw(10) << std::fixed <<Cmatrix[i][j] << " ";
		}
		std::cout << std::endl;
	}

	std::cout << "matrix C computered by bfp:\n";
	for (int i = 0; i < MATRIX_SIZE; ++i) {
		for (int j = 0; j < MATRIX_SIZE; ++j) {
			std::cout <<std::setw(10) << std::fixed << array[i][j] << " ";
		}
		std::cout << std::endl;
	}

	double diff[MATRIX_SIZE][MATRIX_SIZE];
	std::cout << "different between bfp and fp:\n";
	for (int i = 0; i < MATRIX_SIZE; ++i) {
		for (int j = 0; j < MATRIX_SIZE; ++j) {
			diff[i][j]=array[i][j]-Cmatrix[i][j];
			max_diff = std::max(max_diff, abs(diff[i][j]));
			sum_diff += abs(diff[i][j]);
			std::cout << std::setw(10) << std::fixed <<abs(diff[i][j]) << " ";
		}
	}
	std::cout << "\nMax difference: " << max_diff << std::endl;
	std::cout << "Average difference: " << sum_diff / (MATRIX_SIZE*MATRIX_SIZE) << std::endl;
	std::cout << "---------------------------- ADD-SUB------------------------------" << std::endl;
	double a[ARRAY_SIZE];
	double b[ARRAY_SIZE];
	double c[ARRAY_SIZE];
	double c_from_bfp[ARRAY_SIZE];
	double diff_add[ARRAY_SIZE];
	max_diff = 0.0;
	sum_diff = 0.0;
	generateRandomdoublearray(a);
	generateRandomdoublearray(b);
	std::cout << "ADD result C computered by fp:\n";
	for (int i = 0; i < ARRAY_SIZE; ++i) {
		c[i]=a[i]+b[i];
		std::cout << std::setw(10) << std::fixed <<c[i] << " ";
	}
	std::cout << std::endl;
	bfp_fpga <ARRAY_SIZE,16,32,16> bfp;
	bfp_fpga <ARRAY_SIZE,16,32,16>::bfp_t A_double,B_double,result,bfp_a,bfp_b;
	bfp.receive_double(A_double, a);
	bfp.receive_double(B_double, b);
	bfp.bfp_init(bfp_a, A_double);
	bfp.bfp_init(bfp_b, B_double);
	result=A_double+B_double;
	std::cout << "ADD result C computered by bfp:\n";
	bfp.to_double_array_1(result,c_from_bfp);
	for (int i = 0; i < ARRAY_SIZE; ++i) {
		std::cout << std::setw(10) << std::fixed <<c_from_bfp[i] << " ";
	}
	std::cout << std::endl;
	std::cout << "different between fp and bfp:\n";
	for (int i = 0; i < ARRAY_SIZE; ++i) {
		diff_add[i]=c_from_bfp[i]-c[i];
	    max_diff = std::max(max_diff, abs(diff_add[i]));
	    sum_diff += abs(diff_add[i]);
		//if(abs(diff_add[i])>0.0001){
	    std::cout << std::setw(10) << std::fixed <<abs(diff_add[i]) << " ";
		//}
	}
	std::cout << "\nMax difference: " << max_diff << std::endl;
	std::cout << "Average difference: " << sum_diff / ARRAY_SIZE << std::endl;
	max_diff = 0.0;
	sum_diff = 0.0;
	diff_add[ARRAY_SIZE]=0;
	std::cout << "SUB result C computered by fp:\n";
	for (int i = 0; i < ARRAY_SIZE; ++i) {
		c[i]=a[i]-b[i];
		std::cout << std::setw(10) << std::fixed <<c[i] << " ";
	}
	std::cout << std::endl;
	result=A_double-B_double;
	std::cout << "SUB result C computered by bfp:\n";
	bfp.to_double_array_1(result,c_from_bfp);
	for (int i = 0; i < ARRAY_SIZE; ++i) {
		std::cout << std::setw(10) << std::fixed <<c_from_bfp[i] << " ";
	}
	std::cout << std::endl;
	std::cout << "different between fp and bfp:\n";
	for (int i = 0; i < ARRAY_SIZE; ++i) {
		diff_add[i]=c_from_bfp[i]-c[i];
	    max_diff = std::max(max_diff, abs(diff_add[i]));
	    sum_diff += abs(diff_add[i]);
		//if(abs(diff_add[i])>0.0001){
	    std::cout << std::setw(10) << std::fixed <<abs(diff_add[i]) << " ";
		//}
	}
	std::cout << "\nMax difference: " << max_diff << std::endl;
	std::cout << "Average difference: " << sum_diff / ARRAY_SIZE << std::endl;
	std::cout << "---------------------------- FIR------------------------------" << std::endl;
	double input[10] = {10.0, 9.0, 11.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
	double coeffs[4] = {0.1, 0.2, 0.3, 0.4};
	double output1[10];
	double output0;
	double receive_h[4]= {0.0};
	double receive_x[4]= {0.0};
	max_diff = 0.0;
	sum_diff = 0.0;
	BfpFir::bfp_dot_product_t output_data;
	BfpFir::bfp_t receive_h_data,receive_x_data,bfp_h[10],bfp_x[10];
	BfpFir fir_bfp;
	for (int i = 0; i < 10; ++i) {
		int index = 0;
		for (int j = 0; j < 4; ++j) {
			if (i - j >= 0) {
				receive_h[index] = coeffs[j];
				receive_x[index] = input[i - j];
				//std::cout << "receive_h[index]: " << receive_h[index] << std::endl;
				//std::cout << "receive_x[index]: " << receive_x[index] << std::endl;
				index++;
			}
		}
		BfpFir::bfp_t bfpa=init_fir(receive_h);
		BfpFir::bfp_t bfpb=init_fir(receive_x);

		output_data=FIR(bfpa,bfpb);
		fir_bfp.to_double_array(output_data.data,output_data.exp, output0);
		output1[i] = output0;

	}
	std::cout << "Output by BFP: ";
	for (int i = 0; i < 10; ++i) {
		std::cout << output1[i] << ' ';
	}
	std::cout << std::endl;

	double output[10];
	for (int i = 0; i < 10; ++i) {
		output[i] = 0.0;
	}

	for (int i = 0; i < 10; ++i) {
		for (int j = 0; j < 4; ++j) {
			if (i - j >= 0) {
				output[i] += coeffs[j] * input[i - j];
			}
		}
	}
	std::cout << "Output_exp by FP: ";
	for (int i = 0; i < 10; ++i) {
		std::cout << output[i] << " ";
	}
	std::cout << std::endl;
	max_diff = 0.0;
	sum_diff = 0.0;
	diff_add[10]=0;
	for (int i = 0; i < 10; ++i) {
		diff_add[i]=output1[i]-output[i];
	    max_diff = std::max(max_diff, abs(diff_add[i]));
	    sum_diff += abs(diff_add[i]);
		//if(abs(diff_add[i])>0.0001){
	    std::cout << std::setw(10) << std::fixed <<abs(diff_add[i]) << " ";
		//}
	}
	std::cout << "\nMax difference: " << max_diff << std::endl;
	std::cout << "Average difference: " << sum_diff / 10 << std::endl;
	}

