#include "bfp_fpga.h"
#include "matrix_multiply.h"


BfpMatrix::bfp_t init(double a[]) {
	BfpMatrix bfp_matrix_multiply;
	BfpMatrix::bfp_t A_matrix_data,bfp_a;
	bfp_matrix_multiply.receive_double(A_matrix_data, a);
	bfp_matrix_multiply.bfp_init(bfp_a, A_matrix_data);
	return bfp_a;
}
BfpMatrix::bfp_dot_product_t matrix_multiply(BfpMatrix::bfp_t bfp_a,BfpMatrix::bfp_t bfp_b){
	BfpMatrix::bfp_dot_product_t C_matrix_data;
	BfpMatrix bfp_matrix_multiply;
	C_matrix_data = bfp_matrix_multiply.dot_product(bfp_a,bfp_b);
	return C_matrix_data;
	//bfp_matrix_multiply.to_double_array(C_matrix_data.data,C_matrix_data.exp, array);
}

BfpFir::bfp_t init_fir(double a[]) {
	BfpFir bfp_fir;
	BfpFir::bfp_t A_fir_data,bfp_a;
	bfp_fir.receive_double(A_fir_data, a);
	bfp_fir.bfp_init(bfp_a, A_fir_data);
	return bfp_a;
}
void fir_init_bfp(double input[10],double coeffs[4],BfpFir::bfp_t (&bfpa)[10],BfpFir::bfp_t (&bfpb)[10]) {
	double receive_h[4]= {0.0};
	double receive_x[4]= {0.0};
	double output_bfp;
	for (int i = 0; i < 10; ++i) {
		int index = 0;
		for (int j = 0; j < 4; ++j) {
			if (i - j >= 0) {
				receive_h[index] = coeffs[j];
				receive_x[index] = input[i - j];
				index++;
			}
		}
		bfpa[i]=init_fir(receive_h);
		bfpb[i]=init_fir(receive_x);
}
}
BfpFir::bfp_dot_product_t FIR(BfpFir::bfp_t bfp_a,BfpFir::bfp_t bfp_b) {
	BfpFir fir_bfp;
	BfpFir::bfp_dot_product_t output_data;
	output_data =fir_bfp.dot_product(bfp_a,bfp_b);
	return output_data;
	//fir_bfp.to_double_array(output_data.data,output_data.exp, array);
}
