%% Clear workspace 


%Remember to run clc clear all 
% Then run "Sim_Initialization.m" script
% Only then run this script
%% Add VI CRT Solver to the current path
addpath_vicrt_2022

%% Simulink variables initialization



% Vehicle parameters
m = 190; % mass vehicle [kg]
l = 1.525; % wheelbase
lF = 0.839; % wheelbase front [m]
lR = 0.686; % wheelbase rear [m]
twf = 1.200; % trackwidth front [m]
twr = 1.200; % trackwidth rear [m]
hcg = 0.204; % heigth vehicle from ground [m]
Jz = 110 ; % Jzz rotational inertia around zz axis [Nm^2]
g = 9.81;   % gravitational acceleration

Rr = 0.237; % wheel radius [m]
Re = Rr*[1 1 1 1]; % matrix wheel radius
ku = 0.0002; % understeering coeff
kr = 0.06747; % 1/tau
Cf = 10000; %44222 25000 10000
Cr = 19000; %30000 12000
mu = 1;

tau = 14.85; % gearbox ratio

Gear_ratio = 14.85;

Jw = 0.3249; %kg-m2 ??
Beta_max= atan(0.02*mu*g); % Eq. 8.31 Rajamani
% RPM threshold PID controller
P_pid = 0.02;
I_pid = 0;
D_pid = 0;
RPM_thresh = 19000; % motor RPM threshold

% Front brakes parameters
mu_b = 0.38;
Af_f = 904.8; % mm^2
rf_f = 101.5; % mm
n_pads_f = 2;
n_pist_f = 4;

% Rear brakes parameters
Af_r = 452.4; % mm^2
rf_r = 83; % mm
n_pads_r = 2;
n_pist_r = 2;


%% calculation of curvature
X_axes = trackC_Step(1,:)';
Y_axes = trackC_Step(2,:)';
XY = [X_axes Y_axes];
[Larc,Raggio,Kcurvature] = curvature(XY);
Kscalar = 1./Raggio;
Vspeed_ref = 0.7*sqrt( (mu*g)./Kscalar );



% kcurv = LineCurvature2D(path_ref');
% V_ref_Kurv = 0.7*sqrt( (mu*g)./kcurv );

%% Customized simulation

vicrt_inputfile = 'SCD23_vdd_send_svm.xml' ;
intstep = 0.001; 

sim('test21_sim.slx') 

OUTPUT=resreader('SCD23_vdd.res');

%% Choose the Path for MPC
%path_ref =  new_trackC_skidpad;

% path_ref =  trackcenter_2;
path_ref =  trackC_doubleLane;
% path_ref =  new_trackC_skidpad;
% path_ref =  trackC_Step;
%path_ref = trackC_circle;



%% generation of plots
% Vehicle position
Tempo = OUTPUT.time_TIME;
X = OUTPUT.chassis_displacements_longitudinal;Y = OUTPUT.chassis_displacements_lateral;
figure(1),
plot(path_ref(1,:),path_ref(2,:),'--k','Linewidth',0.75), grid on, hold on,
plot(X,Y,'-r','Linewidth',1.5),
title('Vehicle position and Path reference','FontSize',22), 
xlabel('Longitudinal Position (X axis) [m]','FontSize',20),
ylabel('Lateral Position (Y axis) [m]','FontSize',20),
legend({'Reference','Veh position TVC OFF','Veh position TVC ON'},'FontSize',17),
set(gca,'FontSize',18),
hold on
% 

% % Velocità Longitudinale su Tempo
% Vel_car = OUTPUT.chassis_velocities_longitudinal/3.6; 
% Vx_ref = Vx0*ones(length(Tempo),1);
% 
% figure(4),
% plot(Tempo(1:end),Vx_ref,'--k','Linewidth',0.75), hold on,
% plot(Tempo(1:end),Vel_car(1:length(Tempo)),'-r','Linewidth',1.5), grid on,
% title('Vehicle longitudinal velocity on Time'), 
% xlabel('Time [s]'), ylabel('Longitudinal velocity (Vx) [m/s]'),
% legend({'Reference velocity','Vehicle velocity TVC OFF','Vehicle velocity TVC ON'})
% hold on

% Mz moment
Kicomp = ans.Ki_elem;
Kocomp = ans.Ko_elem;
Mz_fig = ans.Mz_final;
Tempo = OUTPUT.time_TIME;

figure(5),
%plot(Tempo(1:end),Kicomp(1:length(Tempo)),'-y'),hold on,
%plot(Tempo(1:end),Kocomp(1:length(Tempo)),'-g'),hold on,
plot(1:length(Mz_fig),Mz_fig,'-r','Linewidth',1.5),grid on,
title('Additional moment for TVC on Time','FontSize',22), 
xlabel('Time [s]','FontSize',20), ylabel('Moment (Mz) [Nm]','FontSize',20),
%legend({'integral LQR','proportional LQR','Total Mz'})
legend({'Total Mz from LQR'},'FontSize',17),
set(gca,'FontSize',18)
hold on


% Delta steering
steerMPC = ans.delta_MPC;

figure(6),
plot(1:length(steerMPC),steerMPC,'-r','Linewidth',1.5),
hold on, grid on, 
title('MPC Steering Angle at wheels on Time','FontSize',22), 
xlabel('Time [s]','FontSize',20),
ylabel('Steering angle at wheels [rad]','FontSize',20),
legend({'MPC steering TVC OFF','MPC steering TVC ON'},'FontSize',17),
set(gca,'FontSize',18),
hold on


% yaw rate
yawrateMPC = ans.yawrate_MPC;
yawratecar = ans.yawrate_car;

figure(7),
plot(1:length(yawrateMPC),yawrateMPC,'--g','Linewidth',0.75),
hold on, grid on,
plot(1:length(yawratecar),yawratecar,'-r','Linewidth',1.5),
title('Comparison of Yaw Rate on Time','FontSize',22), 
xlabel('Time [s]','FontSize',20), ylabel('Yaw rate [rad/s]','FontSize',20),
legend({'Yaw rate referece from MPC TVC OFF','Yaw rate vehicle TVC OFF',...
    'Yaw rate referece from MPC TVC ON','Yaw rate vehicle TVC ON'},'FontSize',17),
set(gca,'FontSize',18)
hold on

% Torque
TFL_fig = ans.TFL_out;
TFR_fig = ans.TFR_out;
TRL_fig = ans.TRL_out;
TRR_fig = ans.TRR_out;

figure(8),
plot(1:length(TFL_fig),TFL_fig,'-g','Linewidth',1.5),
hold on, grid on,
plot(1:length(TFR_fig),TFR_fig,'-m','Linewidth',1.5), hold on,
plot(1:length(TRL_fig),TRL_fig,'-r','Linewidth',1.5), hold on,
plot(1:length(TRR_fig),TRR_fig,'c','Linewidth',1.5), hold on,
title('Motor Torques on Time TVC off no mismatch','FontSize',22), 
xlabel('Time [s]','FontSize',20), ylabel('Motor Torques [Nm]','FontSize',20),
legend({'T_{FL}','T_{FR}','T_{RL}','T_{RR}'},'FontSize',17), 
set(gca,'FontSize',18),
hold on

% % deviation of Path coordinates and Position vehicle
% error_Xaxis = path_ref(1,:)'-X(1:length(path_ref),1);
% error_Yaxis = path_ref(2,:)'-Y(1:length(path_ref),1);
% 
% figure(2),
% plot(Tempo(1:length(path_ref)),abs(error_Xaxis),'-b'),grid on,
% title('Deviation of X_coord Path w.r.t Position vehicle'), 
% xlabel('Time [s]'), ylabel('Absolute error (X axis)[mm]'),
% axis([0 25 -1 10]),
% legend({'Deviation of X position TVC OFF','Deviation of X position TVC ON'})
% hold on
% 
% figure(3),
% plot(Tempo(1:length(path_ref)),abs(error_Yaxis),'-b'),grid on,
% title('Deviation of Y_coord Path w.r.t Position vehicle'), 
% xlabel('Time [s]'), ylabel('Absolute error (Y axis)[mm]'),
% axis([0 25 -1 10])
% legend({'Deviation of Y position TVC OFF','Deviation of Y position TVC ON'})
% hold on

% percentuale riduzione steering effort
%deviation yaw rate misures-yaw rate reference