clear all
close all

% generate circle trackcenters

r = 7.1250;
xc0 = 7.1250+5;
yc0 = -r;

N = 1000;

theta = linspace(0,2*pi,N);
x1 = r*sin(theta) + xc0;
y1 = r*cos(theta) + yc0;

%part1
x0 = linspace(0,5+r,200);
y0 = zeros(1,200);

trackC_circle(1,:) = [x0(1,1:end-1),x1];
trackC_circle(2,:) = [y0(1,1:end-1),y1];

figure, 
plot(trackC_circle(1,:),trackC_circle(2,:),'-ob')
axis equal

save Circle_trackcenters.mat 'trackC_circle'