% reference step using Bezier curves
clear all, clc


%part1
x1 = linspace(0,45,181); %distance = 50-0/(N-1)
y1 = zeros(1,181);

% part2
Pt1 = [45;0];
Pt2 = [50;0];
Pt3 = [55;10];
Pt4 = [60;10];
t = linspace(0,1,61);

Pts = kron((1-t).^3,Pt1) + kron(3*(1-t).^2.*t,Pt2) + kron(3*(1-t).*t.^2,Pt3) + kron(t.^3,Pt4);


%part3
x3 = linspace(60,150,361);
y3 = ones(1,361)*10;



trackC_Step(1,:) = [x1,Pts(1,:),x3];
trackC_Step(2,:) = [y1,Pts(2,:),y3];
plot(trackC_Step(1,:),trackC_Step(2,:),'-ob')
axis equal

save Step_TrackCenters.mat 'trackC_Step'