%clear all


addpath('planner', 'Tracks', 'MPC_code', 'Others', 'MPC_aug')
load PP_Library_d20.mat
load CerrinaTrack_ms.mat
load Kc.mat
load LUT2.mat
load trackcenter_2.mat
load DoubleLane_TrackCenters.mat
load Skidpad_trackcenters.mat
load Step_TrackCenters.mat
load new_Skidpad_trackcenters.mat

%Ts = 0.1; 
Ts = 0.05;                  %Sampling time
N = 20;                     %Prediction horizon

% Planner params
track_width = 2;        
ref_length = 2;         % Parameter to get longer reference trajectory horizon


% MPC params

% Constraints
delta_vx = Ts*20;
delta_steering_max = Ts*160*pi/180;
max_speed = 40;

%Model Parameters
%x = [X, Y, psi,Vx, Vy, r]
%u = [delta]

nx = 6;             %number of states  
nu = 1;             %number of inputs
ndu = 1;           %number of rate inputs = nu
nz = nx +2*nu;  %8
nxu = nx + nu;  %7
z0=zeros(nz*N+nxu,1); %87

Q = diag([10 10 0 0 0 0]);            %size nx*nx
P = diag([10 10 0 0 0 0]);            %size nx*nx
Ru = diag([5]);                     %size nu*nu
Rdu = diag([20]);                   %size nu*nu
MPC_Params = struct('N', N, 'Ts', Ts, 'nx', nx, 'nu', nu, 'ndu', ndu, 'Q', Q, 'P', P, 'Ru', Ru, 'Rdu', Rdu);


%3dof vehicle model parameters
m = 190;
Iz = 110 ;
lf = 0.839;
lr = 0.686;
L = 1.525;
W = 0.8;

Weight_f = lr/(lf+lr);
Weight_r = lf/(lf+lr); 

Crf = 10000; %44222
Crr = 19000;

Vx0 = 10;
Vy0 = 0;
psi0 = 0;
r0 = 0;

aA = -(2*(Crf + Crr)/m);
bA = -(2*(lf*Crf - lr*Crr)/m);
cA = -(2*(lf*Crf - lr*Crr)/Iz);
dA= -(2*(lf^2*Crf + lr^2*Crr)/Iz);




%% matrici A e B

% 
%     A_full = [0 0 0               cos(psi0)                   -sin(psi0)        0;  
%               0 0 0               sin(psi0)                    cos(psi0)        0; 
%               0 0 0                   0                            0            1;
%               0 0 0                   0                            0            0;
%               0 0 0  ((-aA*Vy0/(Vx0^2)) -bA*r0/(Vx0^2) -r0)     aA/Vx0     (bA/Vx0 -Vx0);
%               0 0 0     (-cA*Vy0/(Vx0^2) - dA*r0/(Vx0^2))       cA/Vx0         dA/Vx0    ];
% modfca ale
A_full = [0 0    0      1      0        0;  
          0 0    Vx0     0      1        0; 
          0 0     0      0      0        1;
          0 0     0      0      0        0;
          0 0     0      0    aA/Vx0   (bA/Vx0 -Vx0);
          0 0     0      0    cA/Vx0    dA/Vx0];
    
    
B_u1 = [ 0;
         0;
         0;
         0;
      2*Crf/m;
      2*lf*Crf/Iz];





Model_Params = struct('m', m, 'Iz', Iz, 'L', L, 'W', W, 'lf', lf, 'lr', lr, 'Crf', Crf, 'Crr', Crr, 'Weight_f', Weight_f, 'Weight_r', Weight_r);
planner_parameters = [Ts; N; track_width; ref_length; delta_vx; delta_steering_max; max_speed];
