% clc;
% clear all;
K = 2e9;
EI = 1.21e11;
rho = 2600;
A=6.4;
Ar = 3.228;
L = 5.2;
rhor = 2600; 
a=sqrt(EI/(rho*A));
step=0.01;
t2k=0;
t=0;
size=4001;
i=14;
Ft=zeros(i,size);
Ft_mean=zeros(i,size);
q_n=zeros(i,size);
y01_beam=zeros(i,size);
y_rod=zeros(i,size);
y01=zeros(i,size);
y1d1=zeros(i,size);
y1d2=zeros(i,size);
y2d1=zeros(i,size);
y2d2=zeros(i,size);
y_out_d=0;
u_out_d=0;
qn0_beam_out=0;
qn0_rod_out=0;
qn0_con=0;
dqn0_beam_out=0;
dqn0_rod_out=0;
dqn0_con=0;
kb_con = double(table2array(kb_curv_con));
kr_con = double(table2array(kr_curv_con_w));
kb_out = double(table2array(kb_curv_out));
kr_out = double(table2array(kr_curv_out));
wn_con = double(table2array(w_curv_con));
wb_out = double(table2array(wb_curv_out));
wr_out = double(table2array(wr_curv_out));
yi_b_con=0;
vi_b_con=0;
yi_r_con=0;
vi_r_con=0;
yi_out=0;
vi_out=0;
N=25;
z=2;
linestyles = {'--', '-', '-.','-','--','-',':','-','--','-','-.','-','--','-','-.','-','--'};

s0= [50.13, 45.25, 43.17, 41.96, 41.15, 40.59, 40.17, 39.85, 39.6, 39.40, 39.23, 39.10, 38.98, 38];
R=  [40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 500];
curvature= [1/40,1/45, 1/50, 1/55, 1/60, 1/65, 1/70, 1/75, 1/80, 1/85, 1/90, 1/95, 1/100, 1/1000];
%%
% Initial condtion (t=0, static, in-contact phase only)
for i=7:2:14
t=0;
disp(['i=' num2str(i)]);
z=2;
y01(i,1)=us(s0(i),R(i),L,0)-ys1(s0(i),R(i),0,0);
Ft(i,1)=K.*y01(i,1);
      disp(['t=' num2str(t,'%.3f') ' t2k=' num2str(t2k,'%.3f') ' Ft=' num2str(Ft(i,1)/1e6,'%.3f') ' y_rod=' num2str(y_rod(i,1),'%.3f') ' y01_beam=' num2str(y01_beam(i,z),'%.3f') ' FOR SEPARATION: yi_out=' num2str(yi_out,'%.3f') ' vi_out=' num2str(vi_out,'%.3f') ' FOR IN-CONTACT yi_b_con=' num2str(yi_b_con,'%.3f') ' vi_b_con=' num2str(vi_b_con,'%.3f') ' yi_r_con=' num2str(yi_r_con,'%.3f') ' vi_r_con=' num2str(vi_r_con,'%.3f')] )      

for t=step:step:2

    if y01(i,z-1)>=0
    fy1d=ys1(s0(i),R(i),0,t);
    fu1d=us(s0(i),R(i),L,t);
    for n=1:1:N
    q_n(i,z)=qn(s0(i),R(i),t,t2k,kb_con(i,n),kr_con(i,n),wn_con(i,n),yi_b_con,vi_b_con,yi_r_con,vi_r_con);
    fy1d  =  fy1d + phi_nb1(s0(i),0,kb_con(i,n),kr_con(i,n)).*q_n(i,z);
    fu1d  =  fu1d + phi_nr(s0(i),L,kb_con(i,n),kr_con(i,n)).*q_n(i,z);
    
    end
    y1d=fy1d;
    u1d=fu1d;

    else
    fy1d=ys_out(s0(i),R(i),0,t);
    fu1d=B2(s0(i),t);
    for n=1:1:N

    fy1d  =  fy1d + phi_nb_out(s0(i),0,kb_out(i,n)).*qn_b_out(s0(i),R(i),t,t2k,kb_out(i,n),wb_out(i,n),yi_out,vi_out);
    fu1d  =  fu1d + phi_nr_out(L,kr_out(1,n)).*qn_r_out(s0(i),t,t2k,kr_out(1,n),wr_out(1,n),yi_out,vi_out);

    end
    y1d=fy1d;
    u1d=fu1d;

    end

        y01_beam(i,z)=y1d;
        y_rod(i,z)=u1d;
        y01(i,z)=y_rod(i,z)-y01_beam(i,z);
        Ft(i,z)= K.*y01(i,z);

    % Calculating initial displacement and velocity for separation phase
    if y01(i,z) < 0 && y01(i,z-1) > 0 
        t2k = t;
        syms x0 r s xi ts
        ys1d = subs(diff(ys1(s0(i),R(i),s,ts),ts),ts,t2k);
        ys2d = subs(diff(ys2(s0(i),R(i),s,ts),ts),ts,t2k);
        y1d1 = matlabFunction(diff(ys1(s0(i),R(i),s,ts),ts), 'Vars', [x0, r, s, ts]);
        y2d1 = matlabFunction(diff(ys2(s0(i),R(i),s,ts),ts), 'Vars', [x0, r, s, ts]);
        ud1 =  matlabFunction(diff(us(s0(i),R(i),xi,ts),ts), 'Vars', [x0, r, xi, ts]);
        integral_disp = 0;
        integral_vel= 0;

        integral_ys1 = integral(@(s) ys1(s0(i),R(i),s,t2k),-s0(i),0);
        integral_ys2 = integral(@(s) ys2(s0(i),R(i),s,t2k),0,s0(i));
        integral_ys1d = int(ys1d,s,-s0(i),0);
        integral_ys2d = int(ys2d,s,0,s0(i));

        for n=1:1:N
            qn0_con=integral(@(s) rho.*A.*phi_nb1(s0(i),s,kb_con(i,n),kr_con(i,n)).*ys1(s0(i),R(i),s,t2k),-s0(i),0)+...
            integral(@(s) rho.*A.*phi_nb2(s0(i),s,kb_con(i,n),kr_con(i,n)).*ys2(s0(i),R(i),s,t2k),0,s0(i))+...
            integral(@(xi) rhor.*Ar.*phi_nr(s0(i),xi,kb_con(i,n),kr_con(i,n)).*us(s0(i),R(i),xi,t2k),0, L);
            integral1 = integral(@(s) rho.*A.*phi_nb1(s0(i),s,kb_con(i,n),kr_con(i,n)).*y1d1(s0(i),R(i),s,t2k),-s0(i),0);
            integral2 = integral(@(s) rho.*A.*phi_nb2(s0(i),s, kb_con(i,n), kr_con(i,n)).*y2d1(s0(i),R(i),s,t2k),0,s0(i));
            integral3 = integral(@(xi) rhor.*Ar.*phi_nr(s0(i),xi, kb_con(n), kr_con(n)).*ud1(s0(i),R(i),xi,t2k),0,L);
            total_integral = integral1 + integral2 + integral3;
            dqn0_con = double(total_integral);

            integral_phinb1 = integral(@(s) phi_nb1(s0(i),s,kb_con(i,n),kr_con(i,n)),-s0(i),0);
            integral_disp =  integral_disp + integral_phinb1.*qn0_con;
            integral_vel =  integral_vel + integral_phinb1.*dqn0_con;

        end

        yi_out=integral_ys1 + integral_ys2 + integral_disp;
        vi_out=double(integral_ys1d + integral_ys2d + integral_vel);
    end
    
    % Calculating initial displacement and velocity for in-contact phase
    if y01(i,z) > 0 && y01(i,z-1) < 0
        t2k=t;
        syms x0 r s xi ts;
        y_out_d = subs(diff(ys_out(s0(i),R(i),s,ts),ts),ts,t2k);
        u_out_d = subs(diff(B2(s0(i),ts),ts),ts,t2k);
        ydd_out = matlabFunction(diff(ys_out(s0(i),R(i),s,ts),ts), 'Vars', [x0, r, s,  ts]);
        udd_out = matlabFunction(diff(B2(s0(i),ts),ts), 'Vars', [x0, ts]);
        integral_disp_in_b = 0;
        integral_vel_in_b = 0;
        integral_disp_in_r = 0;
        integral_vel_in_r = 0;

        integral_ys_inb = integral(@(s) ys_out(s0(i),R(i),s,t2k),-s0(i),s0(i));
        integral_ys_inb_d = int(y_out_d,s,-s0(i),s0(i));
        integral_ys_inr = L.*B2(s0(i),t2k);
        integral_ys_inr_d = int(u_out_d,xi,0,L);

        for n=1:1:N
        qn0_beam_out = integral(@(s) rho.*A.*phi_nb_out(s0(i),s,kb_out(i,n)).*ys_out(s0(i),R(i),s,t2k),-s0(i),s0(i));
        integral4 = integral(@(s) rho.*A.*phi_nb_out(s0(i),s,kb_out(i,n)).*ydd_out(s0(i),R(i),s,t2k),-s0(i),s0(i));
        qn0_rod_out = integral(@(xi) rhor.*Ar.*phi_nr_out(xi,kr_out(1,n)).*B2(s0(i),t2k),0,L);
        integral5 = integral(@(xi) rhor.*Ar.*phi_nr_out(xi,kr_out(1,n)).*udd_out(s0(i),t2k),0,L);
        
        dqn0_beam_out = double(integral4);
        dqn0_rod_out=double(integral5);
        
        integral_phinb_out = integral(@(s) phi_nb_out(s0(i),s,kb_out(i,n)),-s0(i),s0(i));
        integral_phinr_out = integral(@(xi) phi_nr_out(xi,kr_out(1,n)),0,L);
        integral_disp_in_b = integral_disp_in_b + integral_phinb_out.*qn0_beam_out;
        integral_disp_in_r = integral_disp_in_r + integral_phinr_out.*qn0_rod_out;
        integral_vel_in_b = integral_vel_in_b + integral_phinb_out.*dqn0_beam_out;
        integral_vel_in_r = integral_vel_in_r + integral_phinr_out.*dqn0_rod_out;
        end

        yi_b_con=integral_ys_inb + integral_disp_in_b;
        vi_b_con=double(integral_ys_inb_d + integral_vel_in_b);
        yi_r_con=integral_ys_inr + integral_disp_in_r;
        vi_r_con=double(integral_ys_inr_d + integral_vel_in_r);

    end

    if  y01(i,z)<0 || (y01(i,z)>0 && y01(i,z-1)<0)
    Ft(i,z)=0;
    end
      disp(['t=' num2str(t,'%.3f') ' t2k=' num2str(t2k,'%.3f') ' Ft=' num2str(Ft(i,z)/1e6,'%.3f') ' y_rod=' num2str(y_rod(i,z),'%.3f') ' y01_beam=' num2str(y01_beam(i,z),'%.3f') ' FOR SEPARATION: yi_out=' num2str(yi_out,'%.3f') ' vi_out=' num2str(vi_out,'%.3f') ' FOR IN-CONTACT yi_b_con=' num2str(yi_b_con,'%.3f') ' vi_b_con=' num2str(vi_b_con,'%.3f') ' yi_r_con=' num2str(yi_r_con,'%.3f') ' vi_r_con=' num2str(vi_r_con,'%.3f')] )
      
        z=z+1;
end

end
%% Pounding force filtration
% P(1,1)=K.*y01(1,1);
% for z=2:1:201
%     if  Ft(1,z)<0 || (Ft(1,z)>0 && Ft(1,z-1)<0)
%     P(1,z)=0;
%     else
%     P(1,z)=K.*y01(1,z);
%     end
% 
% end

% t=0:0.001:0.4;
% figure
% xx = 0:0.0001:0.4;
% yy = spline(t,Ft_straightN50(1,1:numel(t))/1e6,xx);
% plot(xx,yy,'LineWidth',1.5)
% hold on
% yy = spline(t,Ft_curvedN50(14,1:numel(t))/1e6,xx);
% plot(xx,yy,'LineWidth',1.5)
% ylim([0,120])
% % yticks(0:15:60)
% title('Pounding Force')
% xlabel('t')
% ylabel('F(t) MN')

%% Radius comparison
figure 
t=0:0.01:2;
xx = 0:0.001:2;
set(gcf, 'Color', 'w')
for i=1:2:14

yy = spline(t,Ft(i,1:numel(t))/1e6,xx);
plot(xx,yy,'LineStyle',linestyles{i},'Linewidth',1.5)
% plot(xx,yy,'Linewidth',1.5)
ylim([0 100])
title('Pounding Force')
xlabel('t [s]')
ylabel('F(t) MN')
hold on
end

yy = spline(t,Ft_straightN25(1,1:numel(t))/1e6,xx);
plot(xx,yy,"black",'Linewidth',1.5)
legend('R=40','R=50','R=60','R=70','R=80','R=90','R=100','R=infinite')

%% Curvature and radius trend
maxF=zeros(14,1);
meanF=zeros(14,1);

for i=1:2:14
z=1;
h=1;
maxF(i,1)=max(Ft(i,:));
for t=0:0.01:2
      if Ft(i,z)>0
          meanF(i,1)=meanF(i,1)+Ft(i,z);
          h=h+1;
          
      end
      z=z+1;
end
meanF(i,1)=meanF(i,1)/h;
end


figure
set(gcf, 'Color', 'w')
i=1:2:14;
semilogx(curvature(i),meanF(i,1)/1e6,"--o")
hold on
semilogx(curvature(i),maxF(i,1)/1e6,"--o")
%xlim([0, 0.03])
%xticks([0:0.001:0.001,0.022:0.0001:0.03])
title('Pounding Force')
xlabel('Curvature [1/m]')
ylabel('Ft [MN]')
legend('Mean Pounding Force','Max Pounding Force')

figure
set(gcf, 'Color', 'w')
i=1:2:14;
semilogx(R(i),meanF(i,1)/1e6,"--o")
hold on
semilogx(R(i),maxF(i,1)/1e6,"--o")
title('Pounding Force')
xlabel('Radius [m]')
ylabel('Ft [MN]')
legend('Mean Pounding Force','Max Pounding Force')

%% Different periods

x=0:0.01:2;

t1=tiledlayout(2,1);
x1=nexttile;
plot(x1,x,Ft_curvedN5(14,1:numel(x))/1e6)
hold on
plot(x1,x,Ft_straightN5(1,1:numel(x))/1e6)
ylim([0 100])
title('N=5')

x2=nexttile;
plot(x2,x,Ft_curvedN10(14,1:numel(x))/1e6)
hold on
plot(x2,x,Ft_straightN10(1,1:numel(x))/1e6)
ylim([0 100])
title('N=10')

x3=nexttile;
plot(x3,x,Ft_curvedN25(14,1:numel(x))/1e6)
hold on
plot(x3,x,Ft_straightN25(1,1:numel(x))/1e6)
ylim([0 100])
title('N=25')

x4=nexttile;
plot(x4,x,Ft_curvedN50(14,1:numel(x))/1e6)
hold on
plot(x4,x,Ft_straightN50(1,1:numel(x))/1e6)
ylim([0 100])
title('N=50')

x5=nexttile;
plot(x5,x,Ft_curvedN100(14,1:numel(x))/1e6)
hold on
plot(x5,x,Ft_straightN100(1,1:numel(x))/1e6)
ylim([0 100])
title('N=100')
ylabel(t,'Pounding force [MN]')
xlabel(t,'Time [s]')
legend('Curved Bridge R=∞','Straight Bridge')




