* 0. CLEAR MEMORY and CLEAR OUTPUT
clear all
cls

* 1. SET PATHS (write the path to the folder in which your data are located)
global path = "C:\Users\maria\Desktop\tesi magistrale\Stata"

* 2. OPEN DATA (recall the path and write the name of the file)
use "$path\Database_Amsterdam.dta"
drop policy 
drop count_total_policy
egen policy = group(CANCELLATIONPOLICY)
egen count_total_policy = total(policy)

drop p99_ADR
drop p99_PROP_HOST
drop p99_REVENUEUSD
drop p99_REVPAN
drop lnADR
drop lnOCCRATE
drop lnPROP_HOST
drop lnREVENUEUSD
drop lnREVPAN

egen p99_REVENUEUSD = pctile(REVENUEUSD), p(99)
gen lnREVENUEUSD = ln(1+REVENUEUSD)

egen p99_REVPAN = pctile(REVPAN), p(99)
gen lnREVPAN = ln(1+REVPAN)

egen p99_ADR = pctile(ADR), p(99)

gen lnADR = ln(1+ADR) 

egen PROP_HOST = count(ID), by (AIRBNBHOSTID REPORTINGMONTH) // conta il numero di proprietà per ogni host
gen lnPROP_HOST = ln(1+PROP_HOST)
egen p99_PROP_HOST = pctile(PROP_HOST), p(99)

gen lnOCCRATE = ln(1+OCCUPATIONRATE)

egen zona_centrale = group(NEIGHBORHOOD)
replace zona_centrale = 1 if NEIGHBORHOOD=="Centrum-West" | NEIGHBORHOOD=="Centrum-Oost" | NEIGHBORHOOD=="De Pijp - Rivierenbuurt" | NEIGHBORHOOD=="Zuid" | NEIGHBORHOOD=="Westerpark" | NEIGHBORHOOD=="Oud-Oost" | NEIGHBORHOOD=="De Baarsjes - Oud-West" | NEIGHBORHOOD=="Oud-Noord" | NEIGHBORHOOD=="IJburg - Zeeburgereiland"

replace zona_centrale = 2 if NEIGHBORHOOD!="Centrum-West" & NEIGHBORHOOD!="Centrum-Oost" & NEIGHBORHOOD!="De Pijp - Rivierenbuurt" & NEIGHBORHOOD!="Zuid" & NEIGHBORHOOD!="Westerpark" & NEIGHBORHOOD!="Oud-Oost" & NEIGHBORHOOD!="De Baarsjes - Oud-West" & NEIGHBORHOOD!="Oud-Noord" & NEIGHBORHOOD!="IJburg - Zeeburgereiland"

drop zona_centrale
drop dummy_policy

gen dummy_policy = .
replace dummy_policy = 0 if inlist(CANCELLATIONPOLICY, "Flexible", "Moderate", "Flexible policy â  Free cancellation within 48 hours", "Free cancellation may be available") 
replace dummy_policy = 1 if inlist(CANCELLATIONPOLICY, "Strict", "Super Strict 60 Days policy")

drop dummy_tipo_alloggio


gen dummy_tipo_alloggio = . 
replace dummy_tipo_alloggio = 1 if inlist(LISTINGTYPE, "Entire home/apt")
replace dummy_tipo_alloggio = 0 if inlist(LISTINGTYPE, "Private room", "Hotel room", "Shared room")

egen media_ADR_generale = mean(ADR), by(YEAR policy)
twoway (line media_ADR_generale YEAR if policy ==1, sort lcolor(gold) lwidth(thick)) (line media_ADR_generale YEAR if policy==4, sort lcolor(blue) lwidth(thick)) (line media_ADR_generale YEAR if policy==5, sort lcolor(red) lwidth(thick)), legend(on)

drop media_ADR_zona

drop media_ADR_generale
egen media_ADR_generale = mean(ADR), by(YEAR policy)

egen media_ADR_zona = mean(ADR), by (YEAR policy zona_centrale)
twoway (line media_ADR_zona YEAR if policy ==1, sort lcolor(gold) lwidth(thick)) (line media_ADR_zona YEAR if policy==4, sort lcolor(blue) lwidth(thick)) (line media_ADR_zona YEAR if policy==5, sort lcolor(red) lwidth(thick)), by(zona_centrale), legend(label(1 "Policy flessibile") label(2 "Policy moderata") label(2 "Policy rigida"))

egen media_ADR_tipoalloggio = mean(ADR), by (YEAR policy LISTINGTYPE)
twoway (line media_ADR_tipoalloggio YEAR if policy ==1, sort lcolor(gold) lwidth(thick)) (line media_ADR_tipoalloggio YEAR if policy==4, sort lcolor(blue) lwidth(thick)) (line media_ADR_tipoalloggio YEAR if policy==5, sort lcolor(red) lwidth(thick)), by(, legend(on)) by(LISTINGTYPE)

drop media_REVPAN

egen media_REVPAN_zona = mean(REVPAN), by (YEAR policy zona_centrale)
twoway (line media_REVPAN_zona YEAR if policy ==1, sort lcolor(gold) lwidth(thick)) (line media_REVPAN_zona YEAR if policy==4, sort lcolor(blue) lwidth(thick)) (line media_REVPAN_zona YEAR if policy==5, sort lcolor(red) lwidth(thick)), by(, legend(on)) by(zona_centrale)


egen media_REVPAN_neglianni = mean(REVPAN), by(YEAR policy)
twoway (line media_REVPAN_neglianni YEAR if policy ==1, sort lcolor(gold)) (line media_REVPAN_neglianni YEAR if policy==4, sort lcolor(blue)) (line media_REVPAN_neglianni YEAR if policy==5, sort lcolor(green)), legend(on)

egen media_REVPAN_tipoalloggio = mean(REVPAN), by (YEAR policy LISTINGTYPE)
twoway (line media_REVPAN_tipoalloggio YEAR if policy ==1, sort lcolor(gold) lwidth(thick)) (line media_REVPAN_tipoalloggio YEAR if policy==4, sort lcolor(blue) lwidth(thick)) (line media_REVPAN_tipoalloggio YEAR if policy==5, sort lcolor(red) lwidth(thick)), by(, legend(on)) by(LISTINGTYPE)

egen media_REVPAN_zona_tipoalloggio = mean(REVPAN), by (YEAR policy zona_centrale LISTINGTYPE)

drop media_OCCRATE_generale
egen media_OCCRATE_generale = mean(OCCUPATIONRATE), by (YEAR policy)
twoway (line media_OCCRATE_generale YEAR if policy ==1, sort lcolor(gold) lwidth(thick)) (line media_OCCRATE_generale YEAR if policy==4, sort lcolor(blue) lwidth(thick)) (line media_OCCRATE_generale YEAR if policy==5, sort lcolor(red) lwidth(thick)), legend(on)

egen media_OCCRATE_zona = mean(OCCUPATIONRATE), by (YEAR policy zona_centrale)
twoway (line media_OCCRATE_zona YEAR if policy ==1, sort lcolor(gold) lwidth(thick)) (line media_OCCRATE_zona YEAR if policy==4, sort lcolor(blue) lwidth(thick)) (line media_OCCRATE_zona YEAR if policy==5, sort lcolor(red) lwidth(thick)), by(, legend(on)) by(zona_centrale)

egen media_OCCRATE_tipoalloggio = mean(OCCUPATIONRATE), by (YEAR policy LISTINGTYPE)
twoway (line media_OCCRATE_tipoalloggio YEAR if policy ==1, sort lcolor(gold) lwidth(thick)) (line media_OCCRATE_tipoalloggio YEAR if policy==4, sort lcolor(blue) lwidth(thick)) (line media_OCCRATE_tipoalloggio YEAR if policy==5, sort lcolor(red) lwidth(thick)), by(, legend(on)) by(LISTINGTYPE)

////// GRAFICI ADR REVPAN E OCCRATE per anni
list YEAR policy media_ADR_generale if YEAR==2019 & policy == 1

list YEAR policy media_ADR_generale if YEAR==2019 & policy == 4

list YEAR policy media_ADR_generale if YEAR==2019 & policy == 5

list YEAR policy media_ADR_generale if YEAR==2020 & policy == 1

list YEAR policy media_ADR_generale if YEAR==2020 & policy == 4

list YEAR policy media_ADR_generale if YEAR==2020 & policy == 5

list YEAR policy media_ADR_generale if YEAR==2021 & policy == 1

list YEAR policy media_ADR_generale if YEAR==2021 & policy == 4

list YEAR policy media_ADR_generale if YEAR==2021 & policy == 5

list YEAR policy media_ADR_generale if YEAR==2022 & policy == 1

list YEAR policy media_ADR_generale if YEAR==2022 & policy == 4

list YEAR policy media_ADR_generale if YEAR==2022 & policy == 5






list YEAR policy media_REVPAN_neglianni if YEAR==2019 & policy == 1

list YEAR policy media_REVPAN_neglianni if YEAR==2019 & policy == 4

list YEAR policy media_REVPAN_neglianni if YEAR==2019 & policy == 5

list YEAR policy media_REVPAN_neglianni if YEAR==2020 & policy == 1

list YEAR policy media_REVPAN_neglianni if YEAR==2020 & policy == 4

list YEAR policy media_REVPAN_neglianni if YEAR==2020 & policy == 5

list YEAR policy media_REVPAN_neglianni if YEAR==2021 & policy == 1

list YEAR policy media_REVPAN_neglianni if YEAR==2021 & policy == 4

list YEAR policy media_REVPAN_neglianni if YEAR==2021 & policy == 5

list YEAR policy media_REVPAN_neglianni if YEAR==2022 & policy == 1

list YEAR policy media_REVPAN_neglianni if YEAR==2022 & policy == 4

list YEAR policy media_REVPAN_neglianni if YEAR==2022 & policy == 5




list YEAR policy media_OCCRATE_generale if YEAR==2019 & policy == 1

list YEAR policy media_OCCRATE_generale if YEAR==2019 & policy == 4

list YEAR policy media_OCCRATE_generale if YEAR==2019 & policy == 5

list YEAR policy media_OCCRATE_generale if YEAR==2020 & policy == 1

list YEAR policy media_OCCRATE_generale if YEAR==2020 & policy == 4

list YEAR policy media_OCCRATE_generale if YEAR==2020 & policy == 5

list YEAR policy media_OCCRATE_generale if YEAR==2021 & policy == 1

list YEAR policy media_OCCRATE_generale if YEAR==2021 & policy == 4

list YEAR policy media_OCCRATE_generale if YEAR==2021 & policy == 5

list YEAR policy media_OCCRATE_generale if YEAR==2022 & policy == 1

list YEAR policy media_OCCRATE_generale if YEAR==2022 & policy == 4

list YEAR policy media_OCCRATE_generale if YEAR==2022 & policy == 5







/////// GRAFICI ADR 
/// ZONA 1
list YEAR policy zona_centrale media_ADR_zona if YEAR == 2019 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2019 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2019 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2020 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2020 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2020 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2021 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2021 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2021 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2022 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2022 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2022 & policy == 5 & zona_centrale==1

// ZONA 2
list YEAR policy zona_centrale media_ADR_zona if YEAR == 2019 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2019 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2019 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2020 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2020 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2020 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2021 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2021 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2021 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2022 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2022 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_ADR_zona if YEAR == 2022 & policy == 5 & zona_centrale==2

//policy Intero appartamento 2019
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2020
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2021
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2022
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Entire home/apt"


//policy stanza privata 2019
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2020
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2021
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2022
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Private room"

//policy stanza condivisa 2019
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2020
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2021
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2022
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Shared room"


//policy stanza hotel 2019
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2020
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2021
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2022
list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_ADR_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Hotel room"











/////// GRAFICI REVPAN

// policy zona 1 
list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2019 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2019 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2019 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2020 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2020 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2020 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2021 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2021 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2021 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2022 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2022 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2022 & policy == 5 & zona_centrale==1

// policy zona 2
list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2019 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2019 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2019 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2020 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2020 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2020 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2021 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2021 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2021 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2022 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2022 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_REVPAN_zona if YEAR == 2022 & policy == 5 & zona_centrale==2

//policy Intero appartamento 2019
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2020
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2021
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2022
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Entire home/apt"

//policy stanza privata 2019
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2020
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2021
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2022
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Private room"

//policy stanza condivisa 2019
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2020
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2021
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2022
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Shared room"


//policy stanza hotel 2019
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2020
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2021
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2022
list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_REVPAN_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Hotel room"



/////// GRAFICI OCCUPATION RATE

// policy zona 1 
list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2019 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2019 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2019 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2020 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2020 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2020 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2021 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2021 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2021 & policy == 5 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2022 & policy == 1 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2022 & policy == 4 & zona_centrale==1

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2022 & policy == 5 & zona_centrale==1

// policy zona 2
list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2019 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2019 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2019 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2020 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2020 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2020 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2021 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2021 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2021 & policy == 5 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2022 & policy == 1 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2022 & policy == 4 & zona_centrale==2

list YEAR policy zona_centrale media_OCCRATE_zona if YEAR == 2022 & policy == 5 & zona_centrale==2

//policy Intero appartamento 2019
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2020
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2021
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Entire home/apt"

// policy intero appartamento 2022
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Entire home/apt"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Entire home/apt"

//policy stanza privata 2019
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2020
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2021
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Private room"

// policy stanza privata 2022
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Private room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Private room"

//policy stanza condivisa 2019
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2020
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2021
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Shared room"

// policy stanza condivisa 2022
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Shared room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Shared room"


//policy stanza hotel 2019
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2019 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2020
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2020 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2021
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2021 & policy == 5 & LISTINGTYPE == "Hotel room"

// policy stanza hotel 2022
list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 1 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 4 & LISTINGTYPE == "Hotel room"

list YEAR policy LISTINGTYPE media_OCCRATE_tipoalloggio if YEAR == 2022 & policy == 5 & LISTINGTYPE == "Hotel room"


// REGRESSIONE

reg REVPAN dummy_policy zona_centrale dummy_tipo_alloggio

reg REVPAN dummy_policy##zona_centrale##dummy_tipo_alloggio

reg REVPAN dummy_policy zona_centrale dummy_tipo_alloggio i.YEAR

testparm dummy_policy##zona_centrale testparm dummy_policy##dummy_tipo_alloggio testparm i.YEAR 

test (REVPAN dummy_policy zona_centrale dummy_tipo_alloggio)


regress REVPAN i.dummy_policy i.zona_centrale i.YEAR i.dummy_tipo_alloggio

regress REVPAN i.dummy_policy##i.zona_centrale##i.YEAR##i.dummy_tipo_alloggio


reg REVPAN i.dummy_policy

regress OCCUPATIONRATE i.dummy_policy##i.zona_centrale##i.YEAR##i.dummy_tipo_alloggio

regress REVPAN i.dummy_policy##i.zona_centrale##i.YEAR##i.dummy_tipo_alloggio




// REGRESSIONE PROFESSORE
// policy e anni
regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy
est store M1

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.YEAR // da capire come raggruppare gli anni
est store M2

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy i.YEAR
est store M3

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy##i.YEAR
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")


// policy e zone
regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy
est store M1

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.zona_centrale // da capire come raggruppare gli anni
est store M2

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy i.zona_centrale
est store M3

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy##i.zona_centrale
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")

// policy e tipo alloggio
regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy
est store M1

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_tipo_alloggio // da capire come raggruppare gli anni
est store M2

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy i.dummy_tipo_alloggio
est store M3

regress REVPAN PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy##i.dummy_tipo_alloggio
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")

//OCCUPATION RATE
// policy e anni
regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy
est store M1

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.YEAR // da capire come raggruppare gli anni
est store M2

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy i.YEAR
est store M3

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy##i.YEAR
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")


// policy e zone
regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy
est store M1

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.zona_centrale // da capire come raggruppare gli anni
est store M2

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy i.zona_centrale
est store M3

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy##i.zona_centrale
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")

// policy e tipo alloggio
regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy
est store M1

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_tipo_alloggio // da capire come raggruppare gli anni
est store M2

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy i.dummy_tipo_alloggio
est store M3

regress OCCUPATIONRATE PROP_HOST RESERVATIONDAYS MINIMUMSTAY MAXGUESTS i.dummy_policy##i.dummy_tipo_alloggio
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")



// CALCOLI PER TABELLE FINALI

// PER ZONA
collapse (mean) REVPAN OCCUPATIONRATE, by(YEAR zona_centrale)
list

// PER TIPO ALLOGGIO
collapse (mean) REVPAN OCCUPATIONRATE, by(YEAR dummy_tipo_alloggio)
list

// PER ANNO
collapse (mean) REVPAN OCCUPATIONRATE, by(YEAR)
list

// numero di osservazioni per zona per anno
table zona_centrale if zona_centrale==1 & YEAR==2019
table zona_centrale if zona_centrale==2 & YEAR==2019

table zona_centrale if zona_centrale==1 & YEAR==2020
table zona_centrale if zona_centrale==2 & YEAR==2020

table zona_centrale if zona_centrale==1 & YEAR==2021
table zona_centrale if zona_centrale==2 & YEAR==2021

table zona_centrale if zona_centrale==1 & YEAR==2022
table zona_centrale if zona_centrale==2 & YEAR==2022



table zona_centrale if YEAR==2019
table zona_centrale if YEAR==2020
table zona_centrale if YEAR==2021
table zona_centrale if YEAR==2022

// numero di osservazioni per tipo alloggio per anno

table dummy_tipo_alloggio if YEAR==2019
table dummy_tipo_alloggio if YEAR==2020
table dummy_tipo_alloggio if YEAR==2021
table dummy_tipo_alloggio if YEAR==2022

// ALTRE STATISTICHE DESCRITTIVE

collapse (mean) REVPAN OCCUPATIONRATE, by(YEAR dummy_policy zona_centrale)
list

collapse (mean) REVPAN OCCUPATIONRATE, by(YEAR dummy_policy dummy_tipo_alloggio)
list





// REGRESSIONE NUOVA PER PRESENTAZIONE
// SENZA RESERVATIONDAYS COME VARIABILE DI CONTROLLO, INSERENDO I MESI E INSERENDO GLI ANNI IN TUTTE LE ANALISI

// policy e anni
regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy
est store M1

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.YEAR 
est store M2

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy i.YEAR
est store M3

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy##i.YEAR
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")



// policy e zone
regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy
est store M1

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.zona_centrale 
est store M2

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy i.YEAR i.zona_centrale 
est store M3

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy##i.YEAR##i.zona_centrale
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")

// policy e tipo alloggio
regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy
est store M1

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_tipo_alloggio 
est store M2

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy i.YEAR i.dummy_tipo_alloggio
est store M3

regress REVPAN PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy##i.YEAR##i.dummy_tipo_alloggio
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")

// policy e anni
regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy
est store M1

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.YEAR // da capire come raggruppare gli anni
est store M2

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy i.YEAR
est store M3

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy##i.YEAR
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")


// policy e zone
regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy
est store M1

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.zona_centrale // da capire come raggruppare gli anni
est store M2

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy i.YEAR i.zona_centrale
est store M3

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy##i.YEAR##i.zona_centrale
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")

// policy e tipo alloggio
regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy
est store M1

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_tipo_alloggio // da capire come raggruppare gli anni
est store M2

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy i.YEAR i.dummy_tipo_alloggio
est store M3

regress OCCUPATIONRATE PROP_HOST MINIMUMSTAY MAXGUESTS i.MONTH i.dummy_policy##i.YEAR##i.dummy_tipo_alloggio
est store M4

esttab M1 M2 M3 M4, cells($cells) stats($stats) starlevels($levelslist) style($style) nobaselevels varwidth(32) nonumbers mtitles("M1" "M2" "M3" "M4")




