function [fitresult, gof] = createFit4(h_t, V_t)
%CREATEFIT4(H_T,V_T)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input: h_t
%      Y Output: V_t
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 13-Mar-2024 15:24:23


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( h_t, V_t );

% Set up fittype and options.
ft = fittype( 'poly1' );

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, xData, yData );
legend( h, 'V_t vs. h_t', 'untitled fit 1', 'Location', 'NorthEast', 'Interpreter', 'none' );
% Label axes
xlabel( 'h_t', 'Interpreter', 'none' );
ylabel( 'V_t', 'Interpreter', 'none' );
grid on


