function [fitresult, gof] = createFit2(t_h, h_t)
%CREATEFIT2(T_H,H_T)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input: t_h
%      Y Output: h_t
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 13-Mar-2024 15:17:07


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( t_h, h_t );

% Set up fittype and options.
ft = fittype( 'smoothingspline' );

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft );

% % Plot fit with data.
% figure( 'Name', 'untitled fit 1' );
% h = plot( fitresult, xData, yData );
% legend( h, 'h_t vs. t_h', 'untitled fit 1', 'Location', 'NorthEast', 'Interpreter', 'none' );
% % Label axes
% xlabel( 't_h', 'Interpreter', 'none' );
% ylabel( 'h_t', 'Interpreter', 'none' );
% grid on


