function [fitresult, gof] = createFit1(M, h_m)
%CREATEFIT1(M,H_M)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input: M
%      Y Output: h_m
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 11-Mar-2024 22:05:52


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( M, h_m );

% Set up fittype and options.
ft = fittype( 'poly8' );
opts = fitoptions( 'Method', 'LinearLeastSquares' );
opts.Robust = 'LAR';

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
% figure( 'Name', 'untitled fit 1' );
% h = plot( fitresult, xData, yData );
% legend( h, 'h_m vs. M', 'untitled fit 1', 'Location', 'NorthEast', 'Interpreter', 'none' );
% % Label axes
% xlabel( 'M', 'Interpreter', 'none' );
% ylabel( 'h_m', 'Interpreter', 'none' );
% grid on


