function [fitresult, gof] = createFit(M_cd, Cd)
%CREATEFIT(M_CD,CD)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input: M_cd
%      Y Output: Cd
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 07-Mar-2024 00:09:51


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( M_cd, Cd );

% Set up fittype and options.
ft = fittype( 'smoothingspline' );

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft );

% % Plot fit with data.
% figure( 'Name', 'untitled fit 1' );
% h = plot( fitresult, xData, yData );
% legend( h, 'C vs. M', 'untitled fit 1', 'Location', 'NorthEast', 'Interpreter', 'none' );
% % Label axes
% xlabel( 'M', 'Interpreter', 'none' );
% ylabel( 'C', 'Interpreter', 'none' );
% grid on


