%% Ejector 
clear all
clc

Tc = 3400; pc = 55; p0 = 1; T0 = 288;
Mmol = 12; yr = 1.21; %LOX/LH2 
Rr = 8314.5/Mmol;
RHO = sqrt(yr)*(2/(yr+1))^((yr+1)/(2*(yr-1)));
c_star = sqrt(Rr*Tc)/RHO*0.975;
pi_p0 = 0.537;
x = 0;
while abs(x-1) > 0.0001
pc_p0 = pc/p0;
pi_pc = pi_p0/pc_p0;
eps = RHO/(sqrt((2*yr/(yr-1))*(pi_pc^(2/yr)-pi_pc^((yr+1)/yr))));
cf = RHO*sqrt((2*yr/(yr-1))*(1 - (pi_pc)^((yr-1)/yr)));
c = c_star*cf;
we = sqrt((2*yr/(yr-1))*Rr*Tc*(1-pi_pc^((yr-1)/yr)));
M0 = 0.5;
gamma = 1.35; 
A_Apstar = 39; %hp
Mp = ((2/(gamma-1))*((pc_p0/pi_p0)^((gamma-1)/gamma)-1))^0.5;
Ap_Apstar = (1/Mp)*((2/(gamma+1))*(1+0.5*(gamma-1)*Mp^2))^((gamma+1)/(2*(gamma-1)));
Ap_A = Ap_Apstar/A_Apstar;
As_A = 1-Ap_A;
pts_p0 = (1 + 0.5*(gamma-1)*M0^2)^(gamma/(gamma-1));
Ms = ((2/(gamma-1))*((pts_p0/pi_p0)^((gamma-1)/gamma)-1))^0.5;
ptp_p0 = pi_p0*(1 + 0.5*(gamma-1)*Mp^2)^(gamma/(gamma-1));
Tts_T0 = (1 + 0.5*(gamma-1)*M0^2);
Ttp_T0 = Tc/T0;
alpha = (pts_p0/ptp_p0)*(As_A/Ap_A)*(Ms/Mp)*sqrt(Ttp_T0/Tts_T0)*((1+0.5*(gamma-1)*Mp^2)/(1+0.5*(gamma-1)*Ms^2))^((gamma+1)/(2*(gamma-1)));
Te_Ttp = (2/(gamma+1))*((1+alpha*Tts_T0/Ttp_T0)/(1+alpha));
pe_p0 = ((1+alpha)/A_Apstar)*ptp_p0*sqrt(Te_Ttp)*(2/(gamma+1))^((gamma+1)/(2*(gamma-1)));
x = pe_p0*(1+gamma)/(pi_p0*(Ap_A*(1+gamma*Mp^2)+As_A*(1+gamma*Ms^2)));
pi_p0 = pi_p0 + 0.0001;
if abs(pi_p0 - pts_p0) <= 0.01
    break
end
end
Tt10_Ttp = 1; %hp
pte_p0 = pe_p0*(0.5*(gamma+1))^(gamma/(gamma-1));
Mp0 = ((2/(gamma-1))*((ptp_p0)^((gamma-1)/gamma)-1))^0.5;
M10 = ((2/(gamma-1))*((pte_p0)^((gamma-1)/gamma)-1))^0.5;
V0_Vp0 = (M0/Mp0)*((Tts_T0/Ttp_T0)*((1+0.5*(gamma-1)*Mp0^2)/(1+0.5*(gamma-1)*M0^2)))^0.5;
V10_Vp0 = (M10/Mp0)*((Tt10_Ttp)*((1+0.5*(gamma-1)*Mp0^2)/(1+0.5*(gamma-1)*M10^2)))^0.5;
phi_p = (1+alpha)*V10_Vp0-alpha*V0_Vp0;
a0 = 343.4; g = 9.81; V0 = a0*M0; 
Isp_p = a0*M0*phi_p/(V0_Vp0*g);
we_ok = sqrt((2*yr/(yr-1))*Rr*Tc*(1-(0.111/55)^((yr-1)/yr)));