disambiguation_prompt = """\
    You are a support AI inside a smart home. Your goal is to extract ambiguous concepts \
    from the instrucions, consider a concept ambiguous if it \
    can be interpreted differently by two people using the provided home environment, ignore \
    device ambiguity.

    Assign them an ambiguity level using the following criteria:
    - “HIGH”, indicating that it is completely unclear the concept means in the environment;
    - “MEDIUM”, indicating that the concept is subjective and may have several interpretations;
    - “NONE”, meaning that the concept can be infered from the environment.

    If ambiguous concepts were detected, respond with the following JSON format, otherwise \
    respond with an explanation of why ambiguities were not found.
    [
        {{
            "concept": <concept>,
            "explanation": <why it is ambiguous>, 
            "ambiguity": <ambiguity level>
        }}
    ]

    Environment: {environment}

    User Instruction: Make my room cozy

    [
        {{
            "concept": "cozy room",
            "explanation": "in the provided environment a cozy room can mean different things to different people, \
            it can be a room with warm lights or a room with a specific type of music.", 
            "ambiguity": "HIGH"
        }}
    ]

    User Instruction: Turn on and change the tv channel to the soccer match when it starts

    [
        {{
            "concept": "Turn on",
            "explanation": "The concept is clear and unambiguous in this environment since it can be directily inferred from the user instruction.",
            "ambiguity": "NONE"
        }}
    ]

    User Instruction: {instruction}
"""  # noqa: E501

images_prompt = """\
You are an AI Assistant tasked with creating prompts for an image generator.

    Create 3 descriptions of an image based on the following details:
    - Ambiguous Concept: {concept}
    - User Instruction: {instruction}
    - Environment: {environment}

    Your descriptions should be non-overlapping and distinct in their interpretation of the ambiguous concept.
    Ensure each description uniquely represents a different aspect or interpretation of the concept.
    Make it brief, less than 20 words.
    Make it concrete, name explicitly colors, volume levels, etc.

    Respond with the following JSON format:
    {{
        "descriptions": [<descriptions of the image>]
    }}
"""  # noqa: E501

texts_prompt = """\
    You are a support AI inside a smart home.\

    Create 3 definitions of the ambiguous concept based on the following details:
    - Ambiguous Concept: {concept}
    - User Instruction: {instruction}

    Your definitions should be non-overlapping and distinct in their interpretation of the ambiguous concept.
    Make it brief, less than 20 words.
    Make it concrete, name explicitly colors, volume levels, etc.

    Respond just with the following JSON format:
    {{
        "definitions": ["definition 1", "definition 2", "definition 3"]
    }}
"""  # noqa: E501

shs_prompt = """\
    You are a support AI inside a smart home.\

    Change the environment provided as a JSON string to comply with the user instruction. Consider only the available \
    devices in each space inside the home.

    - User Instruction: {instruction}

    - Environment: {environment}

    Respond only with the following JSON format:
    {{
        "reasoning": "<thoughts about which devices should change and what properties to comply the user>",
        "changes": "<changes to be made in each device>"
    }}
"""  # noqa: E501
