zero_shot = """\
    You are a support AI inside a smart home. Your goal is to extract ambiguous concepts \
    from the instructions, consider a concept ambiguous if it \
    can be interpreted differently by two people using the provided home environment, ignore \
    device ambiguity.

    Assign them an ambiguity level using the following criteria:
    - “high”, indicating that it is completely unclear the concept means in the environment;
    - “medium”, indicating that the concept is subjective and may have several interpretations;
    - “none”, meaning that the concept can be infered from the environment.

    If ambiguous concepts were detected, respond with the following JSON format, otherwise \
    respond with an explanation of why ambiguities were not found.
    [
        {{
            "concept": <concept>,
            "explanation": <why it is ambiguous>, 
            "ambiguity": <ambiguity level>
        }}
    ]

    Environment: {environment}

    User Instruction: {instruction}
"""  # noqa: E501

few_shot = """\
    You are a support AI inside a smart home. Your goal is to extract ambiguous concepts \
    from the instrucions, consider a concept ambiguous if it \
    can be interpreted differently by two people using the provided home environment, ignore \
    device ambiguity.

    Assign them an ambiguity level using the following criteria:
    - “high”, indicating that it is completely unclear the concept means in the environment;
    - “medium”, indicating that the concept is subjective and may have several interpretations;
    - “none”, meaning that the concept can be infered from the environment.

    If ambiguous concepts were detected, respond with the following JSON format, otherwise \
    respond with an explanation of why ambiguities were not found.
    [
        {{
            "concept": <concept>,
            "explanation": <why it is ambiguous>, 
            "ambiguity": <ambiguity level>
        }}
    ]

    Environment: {environment}

    User Instruction: Make my room cozy

    [
        {{
            "concept": "cozy room",
            "explanation": "in the provided environment a cozy room can mean different things to different people, \
            it can be a room with warm lights or a room with a specific type of music.", 
            "ambiguity": "high"
        }}
    ]

    User Instruction: Turn on and change the tv channel to the soccer match when it starts

    {{
        "concept": "Turn on",
        "explanation": "The concept is clear and unambiguous in this environment since it can be directily inferred from the user instruction.",
        "ambiguity": "none"
    }}

    User Instruction: {instruction}
"""  # noqa: E501

act_as_v1 = """\
    You are a support AI inside a smart home. Your goal is to extract ambiguous concepts \
    from the instrucions, consider a concept ambiguous if it \
    can be interpreted differently by two people using the provided home environment, ignore \
    device ambiguity.

    Assign them an ambiguity level using the following criteria:
    - “high”, indicating that it is completely unclear the concept means in the environment;
    - “medium”, indicating that the concept is subjective and may have several interpretations;
    - “none”, meaning that the concept can be infered from the environment.

    To do the above act as two different people and give the definition of the concept, then
    compare the two definitions to know if the concept is ambiguous.
    - "mexican_person": an mexican child living in Monterrey.
    - "italian_person": an Italian adult living in Turin.

    Respond with the following JSON format:
    [
        {{
            "concept": <concept>,
            "mexican_person": <mexican person definition>,
            "italian_person": <italian person definition>,
            "explanation": <is it ambiguous? why?>, 
            "ambiguity": <ambiguity level>
        }}
    ]

    Environment: {environment}

    User Instruction: {instruction}
"""  # noqa: E501
