from Paquetes.MODBUS.Comunicacion_MODBUS_TCP import *
from Paquetes.HTTPS.Comunicacion_HTTPS import *
import cv2
from picamera.array import PiRGBArray
from picamera import PiCamera, Color
import numpy as np
import warnings
import os
import time
import datetime
from os import path
import shutil
warnings.filterwarnings("ignore")

PLC = Comunicacion_MODBUS_TCP(IP_Equipo="172.24.13.30", reInicial=1, reFinal=8)
reg_PLC = 1

if path.exists("/home/pi/Desktop/WCC/frame1.png"):
    os.remove("/home/pi/Desktop/WCC/frame1.png")

camera = PiCamera()
camera.resolution = (640, 480)
rawCapture = PiRGBArray(camera, size=(640, 480))

time.sleep(0.1)

camera.brightness = 28
camera.contrast = 72
camera.exposure_mode = 'off'

frame1 = ""
cf1 = 0
minuto = ""
turbidez_ant = 0
f_espera = 300

# capture frames from the camera
for frameim in camera.capture_continuous(rawCapture, format="bgr", use_video_port=True):
    frame = frameim.array
    cv2.imshow("Frame", frame)

    if cf1 > f_espera:
        diff = cv2.subtract(frame1, frame)
        cv2.imshow('Diferencia', diff)

        p_diff_v = np.sum(diff)

        max = 921600*0.25*255*217.77/200

        turbidez = p_diff_v*200/max

        if cf1%20 == 0:
            print(turbidez)

        PLC.respuestaHTTPS(reg_PLC, int(round(turbidez*100)))

        now = datetime.datetime.now()
        today = datetime.date.today()
        last_month = today - datetime.timedelta(days=30)

        if (now.minute == 0 or now.minute == 30) and now.minute != minuto:
            try:
                os.mkdir("/home/pi/Desktop/WCC/Log_images/%d-%d-%d" % (now.year, now.month, now.day))
            except:
                pass

            cv2.imwrite("/home/pi/Desktop/WCC/Log_images/%d-%d-%d/foto-%d-%d-%d_%d:%d.png" % (now.year, now.month, now.day, now.year, now.month, now.day, now.hour, now.minute), frame)
            print("Foto foto-%d-%d-%d_%d:%d.png" % (now.year, now.month, now.day, now.hour, now.minute))

        minuto = now.minute

        try:
            shutil.rmtree("/home/pi/Desktop/WCC/Log_images/%d-%d-%d" % (last_month.year, last_month.month, last_month.day))
        except:
            pass

    if cf1 == f_espera:
        if path.exists("/home/pi/Desktop/WCC/frame1.png"):
            frame1 = cv2.imread("/home/pi/Desktop/WCC/frame1.png")
        else:
            frame1 = frame
            cv2.imwrite("/home/pi/Desktop/WCC/frame1.png", frame1)
        frame1 = cv2.imread("/home/pi/Desktop/WCC/frame1_flujo.png")
        print('Funcionando')
    elif cf1 == 0:
        print('Iniciando')

    cf1 += 1

    key = cv2.waitKey(1) & 0xFF
    rawCapture.truncate(0)

    if key == ord("q"):
        break