import time
from pymodbus.client import ModbusTcpClient
from datetime import datetime
from Libr.HTTPS.Comunicacion_HTTPS import *

# Define the Modbus TCP server details
SERVER_IP = '172.24.13.158'
SERVER_PORT = 502

# Create a Modbus TCP client instance
client = ModbusTcpClient(SERVER_IP, port=SERVER_PORT)

# Stablsh connection with Empowerment
username = "9033"
password = "9033"

name = "emp_EmpRfidRegistros"

emp = Comunicacion_HTTPS(
    username=username, password=password, entity_name=name)

path = ""

with open(path + "token.txt", "r") as Token_txt:
    Token = Token_txt.read()
if Token != "":
    try:
        cerrar = emp.Cerrar_seccion(path)
    except:
        pass
with open(path + "token.txt", "w") as Token_txt:
    Token_txt.write(str(""))
time.sleep(0.1)


def print_with_timestamp(message):
    current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    formatted_message = f"[{current_time}] {message}"
    print(formatted_message)
    # syslog.syslog(str(message))


def extract_tag_information(registers):
    try:
        uii_length = registers[4]
        tid_length = registers[5 + int(uii_length/2)]

        uii_section = registers[5:5 + int(uii_length/2)]
        tid_section = registers[6 + int(uii_length/2):6 + int((uii_length + tid_length)/2)]

        formatted_uii = ''.join(format(byte, '04X') for byte in uii_section)
        formatted_tid = ''.join(format(byte, '04X') for byte in tid_section)

        # TODO Head4:...
        tag_uii = f"{' '.join(formatted_uii[i:i+2] for i in range(0, len(formatted_uii), 2))}"
        tag_id = f"{' '.join(formatted_tid[i:i+2] for i in range(0, len(formatted_tid), 2))}"
        return tag_id
    except:
        pass


def date_format():
    time = datetime.now().strftime("%Y-%m-%d %H:%M:%S.000")
    return time


def token_request():
    with open(path + "token.txt", "r") as Token_txt:
        Token = Token_txt.read()
    if Token == "":
        Token = emp.Solicitar_token(path)
    return Token


def data_send(token, tag_id, head):
    data = {
        "_entityName": "emp_EmpRfidRegistros",
        "canalGateway": f"{int(head)}",
        "fechaLectura": date_format(),
        "idGateway": 1,
        "idTag": tag_id,
    }
    try:
        env = emp.Envio_datos(token, data)
        print_with_timestamp(env)
        return env
    except:
        return "Sin respuesta"


def values(l0, h0, l1, h1, l2, h2, l3, h3):
    combined_value_0 = (l0 << 8) | h0
    combined_value_1 = (l1 << 8) | h1
    combined_value_2 = (l2 << 8) | h2
    combined_value_3 = (l3 << 8) | h3
    values = [combined_value_0, combined_value_1,
              combined_value_2, combined_value_3]

    return values


def main(register_address):
    try:
        # Connect to the Modbus TCP server
        if client.connect():
            # known_tags = []
            # while True:
            print(register_address)

            response = client.write_registers(
                register_address, values(0x00, 0x00, 0x00, 0x06, 0x04, 0x08, 0x39, 0x39), slave=1)

            if response.isError():
                print("Modbus Error:", response)

            response = client.write_registers(
                register_address, values(0x00, 0x00, 0x00, 0x06, 0x01, 0x08, 0x00, 0x00), slave=1)

            # TODO See response???

            if response.isError():
                print("Modbus Error (2):", response)

            current_registers = [1]
            token = token_request()

            while any(current_registers):
                time.sleep(0.1)
                read_response = client.read_holding_registers(
                    register_address, count=19, slave=1)
                if read_response.isError():
                    print("Modbus Read Error:")
                else:
                    current_registers = read_response.registers

                    if current_registers[4] != 0:
                        tag_id = extract_tag_information(current_registers)
                        print_with_timestamp(f"Tag ID: {tag_id}")

                        if (tag_id is not None):
                            env = data_send(token, tag_id, register_address/1000)
                            if '40' in str(env):
                                with open(path + "token.txt", "w") as Token_txt:
                                    Token_txt.write(str(""))
                                token = token_request()
                                env = data_send(token, tag_id, register_address/1000)
                            # if (tag_id not in known_tags):
                            #     known_tags.append(tag_id)
                            #     print(tag_id)
                            #     tags += 1

            # print(f"{tags} tags leídos")
            # print(f"{len(known_tags)} tags conocidos")

            time.sleep(0.1)

        else:
            print("Connection failed.")
    except:
        cerrar = emp.Cerrar_seccion(path)
        print_with_timestamp(f"Cerrar: {cerrar}")
        client.close()


if __name__ == "__main__":
    while True:
        main(4000)
        main(3000)

"""
{
    "_entityName":"emp_EmpRfidRegistros",
    "canalGateway": "3996CC",
    "fechaLectura": "2023-11-16 10:30:09.000",
    "idGateway": 1,
    "idTag": "10",
}

Head 4: UII: 34 00 30 14 F7 33 7C 00 1F 00 00 00 81 B6 TID: E2 80 11 05 20 00 79 8C A9 10 09 3B 
Head 4: UII: 34 00 30 14 F7 33 7C 00 1F 00 00 00 81 B9 TID: E2 80 11 05 20 00 7A CC A9 10 09 3B 
Head 4: UII: 34 00 30 14 F7 33 7C 00 1F 00 00 00 81 B7 TID: E2 80 11 05 20 00 7A 4C A9 10 09 3B 
Head 4: UII: 34 00 30 14 F7 33 7C 00 1F 00 00 00 81 BA TID: E2 80 11 05 20 00 7B 0C A9 10 09 3B 
Head 4: UII: 34 00 30 14 F7 33 7C 00 1F 00 00 00 81 B8 TID: E2 80 11 05 20 00 7A 8C A9 10 09 3B 
Head 4: Tags found: 5
"""
