import serial
import time
import requests
import json
import pandas as pd
import numpy as np

from datetime import date
from datetime import datetime
import time
import os.path as path

from Paquetes.HTTPS.Comunicacion_HTTPS import *
from Paquetes.MODBUS.Comunicacion_MODBUS_TCP import *


class datosEstados(object):
    def __init__(self,columns=['zona','estado'],formatoFecha = "%Y-%m-%d %H:%M:%S.000",zona = [1,2,3,4,5,6,7,8],planta = 62
                 ,pathEstados = "/home/pi/Desktop/Desarrollo_EstadoQuimicos/Registros/Estados_Zonas.csv"
                 ,pathRegistrosDesconexion = "/home/pi/Desktop/Desarrollo_EstadoQuimicos/Registros/Registros_Empowerment.csv"
                 ,pathRegistrosDesconexionJSON = "/home/pi/Desktop/Desarrollo_EstadoQuimicos/Registros/JSONconexion.json"
                 ,entityName = "emp_EmpAcaAlertaQuimosPreparados"):
        
        self.columns = columns
        self.formatoFecha = formatoFecha
        self.zona = zona
        self.planta = planta
        self.pathEstados = pathEstados
        self.pathRegistrosDesconexion = pathRegistrosDesconexion
        self.pathRegistrosDesconexionJSON = pathRegistrosDesconexionJSON
        self.entityName = entityName
        
    # Actualizar tabla de estados
    def actualizarEstados(self,estadoActual):
        try:
            df_estadoAnterior = pd.DataFrame(columns=self.columns)                                                                 # Crea el formato de tabla
            for i in range(len(estadoActual)):
                df_estadoAnterior = df_estadoAnterior.append({"zona": self.zona[i],"estado": estadoActual[i]}, ignore_index=True)  # Actualiza los nuevos estados
            df_estadoAnterior.to_csv(self.pathEstados)
            mensaje = "Estados actualizados"
        except:
            mensaje = "Error actualizando datos"
        return mensaje
        
    # Llama los estados anteriores
    def estadoAnterior(self,columnaSelc ="estadoAnterior"):
        df_estadoAnterior = pd.read_csv(self.pathEstados)
        if columnaSelc == "zona":
            retorna = df_estadoAnterior.iloc[:,1].tolist()
        if columnaSelc == "estadoAnterior":
            retorna = df_estadoAnterior.iloc[:,2].tolist()
        return retorna 

    # Pregunta por cambio de estado y creacion de json para el envio 
    def colCambioEstado(self,estadoActual,estadoAnterior):                                                
        fecha = datetime.now().strftime(self.formatoFecha)                                                                         # Convierte fecha en el formato seleccionado
        colDatos = []
        for i in range(len(estadoActual)):
            if estadoActual[i] != estadoAnterior[i]:
                dic = {"_entityName": self.entityName,"zona": str(i+1),"estado":bool(estadoActual[i]),"planta":self.planta,"tiempoReg":fecha}
                colDatos.append(dic)
        return colDatos

    # Funcion de almacenamiento cuando no hay conexion y borrado cuando se carga la informacion
    def almacenamiento(self,colDatos = [],accion="almacenar"):
        if not path.exists(self.pathRegistrosDesconexionJSON):                                                                     # Verifica si existe un archivo, de lo contrario crea el archivo
            with open(self.pathRegistrosDesconexionJSON,'w') as file:                                                              # Crea el archivo con una lista vacia
                json.dump([],file) 
        
        if accion == "almacenar":                                                                                                  # Fincionalidad para almacenar informacion en el archivo 
            with open(self.pathRegistrosDesconexionJSON,'r') as file:
                datosAnte = json.load(file)
            try:
                datosNu = datosAnte + colDatos                                                                                     # Concatena los registros cuando no hay red para almacenarlos
            except:
                datosNu = colDatos
            
            with open(self.pathRegistrosDesconexionJSON,'w') as file:                                                              # Guarda los registros generados cuando no hay red
                json.dump(datosNu,file)
            return 0
        
        if accion == "recuperar":                                                                                                  # Funcionalidad para recuperar los documentos generados y enviarlos a Empowerment
            with open(self.pathRegistrosDesconexionJSON,'r') as file:
                datosAnte = json.load(file)
            return datosAnte
        
        if accion == "borrar":                                                                                                     # Funcionalidad para borrar los archivos luego de publicarlos en Empowerment (stand alone)
            with open(self.pathRegistrosDesconexionJSON,'w') as file:
                json.dump([],file)
            return 0
            
    # Funcion para el envio de datos a Empowerment
    def envioEmpowerment(self,colDatos,url_Datos):
        Envio = 0                                                                     
        colFormatoDatos = {"items":colDatos}                                             # Arma el formato para el envio de informacion a Empowerment
        #print(colFormatoDatos)
        PublicarEmpowerment = Comunicacion_HTTPS()                                       # Instancia la clase comunicación HTTPS
        try:
            Token = PublicarEmpowerment.Solicitar_token()                                # Llama al metodo para la solicitud de Token
            print(Token)
            if colDatos != []:
                Envio = PublicarEmpowerment.Envio_datos(Token,colFormatoDatos,url_Datos) # Llama al metodo para el envio de datos por HTTPS
                Envio = Envio.status_code                                                # Almacena el codigo de envio generado
            Cerrar = PublicarEmpowerment.Cerrar_seccion(Token)                               # Llama al metodo que cierra la conexion de usuario con Empowerment
        except:
            Envio = 700                                                                  # Valor que adquiere Envio cuando se genera error por falta de conexión a la red
        #print(Envio)
        if Envio == 200 or Envio == 201:                                                 # Pregunta de envio exitoso
            mensaje = "Se realizo envio"
        else:                                                                            # Si el envio no se da, raliza procedimiento de almacenamiento
            mensaje = "Almacenando informacion"
            self.almacenamiento(colDatos = colDatos)                                     # Usan el metodo de la misma clase para realizar almacenamiento de datos                   
        
        return mensaje
       
