#! /usr/bin/env python3
# -*- coding: utf-8 -*-

import re
import serial
import os
import time
import sys
import I2C_LCD_driver
import RPi.GPIO as GPIO
from time import sleep
import pandas as pd
import numpy as np
from datetime import datetime
from Comunicacion_HTTPS import *

# Funciones Lifter


def subir():
    GPIO.output(19, True)
    GPIO.output(26, False)
    time.sleep(10)
    mantener()


def bajar():
    GPIO.output(19, False)
    GPIO.output(26, True)
    time.sleep(7)
    mantener()


def mantener():
    GPIO.output(19, False)
    GPIO.output(26, False)

# Funcion captura de peso


def pesoCaptura():
    try:
        # time.sleep(0.5)
        #Balanza = serial.Serial("/dev/ttyUSB2",baudrate = 9600, timeout = 1)
        Balanza = serial.Serial("/dev/Balanza", baudrate=9600, timeout=1)
        txt_Balanza = ""
        time.sleep(1)
        while Balanza.inWaiting() > 0:
            txt_Balanza += Balanza.read().decode("utf-8")
        Balanza.close()
        # Trampa para limpiar el dato de la balanza (elimina caracteres extraños)
        n_txt_Balanza = re.sub("[?g\?k\n\r]", "_", txt_Balanza).strip() #?g\?k\n\r
        Peso_str, Basura = n_txt_Balanza.split("_", 1)
        #print(Peso_str)
        Peso = float(Peso_str)/1000
        if "kg" in txt_Balanza:
            Peso = float(Peso_str)
        #print(Peso_str)
    except:
        Peso = -999.0
    return Peso

# Funcion de almacenamiento cuando no hay conexión


def almacenamiento(fecha, arbol, peso):

    items = {"fecha": fecha, "peso": peso, "arbol": arbol}
    dfEmpowerment = pd.read_csv(
        '/home/pi/Desktop/Desarrollo_urdidora/Registros/Registros_Empowerment.csv', index_col=0)
    dfEmpowerment = dfEmpowerment.append(items, ignore_index=True)
    dfEmpowerment.to_csv(
        '/home/pi/Desktop/Desarrollo_urdidora/Registros/Registros_Empowerment.csv')


def almacenamientoE(fecha, arbol, peso): #Almacenamiento de éxitos

    items = {"fecha": fecha, "peso": peso, "arbol": arbol}
    dfEmpowerment = pd.read_csv(
        '/home/pi/Desktop/Desarrollo_urdidora/Registros/Registros_Empowerment_OK.csv', index_col=0)
    dfEmpowerment = dfEmpowerment.append(items, ignore_index=True)
    dfEmpowerment.to_csv(
        '/home/pi/Desktop/Desarrollo_urdidora/Registros/Registros_Empowerment_OK.csv')


def envioEmpowerment(fecha, arbol, peso):
    # Instancia la clase comunicación HTTPS
    username = "9014"
    password = "9014"
    Authorization = 'Basic ZW1wd3JtOi42Nj1UKylbKGFTOClmJA=='
    url_Datos = "https://empowerment.serviciosit.co:8443/empowerment/rest/v2/services/emp_PesajeArbolesService/pesajeArbol"
    PublicarEmpowerment = Comunicacion_HTTPS(
        username=username, password=password, Authorization=Authorization, url_Datos=url_Datos)
    # Solicitud de Token
    Token = PublicarEmpowerment.Solicitar_token()
    # print(Token)

    # Se arma paquete para envío de datos
    Datos = {
            "item": {
                "_entityName": "emp_EmpTejPesajeArboles",
                "fechaRegistro": fecha,
                "peso": peso,
                "noArbol": arbol,
                "idBascula": "Tejeduria"
                }
            }
    # print(Datos)
    Envio = PublicarEmpowerment.Envio_datos(Token, Datos)
    # print(Envio)

    # Se arma paquete para cerrar seccion
    Cerrar = PublicarEmpowerment.Cerrar_seccion(Token)
    return Envio


# Main
def main():
    GPIO.setmode(GPIO.BCM)
    GPIO.setup(19, GPIO.OUT)
    GPIO.setup(26, GPIO.OUT)

    Estado = 1
    mylcd = I2C_LCD_driver.lcd()
    mylcd.lcd_display_string("                    ", line=2, pos=1)
    mylcd.lcd_display_string("   espere...        ", line=3, pos=0)
    subir()
    mylcd.lcd_display_string("  Ingrese arbol     ", line=2, pos=1)
    mylcd.lcd_display_string("                    ", line=3, pos=0)

    # Lector = serial.Serial("/dev/ttyUSB0",baudrate = 115200, timeout = 1)
    # Lector = serial.Serial("/dev/Lector_xbee", baudrate=115200, timeout=1)
    txt_Lector = ""
    Codigo = ""
    TaraS = ""
    Tara = 0.00
    while True:
        txt_Lector = str(input())
        time.sleep(1)
        # while Lector.inWaiting() > 0:
        #     txt_Lector += Lector.read().decode("utf-8")
        # print(txt_Lector)
        try:
            Codigo, TaraS = txt_Lector.split(" ", 2)
            # Tara = float(TaraS)
            # print(Codigo,Tara)
        except:
            # Captura cuando solo se lee una orden (Borrar, imprimir, etc.)
            Codigo = txt_Lector.strip()
        txt_Lector = ""

        # Orden ṕara generar un reset
        if Codigo == "BORRAR":
            mylcd.lcd_display_string("                    ", line=2, pos=0)
            mylcd.lcd_display_string("   subiendo...      ", line=3, pos=0)
            subir()
            Codigo = ""
            Estado = 1
            Tara = 0.00
            mylcd.lcd_display_string("  Ingrese arbol     ", line=2, pos=1)
            mylcd.lcd_display_string("                    ", line=3, pos=0)

        # Estado de captura de numero de arbol
        if Estado == 1:
            if Codigo != "" and Codigo != "ENVIAR" and Codigo != "BORRAR":
                arbol = Codigo
                Codigo = ""
                mylcd.lcd_display_string("No. arbol: "+arbol, line=3, pos=0)
                time.sleep(1)
                Estado = 2
            else:
                Codigo = ""
                txt_Lector = ""

        # Estado de posicionamiento
        if Estado == 2:
            mylcd.lcd_display_string("  Capturando peso   ", line=2, pos=1)
            mylcd.lcd_display_string("   bajando...       ", line=3, pos=0)
            bajar()
            Estado = 3

        # Estado de captura de peso
        if Estado == 3:
            # if Tara == 0.00:
            #     Tara = 5554
            Peso = pesoCaptura()
            # Peso = pesoCaptura() - Tara
            # Peso = Peso - Tara
            mylcd.lcd_display_string("   Enviando         ", line=2, pos=1)
            mylcd.lcd_display_string("                    ", line=3, pos=0)
            mylcd.lcd_display_string("Peso: "+str(Peso), line=3, pos=0)
            time.sleep(1)
            # if Codigo == "ENVIAR":
            Codigo = ""
            now = datetime.now()
            fecha = now.strftime("%Y-%m-%d %H:%M:%S.000")
            try:
                Envio = envioEmpowerment(fecha, str(arbol), str(Peso))
                Envio = Envio.status_code
            except:
                Envio = 700
            #print(Envio)
            if Envio == 200 or Envio == 201:
                mylcd.lcd_display_string(
                    "   Envio Exitoso     ", line=2, pos=1)
                #almacenamientoE(fecha, str(arbol), str(Peso))
            else:
                # Almacena los datos para enviarlos mas tarde (cuando vea red)
                almacenamiento(fecha, str(arbol), str(Peso))
                mylcd.lcd_display_string(
                    "   Envio Fallido     ", line=2, pos=1)
                mylcd.lcd_display_string(
                    "  Guardando datos    ", line=3, pos=0)

            subir()
            time.sleep(1)
            Estado = 1
            Tara = 0.00
            mylcd.lcd_display_string("   Ingrese arbol     ", line=2, pos=0)
            mylcd.lcd_display_string("                     ", line=3, pos=0)

    Lector.close()


if __name__ == "__main__":
    try:
        main()
    except:
        print("Algo salio mal...")
        time.sleep(10)