#! /usr/bin/env python3
# -*- coding: utf-8 -*-
import re
import serial
import os,time
import sys
import I2C_LCD_driver
import RPi.GPIO as GPIO
from time import sleep
import pandas as pd
import numpy as np
from datetime import datetime
from Comunicacion_HTTPS import *

def arrayDatos(dfEmpowerment):
    arrDatos = []
    for i in range(dfEmpowerment.shape[0]):
#         Datos = {"_entityName":"emp_EmpTejPesajeArboles","fechaRegistro": dfEmpowerment.iloc[i]["fecha"],
#                           "peso": dfEmpowerment.iloc[i]["peso"],
#                           "noArbol": {"_entityName":"emp_EmpTejViewAditamento","aditamentoNo": str(dfEmpowerment.iloc[i]["arbol"])}}
        Datos = {
                "_entityName": "emp_EmpTejPesajeArboles",
                "fechaRegistro": dfEmpowerment.iloc[i]["fecha"],
                "peso": str(dfEmpowerment.iloc[i]["peso"]),
                "noArbol": str(dfEmpowerment.iloc[i]["arbol"]),
                "idBascula": "Teje "+str(i+1)
                }
        arrDatos.append(Datos)
    arrDatos = {"items":arrDatos}
    return arrDatos

def envioEmpowerment(datos):
    # Instancia la clase comunicación HTTPS
    username = "9014"
    password = "9014"
    Authorization = 'Basic ZW1wd3JtOi42Nj1UKylbKGFTOClmJA=='
    url_Datos = "https://empowerment.serviciosit.co:8443/empowerment/rest/v2/services/emp_PesajeArbolesService/pesajeArboles"
    PublicarEmpowerment = Comunicacion_HTTPS(username = username
                                             ,password = password
                                             ,Authorization = Authorization
                                             ,url_Datos = url_Datos)
    # Solicitud de Token
    Token = PublicarEmpowerment.Solicitar_token()
    # print(Token)

    try:
        Envio = PublicarEmpowerment.Envio_datos(Token,datos)
        Envio = Envio.status_code
        #print(Envio)
    except:
        Envio = 700

    # Se arma paquete para cerrar seccion
    Cerrar = PublicarEmpowerment.Cerrar_seccion(Token)
    return Envio

# Main
def main():
    dfEmpowerment = pd.read_csv('/home/pi/Desktop/Desarrollo_urdidora/Registros/Registros_Empowerment.csv',index_col=0)
    Datos = arrayDatos(dfEmpowerment)
    print(Datos)
    if dfEmpowerment.shape[0] >= 1:
        Envio = envioEmpowerment(Datos)                                         # Realiza el envio de datos
        print(Envio)
        if Envio == 200 or Envio == 201:                                        # Con esta pregunta se eliminan los datos guardados (si es verdadera)
            dfEmpowerment = pd.DataFrame(columns=['fecha','peso','arbol'])
            dfEmpowerment.to_csv('/home/pi/Desktop/Desarrollo_urdidora/Registros/Registros_Empowerment.csv')

if __name__ == "__main__":
    main()