#!/usr/bin/python3
import numpy as np
# import pandas as pd
import json

from pyModbusTCP.client import ModbusClient
from pyModbusTCP import utils

class Comunicacion_MODBUS_TCP(object):
    def __init__(self,IP_Equipo,tamañoRe = 16,reInicial = 1,reFinal = 40,reACT = 39):
        self.IP_Equipo = IP_Equipo
        self.TamañoRe = tamañoRe
        self.reInicial = reInicial
        self.reFinal = reFinal
        self.reACT = reACT
        self.c = ModbusClient(host=self.IP_Equipo, port=502, auto_open=True) 
        
    def datosModbus_JSON(self):
        if self.TamañoRe == 16:
            try:
                regs = self.c.read_holding_registers(self.reInicial,self.reFinal)                                       # Registro, nu_registro (Llama registro de intres)
            except:
                regs = []                                                                                               # Como caso de except crea una lista de ceros
                for i in range(reFinal-1):
                    regs.append(0)
        if self.TamañoRe == 32:
            try:
                regs = self.c.read_holding_registers(self.reInicial,self.reFinal)
                regs = [utils.decode_ieee(f) for f in utils.word_list_to_long(regs)]
            except:
                regs = []                                                                                               # Como caso de except crea una lista de ceros
                for i in range((reFinal/2)-1):
                    regs.append(0)
        return regs
        
    def registroACT(self):

        try:
            ACT = self.c.read_holding_registers(self.reACT,125)
        except:
            ACT = ["0"]
        ACT = self.c.read_holding_registers(self.reInicial,self.reFinal)
        return ACT
        
    def respuestaHTTPS(self,Registro,statusCode):                                                                        
        self.c.write_multiple_registers(Registro, [statusCode])
        return 0