# Open the file for writing
import time
import syslog
import hashlib
from datetime import datetime
from Libr.HTTPS.Comunicacion_HTTPS import *
from random import randint

file_path = '/mnt/cib_solidez/data.txt'

try:
    while True:
        # Get the current time
        current_time = time.strftime('%Y-%m-%d %H:%M:%S')
        
        # Open the file for writing (append mode to keep previous content)
        with open(file_path, 'a') as file:
            # Write the current time to the file
            file.write(current_time + '\n')
        
        print(f"Time '{current_time}' written to '{file_path}'")
        
        # Wait for one second before writing again
        time.sleep(1)
except KeyboardInterrupt:
    print("Writing to the file stopped by user.")
except Exception as e:
    print("An error occurred:", str(e))

"""
[Unit]
Description=Envío dato de Solidez al Empowerment
After=network-online.target

[Service]
ExecStart=/usr/bin/python3 /home/jbenjumeam/Cib/JP/Proyectos/Solidez/Solidez.py
WorkingDirectory=/home/jbenjumeam/Cib/JP/Proyectos/Solidez/
Restart=always
RestartSec=10s
StartLimitInterval=5min
StartLimitBurst=10
SyslogIdentifier=Env_Solidez
StandardOutput=journal
StandardError=journal

[Install]
WantedBy=multi-user.target
"""