import time
import syslog
import hashlib
from datetime import datetime
from Libr.HTTPS.Comunicacion_HTTPS import *
from random import randint

username = "9032"
password = "9032"

name = "emp_EmpAcaSort"

emp = Comunicacion_HTTPS(username=username, password=password, entity_name=name)

path = "/home/jbenjumeam/Cib/JP/Proyectos/Solidez/Env_Solidez/"

with open(path + "token.txt", "r") as Token_txt:
    Token = Token_txt.read()
if Token != "":
    try:
        cerrar = emp.Cerrar_seccion(path)
    except:
        pass
with open(path + "token.txt", "w") as Token_txt:
    Token_txt.write(str(""))
time.sleep(0.1)


def print_with_timestamp(message):
    # current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    # formatted_message = f"[{current_time}] {message}"
    # print(formatted_message)
    syslog.syslog(str(message))


def calculate_file_hash(file_path):
    with open(file_path, "rb") as file:
        content = file.read()
        hash_object = hashlib.sha256(content)
        return hash_object.hexdigest()


def date_format(date_string):
    # Convierte la fecha al formato "%Y-%m-%d %H:%M:%S.000"
    time = datetime.now().strftime("%H:%M:%S.000")
    date_dt = datetime.strptime(date_string, "%d-%b-%y").strftime("%Y-%m-%d")
    date_time = datetime.strptime(
        (date_dt + " " + time), "%Y-%m-%d %H:%M:%S.000"
    ).strftime("%Y-%m-%d %H:%M:%S.000")
    # print(date_time)
    return date_time


def process_line(line):
    # Procesa cada línea para extraer los valores necesarios
    parts = line.split()
    if len(parts) >= 3:
        try:
            order = parts[0].strip().split("-")[-1]
            calificacion = float(
                parts[1]
            )  # ).strip().split(".")[0]+","+str(float(parts[1])).strip().split(".")[1]
            fecha = date_format(parts[2])
            return {"orden": order, "solidezCalificacion": calificacion, "fecha": fecha}
        except ValueError:
            return None
    return None


def clear_file_content(file_path):
    try:
        with open(file_path, "w") as file:
            file.write("")
    except Exception as e:
        print_with_timestamp(f"Error borrando el contenido del archivo: {e}")


def write_unsent_data(file_path, unsent_data):
    with open(file_path, "a") as file:
        for data in unsent_data:
            file.write(data)


def main(input_file, output_folder):
    with open(input_file, "r") as file:
        lines = file.readlines()

    if len(lines):
        data_to_write = []

        for line in lines:
            # Ignora las líneas que empiezan por "ESCALA DE GRISES", "ESTANDAR", y "MUESTRA"
            if not line.startswith(("ESCALA DE GRISES", "ESTANDAR", "MUESTRA")):
                data = process_line(line)
                if data:
                    data_to_write.append((data, line))

        # Guardar los datos procesados en archivos JSON
        unsent_data = []

        with open(path + "token.txt", "r") as Token_txt:
            Token = Token_txt.read()

        if Token == "":
            Token = emp.Solicitar_token(path)

        # Token = "hola" # 401 invalid token
        # Token = "" # 401 invalid token

        for i, data in enumerate(data_to_write):  # index, element in enumerate(l)
            print_with_timestamp(
                f"Enviando orden {data[0]['orden']}... {i+1} de {len(data_to_write)}"
            )
            time.sleep(0.1)
            try:
                envd = emp.Envio_datos(Token, data[0])
            except:
                envd = "Sin respuesta"
            print_with_timestamp(envd)
            # return True
            time.sleep(0.1)

            if not (("201" in str(envd)) or ("200" in str(envd))):
                print_with_timestamp(f"Error enviando orden {data[0]['orden']}...")
                unsent_data.append(data[1])

            # output_file = f"{output_folder}/data_{data['orden']}.json"
            # print_with_timestamp(f"Enviando orden {data['orden']}...")
            # with open(output_file, "w") as json_file:
            #     json.dump(data, json_file)

        # Vaciar el archivo de entrada después de procesar las líneas
        clear_file_content(input_file)

        if len(unsent_data):
            write_unsent_data(input_file, unsent_data)
            cerrar = emp.Cerrar_seccion(path)
            print_with_timestamp(f"Cerrar: {cerrar}")
            time.sleep(300)
            Token = emp.Solicitar_token(path)

    else:
        print_with_timestamp("Archivo vacío.")


if __name__ == "__main__":
    input_file = "/mnt/Solidez/solideznuevo.txt" #"/run/user/1002/gvfs/smb-share:server=172.17.3.6,share=grupos/ACABADOS/Solidez/solideznuevo.txt"
    output_folder = "/home/jbenjumeam/Cib/JP/Proyectos/Solidez/Env_Solidez/outputjsons"
    try:
        main(input_file, output_folder)
        last_modified = calculate_file_hash(input_file)  # os.path.getmtime(file_path)
        print_with_timestamp("Monitoreando cambios en el archivo...")
        while True:
            current_modified = calculate_file_hash(
                input_file
            )  # os.path.getmtime(file_path)
            # print(current_modified)
            if current_modified != last_modified:
                print_with_timestamp("Archivo modificado...")
                main(input_file, output_folder)
                last_modified = current_modified
            time.sleep(1)
    except:
        print_with_timestamp("Monitoreo de cambios interrumpido.")
        t = randint(10, 600)
        print_with_timestamp(f"Esperando {t} segundos para reintentar")
        time.sleep(t)
