import sys
import time
import paramiko
import hashlib
from datetime import datetime  # Importamos la biblioteca datetime
from os.path import abspath, dirname, join

# Rutas y configuración
# path = dirname(sys.executable)  # TODO Descomentar
path = join(dirname(abspath(__file__)))  # This script path  # TODO Comentar

confs_path = f"{path}/confs_path.txt"
with open(confs_path, "r") as file:
    confs = file.read()
print(f"Confs: {confs}")

# conf_file_path = f"G:/Mi unidad/Confs/{confs}/file_path.txt" # TODO Comentar
conf_file_path = f"G:/JBenjumeaM/Confs/{confs}/file_path.txt" # TODO Descomentar
with open(conf_file_path, "r") as file:
    file_path = file.read()
# "L:/ACABADOS/Solidez/solideznuevo.txt"

server_ip = "172.24.43.9"
server_username = "jbenjumeam"

# conf_destination_path = f"G:/Mi unidad/Confs/{confs}/destination_path.txt" # TODO Comentar
conf_destination_path = f"G:/JBenjumeaM/Confs/{confs}/destination_path.txt" # TODO Descomentar
with open(conf_destination_path, "r") as file:
    destination_path = file.read()

remote_filename = f"{confs}.txt"
print(destination_path)

max_retry_attempts = 3
retry_delay_seconds = 5


def print_with_timestamp(message):
    current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    formatted_message = f"[{current_time}] {message}"
    print(formatted_message)


def calculate_file_hash(file_path):
    with open(file_path, "rb") as file:
        content = file.read()
        hash_object = hashlib.sha256(content)
        return hash_object.hexdigest()


def send_content_with_retry(content):
    retry_attempt = 0
    while retry_attempt < max_retry_attempts:
        if send_content_to_server(content):
            return True
        retry_attempt += 1
        time.sleep(retry_delay_seconds)
    return False


def send_content_to_server(content):
    try:
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        ssh.connect(server_ip, username=server_username)
        _, stdout, _ = ssh.exec_command(
            f"echo '{content}' >> {destination_path}{remote_filename}")
        stdout.channel.recv_exit_status()
        ssh.close()
        return True
    except Exception as e:
        print_with_timestamp(f"Error durante la transferencia: {e}")
        return False


def clear_file_content():
    try:
        with open(file_path, "w") as file:
            file.write("")
    except Exception as e:
        print_with_timestamp(f"Error borrando el contenido del archivo: {e}")


def send():
    with open(file_path, "r") as file:
        content = file.read()
    if content.strip():  # Check if the content is not empty
        if send_content_with_retry(content):
            clear_file_content()
            print_with_timestamp(
                "Envío al servidor exitoso. Contenido local borrado.")
        else:
            print_with_timestamp("Error enviando el contenido al servidor.")
    else:
        print_with_timestamp("Archivo vacío.")


if __name__ == "__main__":
    try:
        send()
        last_modified = calculate_file_hash(
            file_path)  # os.path.getmtime(file_path)
        print_with_timestamp("Monitoreando cambios en el archivo...")
        while True:
            current_modified = calculate_file_hash(
                file_path)  # os.path.getmtime(file_path)
            # print(current_modified)
            if current_modified != last_modified:
                print_with_timestamp(
                    "Archivo modificado...")
                send()
                last_modified = current_modified
            time.sleep(1)
    except KeyboardInterrupt:
        print_with_timestamp("Monitor de cambios interrumpido.")
