#!/usr/bin/python3
import json
import time

import requests


class Comunicacion_HTTPS(object):
    def __init__(self, username, password, entity_name):

        self.username = username
        self.password = password
        self.name = entity_name
        self.Authorization = 'Basic ZW1wd3JtOi42Nj1UKylbKGFTOClmJA=='
        self.url_Datos = "https://empowerment.serviciosit.co:8443/empowerment/rest/v2/entities/" + entity_name
        self.url_Token = "https://empowerment.serviciosit.co:8443/empowerment/rest/v2/oauth/token"
        self.url_Revoque = "https://empowerment.serviciosit.co:8443/empowerment/rest/v2/oauth/revoke?token="
        self.pathToken = f'token.txt'

        self.headersT = {
            'Content-Type': 'application/x-www-form-urlencoded',
            'Accept': 'application/json',
            'Authorization': str(self.Authorization),
            'Connection': 'keep-alive',
            'User-Agent': 'otsrvcibernetica',
            'Cache-Control': 'no-cache',
            'Accept-Encoding': 'gzip, deflatee'
        }

    def headersB(self, Token: str):
        bearer = 'Bearer '
        Bearer = bearer + str(Token).strip('"')
        headersB = {
            'Authorization': Bearer,
            'Content-Type': 'text/plain',
            'User-Agent': 'otsrvcibernetica',
            'Accept': '*/*',
            'Cache-Control': 'no-cache',
            'Accept-Encoding': 'gzip, deflatee',
            'Connection': 'keep-alive',
        }
        return headersB

    def Solicitar_token(self, path: str) -> str:
        """Registro del token"""

        payload = "grant_type=password&username=" + \
            str(self.username)+"&password=" + str(self.password)
        response = requests.post(
            self.url_Token, headers=self.headersT, data=payload)
        lectura = json.loads(response.text)
        Token = lectura['access_token']

        with open(path + self.pathToken, 'w') as Token_txt:
            Token_txt.write(str(Token))
        time.sleep(0.1)
        return Token

    def Envio_datos(self, Token: str, Datos: dict):
        payload = json.dumps(Datos)
        Envio_datos = requests.post(
            self.url_Datos, headers=self.headersB(Token), data=payload, timeout=15)
        return Envio_datos

    def Lectura_datos(self, Token: str) -> list[dict]:
        Lectura_datos = requests.get(
            self.url_Datos, headers=self.headersB(Token))
        return json.loads(Lectura_datos.text)

    def Modificar_datos(self, Token: str, Datos: dict):
        payload = json.dumps(Datos)
        Modificar_datos = requests.put(
            self.url_Datos+'/275', headers=self.headersB(Token), data=payload)
        return Modificar_datos

    # def Borrar_datos(self, Token: str):
    #     Borrar_datos = requests.delete(
    #         self.url_Datos, headers=self.headersB(Token))
    #     return Borrar_datos

    def Cerrar_seccion(self, path: str) -> bool:
        """Cerrado de sección y borrado del archivo del token"""

        with open(path + self.pathToken, 'r') as Token_txt:
            Token = Token_txt.read()
        time.sleep(0.1)

        url_revoke_Token = self.url_Revoque + str(Token).strip('"')
        Cerrar_seccion = requests.post(url_revoke_Token, headers=self.headersT)

        if '200' in str(Cerrar_seccion) or '201' in str(Cerrar_seccion) or '400' in str(Cerrar_seccion) or '401' in str(Cerrar_seccion):
            with open(path + self.pathToken, 'w') as Token_txt:
                Token_txt.write(str(''))
            time.sleep(0.1)
            return True
        else:
            return False


# if __name__ == "__main__":

#     username = "9025"
#     password = "9025"
#     n_Llamados = "emp_EmpMirLlamados"
#     n_Estados = "emp_EmpMirEstados"

#     emp_Estados = Comunicacion_HTTPS(
#         username=username, password=password, entity_name=n_Estados)

#     Token = emp_Estados.Solicitar_token()

#     datos = {
#         "codigo": '03'
#     }
#     # emp_Estados.Modificar_datos(Token,datos)
#     print(emp_Estados.Lectura_datos(Token))

#     Cerrar = emp_Estados.Cerrar_seccion(Token)
