import time
import syslog
import hashlib
from datetime import datetime
from Libr.HTTPS.Comunicacion_HTTPS import *
from random import randint

username = "9026"
password = "9026"

name = "emp_EmpAcaSort"

emp = Comunicacion_HTTPS(username=username, password=password, entity_name=name)

path = "/home/jbenjumeam/Cib/JP/Proyectos/Dato_SORT/Env_SORT/"

with open(path + "token.txt", "r") as Token_txt:
    Token = Token_txt.read()
if Token != "":
    try:
        cerrar = emp.Cerrar_seccion(path)
    except:
        pass
with open(path + "token.txt", "w") as Token_txt:
    Token_txt.write(str(""))
time.sleep(0.1)


def print_with_timestamp(message):
    # current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    # formatted_message = f"[{current_time}] {message}"
    # print(formatted_message)
    syslog.syslog(str(message))


def calculate_file_hash(file_path):
    with open(file_path, "rb") as file:
        content = file.read()
        hash_object = hashlib.sha256(content)
        return hash_object.hexdigest()


def date_format(date_string: str, time_string: str):
    # Convierte la fecha al formato "%Y-%m-%d %H:%M:%S.000"
    time_string += ":00.000"
    date_dt = datetime.strptime(date_string, "%d-%b-%y").strftime("%Y-%m-%d")
    date_time = datetime.strptime(
        (date_dt + " " + time_string), "%Y-%m-%d %H:%M:%S.000"
    ).strftime("%Y-%m-%d %H:%M:%S.000")
    # print(date_time)
    return date_time


def process_line(line):
    # Procesa cada línea para extraer los valores necesarios
    parts = line.split(";")
    if len(parts) >= 8:  # TODO Cambiar a 9 con equipo
        try:
            lote = parts[0].strip()
            de = float(parts[1].strip())
            sort = parts[2].strip()
            estandar = parts[3].strip()
            fecha = date_format(parts[4].strip(), parts[5].strip())
            pasaFalla = parts[6].strip()
            gradoBlanco = float(parts[7].strip())
            # equipo = parts[8].strip()
            return {
                "orden": lote,
                "de": de,
                "sort": sort,
                "estandar": estandar,
                "fecha": fecha,
                "pasaFalla": pasaFalla,
                "gradoBlanco": gradoBlanco,
                # "equipo": equipo,
            }
        except ValueError:
            return None
    return None


def clear_file_content(file_path):
    try:
        with open(file_path, "w") as file:
            file.write("")
    except Exception as e:
        print_with_timestamp(f"Error borrando el contenido del archivo: {e}")


def write_unsent_data(file_path, unsent_data):
    with open(file_path, "a") as file:
        for data in unsent_data:
            file.write(data)


def main(input_file, output_folder):
    with open(input_file, "r") as file:
        lines = file.readlines()

    if len(lines):
        data_to_write = []

        for line in lines:
            # Ignora las líneas que empiezan por "ESCALA DE GRISES", "ESTANDAR", y "MUESTRA"
            if not line.startswith(("Lote;DE", ";", " ")):
                data = process_line(line)
                if data:
                    data_to_write.append((data, line))

        # Guardar los datos procesados en archivos JSON
        unsent_data = []

        with open(path + "token.txt", "r") as Token_txt:
            Token = Token_txt.read()

        if Token == "":
            Token = emp.Solicitar_token(path)

        # Token = "hola" # 401 invalid token
        # Token = "" # 401 invalid token

        for i, data in enumerate(data_to_write):  # index, element in enumerate(l)
            print_with_timestamp(
                f"Enviando lote {data[0]['orden']}... {i+1} de {len(data_to_write)}"
            )
            time.sleep(0.1)
            try:
                envd = emp.Envio_datos(Token, data[0])
            except:
                envd = "Sin respuesta"
            print_with_timestamp(envd)  # TODO Descomentar
            # envd = "201"  # TODO Comentar
            time.sleep(0.1)

            if not (("201" in str(envd)) or ("200" in str(envd))):
                print_with_timestamp(f"Error enviando lote {data[0]['orden']}...")
                unsent_data.append(data[1])

            # output_file = f"{output_folder}/data_{data['orden']}.json"
            # print_with_timestamp(f"Enviando orden {data['orden']}...")
            # with open(output_file, "w") as json_file:
            #     json.dump(data, json_file)

        # Vaciar el archivo de entrada después de procesar las líneas
        clear_file_content(input_file)  # TODO Descomentar

        if len(unsent_data):
            write_unsent_data(input_file, unsent_data)
            cerrar = emp.Cerrar_seccion(path)
            print_with_timestamp(f"Cerrar: {cerrar}")
            time.sleep(300)
            Token = emp.Solicitar_token(path)

    else:
        print_with_timestamp("Archivo vacío.")


if __name__ == "__main__":
    input_file = "/mnt/Solidez/Transfer/DE_555" #"/run/user/1002/gvfs/smb-share:server=172.17.3.6,share=grupos/ACABADOS/Solidez/Transfer/DE_555" #"/home/jbenjumeam/Cib/JP/Proyectos/Dato_SORT/Env_SORT/SORT.txt"
    output_folder = "/home/jbenjumeam/Cib/JP/Proyectos/Dato_SORT/Env_SORT/outputjsons"
    try:
        main(input_file, output_folder)
        last_modified = calculate_file_hash(input_file)  # os.path.getmtime(file_path)
        print_with_timestamp("Monitoreando cambios en el archivo...")
        while True:
            current_modified = calculate_file_hash(
                input_file
            )  # os.path.getmtime(file_path)
            # print(current_modified)
            if current_modified != last_modified:
                print_with_timestamp("Archivo modificado...")
                main(input_file, output_folder)
                last_modified = current_modified
            time.sleep(1)
    except:
        print_with_timestamp("Monitoreo de cambios interrumpido.")
        t = randint(10, 600)
        print_with_timestamp(f"Esperando {t} segundos para reintentar")
        time.sleep(t)
