from sim import simulate
import config as conf
from plot import MultiPlot
from statistics_GC import AvgStatistics
from statistics_GC import DailyStatistics
import numpy as np
import json as js
import matplotlib.pyplot as plt
#plt.rcParams['font.size'] = 20
import pickle


def reset_parameters():
    conf.NBSS = 20 ## Max number of chargers
    conf.SPV = 500 # Nominal capacity of one PV (kW) * number of panels
    conf.BTH = conf.C * 0.9 #C Battery capacity  # Minimum charge level (during off peak periods?)
    conf.TMAX = 480 #5 # Maximum time by which the charge process can be postponed
    conf.F = 17 #0 # Fraction of batteries whose charge can be postponed


def multi_plot(stats, x, legend_values, xlabel, legend_label): #没有用到????
    MultiPlot(stats.avg_arrivals, xvalues=x, title="Arrivals", labels=legend_label, xlabel=xlabel).plot(legend_values)
    MultiPlot(stats.avg_loss, xvalues=x, title="Losses", ylabel='Losses', labels=legend_label, xlabel=xlabel).plot(legend_values)
    MultiPlot(stats.avg_loss_prob, xvalues=x, title="Loss probability", ylabel='$P_l$', labels=legend_label, xlabel=xlabel).plot(legend_values)
    # MultiPlot(stats.avg_avg_wait, xvalues=x, title="Avg wait", labels=legend_label, xlabel=xlabel).plot(legend_values)
    # MultiPlot(stats.avg_avg_ready, xvalues=x, title="Avg ready batteries", labels=legend_label, xlabel=xlabel).plot(
    #     legend_values)
    MultiPlot(stats.avg_cost, xvalues=x, title="Costs", ylabel="Daily Cost [€]", labels=legend_label, xlabel=xlabel).plot(
        legend_values)
    MultiPlot(stats.avg_saving, xvalues=x, title="Savings", ylabel="Daily Cost [€]", labels=legend_label,
              xlabel=xlabel).plot(legend_values)
    MultiPlot(stats.cost_per_service, xvalues=x, title="Cost per service", ylabel="Daily Cost [€]",
              labels=legend_label, xlabel=xlabel).plot(legend_values)


def plot_stats(stats, params, label):

    #print(stats.avg_arrivals)
    #print(stats.avg_loss)
    #print(stats.avg_avg_wait)
    #print(stats.avg_avg_ready)
    MultiPlot(stats.avg_arrivals, title="Arrivals", xvalues=label, labels=label).single_plot()    
    MultiPlot(stats.avg_loss, title="Losses", xvalues=label, xlabel=params, labels=label).single_plot()    
    MultiPlot(stats.avg_avg_wait, title="Waiting", xvalues=label, labels=label).single_plot()    
    MultiPlot(stats.avg_avg_ready, title="Average ready", xvalues=label, labels=label).single_plot()
    MultiPlot(stats.avg_cost, title="Costs", xvalues=label, xlabel=params,
              ylabel="Daily Cost [€]", labels=label).single_plot()

    y = np.array((stats.avg_cost.tolist(), stats.avg_saving.tolist(),
                  stats.avg_net_cost.tolist()))
    MultiPlot(y, title="Costs", xlabel=params,
              ylabel="Daily Cost [€]", xvalues=label).plot(["Grid", "Sold", "Net"])

    y = np.array((stats.avg_tot_consumption.tolist(), stats.avg_consumption.tolist(),
                  stats.avg_spv_consumption.tolist()))
    MultiPlot(y, title="Consumption", xlabel=params,
              ylabel="$E^G$ [Wh]", xvalues=label).plot(["Tot", "Grid", "SPV"])
    MultiPlot(stats.avg_consumption, stats.avg_loss_prob, title="Consumption vs prob loss", ylabel="Energy per day [Wh/day]").plot_consumption_prob_loss(label)
    #print(stats.avg_loss_prob)
    MultiPlot(stats.avg_cost, stats.avg_loss_prob, title="Cost vs prob loss").plot_cost_prob_loss(label)

    MultiPlot(stats.cost_per_service, stats.avg_loss_prob, title="Cost per service vs prob loss").plot_cost_prob_loss(label)


if __name__ == "__main__":
    #reset_parameters()
    
    
    # Output folder
    output_folder = "results/output_data/"
    
    # SPV / NBSS
    #spv_list = [0] + list(range(100,1600,200)) #range(500, 1600, 100))
    #print(spv_list)
    #spv_list = [0, 100, 300, 500, 700, 900, 1100, 1300, 1500]
    spv_list = [0, 25, 50, 75, 100, 300, 1500]
    nbss_list = list(range(15,26,1)) #range(10, 21, 1))
    #print(nbss_list)
    #nbss_list = [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25]
    stats_by_nbss = AvgStatistics(len(nbss_list), len(spv_list))
    stats_by_spv = AvgStatistics(r=len(spv_list))

    # F / TMAX
    #f_list = [0] + list(range(1,conf.NBSS + 1,2))
    #f_list = [0, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25]
    f_list = [0, 11, 15, 17, 19, 20, 22]
    tmax_list = [0,30,60] + list(range(120,660,60)) #60, 660, 60))
    # print(tmax_list) [0, 30, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600]
    #tmax_list = [0, 30, 60, 120, 180]
    stats_by_tmaxf = AvgStatistics(len(tmax_list), len(f_list))
    # print(stats_by_tmaxf) object
    stats_by_f = AvgStatistics(r=len(f_list))
    # print(stats_by_f) object
    stats_by_Tmax = AvgStatistics(r=len(tmax_list))

    # BTH
    bth_list = [bth / 100 for bth in range(60, 95, 5)]
    stats_by_bth = AvgStatistics(r=len(bth_list))

    # ARRIVAL_COEFF
    arrival_list = [conf.arrival_rate, conf.arrival_rate_2, conf.arrival_rate_3]
    stats_by_arr_rate = AvgStatistics(r=len(arrival_list))

    
#    #%% Multiple PV sizes and NBSS
#    for spv in spv_list:
#        for nbss in nbss_list:
#            conf.SPV = spv
#            conf.NBSS = nbss
#            stats, debug_data = simulate()
#            print("-")
#    
#            stats_by_nbss.compute_avg(stats, nbss_list.index(conf.NBSS), spv_list.index(conf.SPV))
#
#   fn = 'stats_by_nbss'
#    data_to_pick = stats_by_nbss
#                  
#    multi_plot(stats_by_nbss, spv_list, nbss_list, "$C_{P}$ [$kW_p$]", "NBSS")
#    # plot01_stats_by_nbss
    
    '''
    #%% Multiple PV sizes
    for spv in spv_list:
        conf.SPV = spv
        stats, debug_data = simulate()
        print("-")
    
        stats_by_spv.compute_avg(stats, spv_list.index(conf.SPV))
   
    #plot_stats(stats_by_spv, "SPV", spv_list)
    
    ####################cost vs loss
    cost = stats_by_spv.avg_cost
    loss = stats_by_spv.avg_loss

    plt.figure()
    plt.grid()
    axes = plt.subplot(111)

    type1=plt.scatter(cost[0], loss[0], c='red')
    type2=plt.scatter(cost[1], loss[1], c='green')
    type3=plt.scatter(cost[2], loss[2], c='black')
    type4=plt.scatter(cost[3], loss[3], c='orange')
    type5=plt.scatter(cost[4], loss[4], c='purple')
    type6=plt.scatter(cost[5], loss[5], c='olive')
    type7=plt.scatter(cost[6], loss[6], c='cyan')

    plt.xlabel('daily_cost', fontsize=15)
    plt.ylabel('daily_loss', fontsize=15)
    axes.legend((type1, type2, type3, type4, type5, type6, type7), ('SPV0', 'SPV25', 'SPV50', 'SPV75', 'SPV100', 'SPV300', 'SPV1500'), loc='upper right')
    plt.show()

    ####################cost vs loss
    '''



    #%% Multiple NBSS values
#    for nbss in nbss_list:
#        conf.NBSS = nbss
#        stats, debug_data = simulate()
#        print("-")
#    
#        stats_by_nbss.compute_avg(stats, nbss_list.index(conf.NBSS))
#    
#    fn = 'stats_by_nbss'
#    data_to_pick = stats_by_nbss
#    
#    plot_stats(stats_by_nbss, "NBSS", nbss_list)
    
#%% TEST:
#conf.NBSS = 40
#stats, debug_data = simulate()
#print("-")
#stats_by_nbss.compute_avg(stats, nbss_list.index(conf.NBSS))
#
#fn = 'stats_by_nbss'
#data_to_pick = stats_by_nbss   
##plot_stats(stats_by_nbss, "NBSS", nbss_list)   
    
    #%% Multiple BTH values 70-90%
#    for bth in bth_list:
#        conf.BTH = conf.C * bth
#        stats, debug_data = simulate()
#        print("-")
#    
#        # The following line has been replaced by the line afterward: is it correct?
#        #stats_by_bth.compute_avg(stats, bth_list.index(bth))
#        stats_by_bth.compute_avg(stats, bth_list.index(conf.BTH))
#    plot_stats(stats_by_bth, "Bth", bth_list)

    #%% Multiple Tmax and f values
#    for tmax in tmax_list:
#        for f in f_list:
#            conf.TMAX = tmax
#            conf.F = f
#            print(tmax, f)
#            stats, debug_data = simulate()
#            print("-")
#
#            stats_by_tmaxf.compute_avg(stats, tmax_list.index(tmax), f_list.index(f))
#            
#    fn = 'stats_by_tmaxf'
#    data_to_pick = stats_by_tmaxf
    
#    multi_plot(stats_by_tmaxf, f_list, tmax_list, "F", "TMAX")

    '''
    #%% Multiple f values
    #print(conf.B)
    for f in f_list:
        conf.F1 = f
        #conf.F2 = f
        #conf.F3 = f
        #conf.F4 = f
        stats, debug_data = simulate()
        print("-")
    
        #stats_by_f.compute_avg(stats, f_list.index(conf.F))
        
    #fn = 'stats_by_f'
    #data_to_pick = stats_by_f
    
    #plot_stats(stats_by_f, "F", f_list)
    
    ######################cost vs loss---year
    cost = stats_by_f.avg_cost
    loss = stats_by_f.avg_loss

    plt.figure()
    plt.grid()
    axes = plt.subplot(111)

    type1=plt.scatter(cost[0], loss[0], c='red')
    type2=plt.scatter(cost[1], loss[1], c='green')
    type3=plt.scatter(cost[2], loss[2], c='black')
    type4=plt.scatter(cost[3], loss[3], c='orange')
    type5=plt.scatter(cost[4], loss[4], c='purple')
    type6=plt.scatter(cost[5], loss[5], c='olive')
    type7=plt.scatter(cost[6], loss[6], c='cyan')

    plt.xlabel('daily_cost', fontsize=15)
    plt.ylabel('daily_loss', fontsize=15)
    axes.legend((type1, type2, type3, type4, type5, type6, type7), ('F0', 'F11', 'F15', 'F17', 'F19', 'F20', 'F22'), loc='upper right')
    plt.show()
    ##########################
    '''
    '''
    ######################cost vs loss -- season
    lengthTmax = len(f_list)
    daily_cost_winter=[]
    daily_loss_winter=[]
    daily_loss=[]
    daily_cost=[]
    for i in range(lengthTmax):
        conf.F1 = f_list[i]
        conf.F2 = f_list[i]
        conf.F3 = f_list[i]
        conf.F4 = f_list[i]
        stats, debug_data = simulate()
        daily_loss = list(stats.loss.values())
        daily_cost = list(stats.cost.values())

        #daily_cost_spring.append(np.mean(daily_cost[60:152]))
        #daily_cost_summer.append(np.mean(daily_cost[153:243]))
        daily_cost_winter.append(np.mean(daily_cost[0:59]+daily_cost[334:365]))
        #daily_cost_autumn.append(np.mean(daily_cost[244:333]))
    
        #daily_loss_spring.append(np.mean(daily_loss[60:152]))
        #daily_loss_summer.append(np.mean(daily_loss[153:243]))        
        daily_loss_winter.append(np.mean(daily_loss[0:59]+daily_loss[334:365]))
        #daily_loss_autumn.append(np.mean(daily_loss[244:333]))

    
    plt.figure()
    plt.grid()
    axes = plt.subplot(111)
    type1=plt.scatter(daily_cost_winter[0], daily_loss_winter[0], c='red')
    type2=plt.scatter(daily_cost_winter[1], daily_loss_winter[1], c='green')
    type3=plt.scatter(daily_cost_winter[2], daily_loss_winter[2], c='black')
    type4=plt.scatter(daily_cost_winter[3], daily_loss_winter[3], c='orange')
    type5=plt.scatter(daily_cost_winter[4], daily_loss_winter[4], c='purple')
    type6=plt.scatter(daily_cost_winter[5], daily_loss_winter[5], c='olive')
    type7=plt.scatter(daily_cost_winter[6], daily_loss_winter[6], c='cyan')

    plt.xlabel('daily_cost', fontsize=15)
    plt.ylabel('daily_loss', fontsize=15)
    axes.legend((type1, type2, type3, type4, type5, type6, type7), ('F0', 'F11', 'F15', 'F17', 'F19', 'F20', 'F22'), loc='upper right')
    plt.show()
    ######################cost vs loss -- season
    '''


    ###################### postpone and new price
    '''

    stats, debug_data = simulate()

    
    cost = list(stats.cost.values())
    lost = list(stats.loss.values())
    #avg_arrivals = list(stats.arrivals.values())
    avg_spv_consumption = list(stats.spv_production.values())
    avg_tot_consumption = list(stats.total_consumption.values())
    #cost_per_service = list(stats.cost_per_service.values())
    avg_avg_wait = list(stats.avg_wait.values())
    meann=np.mean(list(stats.loss.values()))
    meanm=np.mean(list(stats.cost.values()))
    #mean3=np.mean(list(stats.arrivals.values()))
    mean4=np.mean(list(stats.spv_production.values()))
    mean5=np.mean(list(stats.total_consumption.values()))
    #mean6=np.mean(list(stats.cost_per_service.values()))
    mean7=np.mean(list(stats.avg_wait.values()))
    print('lost',meann)
    print('cost',meanm)
    #print('avg_arrivals',mean3)
    print('avg_spv_consumption',mean4)
    print('avg_tot_consumption',mean5)
    #print('cost_per_service',mean6)
    print('avg_avg_wait',mean7)
    
    avg_ready=list(stats.avg_ready.values())
    mean=np.mean(list(stats.avg_ready.values()))
    print('avg_ready', mean)
    
    #plt.figure()
    #plt.grid()
    #x = np.arange(365)
    #plt.plot(x, avg_ready)
    #plt.show()

    #plt.plot(x, cost)
    #plt.show()

    #plt.plot(x, lost)
    #plt.show()

    #plt.plot(x, avg_arrivals)
    #plt.show()

    #plt.plot(x, avg_spv_consumption)
    #plt.show()

    #plt.plot(x, avg_tot_consumption)
    #plt.show()


    #plt.plot(x, avg_avg_wait)
    #plt.show()

    ###################### postpone and new price
    '''



    #%% Multiple Tmax values
#    for tmax in tmax_list: #这个for的用途是?
#        conf.TMAX = tmax
#        stats, debug_data = simulate() #python file sim.py func simulate
#    
#        stats_by_Tmax.compute_avg(stats, tmax_list.index(conf.TMAX)) #python statis.py 传参为什么不一样呢???
#    
#    fn = 'stats_by_Tmax'
#    data_to_pick = stats_by_Tmax
#    #print(stats_by_Tmax)
#    
#    plot_stats(stats_by_Tmax, "$T_{MAX}$", tmax_list)




'''

#*********DAILY SEASON FIGURE************************
#Tmax2_list = [400, 425, 450, 475, 500, 525, 550] #set TMAX in spring, one loop one value
#Tmax3_list = [450, 475, 500, 525, 550, 575, 600] #set TMAX in summer, one loop one value
Tmax1_list = [125, 150, 175, 200, 225, 250, 275] #set TMAX in winter, one loop one value
#Tmax4_list = [150, 200, 250, 300, 325, 350, 375] #set TMAX in autumn, one loop one value

lengthTmax = len(Tmax1_list)
#daily_cost_spring=[]
#daily_cost_summer=[]
daily_cost_winter=[]
#daily_cost_autumn=[]
#daily_loss_spring=[]
#daily_loss_summer=[]
daily_loss_winter=[]
#daily_loss_autumn=[]
for i in range(lengthTmax):
    #conf.TMAX2 = Tmax2_list[i]
    #conf.TMAX3 = Tmax3_list[i]
    conf.TMAX1 = Tmax1_list[i]
    #conf.TMAX4 = Tmax4_list[i]
    conf.TMAX2=475
    conf.TMAX3=500
    conf.TMAX4=325
    #conf.TMAX1=225
    stats, debug_data = simulate()
    daily_loss = list(stats.loss.values())
    daily_cost = list(stats.cost.values())

    #daily_cost_spring.append(np.mean(daily_cost[60:152]))
    #daily_cost_summer.append(np.mean(daily_cost[153:243]))
    daily_cost_winter.append(np.mean(daily_cost[0:59]+daily_cost[334:365]))
    #daily_cost_autumn.append(np.mean(daily_cost[244:333]))
    
    #daily_loss_spring.append(np.mean(daily_loss[60:152]))
    #daily_loss_summer.append(np.mean(daily_loss[153:243]))        
    daily_loss_winter.append(np.mean(daily_loss[0:59]+daily_loss[334:365]))
    #daily_loss_autumn.append(np.mean(daily_loss[244:333]))




#colors = np.array(["red","green","black","orange","purple","beige","cyan"])
plt.figure()
plt.grid()
axes = plt.subplot(111)

type1=plt.scatter(daily_cost_winter[0], daily_loss_winter[0], c='red')
type2=plt.scatter(daily_cost_winter[1], daily_loss_winter[1], c='green')
type3=plt.scatter(daily_cost_winter[2], daily_loss_winter[2], c='black')
type4=plt.scatter(daily_cost_winter[3], daily_loss_winter[3], c='orange')
type5=plt.scatter(daily_cost_winter[4], daily_loss_winter[4], c='purple')
type6=plt.scatter(daily_cost_winter[5], daily_loss_winter[5], c='olive')
type7=plt.scatter(daily_cost_winter[6], daily_loss_winter[6], c='cyan')

#print(daily_cost_spring)
#print(daily_loss_spring)

plt.xlabel('daily_cost', fontsize=15)
plt.ylabel('daily_loss', fontsize=15)
axes.legend((type1, type2, type3, type4, type5, type6, type7), ('TMAX125','TMAX150','TMAX175', 'TMAX200', 'TMAX225', 'TMAX250', 'TMAX275'), loc='upper right')
#plt.legend(loc='upper right', prop={'size':10})
plt.show()
'''
'''
plt.figure()
plt.grid()
axes = plt.subplot(111)

type1=plt.scatter(daily_cost_autumn[0], daily_loss_autumn[0], c='red')
type2=plt.scatter(daily_cost_autumn[1], daily_loss_autumn[1], c='green')
type3=plt.scatter(daily_cost_autumn[2], daily_loss_autumn[2], c='black')
type4=plt.scatter(daily_cost_autumn[3], daily_loss_autumn[3], c='orange')
type5=plt.scatter(daily_cost_autumn[4], daily_loss_autumn[4], c='purple')
type6=plt.scatter(daily_cost_autumn[5], daily_loss_autumn[5], c='olive')
type7=plt.scatter(daily_cost_autumn[6], daily_loss_autumn[6], c='cyan')

plt.xlabel('daily_cost_autumn', fontsize=15)
plt.ylabel('daily_loss_autumn', fontsize=15)
axes.legend((type1, type2, type3, type4, type5, type6, type7), ('TMAX150','TMAX200', 'TMAX250', 'TMAX300', 'TMAX325', 'TMAX350', 'TMAX375'), loc='upper right')
plt.show()

#*********DAILY SEASON FIGURE************************
'''




#**DAILY with 4 seasons****************************************************************
# get list of daily data: arrival, loss, cost, avg_ready, avg_wait, loss_prob, consumption, tot_consumption,
#   spv_consumption, saving, per_service, net_cost

#Tmax2_list = [475, 150] #set TMAX in spring, one loop one value
#Tmax3_list = [500, 150] #set TMAX in summer, one loop one value
#Tmax1_list = [225, 150] #set TMAX in winter, one loop one value
#Tmax4_list = [270, 150] #set TMAX in autumn, one loop one value


stats, debug_data = simulate()
daily_arrivals = list(stats.arrivals.values())
daily_loss = list(stats.loss.values())
daily_cost = list(stats.cost.values())
daily_avg_ready = list(stats.avg_ready.values())
daily_avg_wait = list(stats.avg_wait.values())
daily_loss_prob = list(stats.loss_prob.values())
daily_consumption = list(stats.consumption.values())
daily_saving = list(stats.saving.values())
count = len(daily_arrivals)
cost_per_service = np.zeros(count)
daily_net_cost = np.zeros(count)
for i in range(count):
    cost_per_service[i] = daily_cost[i] / (daily_arrivals[i] - daily_loss[i])
    daily_net_cost[i] = daily_cost[i] - daily_saving[i]
    conf.TMAX2 = 150
    conf.TMAX3 = 150
    conf.TMAX1 = 150
    conf.TMAX4 = 150

print(np.mean(daily_loss))
print(np.mean(daily_cost))
print(np.mean(daily_avg_ready))
print(np.mean(daily_arrivals))
print(np.mean(daily_loss_prob))
print(np.mean(daily_consumption))
print(np.mean(daily_saving))

plt.figure()
plt.grid()
x = np.arange(365)
#plt.plot(x, daily_arrivals)
plt.plot(x, daily_loss)
plt.plot(x, daily_cost)
#plt.plot(x, daily_avg_ready)
#plt.plot(x, daily_avg_wait)
#plt.plot(x, daily_loss_prob)
#plt.plot(x, daily_consumption)
#plt.plot(x, daily_saving)
#plt.plot(x, cost_per_service)
#plt.plot(x, daily_net_cost)
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.axvline(x=59, c='r', linestyle='--', linewidth=2, label='end of Feb')
plt.axvline(x=151, c='g', linestyle='--', linewidth=2, label='end of May')
plt.axvline(x=243, c='c', linestyle='--', linewidth=2, label='end of August')
plt.axvline(x=334, c='m', linestyle='--', linewidth=2, label='end of Nov')
plt.xlabel('365 days', fontsize=15)

#plt.title('daily_arrivals', fontsize=15)
#plt.title('daily_loss', fontsize=15) 
#plt.title('daily_cost', fontsize=15)  
#plt.title('daily_avg_ready', fontsize=15) 
#plt.title('daily_avg_wait', fontsize=15) 
#plt.title('daily_loss_prob', fontsize=15) 
#plt.title('daily_consumption', fontsize=15)
#plt.title('daily_saving', fontsize=15) 
#plt.title('cost_per_service', fontsize=15)
#plt.title('daily_net_cost', fontsize=15)
plt.legend(loc='upper right', prop={'size':10})
plt.show()

#dailyResults.compute_daily(stats)
#print(type(dailyResults))
#**DAILY******************************************************************



'''
#**DAILY CHANGE TMAX******************************************************************
#Tmax2_list = [400, 425, 450, 475] #set TMAX in spring, one loop one value
#Tmax3_list = [500, 525, 545, 565] #set TMAX in summer, one loop one value
Tmax1_list = [250, 275, 225, 250] #autumn
Tmax4_list = [100, 100, 120, 120] #winter



lengthTmax = len(Tmax1_list)
for i in range(lengthTmax):
    #conf.TMAX2 = Tmax2_list[i]
    #conf.TMAX3 = Tmax3_list[i]
    conf.TMAX1 = Tmax1_list[i]
    conf.TMAX4 = Tmax4_list[i]
    #print(conf.TMAX1, conf.TMAX2)
    if i==0:
        stats1, debug_data = simulate()
        print(conf.TMAX1, conf.TMAX2, conf.TMAX3, conf.TMAX4)
    if i==1:
        stats2, debug_data = simulate()
        print(conf.TMAX1, conf.TMAX2, conf.TMAX3, conf.TMAX4)
    if i==2:
        stats3, debug_data = simulate()
        print(conf.TMAX1, conf.TMAX2, conf.TMAX3, conf.TMAX4)
    if i==3:
        stats4, debug_data = simulate()
        print(conf.TMAX1, conf.TMAX2, conf.TMAX3, conf.TMAX4)




daily_loss1 = list(stats1.loss.values())
daily_cost1 = list(stats1.cost.values())
daily_loss2 = list(stats2.loss.values())
daily_cost2 = list(stats2.cost.values())
daily_loss3 = list(stats3.loss.values())
daily_cost3 = list(stats3.cost.values())
daily_loss4 = list(stats4.loss.values())
daily_cost4 = list(stats4.cost.values())


daily_cost1_winter = daily_cost1[0:59]+daily_cost1[334:365]
daily_cost1_autumn = daily_cost1[244:333]
daily_loss1_winter = daily_loss1[0:59]+daily_loss1[334:365]
daily_loss1_autumn = daily_loss1[244:333]
daily_cost2_winter = daily_cost2[0:59]+daily_cost2[334:365]
daily_cost2_autumn = daily_cost2[244:333]
daily_loss2_winter = daily_loss2[0:59]+daily_loss2[334:365]
daily_loss2_autumn = daily_loss2[244:333]
daily_cost3_winter = daily_cost3[0:59]+daily_cost3[334:365]
daily_cost3_autumn = daily_cost3[244:333]
daily_loss3_winter = daily_loss3[0:59]+daily_loss3[334:365]
daily_loss3_autumn = daily_loss3[244:333]
daily_cost4_winter = daily_cost4[0:59]+daily_cost4[334:365]
daily_cost4_autumn = daily_cost4[244:333]
daily_loss4_winter = daily_loss4[0:59]+daily_loss4[334:365]
daily_loss4_autumn = daily_loss4[244:333]



daily_cost1_spring = daily_cost1[60:152]
daily_cost1_summer = daily_cost1[153:243]
daily_loss1_spring = daily_loss1[60:152]
daily_loss1_summer = daily_loss1[153:243]
daily_cost2_spring = daily_cost2[60:152]
daily_cost2_summer = daily_cost2[153:243]
daily_loss2_spring = daily_loss2[60:152]
daily_loss2_summer = daily_loss2[153:243]
daily_cost3_spring = daily_cost3[60:152]
daily_cost3_summer = daily_cost3[153:243]
daily_loss3_spring = daily_loss3[60:152]
daily_loss3_summer = daily_loss3[153:243]
daily_cost4_spring = daily_cost4[60:152]
daily_cost4_summer = daily_cost4[153:243]
daily_loss4_spring = daily_loss4[60:152]
daily_loss4_summer = daily_loss4[153:243]



#print(np.mean(daily_cost1_spring), '\n', np.mean(daily_cost2_spring), '\n', np.mean(daily_cost3_spring), '\n', np.mean(daily_cost4_spring))
#print(np.mean(daily_loss1_spring), '\n', np.mean(daily_loss2_spring), '\n', np.mean(daily_loss3_spring), '\n', np.mean(daily_loss4_spring))
#print(np.mean(daily_cost1_summer), '\n', np.mean(daily_cost2_summer), '\n', np.mean(daily_cost3_summer), '\n', np.mean(daily_cost4_summer))
#print(np.mean(daily_loss1_summer), '\n', np.mean(daily_loss2_summer), '\n', np.mean(daily_loss3_summer), '\n', np.mean(daily_loss4_summer))
print(np.mean(daily_cost1_autumn), '\n', np.mean(daily_cost2_autumn), '\n', np.mean(daily_cost3_autumn), '\n', np.mean(daily_cost4_autumn))
print(np.mean(daily_loss1_autumn), '\n', np.mean(daily_loss2_autumn), '\n', np.mean(daily_loss3_autumn), '\n', np.mean(daily_loss4_autumn))
print(np.mean(daily_cost1_winter), '\n', np.mean(daily_cost2_winter), '\n', np.mean(daily_cost3_winter), '\n', np.mean(daily_cost4_winter))
print(np.mean(daily_loss1_winter), '\n', np.mean(daily_loss2_winter), '\n', np.mean(daily_loss3_winter), '\n', np.mean(daily_loss4_winter))


##############spring

plt.figure()
plt.grid()
x = np.arange(92)
plt.plot(x, daily_cost1_spring, label="cost 1 SpringTMAX 425", c='k')
plt.plot(x, daily_cost2_spring, label="cost 2 SpringTMAX 450", c='g')
plt.plot(x, daily_cost3_spring, label="cost 3 SpringTMAX 475", c='b')
plt.plot(x, daily_cost4_spring, label="cost 4 SpringTMAX 500", c='m')
plt.plot(x, daily_loss1_spring, label="loss 1 SpringTMAX 425", c='k')
plt.plot(x, daily_loss2_spring, label="loss 2 SpringTMAX 450", c='g')
plt.plot(x, daily_loss3_spring, label="loss 3 SpringTMAX 475", c='b')
plt.plot(x, daily_loss4_spring, label="loss 4 SpringTMAX 500", c='m')
plt.xlabel('spring days', fontsize=15)
#plt.title('daily_net_cost', fontsize=15)
plt.legend(loc='upper right', prop={'size':10})
plt.show()


##############summer

plt.figure()
plt.grid()
x = np.arange(90)
plt.plot(x, daily_cost1_summer, label="cost 1 SummerTMAX 475", c='k')
plt.plot(x, daily_cost2_summer, label="cost 2 SummerTMAX 500", c='g')
plt.plot(x, daily_cost3_summer, label="cost 3 SummerTMAX 525", c='b')
plt.plot(x, daily_cost4_summer, label="cost 4 SummerTMAX 550", c='m')
plt.plot(x, daily_loss1_summer, label="loss 1 SummerTMAX 475", c='k')
plt.plot(x, daily_loss2_summer, label="loss 2 SummerTMAX 500", c='g')
plt.plot(x, daily_loss3_summer, label="loss 3 SummerTMAX 525", c='b')
plt.plot(x, daily_loss4_summer, label="loss 4 SummerTMAX 550", c='m')
plt.xlabel('summer days', fontsize=15)
#plt.title('daily_net_cost', fontsize=15)
plt.legend(loc='upper right', prop={'size':10})
plt.show()


##############autumn

plt.figure()
plt.grid()
x = np.arange(89)
plt.plot(x, daily_cost1_autumn, label="cost 1 SummerTMAX ", c='k')
plt.plot(x, daily_cost2_autumn, label="cost 2 SummerTMAX ", c='g')
plt.plot(x, daily_cost3_autumn, label="cost 3 SummerTMAX ", c='b')
plt.plot(x, daily_cost4_autumn, label="cost 4 SummerTMAX ", c='m')
plt.plot(x, daily_loss1_autumn, label="loss 1 SummerTMAX ", c='k')
plt.plot(x, daily_loss2_autumn, label="loss 2 SummerTMAX ", c='g')
plt.plot(x, daily_loss3_autumn, label="loss 3 SummerTMAX ", c='b')
plt.plot(x, daily_loss4_autumn, label="loss 4 SummerTMAX ", c='m')
plt.xlabel('autumn days', fontsize=15)
#plt.title('daily_net_cost', fontsize=15)
plt.legend(loc='upper right', prop={'size':10})
plt.show()


##############winter

plt.figure()
plt.grid()
x = np.arange(90)
plt.plot(x, daily_cost1_winter, label="cost 1 SummerTMAX ", c='k')
plt.plot(x, daily_cost2_winter, label="cost 2 SummerTMAX ", c='g')
plt.plot(x, daily_cost3_winter, label="cost 3 SummerTMAX ", c='b')
plt.plot(x, daily_cost4_winter, label="cost 4 SummerTMAX ", c='m')
plt.plot(x, daily_loss1_winter, label="loss 1 SummerTMAX ", c='k')
plt.plot(x, daily_loss2_winter, label="loss 2 SummerTMAX ", c='g')
plt.plot(x, daily_loss3_winter, label="loss 3 SummerTMAX ", c='b')
plt.plot(x, daily_loss4_winter, label="loss 4 SummerTMAX ", c='m')
plt.xlabel('winter days', fontsize=15)
#plt.title('daily_net_cost', fontsize=15)
plt.legend(loc='upper right', prop={'size':10})
plt.show()



#*********************************************************************************
'''




'''
#####FULL YEAR#######################################################################

plt.figure()
plt.grid()
x = np.arange(365)
plt.plot(x, daily_cost1, label="cost 1 S&STMAX 200", c='k')
plt.plot(x, daily_cost2, label="cost 2 S&STMAX 400", c='g')
plt.plot(x, daily_cost3, label="cost 3 S&STMAX 600", c='b')
plt.plot(x, daily_cost4, label="cost 4 S&STMAX 1000", c='m')
plt.plot(x, daily_loss1, label="loss 1 S&STMAX 200", c='k')
plt.plot(x, daily_loss2, label="loss 2 S&STMAX 400", c='g')
plt.plot(x, daily_loss3, label="loss 3 S&STMAX 600", c='b')
plt.plot(x, daily_loss4, label="loss 4 S&STMAX 1000", c='m')
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.axvline(x=59, c='r', linestyle='--', linewidth=2, label='end of Feb')
plt.axvline(x=151, c='g', linestyle='--', linewidth=2, label='end of May')
plt.axvline(x=243, c='c', linestyle='--', linewidth=2, label='end of August')
plt.axvline(x=334, c='m', linestyle='--', linewidth=2, label='end of Nov')
plt.xlabel('365 days', fontsize=15)
#plt.title('daily_net_cost', fontsize=15)
plt.legend(loc='upper right', prop={'size':10})
plt.show()

######FULL YEAR#########################################################################
'''
#**DAILY CHANGE TMAX******************************************************************



#plot_stats()


    # %% By arrival rate
#    for i in range(len(arrival_list)):
#        conf.arrival_rate = arrival_list[i]
#        stats, debug_data = simulate()
#        print("-")
#    
#        stats_by_arr_rate.compute_avg(stats, i)
#    
#    plot_stats(stats_by_arr_rate, list(range(3)), ["3 peaks", "2 peaks", "Fixed coeff"])
#%%


'''
afile = open(output_folder+ fn, 'wb')
pickle.dump(data_to_pick, afile)
afile.close()
#%%
#reload object from file
file2 = open(output_folder+ fn, 'rb')
new_d = pickle.load(file2)
file2.close()
'''










