function MLP_SimulinkBlock(SimulinkFileName)
% MLP_SimulinkBlock - Create a Simulink model with a pre-trained MLP block
%
% Use this function after creating and training an MLP through the
% "MLP_builder()" function. It creates a new Simulink model with an MLP
% block inside, ready for deployment. If you have correctly loaded the
% required variables, the block is ready-to-use in your model.
%
% Author: Marino Massimo Costantini

% Create a new Simulink model
new_system(SimulinkFileName);
open_system(SimulinkFileName);

% Add the DeployMLP block to the Simulink model
add_block('DeployMLP_Simulink/DeployMLP', [SimulinkFileName,'/DeployMLP']);
end

