function [y_py_fun] = DeployMLP_Python(test_array,MLP_py_shape,MLP_struct,MLP_py_activation_functions,scale)
MLP_dict=struct2pydict(MLP_struct);
np = py.importlib.import_module('numpy');

y_py_fun=pyrunfile("MLP_builder.py", ...
    "y", ...
    mode='deploy', ...
    p = np.array(test_array), ...
    MLP_shape=np.array(MLP_py_shape), ...
    parameters=MLP_dict, ...
    activation_functions=MLP_py_activation_functions, ...
    maxes_X=np.array(scale(1:size(test_array,2))), ...
    maxes_Y=np.array(scale(length(scale)-MLP_py_shape(end)+1:end)));

y_py_fun = double(y_py_fun);
end


%%%%% NESTED FUNCTION %%%%%
% FUNCTION: struct2pydict
%
% DESCRIPTION:
% Converts a MATLAB structure to a Python dictionary. This function is designed
% to address compatibility issues when dealing with signals written in Python
% that need to be saved in .mat format within MATLAB. The function leverages
% Python's numpy module for array conversion.
%
% INPUT:
%   - matlabStruct: MATLAB structure to be converted to a Python dictionary.
%
% OUTPUT:
%   - pythonDict: Python dictionary equivalent of the input MATLAB structure.
%
% USAGE:
%   pythonDict = struct2pydict(matlabStruct);
%
% EXAMPLE:
%   % Define a MATLAB structure
%   myStruct.field1 = [1, 2, 3];
%   myStruct.field2.nestedField = 'hello';
%
%   % Convert the MATLAB structure to a Python dictionary
%   pythonDict = struct2pydict(myStruct);
%
%   % Now pythonDict can be saved in .mat format without compatibility issues.
%
% NOTES:
%   - Ensure that the Python package containing 'numpy' is installed in your
%     MATLAB environment for proper array conversion.
%   - Use this function when dealing with signals written in Python that need
%     to be saved in .mat format within MATLAB.
%
% SEE ALSO:
%   - Save signals in .mat format using the 'save' function in MATLAB.

function pythonDict = struct2pydict(matlabStruct)
    % Import the numpy module for array conversion
    np = py.importlib.import_module('numpy');

    % Initialize an empty Python dictionary
    pythonDict = py.dict;

    % Iterate over the fields of the structure
    fields = fieldnames(matlabStruct);
    for i = 1:numel(fields)
        field = fields{i};
        value = matlabStruct.(field);

        % If the value is a nested structure, recursively call the function
        if isstruct(value)
            value = struct2pydict(value);
        elseif isnumeric(value)
            % Convert numeric arrays to Python lists using numpy
            value = np.array(value);
        end

        % Add the field and value to the Python dictionary
        pythonDict{field} = value;
    end
end
