function [y_mat_fun] = DeployMLP_Matlab(input, W_conc, b_conc, scale, decoding_matrix)
tic;
disp('MLP deployment (Matlab)...')
persistent W_n_code b_n_code x_scale_factor y_scale_factor W_n b_n N_active_layer
if isempty(W_n_code)||isempty(b_n_code)
    disp('One-time calculations in progress...')
    N_active_layer =  length(decoding_matrix)-1;
    W_n_code       =  zeros(N_active_layer+1,1);
    b_n_code       =  zeros(N_active_layer+1,1);
    x_scale_factor =  scale(1:decoding_matrix(1,1));
    y_scale_factor =  scale(length(scale)-decoding_matrix(end,1)+1:end);
    sizes          =  [decoding_matrix(1:end-1,1).*decoding_matrix(2:end,1) decoding_matrix(2:end,1)];
    for i=1:N_active_layer
        W_n_code(i+1) = W_n_code(i)+sizes(i,1);
        b_n_code(i+1) = b_n_code(i)+sizes(i,2);
    end
    Input_consistency_check(input)
    disp('One-time calculations ended...')
    disp('------------------------------------------')
end

z_n = (input./x_scale_factor)';
for i=1:N_active_layer
    b_n = b_conc(b_n_code(i)+1:b_n_code(i+1));
    W_n = reshape(W_conc(W_n_code(i)+1:W_n_code(i+1)),decoding_matrix(i,1),decoding_matrix(i+1,1));
    z_n = activation_function(decoding_matrix(i+1,2),W_n'*z_n+b_n');
end
y_mat_fun   =    z_n'.*y_scale_factor




elapsed_time = toc;  % Stop the timer and get the elapsed time
if elapsed_time<10
    elapsed_time_str= [num2str(double(elapsed_time*1000)), ' msec'];
else
    elapsed_time_str= [num2str(double(elapsed_time)), ' sec'] ;
end
n=size(input,1);
disp(['Elapsed time matlab function call call: ',elapsed_time_str]);
disp(['Number of Input processed: ',num2str(n)]);
disp(['Average elapsed time for each Input: ',num2str(elapsed_time*1000/n,4) ' msec'])
disp('-------------------------------------------------')
clear global


    function result = activation_function(type, z)
        switch type
        
            case 1 % sigmoid
            result = 1 ./ (1 + exp(-z));
            case 2 % tanh
            result = tanh(z);
            case 3 % relu
            result = max(0, z);
            case 4 % lin
            result = z;
            case 5 % softmax
            exp_z = exp(z);
            result = exp_z / sum(exp_z);
            case 6 % step
            result = z > 0;
            case 7 % sine
            result =  sin(z);
            otherwise
            error('Invalid activation function type');
        end
    end

    function Input_consistency_check(input_layer)

        if size(input_layer,2)~=decoding_matrix(1,1)
            error('Input size is wrong: detected [%d] instead of [%d]', length(input_layer), decoding_matrix(1,1));
        end
    end

end
