import rclpy
from rclpy.node import Node
from std_msgs.msg import Float32MultiArray

class TrajectoryPublisher(Node):
    def __init__(self):
        super().__init__('trajectory_publisher')
        self.publisher_ = self.create_publisher(Float32MultiArray, 'trajectory', 10)
        timer_period = 2  # seconds
        self.timer = self.create_timer(timer_period, self.publish_trajectory)

    def publish_trajectory(self):
        
        coordinates = [1.0, 2.0, 3.0, 4.0, 5.0]
        msg = Float32MultiArray()
        msg.data = coordinates
        self.publisher_.publish(msg)
        self.get_logger().info('Publishing: %s' % str(msg.data))

def main(args=None):
    rclpy.init(args=args)
    trajectory_publisher = TrajectoryPublisher()
    rclpy.spin(trajectory_publisher)
    trajectory_publisher.destroy_node()
    rclpy.shutdown()

if __name__ == '__main__':
    main()
