import rclpy
from nav2_msgs.msg import Path
from geometry_msgs.msg import PoseStamped

with open("text,txt", "rt") as f:
    mylist = f.readlines()
    coord_list = mylist[0]


def main():
    rclpy.init()
    node = rclpy.create_node('trajectory_publisher')

    path_pub = node.create_publisher(Path, '/trajectory', 10)
    rate = node.create_rate(1)  # Adjust the rate according to your needs

    while rclpy.ok():
        # Create a Path message and populate it with trajectory points
        path_msg = Path()
        for i in len(coord_list):  # Replace with your actual number of points
            pose = PoseStamped()
            pose.pose.position.x = coord_list[i][0]  # Replace with your actual x-coordinate
            pose.pose.position.y = coord_list[i][1]  # Replace with your actual y-coordinate
            pose.pose.position.z = 0  # Replace with your actual z-coordinate
            path_msg.poses.append(pose)

        path_pub.publish(path_msg)
        rate.sleep()

    node.destroy_node()
    rclpy.shutdown()

if __name__ == '__main__':
    main()

